/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.mc.utils;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import weblogic.webservice.core.soap.NameImpl;

public class McConstants {
    public static final String MC_ANONYMOUS = "/anonymous?id=";

    public static String getAnonymousURITemplate(McVersion mcVersion) {
        return mcVersion.getNamespaceUri() + MC_ANONYMOUS;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FaultCode {
        SENDER("Client", "Sender"),
        RECEIVER("Server", "Receiver");

        Map<SOAPVersion, String> versionToCodeMap = new HashMap<SOAPVersion, String>();

        private FaultCode(String string2, String string3) {
            this.versionToCodeMap.put(SOAPVersion.SOAP_11, string2);
            this.versionToCodeMap.put(SOAPVersion.SOAP_12, string3);
        }

        public String getCodeLocalName(SOAPVersion sOAPVersion) {
            return this.versionToCodeMap.get((Object)sOAPVersion);
        }

        public String getCodeQualifiedName(SOAPVersion sOAPVersion) {
            String string = this.versionToCodeMap.get((Object)sOAPVersion);
            return sOAPVersion.getPrefix() + ":" + string;
        }

        public QName getCodeQName(SOAPVersion sOAPVersion) {
            String string = this.versionToCodeMap.get((Object)sOAPVersion);
            return new QName(sOAPVersion.getNamespaceUri(), string);
        }

        public Name getCodeName(SOAPVersion sOAPVersion) {
            String string = this.versionToCodeMap.get((Object)sOAPVersion);
            return new NameImpl(string, sOAPVersion.getPrefix(), sOAPVersion.getNamespaceUri());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Element {
        MC_SUPPORTED("MCSupported"),
        MC("MakeConnection"),
        ADDRESS("Address"),
        MISSING_SELECTION_FAULT("MissingSelection"),
        UNSUPPORTED_SELECTION_FAULT("UnsupportedSelection"),
        UNSUPPORTED_SELECTION("UnsupportedSelection"),
        MESSAGE_PENDING("MessagePending"),
        PENDING("pending");

        private String elementName;

        private Element(String string2) {
            this.elementName = string2;
        }

        public String getElementName() {
            return this.elementName;
        }

        public String getQualifiedName(McVersion mcVersion) {
            return mcVersion.getPrefix() + ":" + this.elementName;
        }

        public QName getQName(McVersion mcVersion) {
            return new QName(mcVersion.getNamespaceUri(), this.elementName, mcVersion.getPrefix());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Action {
        MC("MakeConnection"),
        FAULT("fault");

        String elementName;

        private Action(String string2) {
            this.elementName = string2;
        }

        public String getElementName() {
            return this.elementName;
        }

        public String getActionURI(McVersion mcVersion) {
            return mcVersion.getNamespaceUri() + "/" + this.elementName;
        }

        public boolean matchesAnyMCVersion(String string) {
            for (McVersion mcVersion : McVersion.values()) {
                if (!this.getActionURI(mcVersion).equals(string)) continue;
                return true;
            }
            return false;
        }

        public static boolean matchesAnyActionAndMCVersion(String string) {
            for (Action action : Action.values()) {
                if (!action.matchesAnyMCVersion(string)) continue;
                return true;
            }
            return false;
        }

        public static Action valueOfElementName(String string) {
            for (Action action : Action.values()) {
                if (!action.getElementName().equals(string)) continue;
                return action;
            }
            throw new IllegalArgumentException("No enum in " + Action.class.getName() + " with elementName: " + string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SOAPVersion {
        SOAP_11("soap", "http://schemas.xmlsoap.org/soap/envelope/"),
        SOAP_12("soap12", "http://www.w3.org/2003/05/soap-envelope");

        String prefix;
        String namespaceUri;

        private SOAPVersion(String string2, String string3) {
            this.prefix = string2;
            this.namespaceUri = string3;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getNamespaceUri() {
            return this.namespaceUri;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum McVersion {
        MC_11("wsmc", "http://docs.oasis-open.org/ws-rx/wsmc/200702");

        String prefix;
        String namespaceUri;

        private McVersion(String string2, String string3) {
            this.prefix = string2;
            this.namespaceUri = string3;
        }

        public static McVersion latest() {
            return MC_11;
        }

        public static McVersion forNamespaceUri(String string) {
            for (McVersion mcVersion : McVersion.values()) {
                if (!mcVersion.getNamespaceUri().equals(string)) continue;
                return mcVersion;
            }
            return McVersion.latest();
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getNamespaceUri() {
            return this.namespaceUri;
        }

        public boolean isLaterThan(McVersion mcVersion) {
            return mcVersion.ordinal() < this.ordinal();
        }

        public boolean isLaterThanOrEqualTo(McVersion mcVersion) {
            return mcVersion.ordinal() <= this.ordinal();
        }

        public boolean isBefore(McVersion mcVersion) {
            return mcVersion.ordinal() > this.ordinal();
        }
    }
}

