/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.mc.utils;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.message.StringHeader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import weblogic.protocol.LocalServerIdentity;
import weblogic.wsee.WseeMCLogger;
import weblogic.wsee.mc.faults.McFaultMsg;
import weblogic.wsee.mc.utils.McConstants;
import weblogic.wsee.util.Guid;

public class McProtocolUtils {
    private static final Logger LOGGER = Logger.getLogger(McProtocolUtils.class.getName());
    private static final String UTF8 = "UTF-8";

    public static McConstants.SOAPVersion getSOAPVersionFromName(Name name) {
        for (McConstants.SOAPVersion sOAPVersion : McConstants.SOAPVersion.values()) {
            if (!sOAPVersion.getNamespaceUri().equals(name.getURI())) continue;
            return sOAPVersion;
        }
        return McConstants.SOAPVersion.SOAP_11;
    }

    public static McConstants.FaultCode getSOAPFaultCodeFromName(Name name) {
        McConstants.SOAPVersion sOAPVersion = McProtocolUtils.getSOAPVersionFromName(name);
        for (McConstants.FaultCode faultCode : McConstants.FaultCode.values()) {
            if (!faultCode.getCodeLocalName(sOAPVersion).equals(name.getLocalName())) continue;
            return faultCode;
        }
        return null;
    }

    public static McConstants.SOAPVersion getSOAPVersionFromNamespaceUri(String string) {
        for (McConstants.SOAPVersion sOAPVersion : McConstants.SOAPVersion.values()) {
            if (!sOAPVersion.getNamespaceUri().equals(string)) continue;
            return sOAPVersion;
        }
        return McConstants.SOAPVersion.SOAP_11;
    }

    public static String generateUUID() {
        String string = Guid.generateGuid();
        String string2 = LocalServerIdentity.getIdentity().getServerName();
        if (string2 == null) {
            string2 = "client";
        }
        return "uuid:" + string2 + ":" + string.substring(5, string.length());
    }

    public static Message createMessageFromFaultMessage(McFaultMsg mcFaultMsg, AddressingVersion addressingVersion, SOAPVersion sOAPVersion) throws SOAPException {
        String string = sOAPVersion == SOAPVersion.SOAP_12 ? "SOAP 1.2 Protocol" : "SOAP 1.1 Protocol";
        MessageFactory messageFactory = MessageFactory.newInstance((String)string);
        SOAPMessage sOAPMessage = messageFactory.createMessage();
        mcFaultMsg.write(sOAPMessage);
        Message message = Messages.create((SOAPMessage)sOAPMessage);
        String string2 = McConstants.Action.FAULT.getActionURI(mcFaultMsg.getMcVersion());
        StringHeader stringHeader = new StringHeader(addressingVersion.actionTag, string2);
        message.getHeaders().add((Header)stringHeader);
        return message;
    }

    public static String encodeId(String string) {
        try {
            return URLEncoder.encode(string, UTF8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Encoding of id failed: " + unsupportedEncodingException.toString(), unsupportedEncodingException);
            }
            WseeMCLogger.logUnexpectedException((String)unsupportedEncodingException.toString(), (Throwable)unsupportedEncodingException);
            return string;
        }
    }

    public static String decodeId(String string) {
        try {
            return URLDecoder.decode(string, UTF8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Decode of id failed: " + unsupportedEncodingException.toString(), unsupportedEncodingException);
            }
            WseeMCLogger.logUnexpectedException((String)unsupportedEncodingException.toString(), (Throwable)unsupportedEncodingException);
            return string;
        }
    }
}

