/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.message;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.rpc.handler.MessageContext;

public class FilteredMessageContext
implements MessageContext {
    private static final String INTERNAL_PREFIX = "weblogic.wsee.";
    private final MessageContext messageContext;

    public FilteredMessageContext(MessageContext messageContext) {
        assert (messageContext != null) : "No message context";
        this.messageContext = messageContext;
    }

    private void checkKey(String string) {
        if (!this.isValid(string)) {
            throw new IllegalArgumentException(string + " starts with an internal prefix");
        }
    }

    private boolean isValid(String string) {
        return string == null || !string.startsWith(INTERNAL_PREFIX);
    }

    public void setProperty(String string, Object object) {
        this.checkKey(string);
        this.messageContext.setProperty(string, object);
    }

    public Object getProperty(String string) {
        this.checkKey(string);
        return this.messageContext.getProperty(string);
    }

    public void removeProperty(String string) {
        this.checkKey(string);
        this.messageContext.removeProperty(string);
    }

    public boolean containsProperty(String string) {
        this.checkKey(string);
        return this.messageContext.containsProperty(string);
    }

    public Iterator getPropertyNames() {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = this.messageContext.getPropertyNames();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!this.isValid(string)) continue;
            hashSet.add(string);
        }
        return Collections.unmodifiableSet(hashSet).iterator();
    }
}

