/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.message;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.NodeList;
import weblogic.wsee.message.MsgHeader;
import weblogic.wsee.message.MsgHeaderException;
import weblogic.wsee.message.MsgHeaderType;
import weblogic.wsee.message.MsgHeaders;
import weblogic.wsee.util.ToStringWriter;

public class FreeStandingMsgHeaders
implements MsgHeaders,
Serializable {
    private final Map headers = new HashMap();

    public MsgHeader getHeader(MsgHeaderType msgHeaderType) throws MsgHeaderException {
        return (MsgHeader)this.headers.get(msgHeaderType);
    }

    public void addHeader(MsgHeader msgHeader) throws MsgHeaderException {
        if (this.headers.containsKey(msgHeader.getType())) {
            throw new MsgHeaderException("FreeStandingMsgHeaders already contains header of type " + msgHeader.getName() + ". Cannot add another one.");
        }
        this.headers.put(msgHeader.getType(), msgHeader);
    }

    public void addHeaders(NodeList nodeList) throws MsgHeaderException {
    }

    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    public void merge(FreeStandingMsgHeaders freeStandingMsgHeaders) {
        Iterator iterator = freeStandingMsgHeaders.listHeaders();
        while (iterator.hasNext()) {
            MsgHeader msgHeader = (MsgHeader)iterator.next();
            if (msgHeader.isMultiple()) {
                this.addHeader(msgHeader);
                continue;
            }
            if (this.getHeader(msgHeader.getType()) != null) continue;
            this.addHeader(msgHeader);
        }
    }

    public Iterator listHeaders() {
        return this.headers.values().iterator();
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.writeMap("headers", this.headers);
    }
}

