/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.message;

import java.io.Serializable;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import weblogic.wsee.message.MsgHeaderException;
import weblogic.wsee.message.MsgHeaderType;
import weblogic.wsee.util.ToStringWriter;
import weblogic.xml.dom.DOMUtils;
import weblogic.xml.domimpl.DocumentImpl;

public abstract class MsgHeader
implements Serializable {
    private static final long serialVersionUID = -7520245755108809744L;
    private boolean mustUnderstand = false;
    private String role;
    private boolean refParam = false;
    private boolean hasDuplicated = false;
    private transient String currentSoapEnvelopeNamespace;

    public abstract MsgHeaderType getType();

    public abstract QName getName();

    public abstract void read(Element var1) throws MsgHeaderException;

    public abstract void write(Element var1) throws MsgHeaderException;

    public boolean isMultiple() {
        return false;
    }

    protected String getCurrentSoapEnvelopeNamespace() {
        return this.currentSoapEnvelopeNamespace;
    }

    public Element writeToParent(Element element) throws MsgHeaderException {
        Element element2;
        QName qName;
        int n;
        String string = element.getLocalName();
        if (null == string && null != (string = element.getNodeName()) && (n = string.indexOf(58)) >= 0) {
            string = string.substring(n + 1);
        }
        if ("Header".equals(string)) {
            this.currentSoapEnvelopeNamespace = this.getSoapNamespace(element);
        }
        if ((qName = this.getName()).getPrefix() != null && qName.getPrefix().length() > 0) {
            element2 = element.getOwnerDocument().createElementNS(qName.getNamespaceURI(), qName.getPrefix() + ":" + qName.getLocalPart());
            DOMUtils.addNamespaceDeclaration(element, qName.getPrefix(), qName.getNamespaceURI());
        } else {
            Document document = element.getOwnerDocument();
            element2 = document instanceof DocumentImpl ? ((DocumentImpl)document).createElementNS(qName.getNamespaceURI(), qName.getLocalPart(), "") : document.createElementNS(qName.getNamespaceURI(), qName.getLocalPart());
        }
        if (this.refParam) {
            DOMUtils.addNamespaceDeclaration(element2, "wsa", "http://www.w3.org/2005/08/addressing");
            element2.setAttributeNS("http://www.w3.org/2005/08/addressing", "wsa:IsReferenceParameter", "true");
        }
        this.addStandardNamespaces(element2);
        this.write(element2);
        element.appendChild(element2);
        return element2;
    }

    protected void addStandardNamespaces(Element element) {
        DOMUtils.addNamespaceDeclaration(element, "wsu", "http://schemas.xmlsoap.org/ws/2002/07/utility");
        if (this.isMustUnderstand()) {
            DOMUtils.addNamespaceDeclaration(element, "env", this.getCurrentSoapEnvelopeNamespace());
        }
    }

    public void setMustUnderstand(boolean bl) {
        this.mustUnderstand = bl;
    }

    public boolean isMustUnderstand() {
        return this.mustUnderstand;
    }

    public void setRefParam(boolean bl) {
        this.refParam = bl;
    }

    public boolean isRefParam() {
        return this.refParam;
    }

    public void setDuplicated(boolean bl) {
        this.hasDuplicated = bl;
    }

    public boolean hasDuplicated() {
        return this.hasDuplicated;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String string) {
        this.role = string;
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.writeField("name", this.getName());
        toStringWriter.writeField("role", this.role);
        toStringWriter.writeField("mustUnderstand", new Boolean(this.mustUnderstand));
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    private String getSoapNamespace(Element element) {
        assert (element != null);
        String string = element.getNamespaceURI();
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(string) || "http://www.w3.org/2003/05/soap-envelope".equals(string)) {
            return string;
        }
        return null;
    }
}

