/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.message;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import weblogic.wsee.jaxws.cluster.spi.ClusterMsgHeaderFactory;
import weblogic.wsee.message.MsgHeader;
import weblogic.wsee.message.MsgHeaderException;
import weblogic.wsee.message.MsgHeaderFactoryIntf;
import weblogic.wsee.message.StandardMsgHeaderFactory;
import weblogic.wsee.message.UnknownMsgHeader;
import weblogic.wsee.reliability.headers.WsrmMsgHeaderFactory;

public class MsgHeaderFactory
implements MsgHeaderFactoryIntf {
    private static final MsgHeaderFactory instance = new MsgHeaderFactory();
    private List<MsgHeaderFactoryIntf> subFactories = new ArrayList<MsgHeaderFactoryIntf>();
    private StandardMsgHeaderFactory _stdFactory;

    public static MsgHeaderFactory getInstance() {
        return instance;
    }

    public void addMsgHeaderClass(QName qName, Class clazz) {
        this._stdFactory.addMsgHeaderClass(qName, clazz);
    }

    public MsgHeader createMsgHeader(QName qName) throws MsgHeaderException {
        MsgHeaderFactoryIntf msgHeaderFactoryIntf;
        MsgHeader msgHeader = null;
        Iterator<MsgHeaderFactoryIntf> iterator = this.subFactories.iterator();
        while (iterator.hasNext() && (msgHeader = (msgHeaderFactoryIntf = iterator.next()).createMsgHeader(qName)) == null) {
        }
        if (msgHeader == null) {
            msgHeader = new UnknownMsgHeader(qName);
        }
        return msgHeader;
    }

    private void addMsgHeaderFactory(MsgHeaderFactoryIntf msgHeaderFactoryIntf) {
        this.subFactories.add(msgHeaderFactoryIntf);
    }

    private MsgHeaderFactory() {
    }

    static {
        MsgHeaderFactory msgHeaderFactory = MsgHeaderFactory.getInstance();
        msgHeaderFactory._stdFactory = new StandardMsgHeaderFactory();
        msgHeaderFactory.addMsgHeaderFactory(msgHeaderFactory._stdFactory);
        msgHeaderFactory.addMsgHeaderFactory(new ClusterMsgHeaderFactory());
        msgHeaderFactory.addMsgHeaderFactory(new WsrmMsgHeaderFactory());
    }
}

