/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.message;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import weblogic.wsee.addressing.ActionHeader;
import weblogic.wsee.addressing.AddressingHeader;
import weblogic.wsee.addressing.CallbackToHeader;
import weblogic.wsee.addressing.EmbeddedWsdlHeader;
import weblogic.wsee.addressing.FaultDetailHeader;
import weblogic.wsee.addressing.FaultToHeader;
import weblogic.wsee.addressing.FromHeader;
import weblogic.wsee.addressing.InterfaceNameHeader;
import weblogic.wsee.addressing.MessageIdHeader;
import weblogic.wsee.addressing.RelatesToHeader;
import weblogic.wsee.addressing.ReplyToHeader;
import weblogic.wsee.addressing.ServiceNameHeader;
import weblogic.wsee.addressing.SetCookieHeader;
import weblogic.wsee.addressing.TimestampHeader;
import weblogic.wsee.addressing.ToHeader;
import weblogic.wsee.callback.CallbackInfoHeader;
import weblogic.wsee.callback.Wlw81CallbackHeader;
import weblogic.wsee.callback.controls.ControlCallbackInfoHeader;
import weblogic.wsee.cluster.CorrelationHeader;
import weblogic.wsee.cluster.ServiceIdentityHeader;
import weblogic.wsee.conversation.ContinueHeader;
import weblogic.wsee.conversation.StartHeader;
import weblogic.wsee.message.MsgHeader;
import weblogic.wsee.message.MsgHeaderException;
import weblogic.wsee.message.MsgHeaderFactoryIntf;
import weblogic.wsee.reliability.SAFServerHeader;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability.headers.AckRequestedHeader;
import weblogic.wsee.reliability.headers.AcknowledgementHeader;
import weblogic.wsee.reliability.headers.SequenceHeader;
import weblogic.wsee.reliability.headers.TestSequenceSSLHeader;
import weblogic.wsee.reliability.headers.UsesSequenceSSLHeader;
import weblogic.wsee.reliability.headers.UsesSequenceSTRHeader;
import weblogic.wsee.reliability.headers.WsrmHeader;
import weblogic.wsee.workarea.WorkAreaHeader;
import weblogic.wsee.wsa.wsaddressing.WSAddressingConstants;

public class StandardMsgHeaderFactory
implements MsgHeaderFactoryIntf {
    private Map headerClasses = new HashMap();
    private static Set needFillQNameHeaders = new HashSet();

    public MsgHeader createMsgHeader(QName qName) throws MsgHeaderException {
        try {
            Class clazz = (Class)this.headerClasses.get(qName);
            if (clazz != null) {
                MsgHeader msgHeader = (MsgHeader)clazz.newInstance();
                if (needFillQNameHeaders.contains(clazz)) {
                    if (msgHeader instanceof AddressingHeader) {
                        ((AddressingHeader)((Object)msgHeader)).setName(qName);
                    } else if (msgHeader instanceof WsrmHeader) {
                        ((WsrmHeader)msgHeader).setNamespaceUri(qName.getNamespaceURI());
                    }
                }
                return msgHeader;
            }
            return null;
        }
        catch (MsgHeaderException msgHeaderException) {
            throw msgHeaderException;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new MsgHeaderException("Could not build header for " + qName, illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new MsgHeaderException("Could not build header for " + qName, instantiationException);
        }
    }

    void addMsgHeaderClass(QName qName, Class clazz) {
        this.headerClasses.put(qName, clazz);
    }

    StandardMsgHeaderFactory() {
        needFillQNameHeaders.add(ToHeader.class);
        needFillQNameHeaders.add(FromHeader.class);
        needFillQNameHeaders.add(MessageIdHeader.class);
        needFillQNameHeaders.add(ReplyToHeader.class);
        needFillQNameHeaders.add(FaultToHeader.class);
        needFillQNameHeaders.add(ActionHeader.class);
        needFillQNameHeaders.add(RelatesToHeader.class);
        this.addMsgHeaderClass(WSAddressingConstants.WSA_HEADER_TO_10, ToHeader.class);
        this.addMsgHeaderClass(WSAddressingConstants.WSA_HEADER_TO, ToHeader.class);
        this.addMsgHeaderClass(WSAddressingConstants.WSA_HEADER_SOURCE_10, FromHeader.class);
        this.addMsgHeaderClass(WSAddressingConstants.WSA_HEADER_SOURCE, FromHeader.class);
        this.addMsgHeaderClass(WSAddressingConstants.WSA_HEADER_MESSAGE_ID_10, MessageIdHeader.class);
        this.addMsgHeaderClass(WSAddressingConstants.WSA_HEADER_MESSAGE_ID, MessageIdHeader.class);
        this.addMsgHeaderClass(WSAddressingConstants.WSA_HEADER_REPLY_TO_10, ReplyToHeader.class);
        this.addMsgHeaderClass(WSAddressingConstants.WSA_HEADER_REPLY_TO, ReplyToHeader.class);
        this.addMsgHeaderClass(WSAddressingConstants.WSA_HEADER_FAULT_TO_10, FaultToHeader.class);
        this.addMsgHeaderClass(WSAddressingConstants.WSA_HEADER_FAULT_TO, FaultToHeader.class);
        this.addMsgHeaderClass(WSAddressingConstants.WSA_HEADER_ACTION_10, ActionHeader.class);
        this.addMsgHeaderClass(WSAddressingConstants.WSA_HEADER_ACTION, ActionHeader.class);
        this.addMsgHeaderClass(WSAddressingConstants.WSA_HEADER_RELATES_TO_10, RelatesToHeader.class);
        this.addMsgHeaderClass(WSAddressingConstants.WSA_HEADER_RELATES_TO, RelatesToHeader.class);
        this.addMsgHeaderClass(WSAddressingConstants.WSA_HEADER_FAULT_DETAIL, FaultDetailHeader.class);
        this.addMsgHeaderClass(WSAddressingConstants.WSA_HEADER_FAULT_DETAIL_10, FaultDetailHeader.class);
        this.addMsgHeaderClass(WSAddressingConstants.WSA_HEADER_METADATA_INTERFACE_NAME_10, InterfaceNameHeader.class);
        this.addMsgHeaderClass(WSAddressingConstants.WSA_HEADER_METADATA_SERVICE_NAME_10, ServiceNameHeader.class);
        this.addMsgHeaderClass(WSAddressingConstants.WSA_METADATA_EMBEDDED_WSDL_NAME_11, EmbeddedWsdlHeader.class);
        this.addMsgHeaderClass(WSAddressingConstants.WSA_METADATA_EMBEDDED_WSDL_NAME_20, EmbeddedWsdlHeader.class);
        this.addMsgHeaderClass(SetCookieHeader.NAME, SetCookieHeader.class);
        this.addMsgHeaderClass(TimestampHeader.NAME, TimestampHeader.class);
        this.addMsgHeaderClass(StartHeader.NAME, StartHeader.class);
        this.addMsgHeaderClass(ContinueHeader.NAME, ContinueHeader.class);
        this.addMsgHeaderClass(CallbackToHeader.NAME, CallbackToHeader.class);
        for (WsrmConstants.RMVersion rMVersion : WsrmConstants.RMVersion.values()) {
            this.addMsgHeaderClass(WsrmHeader.getQName(AcknowledgementHeader.class, rMVersion), AcknowledgementHeader.class);
            this.addMsgHeaderClass(WsrmHeader.getQName(AckRequestedHeader.class, rMVersion), AckRequestedHeader.class);
            this.addMsgHeaderClass(WsrmHeader.getQName(SequenceHeader.class, rMVersion), SequenceHeader.class);
            needFillQNameHeaders.add(AcknowledgementHeader.class);
            needFillQNameHeaders.add(AckRequestedHeader.class);
            needFillQNameHeaders.add(SequenceHeader.class);
            if (!rMVersion.isLaterThanOrEqualTo(WsrmConstants.RMVersion.RM_11)) continue;
            this.addMsgHeaderClass(WsrmHeader.getQName(UsesSequenceSTRHeader.class, rMVersion), UsesSequenceSTRHeader.class);
            this.addMsgHeaderClass(WsrmHeader.getQName(UsesSequenceSSLHeader.class, rMVersion), UsesSequenceSSLHeader.class);
            this.addMsgHeaderClass(WsrmHeader.getQName(TestSequenceSSLHeader.class, rMVersion), TestSequenceSSLHeader.class);
            needFillQNameHeaders.add(UsesSequenceSTRHeader.class);
            needFillQNameHeaders.add(UsesSequenceSSLHeader.class);
            needFillQNameHeaders.add(TestSequenceSSLHeader.class);
        }
        this.addMsgHeaderClass(WorkAreaHeader.NAME, WorkAreaHeader.class);
        this.addMsgHeaderClass(CorrelationHeader.NAME, CorrelationHeader.class);
        this.addMsgHeaderClass(ServiceIdentityHeader.NAME, ServiceIdentityHeader.class);
        this.addMsgHeaderClass(SAFServerHeader.NAME, SAFServerHeader.class);
        this.addMsgHeaderClass(CallbackInfoHeader.NAME, CallbackInfoHeader.class);
        this.addMsgHeaderClass(ControlCallbackInfoHeader.NAME, ControlCallbackInfoHeader.class);
        this.addMsgHeaderClass(Wlw81CallbackHeader.NAME, Wlw81CallbackHeader.class);
    }
}

