/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.message;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import weblogic.apache.xml.serialize.OutputFormat;
import weblogic.apache.xml.serialize.XMLSerializer;
import weblogic.wsee.message.MsgHeader;
import weblogic.wsee.message.MsgHeaderException;
import weblogic.wsee.message.MsgHeaderType;
import weblogic.xml.dom.DOMStreamReader;
import weblogic.xml.dom.DOMStreamWriter;
import weblogic.xml.stax.ChildReaderToWriter;

public class UnknownMsgHeader
extends MsgHeader
implements Externalizable {
    private final MsgHeaderType type = new MsgHeaderType();
    private Element xmlHeader;
    private QName qname;

    public UnknownMsgHeader() {
    }

    public UnknownMsgHeader(QName qName) {
        this.qname = qName;
    }

    public UnknownMsgHeader(Element element) {
        String string;
        String string2 = element.getPrefix();
        if (string2 == null) {
            string2 = "";
        }
        if ((string = element.getLocalName()) == null) {
            string = element.getNodeName();
        }
        this.qname = new QName(element.getNamespaceURI(), string, string2);
        this.xmlHeader = element;
    }

    public MsgHeaderType getType() {
        return this.type;
    }

    public QName getName() {
        return this.qname;
    }

    public Element getElement() {
        return this.xmlHeader;
    }

    public void read(Element element) throws MsgHeaderException {
        this.xmlHeader = element;
    }

    public void write(Element element) throws MsgHeaderException {
        try {
            if (this.xmlHeader.getLocalName() == null) {
                this.xmlHeader = (Element)element.getOwnerDocument().importNode(this.xmlHeader, true);
            }
            DOMStreamReader dOMStreamReader = new DOMStreamReader(this.xmlHeader);
            DOMStreamWriter dOMStreamWriter = new DOMStreamWriter(element.getOwnerDocument(), element);
            new ChildReaderToWriter((XMLStreamWriter)((Object)dOMStreamWriter)).writeChildren((XMLStreamReader)dOMStreamReader);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MsgHeaderException("Could not write " + this.getName().getLocalPart(), xMLStreamException);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        String string = objectInput.readUTF();
        String string2 = objectInput.readUTF();
        String string3 = objectInput.readUTF();
        this.qname = new QName(string, string2, string3);
        int n = objectInput.readInt();
        byte[] byArray = new byte[n];
        int n2 = 0;
        for (int i = 0; i < n; i += n2) {
            n2 = objectInput.read(byArray, i, n - i);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(byteArrayInputStream);
            this.xmlHeader = document.getDocumentElement();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException(parserConfigurationException.toString());
        }
        catch (SAXException sAXException) {
            throw new IOException(sAXException.toString());
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeUTF(this.qname.getNamespaceURI());
        objectOutput.writeUTF(this.qname.getLocalPart());
        objectOutput.writeUTF(this.qname.getPrefix());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputFormat outputFormat = new OutputFormat("XML", null, false);
        XMLSerializer xMLSerializer = new XMLSerializer((OutputStream)byteArrayOutputStream, outputFormat);
        xMLSerializer.serialize(this.xmlHeader);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        objectOutput.writeInt(byArray.length);
        objectOutput.write(byArray);
    }
}

