/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.message.soap;

import java.io.IOException;
import java.util.Locale;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import weblogic.wsee.jaxrpc.soapfault.SOAPFaultUtil;
import weblogic.wsee.jws.container.InvokeException;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.message.soap.SoapMsgHeaders;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.util.WLMessageFactory;
import weblogic.xml.saaj.MessageFactoryImpl;
import weblogic.xml.saaj.SOAPMessageImpl;
import weblogic.xml.saaj.util.HeaderUtils;

public class SoapMessageContext
extends WlMessageContext
implements SOAPMessageContext {
    private static final boolean verbose = Verbose.isVerbose(SoapMessageContext.class);
    protected SOAPMessage msg;
    private MessageFactory messageFactory;
    private boolean soap12 = false;
    private boolean isMsgReset = true;
    private boolean _hasFault;

    public SoapMessageContext() {
        this(false);
    }

    public SoapMessageContext(boolean bl) {
        this.soap12 = bl;
        this.messageFactory = WLMessageFactory.getInstance().getMessageFactory(this.soap12);
        if (verbose) {
            Verbose.log("Created");
        }
    }

    public SOAPMessage getMessage() {
        if (this.msg == null) {
            try {
                this.msg = this.messageFactory.createMessage();
            }
            catch (SOAPException sOAPException) {
                throw new JAXRPCException((Throwable)sOAPException);
            }
        }
        return this.msg;
    }

    public void setMessage(SOAPMessage sOAPMessage) {
        if (verbose) {
            Verbose.log("set Message called: " + sOAPMessage);
        }
        this.msg = sOAPMessage;
        if (this.msg != null) {
            this.setHeaders(new SoapMsgHeaders(sOAPMessage));
        }
        this.isMsgReset = true;
    }

    public String[] getRoles() {
        return new String[0];
    }

    public MessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    public SOAPMessage clearMessage() {
        return this.clearMessage(false);
    }

    public SOAPMessage clearMessage(boolean bl) {
        if (verbose) {
            Verbose.log("Reset message");
        }
        try {
            SOAPMessage sOAPMessage = ((MessageFactoryImpl)this.messageFactory).createMessage(false, bl);
            String string = (String)this.getProperty("weblogic.wsee.client.xmlcharset");
            if (!StringUtil.isEmpty(string) && !string.toLowerCase(Locale.ENGLISH).equals("utf-8")) {
                this.setCharacterEncoding(string, bl, sOAPMessage);
            }
            this.setMessage(sOAPMessage);
        }
        catch (SOAPException sOAPException) {
            throw new JAXRPCException((Throwable)sOAPException);
        }
        catch (IOException iOException) {
            throw new JAXRPCException((Throwable)iOException);
        }
        return this.msg;
    }

    private void setCharacterEncoding(String string, boolean bl, SOAPMessage sOAPMessage) {
        bl = false;
        String string2 = HeaderUtils.constructContentTypeHeader(null, (String)string, (SOAPMessageImpl)((SOAPMessageImpl)sOAPMessage), (boolean)bl, (boolean)this.soap12);
        sOAPMessage.getMimeHeaders().setHeader("Content-Type", string2);
        try {
            sOAPMessage.setProperty("javax.xml.soap.character-set-encoding", (Object)string);
            sOAPMessage.setProperty("javax.xml.soap.write-xml-declaration", (Object)"true");
        }
        catch (Exception exception) {
            throw new InvokeException("can't change soap message characterEncoding", exception);
        }
    }

    public boolean hasFault() {
        boolean bl = super.hasFault();
        if (bl) {
            return true;
        }
        if (this.getProperty("weblogic.wsee.ignore.fault") != null) {
            return false;
        }
        if (this.isMsgReset) {
            this.isMsgReset = false;
            SOAPMessage sOAPMessage = this.getMessage();
            try {
                SOAPBody sOAPBody;
                if (sOAPMessage != null && (sOAPBody = sOAPMessage.getSOAPBody()) != null) {
                    this._hasFault = sOAPBody.hasFault();
                }
            }
            catch (SOAPException sOAPException) {
                throw new JAXRPCException("Failed to call hasFault", (Throwable)sOAPException);
            }
        }
        return this._hasFault;
    }

    public void setFault(Throwable throwable) {
        if (throwable == null && this.hasFault()) {
            this.clearMessage();
        }
        super.setFault(throwable);
        if (throwable == null) {
            return;
        }
        if (SOAPFaultUtil.isVersionMismatch(throwable)) {
            this.setMessage(SOAPFaultUtil.createVersionMismatchMsg(this.soap12, throwable));
        } else {
            this.setMessage(SOAPFaultUtil.exception2Fault(this.messageFactory, throwable));
        }
    }

    public boolean isSoap12() {
        return this.soap12;
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.writeField("hasFault", "" + this.hasFault());
        toStringWriter.writeMap("properties", this.propertyMap);
        toStringWriter.end();
    }
}

