/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.message.soap;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weblogic.wsee.addressing.AddressingHeader;
import weblogic.wsee.message.MsgHeader;
import weblogic.wsee.message.MsgHeaderException;
import weblogic.wsee.message.MsgHeaderFactory;
import weblogic.wsee.message.MsgHeaderType;
import weblogic.wsee.message.MsgHeaders;
import weblogic.wsee.util.Verbose;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public class SoapMsgHeaders
implements MsgHeaders {
    private static final boolean verbose = Verbose.isVerbose(SoapMsgHeaders.class);
    private final SOAPMessage message;
    private Element soapHeader;
    private final Map parsedHeaders = new HashMap();

    public SoapMsgHeaders(Element element) throws MsgHeaderException {
        this.message = null;
        this.soapHeader = element;
        this.parseHeaders(this.soapHeader);
    }

    public SoapMsgHeaders(SOAPMessage sOAPMessage) throws MsgHeaderException {
        this.message = sOAPMessage;
        try {
            this.soapHeader = sOAPMessage.getSOAPHeader();
            if (this.soapHeader != null) {
                this.parseHeaders(this.soapHeader);
            }
        }
        catch (SOAPException sOAPException) {
            throw new MsgHeaderException("Could not access SOAP header", sOAPException);
        }
    }

    public MsgHeader getHeader(MsgHeaderType msgHeaderType) throws MsgHeaderException {
        return (MsgHeader)this.parsedHeaders.get(msgHeaderType);
    }

    public void addHeader(MsgHeader msgHeader) throws MsgHeaderException {
        this.addHeaderInternal(msgHeader, false);
    }

    private void addHeaderInternal(MsgHeader msgHeader, boolean bl) throws MsgHeaderException {
        if (!bl && this.parsedHeaders.containsKey(msgHeader.getType())) {
            throw new MsgHeaderException("SoapMsgHeaders already contains header of type " + msgHeader.getName() + ". Cannot add another one.");
        }
        this.parsedHeaders.put(msgHeader.getType(), msgHeader);
        this.ensureSOAPHeader();
        Element element = msgHeader.writeToParent(this.soapHeader);
        if (msgHeader.getRole() != null) {
            this.setActor(element, msgHeader.getRole());
        }
        if (msgHeader.isMustUnderstand()) {
            this.setMustUnderstand(element, true);
        }
    }

    public void replaceHeader(MsgHeader msgHeader) throws MsgHeaderException {
        this.ensureSOAPHeader();
        QName qName = msgHeader.getName();
        NodeList nodeList = this.soapHeader.getElementsByTagNameNS(qName.getNamespaceURI(), qName.getLocalPart());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            this.soapHeader.removeChild(nodeList.item(i));
        }
        this.addHeaderInternal(msgHeader, true);
    }

    public void addHeaders(NodeList nodeList) throws MsgHeaderException {
        this.ensureSOAPHeader();
        try {
            DOMUtils.copyNodes(this.soapHeader, nodeList);
        }
        catch (DOMProcessingException dOMProcessingException) {
            throw new MsgHeaderException("Could not copy headers", (Throwable)((Object)dOMProcessingException));
        }
    }

    private void ensureSOAPHeader() {
        if (this.soapHeader == null) {
            if (this.message == null) {
                throw new MsgHeaderException("Could not create SOAP header - not inside a message");
            }
            try {
                this.soapHeader = this.message.getSOAPHeader();
                if (this.soapHeader == null) {
                    this.soapHeader = this.message.getSOAPPart().getEnvelope().addHeader();
                }
            }
            catch (SOAPException sOAPException) {
                throw new MsgHeaderException("Could not add SOAP header", sOAPException);
            }
        }
    }

    public boolean isEmpty() {
        return this.parsedHeaders.isEmpty();
    }

    public Iterator listHeaders() {
        return this.parsedHeaders.values().iterator();
    }

    private void parseHeaders(Element element) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element element2;
            if (!(node instanceof Element) || (element2 = (Element)node).getNamespaceURI() == null) continue;
            QName qName = new QName(element2.getNamespaceURI(), element2.getLocalName());
            MsgHeader msgHeader = MsgHeaderFactory.getInstance().createMsgHeader(qName);
            msgHeader.read(element2);
            String string = this.getActor(element2);
            if (string != null && string.length() > 0) {
                msgHeader.setRole(string);
            }
            msgHeader.setMustUnderstand(this.getMustUnderstand(element2));
            if (verbose) {
                Verbose.log("Parsed header " + qName + ":" + msgHeader);
            }
            if (this.parsedHeaders.get(msgHeader.getType()) != null) {
                if (msgHeader instanceof AddressingHeader) {
                    msgHeader.setDuplicated(true);
                } else if (!msgHeader.isMultiple()) {
                    throw new JAXRPCException("Duplicate header " + qName + ":" + msgHeader);
                }
            }
            this.parsedHeaders.put(msgHeader.getType(), msgHeader);
        }
    }

    private String getSoapNamespace(Element element) {
        Node node = element.getParentNode();
        assert (node != null);
        String string = node.getNamespaceURI();
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(string) || "http://www.w3.org/2003/05/soap-envelope".equals(string)) {
            return string;
        }
        return null;
    }

    public boolean getMustUnderstand(Element element) {
        String string = this.getSoapNamespace(element);
        if (string == null) {
            return false;
        }
        Attr attr = element.getAttributeNodeNS(string, "mustUnderstand");
        if (attr == null) {
            return false;
        }
        String string2 = attr.getValue();
        return "1".equals(string2) || "true".equals(string2);
    }

    public void setMustUnderstand(Element element, boolean bl) {
        String string = this.getSoapNamespace(element);
        if (string == null) {
            return;
        }
        element.setAttributeNS(string, "env:mustUnderstand", bl ? "1" : "0");
    }

    public String getActor(Element element) {
        String string = this.getSoapNamespace(element);
        if (string == null) {
            return null;
        }
        return element.getAttributeNS(string, "actor");
    }

    public void setActor(Element element, String string) {
        String string2 = this.getSoapNamespace(element);
        if (string2 == null) {
            return;
        }
        element.setAttributeNS(string2, "actor", string);
    }
}

