/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.monitoring;

import java.util.Date;
import weblogic.management.ManagementException;
import weblogic.wsee.monitoring.WseeAggregatableBaseOperationRuntimeData;
import weblogic.wsee.monitoring.WseeBaseRuntimeData;
import weblogic.wsee.util.Verbose;

public class WseeBaseOperationRuntimeData
extends WseeAggregatableBaseOperationRuntimeData {
    public static final String WS_PROTOCOL_OP_NAME = "Ws-Protocol";
    private static final long nanoPerMilli = 1000000L;
    private static final boolean verbose = Verbose.isVerbose(WseeBaseOperationRuntimeData.class);
    private int dispatchCount = 0;
    private long dispatchTimeTotal = 0L;
    private long dispatchTimeHigh = 0L;
    private long dispatchTimeLow = 0L;
    private int executionCount = 0;
    private long executionTimeTotal = 0L;
    private long executionTimeHigh = 0L;
    private long executionTimeLow = 0L;
    private int responseCount = 0;
    private long responseTimeTotal = 0L;
    private long responseTimeHigh = 0L;
    private long responseTimeLow = 0L;
    private int responseErrorCount = 0;
    private Throwable lastResponseError = null;
    private long lastInvocationTime;
    private int errorCount;
    private Throwable lastError = null;
    private long lastErrorTime;
    private long lastResponseTime;
    private long lastResponseErrorTime;
    private long lastResetTime;

    public static WseeBaseOperationRuntimeData createWsProtocolOp(WseeBaseRuntimeData wseeBaseRuntimeData) throws ManagementException {
        WseeBaseOperationRuntimeData wseeBaseOperationRuntimeData = new WseeBaseOperationRuntimeData(WS_PROTOCOL_OP_NAME);
        wseeBaseOperationRuntimeData.setParentData(wseeBaseRuntimeData);
        return wseeBaseOperationRuntimeData;
    }

    WseeBaseOperationRuntimeData(String string) {
        super(string, null);
    }

    public String getOperationName() {
        return this.getName();
    }

    public int getInvocationCount() {
        return this.dispatchCount;
    }

    public long getDispatchTimeTotal() {
        return this.dispatchTimeTotal / 1000000L;
    }

    public long getDispatchTimeHigh() {
        return this.dispatchTimeHigh / 1000000L;
    }

    public long getDispatchTimeLow() {
        return this.dispatchTimeLow / 1000000L;
    }

    public long getDispatchTimeAverage() {
        return this.dispatchCount == 0 ? 0L : this.dispatchTimeTotal / (long)this.dispatchCount / 1000000L;
    }

    public long getExecutionTimeTotal() {
        return this.executionTimeTotal / 1000000L;
    }

    public long getExecutionTimeHigh() {
        return this.executionTimeHigh / 1000000L;
    }

    public long getExecutionTimeLow() {
        return this.executionTimeLow / 1000000L;
    }

    public long getExecutionTimeAverage() {
        return this.executionCount == 0 ? 0L : this.executionTimeTotal / (long)this.executionCount / 1000000L;
    }

    public int getResponseCount() {
        return this.responseCount;
    }

    public long getResponseTimeTotal() {
        return this.responseTimeTotal / 1000000L;
    }

    public long getResponseTimeHigh() {
        return this.responseTimeHigh / 1000000L;
    }

    public long getResponseTimeLow() {
        return this.responseTimeLow / 1000000L;
    }

    public long getResponseTimeAverage() {
        return this.responseCount == 0 ? 0L : this.responseTimeTotal / (long)this.responseCount / 1000000L;
    }

    public int getResponseErrorCount() {
        return this.responseErrorCount;
    }

    public long getLastInvocationTime() {
        return this.lastInvocationTime;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public String getLastError() {
        return this.lastError != null ? this.lastError.toString() : null;
    }

    public long getLastErrorTime() {
        return this.lastErrorTime;
    }

    public long getLastResponseTime() {
        return this.lastResponseTime;
    }

    public long getLastResponseErrorTime() {
        return this.lastResponseErrorTime;
    }

    public String getLastResponseError() {
        return this.lastResponseError != null ? this.lastResponseError.toString() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportInvocation(long l, long l2, long l3) {
        if (verbose) {
            Verbose.log("WSEE[MONITORING[Invocation[DispatchTime=" + l + "][ExecutionTime=" + l2 + "][ResponseTime=" + l3 + "]]]");
        }
        WseeBaseOperationRuntimeData wseeBaseOperationRuntimeData = this;
        synchronized (wseeBaseOperationRuntimeData) {
            this.unsync_reportDispatch(l);
            this.unsync_reportExecution(l2);
            this.unsync_reportResponse(l3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportOnewayInvocation(long l, long l2) {
        if (verbose) {
            Verbose.log("WSEE[MONITORING[Invocation[DispatchTime=" + l + "][ExecutionTime=" + l2 + "]]]");
        }
        WseeBaseOperationRuntimeData wseeBaseOperationRuntimeData = this;
        synchronized (wseeBaseOperationRuntimeData) {
            this.unsync_reportDispatch(l);
            this.unsync_reportExecution(l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportDispatch(long l) {
        WseeBaseOperationRuntimeData wseeBaseOperationRuntimeData = this;
        synchronized (wseeBaseOperationRuntimeData) {
            this.unsync_reportDispatch(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportExecution(long l) {
        WseeBaseOperationRuntimeData wseeBaseOperationRuntimeData = this;
        synchronized (wseeBaseOperationRuntimeData) {
            this.unsync_reportExecution(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportResponse(long l) {
        WseeBaseOperationRuntimeData wseeBaseOperationRuntimeData = this;
        synchronized (wseeBaseOperationRuntimeData) {
            this.unsync_reportResponse(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportError(Throwable throwable) {
        WseeBaseOperationRuntimeData wseeBaseOperationRuntimeData = this;
        synchronized (wseeBaseOperationRuntimeData) {
            ++this.errorCount;
            this.lastError = throwable;
            this.lastErrorTime = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportResponseError(Throwable throwable) {
        WseeBaseOperationRuntimeData wseeBaseOperationRuntimeData = this;
        synchronized (wseeBaseOperationRuntimeData) {
            ++this.responseErrorCount;
            this.lastResponseError = throwable;
            this.lastResponseErrorTime = System.currentTimeMillis();
        }
    }

    private void unsync_reportResponse(long l) {
        if (l >= 0L) {
            this.lastResponseTime = System.currentTimeMillis();
            if (this.responseCount == 0) {
                this.responseTimeTotal = l;
                this.responseTimeHigh = l;
                this.responseTimeLow = l;
                this.responseCount = 1;
            } else {
                ++this.responseCount;
                this.responseTimeTotal += l;
                if (l > this.responseTimeHigh) {
                    this.responseTimeHigh = l;
                }
                if (l < this.responseTimeLow) {
                    this.responseTimeLow = l;
                }
            }
        }
    }

    private void unsync_reportExecution(long l) {
        if (l > 0L) {
            if (this.executionCount == 0) {
                this.executionTimeTotal = l;
                this.executionTimeHigh = l;
                this.executionTimeLow = l;
                this.executionCount = 1;
            } else {
                ++this.executionCount;
                this.executionTimeTotal += l;
                if (l > this.executionTimeHigh) {
                    this.executionTimeHigh = l;
                }
                if (l < this.executionTimeLow) {
                    this.executionTimeLow = l;
                }
            }
        }
    }

    private void unsync_reportDispatch(long l) {
        if (l >= 0L) {
            this.lastInvocationTime = System.currentTimeMillis();
            if (this.dispatchCount == 0) {
                this.dispatchTimeTotal = l;
                this.dispatchTimeHigh = l;
                this.dispatchTimeLow = l;
                this.dispatchCount = 1;
            } else {
                ++this.dispatchCount;
                this.dispatchTimeTotal += l;
                if (l > this.dispatchTimeHigh) {
                    this.dispatchTimeHigh = l;
                }
                if (l < this.dispatchTimeLow) {
                    this.dispatchTimeLow = l;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        WseeBaseOperationRuntimeData wseeBaseOperationRuntimeData = this;
        synchronized (wseeBaseOperationRuntimeData) {
            this.lastResetTime = System.currentTimeMillis();
            this.executionCount = 0;
            this.dispatchTimeTotal = 0L;
            this.dispatchTimeHigh = 0L;
            this.dispatchTimeLow = 0L;
            this.executionTimeTotal = 0L;
            this.executionTimeHigh = 0L;
            this.executionTimeLow = 0L;
            this.lastResponseErrorTime = 0L;
            this.lastResponseError = null;
            this.lastInvocationTime = 0L;
            this.errorCount = 0;
            this.lastError = null;
            this.lastErrorTime = 0L;
            this.lastResponseTime = 0L;
            this.lastResponseErrorTime = 0L;
        }
    }

    public Date getLastResetTime() {
        return new Date(this.lastResetTime);
    }
}

