/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.monitoring;

import com.sun.istack.Nullable;
import java.util.Set;
import weblogic.management.ManagementException;
import weblogic.wsee.monitoring.WseeAggregatableBaseOperationRuntimeData;
import weblogic.wsee.monitoring.WseeBaseOperationRuntimeData;
import weblogic.wsee.monitoring.WseeBasePortRuntimeData;
import weblogic.wsee.monitoring.WseeBaseRuntimeData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WseeBasePortAggregatedBaseOperationsRuntimeData
extends WseeAggregatableBaseOperationRuntimeData {
    public WseeBasePortAggregatedBaseOperationsRuntimeData(String string, @Nullable WseeBaseRuntimeData wseeBaseRuntimeData) throws ManagementException {
        super(string, wseeBaseRuntimeData);
    }

    @Override
    public int getErrorCount() {
        int n = 0;
        for (WseeBaseOperationRuntimeData wseeBaseOperationRuntimeData : this.getOperationsData()) {
            n += wseeBaseOperationRuntimeData.getErrorCount();
        }
        return n;
    }

    @Override
    public int getInvocationCount() {
        int n = 0;
        for (WseeBaseOperationRuntimeData wseeBaseOperationRuntimeData : this.getOperationsData()) {
            n += wseeBaseOperationRuntimeData.getInvocationCount();
        }
        return n;
    }

    @Override
    public int getResponseCount() {
        int n = 0;
        for (WseeBaseOperationRuntimeData wseeBaseOperationRuntimeData : this.getOperationsData()) {
            n += wseeBaseOperationRuntimeData.getResponseCount();
        }
        return n;
    }

    @Override
    public int getResponseErrorCount() {
        int n = 0;
        for (WseeBaseOperationRuntimeData wseeBaseOperationRuntimeData : this.getOperationsData()) {
            n += wseeBaseOperationRuntimeData.getResponseErrorCount();
        }
        return n;
    }

    @Override
    public long getDispatchTimeTotal() {
        long l = 0L;
        for (WseeBaseOperationRuntimeData wseeBaseOperationRuntimeData : this.getOperationsData()) {
            if (wseeBaseOperationRuntimeData.getInvocationCount() <= 0) continue;
            l += wseeBaseOperationRuntimeData.getDispatchTimeTotal();
        }
        return l;
    }

    @Override
    public long getExecutionTimeTotal() {
        long l = 0L;
        for (WseeBaseOperationRuntimeData wseeBaseOperationRuntimeData : this.getOperationsData()) {
            if (wseeBaseOperationRuntimeData.getInvocationCount() <= 0) continue;
            l += wseeBaseOperationRuntimeData.getExecutionTimeTotal();
        }
        return l;
    }

    @Override
    public long getResponseTimeTotal() {
        long l = 0L;
        for (WseeBaseOperationRuntimeData wseeBaseOperationRuntimeData : this.getOperationsData()) {
            if (wseeBaseOperationRuntimeData.getResponseCount() <= 0) continue;
            l += wseeBaseOperationRuntimeData.getResponseTimeTotal();
        }
        return l;
    }

    @Override
    public long getDispatchTimeHigh() {
        long l = 0L;
        for (WseeBaseOperationRuntimeData wseeBaseOperationRuntimeData : this.getOperationsData()) {
            if (wseeBaseOperationRuntimeData.getInvocationCount() <= 0) continue;
            l = Math.max(l, wseeBaseOperationRuntimeData.getDispatchTimeHigh());
        }
        return l;
    }

    @Override
    public long getExecutionTimeHigh() {
        long l = 0L;
        for (WseeBaseOperationRuntimeData wseeBaseOperationRuntimeData : this.getOperationsData()) {
            if (wseeBaseOperationRuntimeData.getInvocationCount() <= 0) continue;
            l = Math.max(l, wseeBaseOperationRuntimeData.getExecutionTimeHigh());
        }
        return l;
    }

    @Override
    public long getResponseTimeHigh() {
        long l = 0L;
        for (WseeBaseOperationRuntimeData wseeBaseOperationRuntimeData : this.getOperationsData()) {
            if (wseeBaseOperationRuntimeData.getInvocationCount() <= 0 || wseeBaseOperationRuntimeData.getResponseCount() <= 0) continue;
            l = Math.max(l, wseeBaseOperationRuntimeData.getResponseTimeHigh());
        }
        return l;
    }

    @Override
    public long getLastErrorTime() {
        long l = 0L;
        for (WseeBaseOperationRuntimeData wseeBaseOperationRuntimeData : this.getOperationsData()) {
            if (wseeBaseOperationRuntimeData.getInvocationCount() <= 0) continue;
            l = Math.max(l, wseeBaseOperationRuntimeData.getLastErrorTime());
        }
        return l;
    }

    @Override
    public long getLastInvocationTime() {
        long l = 0L;
        for (WseeBaseOperationRuntimeData wseeBaseOperationRuntimeData : this.getOperationsData()) {
            if (wseeBaseOperationRuntimeData.getInvocationCount() <= 0) continue;
            l = Math.max(l, wseeBaseOperationRuntimeData.getLastInvocationTime());
        }
        return l;
    }

    @Override
    public long getLastResponseTime() {
        long l = 0L;
        for (WseeBaseOperationRuntimeData wseeBaseOperationRuntimeData : this.getOperationsData()) {
            if (wseeBaseOperationRuntimeData.getInvocationCount() <= 0 || wseeBaseOperationRuntimeData.getResponseCount() <= 0) continue;
            l = Math.max(l, wseeBaseOperationRuntimeData.getLastResponseTime());
        }
        return l;
    }

    @Override
    public long getLastResponseErrorTime() {
        long l = 0L;
        for (WseeBaseOperationRuntimeData wseeBaseOperationRuntimeData : this.getOperationsData()) {
            if (wseeBaseOperationRuntimeData.getInvocationCount() <= 0) continue;
            l = Math.max(l, wseeBaseOperationRuntimeData.getLastResponseErrorTime());
        }
        return l;
    }

    @Override
    public long getDispatchTimeLow() {
        long l = 0L;
        boolean bl = true;
        for (WseeBaseOperationRuntimeData wseeBaseOperationRuntimeData : this.getOperationsData()) {
            if (wseeBaseOperationRuntimeData.getInvocationCount() <= 0) continue;
            if (bl) {
                l = wseeBaseOperationRuntimeData.getDispatchTimeLow();
                bl = false;
                continue;
            }
            l = Math.min(l, wseeBaseOperationRuntimeData.getDispatchTimeLow());
        }
        return l;
    }

    @Override
    public long getExecutionTimeLow() {
        long l = 0L;
        boolean bl = true;
        for (WseeBaseOperationRuntimeData wseeBaseOperationRuntimeData : this.getOperationsData()) {
            if (wseeBaseOperationRuntimeData.getInvocationCount() <= 0) continue;
            if (bl) {
                l = wseeBaseOperationRuntimeData.getExecutionTimeLow();
                bl = false;
                continue;
            }
            l = Math.min(l, wseeBaseOperationRuntimeData.getExecutionTimeLow());
        }
        return l;
    }

    @Override
    public long getResponseTimeLow() {
        long l = 0L;
        boolean bl = true;
        for (WseeBaseOperationRuntimeData wseeBaseOperationRuntimeData : this.getOperationsData()) {
            if (wseeBaseOperationRuntimeData.getInvocationCount() <= 0 || wseeBaseOperationRuntimeData.getResponseCount() <= 0) continue;
            if (bl) {
                l = wseeBaseOperationRuntimeData.getResponseTimeLow();
                bl = false;
                continue;
            }
            l = Math.min(l, wseeBaseOperationRuntimeData.getResponseTimeLow());
        }
        return l;
    }

    @Override
    public String getLastError() {
        long l = 0L;
        String string = null;
        for (WseeBaseOperationRuntimeData wseeBaseOperationRuntimeData : this.getOperationsData()) {
            long l2;
            if (wseeBaseOperationRuntimeData.getInvocationCount() <= 0 || (l2 = wseeBaseOperationRuntimeData.getLastErrorTime()) <= l) continue;
            l = l2;
            string = wseeBaseOperationRuntimeData.getLastError();
        }
        return string;
    }

    @Override
    public String getLastResponseError() {
        long l = 0L;
        String string = null;
        for (WseeBaseOperationRuntimeData wseeBaseOperationRuntimeData : this.getOperationsData()) {
            long l2;
            if (wseeBaseOperationRuntimeData.getInvocationCount() <= 0 || (l2 = wseeBaseOperationRuntimeData.getLastResponseErrorTime()) <= l) continue;
            l = l2;
            string = wseeBaseOperationRuntimeData.getLastResponseError();
        }
        return string;
    }

    @Override
    public long getDispatchTimeAverage() {
        int n = 0;
        long l = 0L;
        for (WseeBaseOperationRuntimeData wseeBaseOperationRuntimeData : this.getOperationsData()) {
            int n2 = wseeBaseOperationRuntimeData.getInvocationCount();
            if (n2 <= 0) continue;
            n += n2;
            l += wseeBaseOperationRuntimeData.getDispatchTimeTotal();
        }
        return WseeBasePortAggregatedBaseOperationsRuntimeData.average(l, n);
    }

    @Override
    public long getExecutionTimeAverage() {
        int n = 0;
        long l = 0L;
        for (WseeBaseOperationRuntimeData wseeBaseOperationRuntimeData : this.getOperationsData()) {
            int n2 = wseeBaseOperationRuntimeData.getInvocationCount();
            if (n2 <= 0) continue;
            n += n2;
            l += wseeBaseOperationRuntimeData.getExecutionTimeTotal();
        }
        return WseeBasePortAggregatedBaseOperationsRuntimeData.average(l, n);
    }

    @Override
    public long getResponseTimeAverage() {
        int n = 0;
        long l = 0L;
        for (WseeBaseOperationRuntimeData wseeBaseOperationRuntimeData : this.getOperationsData()) {
            int n2;
            if (wseeBaseOperationRuntimeData.getInvocationCount() <= 0 || (n2 = wseeBaseOperationRuntimeData.getResponseCount()) <= 0) continue;
            n += n2;
            l += wseeBaseOperationRuntimeData.getResponseTimeTotal();
        }
        return WseeBasePortAggregatedBaseOperationsRuntimeData.average(l, n);
    }

    private static long average(long l, int n) {
        return Math.round((double)l / (double)n);
    }

    private Set<WseeBaseOperationRuntimeData> getOperationsData() {
        return ((WseeBasePortRuntimeData)this.getParentData()).getOperationsData();
    }
}

