/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.monitoring;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import weblogic.management.ManagementException;
import weblogic.wsee.mc.mbean.WseeMcRuntimeData;
import weblogic.wsee.monitoring.WseeBaseOperationRuntimeData;
import weblogic.wsee.monitoring.WseeBasePortAggregatedBaseOperationsRuntimeData;
import weblogic.wsee.monitoring.WseeBaseRuntimeData;
import weblogic.wsee.monitoring.WseeClusterRoutingRuntimeData;
import weblogic.wsee.monitoring.WseeHandlerRuntimeData;
import weblogic.wsee.monitoring.WseeOperationRuntimeData;
import weblogic.wsee.monitoring.WseePortPolicyRuntimeData;
import weblogic.wsee.monitoring.WseeWsrmRuntimeData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WseeBasePortRuntimeData
extends WseeBaseRuntimeData {
    private String transport = null;
    private Set<WseeBaseOperationRuntimeData> operations = new HashSet<WseeBaseOperationRuntimeData>();
    private Set<WseeHandlerRuntimeData> handlers = new HashSet<WseeHandlerRuntimeData>();
    private long startTime = 0L;
    private WseePortPolicyRuntimeData metric = null;
    private WseeClusterRoutingRuntimeData _clusterRouting = null;
    private WseeWsrmRuntimeData _wsrm = null;
    private WseeMcRuntimeData _mc = null;
    private WseeBasePortAggregatedBaseOperationsRuntimeData _aggregatedBaseOperations = null;
    private ReentrantReadWriteLock _childLock = new ReentrantReadWriteLock();

    WseeBasePortRuntimeData(String string, String string2) throws ManagementException {
        super(string, null);
        this.transport = string2;
    }

    public boolean addOperation(WseeBaseOperationRuntimeData wseeBaseOperationRuntimeData) {
        for (WseeBaseOperationRuntimeData wseeBaseOperationRuntimeData2 : this.operations) {
            if (!wseeBaseOperationRuntimeData2.getName().equals(wseeBaseOperationRuntimeData.getName())) continue;
            return false;
        }
        wseeBaseOperationRuntimeData.setParentData(this);
        this.operations.add(wseeBaseOperationRuntimeData);
        return true;
    }

    public boolean addHandler(WseeHandlerRuntimeData wseeHandlerRuntimeData) {
        for (WseeHandlerRuntimeData wseeHandlerRuntimeData2 : this.handlers) {
            if (!wseeHandlerRuntimeData2.getName().equals(wseeHandlerRuntimeData.getName())) continue;
            return false;
        }
        wseeHandlerRuntimeData.setParentData(this);
        this.handlers.add(wseeHandlerRuntimeData);
        return true;
    }

    public void setPortPolicy(WseePortPolicyRuntimeData wseePortPolicyRuntimeData) {
        this.metric = wseePortPolicyRuntimeData;
    }

    public String getPortName() {
        return this.getName();
    }

    public String getTransportProtocolType() {
        return this.transport;
    }

    public WseeOperationRuntimeData[] getOperations() {
        return this.operations.toArray(new WseeOperationRuntimeData[this.operations.size()]);
    }

    public WseeHandlerRuntimeData[] getHandlers() {
        return this.handlers.toArray(new WseeHandlerRuntimeData[this.handlers.size()]);
    }

    public int getPolicyFaults() {
        return this.metric.getPolicyFaults();
    }

    void setStartTime(long l) {
        this.startTime = l;
    }

    public long getStartTime() {
        return this.startTime;
    }

    @Deprecated
    public int getTotalFaults() {
        return this.metric.getTotalFaults();
    }

    public int getTotalSecurityFaults() {
        return this.metric.getTotalSecurityFaults();
    }

    public WseePortPolicyRuntimeData getPortPolicy() {
        return this.metric;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClusterRouting(WseeClusterRoutingRuntimeData wseeClusterRoutingRuntimeData) {
        try {
            this._childLock.writeLock().lock();
            this._clusterRouting = wseeClusterRoutingRuntimeData;
        }
        finally {
            this._childLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WseeClusterRoutingRuntimeData getClusterRouting() {
        try {
            this._childLock.readLock().lock();
            WseeClusterRoutingRuntimeData wseeClusterRoutingRuntimeData = this._clusterRouting;
            return wseeClusterRoutingRuntimeData;
        }
        finally {
            this._childLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWsrm(WseeWsrmRuntimeData wseeWsrmRuntimeData) {
        try {
            this._childLock.writeLock().lock();
            this._wsrm = wseeWsrmRuntimeData;
        }
        finally {
            this._childLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WseeWsrmRuntimeData getWsrm() {
        try {
            this._childLock.readLock().lock();
            WseeWsrmRuntimeData wseeWsrmRuntimeData = this._wsrm;
            return wseeWsrmRuntimeData;
        }
        finally {
            this._childLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMcData(WseeMcRuntimeData wseeMcRuntimeData) {
        try {
            this._childLock.writeLock().lock();
            this._mc = wseeMcRuntimeData;
        }
        finally {
            this._childLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WseeMcRuntimeData getMcData() {
        try {
            this._childLock.readLock().lock();
            WseeMcRuntimeData wseeMcRuntimeData = this._mc;
            return wseeMcRuntimeData;
        }
        finally {
            this._childLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAggregatedBaseOperationsData(WseeBasePortAggregatedBaseOperationsRuntimeData wseeBasePortAggregatedBaseOperationsRuntimeData) {
        try {
            this._childLock.writeLock().lock();
            this._aggregatedBaseOperations = wseeBasePortAggregatedBaseOperationsRuntimeData;
        }
        finally {
            this._childLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WseeBasePortAggregatedBaseOperationsRuntimeData getAggregatedBaseOperationsData() {
        try {
            this._childLock.readLock().lock();
            WseeBasePortAggregatedBaseOperationsRuntimeData wseeBasePortAggregatedBaseOperationsRuntimeData = this._aggregatedBaseOperations;
            return wseeBasePortAggregatedBaseOperationsRuntimeData;
        }
        finally {
            this._childLock.readLock().unlock();
        }
    }

    Set<WseeBaseOperationRuntimeData> getOperationsData() {
        return this.operations;
    }
}

