/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.monitoring;

import com.sun.istack.Nullable;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.server.WSEndpoint;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import weblogic.jws.jaxws.client.ClientIdentityFeature;
import weblogic.management.ManagementException;
import weblogic.management.WebLogicMBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.WseeAggregatableBaseOperationRuntimeMBean;
import weblogic.management.runtime.WseeBaseOperationRuntimeMBean;
import weblogic.management.runtime.WseeBasePortRuntimeMBean;
import weblogic.management.runtime.WseeClientPortRuntimeMBean;
import weblogic.management.runtime.WseeClusterRoutingRuntimeMBean;
import weblogic.management.runtime.WseeHandlerRuntimeMBean;
import weblogic.management.runtime.WseeMcRuntimeMBean;
import weblogic.management.runtime.WseePortPolicyRuntimeMBean;
import weblogic.management.runtime.WseePortRuntimeMBean;
import weblogic.management.runtime.WseeV2RuntimeMBean;
import weblogic.management.runtime.WseeWsrmRuntimeMBean;
import weblogic.t3.srvr.ServerRuntime;
import weblogic.wsee.WseeCoreLogger;
import weblogic.wsee.jaxws.spi.ClientIdentityRegistry;
import weblogic.wsee.mc.mbean.WseeMcRuntimeData;
import weblogic.wsee.mc.mbean.WseeMcRuntimeMBeanImpl;
import weblogic.wsee.monitoring.WseeBaseOperationRuntimeData;
import weblogic.wsee.monitoring.WseeBaseOperationRuntimeMBeanImpl;
import weblogic.wsee.monitoring.WseeBasePortAggregatedBaseOperationsRuntimeData;
import weblogic.wsee.monitoring.WseeBasePortAggregatedBaseOperationsRuntimeMBeanImpl;
import weblogic.wsee.monitoring.WseeBasePortRuntimeData;
import weblogic.wsee.monitoring.WseeClientRuntimeMBeanImpl;
import weblogic.wsee.monitoring.WseeClusterRoutingRuntimeData;
import weblogic.wsee.monitoring.WseeClusterRoutingRuntimeMBeanImpl;
import weblogic.wsee.monitoring.WseeHandlerRuntimeData;
import weblogic.wsee.monitoring.WseeHandlerRuntimeMBeanImpl;
import weblogic.wsee.monitoring.WseePortPolicyRuntimeData;
import weblogic.wsee.monitoring.WseePortPolicyRuntimeMBeanImpl;
import weblogic.wsee.monitoring.WseeRuntimeMBeanDelegate;
import weblogic.wsee.monitoring.WseeWsrmRuntimeData;
import weblogic.wsee.monitoring.WseeWsrmRuntimeMBeanImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WseeBasePortRuntimeMBeanImpl<M extends WseeBasePortRuntimeMBean, D extends WseeBasePortRuntimeData>
extends WseeRuntimeMBeanDelegate<M, D>
implements WseeBasePortRuntimeMBean {
    private List<WseeBaseOperationRuntimeMBeanImpl> operations = new ArrayList<WseeBaseOperationRuntimeMBeanImpl>();
    private List<WseeHandlerRuntimeMBeanImpl> handlers = new ArrayList<WseeHandlerRuntimeMBeanImpl>();
    private WseePortPolicyRuntimeMBeanImpl metric = null;
    private WseeClusterRoutingRuntimeMBeanImpl _clusterRouting = null;
    private WseeWsrmRuntimeMBeanImpl _wsrm = null;
    private WseeMcRuntimeMBeanImpl _mc = null;
    private WseeBasePortAggregatedBaseOperationsRuntimeMBeanImpl _aggregatedBaseOperations = null;

    @Nullable
    public static WseeBasePortRuntimeMBean getFromPacket(Packet packet) {
        if (packet == null) {
            return null;
        }
        WseeBasePortRuntimeMBean wseeBasePortRuntimeMBean = null;
        if (packet.component != null) {
            wseeBasePortRuntimeMBean = (WseeBasePortRuntimeMBean)packet.component.getSPI(WseePortRuntimeMBean.class);
        }
        if (wseeBasePortRuntimeMBean == null) {
            wseeBasePortRuntimeMBean = WseeBasePortRuntimeMBeanImpl.getFromClientBinding(packet.getBinding());
        }
        return wseeBasePortRuntimeMBean;
    }

    public static WseePortRuntimeMBean getFromEndpoint(WSEndpoint wSEndpoint) {
        if (wSEndpoint == null) {
            return null;
        }
        WseeV2RuntimeMBean wseeV2RuntimeMBean = (WseeV2RuntimeMBean)wSEndpoint.getSPI(WseeV2RuntimeMBean.class);
        if (wseeV2RuntimeMBean == null) {
            return null;
        }
        QName qName = wSEndpoint.getPortName();
        WseePortRuntimeMBean[] wseePortRuntimeMBeanArray = wseeV2RuntimeMBean.getPorts();
        WseePortRuntimeMBean wseePortRuntimeMBean = null;
        for (WseePortRuntimeMBean wseePortRuntimeMBean2 : wseePortRuntimeMBeanArray) {
            if (!wseePortRuntimeMBean2.getPortName().equals(qName.getLocalPart())) continue;
            wseePortRuntimeMBean = wseePortRuntimeMBean2;
            break;
        }
        return wseePortRuntimeMBean;
    }

    public static WseeClientPortRuntimeMBean getFromClientBinding(WSBinding wSBinding) {
        WseeClientRuntimeMBeanImpl wseeClientRuntimeMBeanImpl;
        if (wSBinding == null) {
            return null;
        }
        WseeClientPortRuntimeMBean wseeClientPortRuntimeMBean = null;
        ClientIdentityFeature clientIdentityFeature = (ClientIdentityFeature)wSBinding.getFeature(ClientIdentityFeature.class);
        if (clientIdentityFeature != null && (wseeClientRuntimeMBeanImpl = ClientIdentityRegistry.getClientRuntimeMBean(clientIdentityFeature.getClientId())) != null) {
            wseeClientPortRuntimeMBean = wseeClientRuntimeMBeanImpl.getPort();
        }
        return wseeClientPortRuntimeMBean;
    }

    public WseeBasePortRuntimeMBeanImpl() throws ManagementException {
        super(null, null, null, false);
        throw new AssertionError((Object)"Public constructor provided only for JMX compliance.");
    }

    WseeBasePortRuntimeMBeanImpl(String string, RuntimeMBean runtimeMBean, WseeBasePortRuntimeMBeanImpl wseeBasePortRuntimeMBeanImpl) throws ManagementException {
        super(string, runtimeMBean, wseeBasePortRuntimeMBeanImpl, false);
    }

    WseeBasePortRuntimeMBeanImpl(String string, String string2) throws ManagementException {
        super(string, null, null, false);
    }

    protected void internalInitProxy(WseeBasePortRuntimeMBeanImpl wseeBasePortRuntimeMBeanImpl) throws ManagementException {
        WseeRuntimeMBeanDelegate wseeRuntimeMBeanDelegate;
        wseeBasePortRuntimeMBeanImpl.setData(this.getData());
        wseeBasePortRuntimeMBeanImpl.setMetric((WseePortPolicyRuntimeMBeanImpl)this.metric.createProxy(this.metric.getName(), wseeBasePortRuntimeMBeanImpl));
        wseeBasePortRuntimeMBeanImpl.setClusterRouting((WseeClusterRoutingRuntimeMBeanImpl)this._clusterRouting.createProxy(this._clusterRouting.getName(), wseeBasePortRuntimeMBeanImpl));
        wseeBasePortRuntimeMBeanImpl.setWsrm((WseeWsrmRuntimeMBeanImpl)this._wsrm.createProxy(this._wsrm.getName(), wseeBasePortRuntimeMBeanImpl));
        wseeBasePortRuntimeMBeanImpl.setMc((WseeMcRuntimeMBeanImpl)this._mc.createProxy(this._mc.getName(), wseeBasePortRuntimeMBeanImpl));
        wseeBasePortRuntimeMBeanImpl.setAggregatedBaseOperations((WseeBasePortAggregatedBaseOperationsRuntimeMBeanImpl)this._aggregatedBaseOperations.createProxy(this._aggregatedBaseOperations.getName(), wseeBasePortRuntimeMBeanImpl));
        for (WseeBaseOperationRuntimeMBeanImpl wseeRuntimeMBeanDelegate2 : this.operations) {
            wseeRuntimeMBeanDelegate = (WseeBaseOperationRuntimeMBeanImpl)wseeRuntimeMBeanDelegate2.createProxy(wseeRuntimeMBeanDelegate2.getName(), wseeBasePortRuntimeMBeanImpl);
            wseeBasePortRuntimeMBeanImpl.addOperation((WseeBaseOperationRuntimeMBeanImpl)wseeRuntimeMBeanDelegate);
        }
        for (WseeHandlerRuntimeMBeanImpl wseeHandlerRuntimeMBeanImpl : this.handlers) {
            wseeRuntimeMBeanDelegate = (WseeHandlerRuntimeMBeanImpl)wseeHandlerRuntimeMBeanImpl.createProxy(wseeHandlerRuntimeMBeanImpl.getName(), wseeBasePortRuntimeMBeanImpl);
            wseeBasePortRuntimeMBeanImpl.addHandler((WseeHandlerRuntimeMBeanImpl)wseeRuntimeMBeanDelegate);
        }
    }

    protected void setMetric(WseePortPolicyRuntimeMBeanImpl wseePortPolicyRuntimeMBeanImpl) {
        this.metric = wseePortPolicyRuntimeMBeanImpl;
        ((WseeBasePortRuntimeData)this.getData()).setPortPolicy((WseePortPolicyRuntimeData)wseePortPolicyRuntimeMBeanImpl.getData());
    }

    protected void setClusterRouting(WseeClusterRoutingRuntimeMBeanImpl wseeClusterRoutingRuntimeMBeanImpl) {
        this._clusterRouting = wseeClusterRoutingRuntimeMBeanImpl;
        ((WseeBasePortRuntimeData)this.getData()).setClusterRouting((WseeClusterRoutingRuntimeData)wseeClusterRoutingRuntimeMBeanImpl.getData());
    }

    protected void setWsrm(WseeWsrmRuntimeMBeanImpl wseeWsrmRuntimeMBeanImpl) {
        this._wsrm = wseeWsrmRuntimeMBeanImpl;
        ((WseeBasePortRuntimeData)this.getData()).setWsrm((WseeWsrmRuntimeData)wseeWsrmRuntimeMBeanImpl.getData());
    }

    protected void setAggregatedBaseOperations(WseeBasePortAggregatedBaseOperationsRuntimeMBeanImpl wseeBasePortAggregatedBaseOperationsRuntimeMBeanImpl) {
        this._aggregatedBaseOperations = wseeBasePortAggregatedBaseOperationsRuntimeMBeanImpl;
        ((WseeBasePortRuntimeData)this.getData()).setAggregatedBaseOperationsData((WseeBasePortAggregatedBaseOperationsRuntimeData)wseeBasePortAggregatedBaseOperationsRuntimeMBeanImpl.getData());
    }

    protected void setMc(WseeMcRuntimeMBeanImpl wseeMcRuntimeMBeanImpl) {
        this._mc = wseeMcRuntimeMBeanImpl;
        ((WseeBasePortRuntimeData)this.getData()).setMcData((WseeMcRuntimeData)wseeMcRuntimeMBeanImpl.getData());
    }

    @Override
    public String getPortName() {
        return this.name;
    }

    @Override
    public String getTransportProtocolType() {
        return ((WseeBasePortRuntimeData)this.getData()).getTransportProtocolType();
    }

    protected void addOperation(WseeBaseOperationRuntimeMBeanImpl wseeBaseOperationRuntimeMBeanImpl) {
        ((WseeBasePortRuntimeData)this.getData()).addOperation((WseeBaseOperationRuntimeData)wseeBaseOperationRuntimeMBeanImpl.getData());
        this.operations.add(wseeBaseOperationRuntimeMBeanImpl);
        wseeBaseOperationRuntimeMBeanImpl.setParent((WebLogicMBean)this);
        if (this.isRegistered()) {
            try {
                wseeBaseOperationRuntimeMBeanImpl.register();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.toString(), exception);
            }
        }
    }

    public void addHandler(WseeHandlerRuntimeMBeanImpl wseeHandlerRuntimeMBeanImpl) {
        ((WseeBasePortRuntimeData)this.getData()).addHandler((WseeHandlerRuntimeData)wseeHandlerRuntimeMBeanImpl.getData());
        this.handlers.add(wseeHandlerRuntimeMBeanImpl);
        wseeHandlerRuntimeMBeanImpl.setParent((WebLogicMBean)this);
        if (this.isRegistered()) {
            try {
                wseeHandlerRuntimeMBeanImpl.register();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.toString(), exception);
            }
        }
    }

    @Override
    public WseeHandlerRuntimeMBean[] getHandlers() {
        return this.handlers.toArray(new WseeHandlerRuntimeMBeanImpl[this.handlers.size()]);
    }

    @Override
    public void register() throws ManagementException {
        if (this.isRegistered()) {
            return;
        }
        super.register();
        if (!this.isProxy()) {
            ((WseeBasePortRuntimeData)this.getData()).setStartTime(System.currentTimeMillis());
        }
        for (WseeBaseOperationRuntimeMBeanImpl wseeRuntimeMBeanDelegate : this.operations) {
            wseeRuntimeMBeanDelegate.register();
        }
        for (WseeHandlerRuntimeMBeanImpl wseeHandlerRuntimeMBeanImpl : this.handlers) {
            wseeHandlerRuntimeMBeanImpl.register();
        }
        this.metric.setParent((WebLogicMBean)this);
        this.metric.register();
        this._clusterRouting.register();
        this._wsrm.register();
        this._mc.register();
        this._aggregatedBaseOperations.register();
    }

    @Override
    public void unregister() throws ManagementException {
        super.unregister();
        if (!this.isProxy()) {
            ((WseeBasePortRuntimeData)this.getData()).setStartTime(0L);
        }
        this.unregisterHandlers();
        this.unregisterOperations();
        this.unregisterWsspMetric();
        this.unregisterClusterRouting();
        this.unregisterWsrm();
        this.unregisterMc();
        this.unregisterAggregatedOps();
    }

    private void unregisterAggregatedOps() {
        if (this._aggregatedBaseOperations != null) {
            try {
                this._aggregatedBaseOperations.unregister();
                ServerRuntime.theOne().removeChild(this._aggregatedBaseOperations);
            }
            catch (ManagementException managementException) {
                managementException.printStackTrace();
            }
        }
        this._aggregatedBaseOperations = null;
    }

    private void unregisterWsspMetric() {
        if (this.metric != null) {
            try {
                this.metric.unregister();
                ServerRuntime.theOne().removeChild(this.metric);
            }
            catch (ManagementException managementException) {
                managementException.printStackTrace();
            }
        }
        this.metric = null;
    }

    private void unregisterOperations() {
        if (this.operations != null && this.operations.size() > 0) {
            for (WseeBaseOperationRuntimeMBeanImpl wseeBaseOperationRuntimeMBeanImpl : this.operations) {
                try {
                    wseeBaseOperationRuntimeMBeanImpl.unregister();
                    ServerRuntime.theOne().removeChild(wseeBaseOperationRuntimeMBeanImpl);
                }
                catch (ManagementException managementException) {
                    managementException.printStackTrace();
                }
            }
            this.operations.clear();
        }
        this.operations = null;
    }

    private void unregisterHandlers() {
        if (this.handlers != null && this.handlers.size() > 0) {
            for (WseeHandlerRuntimeMBeanImpl wseeHandlerRuntimeMBeanImpl : this.handlers) {
                try {
                    wseeHandlerRuntimeMBeanImpl.unregister();
                    ServerRuntime.theOne().removeChild(wseeHandlerRuntimeMBeanImpl);
                }
                catch (ManagementException managementException) {
                    managementException.printStackTrace();
                }
            }
            this.handlers.clear();
        }
        this.handlers = null;
    }

    private void unregisterClusterRouting() {
        if (this._clusterRouting != null) {
            try {
                this._clusterRouting.unregister();
                ServerRuntime.theOne().removeChild(this._clusterRouting);
            }
            catch (ManagementException managementException) {
                WseeCoreLogger.logUnexpectedException((String)managementException.toString(), (Throwable)managementException);
            }
            this._clusterRouting = null;
        }
    }

    private void unregisterWsrm() {
        if (this._wsrm != null) {
            try {
                this._wsrm.unregister();
                ServerRuntime.theOne().removeChild(this._wsrm);
            }
            catch (ManagementException managementException) {
                WseeCoreLogger.logUnexpectedException((String)managementException.toString(), (Throwable)managementException);
            }
            this._wsrm = null;
        }
    }

    private void unregisterMc() {
        if (this._mc != null) {
            try {
                this._mc.unregister();
                ServerRuntime.theOne().removeChild(this._mc);
            }
            catch (ManagementException managementException) {
                WseeCoreLogger.logUnexpectedException((String)managementException.toString(), (Throwable)managementException);
            }
            this._mc = null;
        }
    }

    @Override
    public int getPolicyFaults() {
        return this.metric.getPolicyFaults();
    }

    @Override
    public long getStartTime() {
        return ((WseeBasePortRuntimeData)this.getData()).getStartTime();
    }

    @Override
    @Deprecated
    public int getTotalFaults() {
        return this.metric.getTotalFaults();
    }

    @Override
    public int getTotalSecurityFaults() {
        return this.metric.getTotalSecurityFaults();
    }

    @Override
    public WseePortPolicyRuntimeMBean getPortPolicy() {
        return this.metric;
    }

    @Override
    public WseeClusterRoutingRuntimeMBean getClusterRouting() {
        return this._clusterRouting;
    }

    @Override
    public WseeWsrmRuntimeMBean getWsrm() {
        return this._wsrm;
    }

    @Override
    public WseeMcRuntimeMBean getMc() {
        return this._mc;
    }

    @Override
    public WseeAggregatableBaseOperationRuntimeMBean getAggregatedBaseOperations() {
        return this._aggregatedBaseOperations;
    }

    @Override
    public WseeBaseOperationRuntimeMBean[] getBaseOperations() {
        return this.operations.toArray(new WseeBaseOperationRuntimeMBean[this.operations.size()]);
    }
}

