/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.monitoring;

import java.util.HashSet;
import java.util.Set;
import weblogic.ejb.container.internal.EJBComponentRuntimeMBeanImpl;
import weblogic.j2ee.J2EEApplicationRuntimeMBeanImpl;
import weblogic.management.ManagementException;
import weblogic.management.WebLogicMBean;
import weblogic.management.runtime.ComponentRuntimeMBean;
import weblogic.management.runtime.EJBComponentRuntimeMBean;
import weblogic.management.runtime.OwsmSecurityPolicyRuntimeMBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.WebAppComponentRuntimeMBean;
import weblogic.management.runtime.WseeBaseRuntimeMBean;
import weblogic.management.runtime.WseePolicyRuntimeMBean;
import weblogic.management.runtime.WseePortRuntimeMBean;
import weblogic.management.runtime.WseeV2RuntimeMBean;
import weblogic.servlet.internal.WebAppRuntimeMBeanImpl;
import weblogic.t3.srvr.ServerRuntime;
import weblogic.wsee.deploy.VersioningHelper;
import weblogic.wsee.monitoring.OwsmSecurityPolicyRuntimeData;
import weblogic.wsee.monitoring.WseePolicyRuntimeData;
import weblogic.wsee.monitoring.WseePortRuntimeData;
import weblogic.wsee.monitoring.WseePortRuntimeMBeanImpl;
import weblogic.wsee.monitoring.WseeRuntimeData;
import weblogic.wsee.monitoring.WseeRuntimeMBeanDelegate;
import weblogic.wsee.monitoring.WseeRuntimeMBeanManager;
import weblogic.wsee.policy.mbean.OwsmSecurityPolicyRuntimeMBeanImpl;
import weblogic.wsee.policy.mbean.WseePolicyRuntimeMBeanImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class WseeBaseRuntimeMBeanImpl
extends WseeRuntimeMBeanDelegate<WseeBaseRuntimeMBean, WseeRuntimeData>
implements WseeBaseRuntimeMBean {
    private Set<WseePortRuntimeMBeanImpl> ports = new HashSet<WseePortRuntimeMBeanImpl>();
    private WseePolicyRuntimeMBeanImpl wprm = null;
    private OwsmSecurityPolicyRuntimeMBeanImpl owsmSecPolicy = null;
    protected String serviceName;

    public WseeBaseRuntimeMBeanImpl() throws ManagementException {
        super(null, null, null, false);
        throw new AssertionError((Object)"Public constructor provided only for JMX compliance.");
    }

    protected WseeBaseRuntimeMBeanImpl(String string, RuntimeMBean runtimeMBean, WseeBaseRuntimeMBeanImpl wseeBaseRuntimeMBeanImpl) throws ManagementException {
        super(string, runtimeMBean, wseeBaseRuntimeMBeanImpl, false);
    }

    WseeBaseRuntimeMBeanImpl(String string, RuntimeMBean runtimeMBean, String string2, String string3, String string4, String string5, String string6, String string7) throws ManagementException {
        this(string, runtimeMBean, string2, string3, string4, string5, string6, string7, true);
    }

    protected WseeBaseRuntimeMBeanImpl(String string, RuntimeMBean runtimeMBean, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl) throws ManagementException {
        super(string, runtimeMBean, null, false);
        if (bl && !(runtimeMBean instanceof ComponentRuntimeMBean) && !(runtimeMBean instanceof J2EEApplicationRuntimeMBeanImpl)) {
            throw new IllegalArgumentException("Attempt to parent a WseeV2RuntimeMBean off something other than a component runtime: " + runtimeMBean);
        }
        WseeRuntimeData wseeRuntimeData = new WseeRuntimeData(string, string2, string3, string4, string5, string6);
        this.setData(wseeRuntimeData);
        this.serviceName = string7;
        this.setWprm(new WseePolicyRuntimeMBeanImpl(this.getName(), this));
        this.setOwsmSecPolicy(new OwsmSecurityPolicyRuntimeMBeanImpl(this.getName(), this));
        if (bl) {
            if (runtimeMBean instanceof WebAppComponentRuntimeMBean) {
                ((WebAppRuntimeMBeanImpl)runtimeMBean).addWseeV2Runtime((WseeV2RuntimeMBean)((Object)this));
            } else if (runtimeMBean instanceof EJBComponentRuntimeMBean) {
                ((EJBComponentRuntimeMBeanImpl)runtimeMBean).addWseeV2Runtime((WseeV2RuntimeMBean)((Object)this));
            } else if (runtimeMBean instanceof J2EEApplicationRuntimeMBeanImpl) {
                ((J2EEApplicationRuntimeMBeanImpl)runtimeMBean).addWseeV2Runtime((WseeV2RuntimeMBean)((Object)this));
            }
        }
        this.register();
    }

    protected WseeBaseRuntimeMBeanImpl internalInitProxy(WseeBaseRuntimeMBeanImpl wseeBaseRuntimeMBeanImpl) throws ManagementException {
        wseeBaseRuntimeMBeanImpl.setData(this.getData());
        wseeBaseRuntimeMBeanImpl.setWprm((WseePolicyRuntimeMBeanImpl)this.wprm.createProxy(this.wprm.getName(), wseeBaseRuntimeMBeanImpl));
        wseeBaseRuntimeMBeanImpl.setOwsmSecPolicy((OwsmSecurityPolicyRuntimeMBeanImpl)this.owsmSecPolicy.createProxy(this.owsmSecPolicy.getName(), wseeBaseRuntimeMBeanImpl));
        for (WseePortRuntimeMBeanImpl wseePortRuntimeMBeanImpl : this.ports) {
            WseePortRuntimeMBeanImpl wseePortRuntimeMBeanImpl2 = (WseePortRuntimeMBeanImpl)wseePortRuntimeMBeanImpl.createProxy(wseePortRuntimeMBeanImpl.getName(), wseeBaseRuntimeMBeanImpl);
            wseeBaseRuntimeMBeanImpl.addPort(wseePortRuntimeMBeanImpl2);
        }
        return wseeBaseRuntimeMBeanImpl;
    }

    protected void setWprm(WseePolicyRuntimeMBeanImpl wseePolicyRuntimeMBeanImpl) {
        this.wprm = wseePolicyRuntimeMBeanImpl;
        ((WseeRuntimeData)this.getData()).setPolicyRuntime((WseePolicyRuntimeData)wseePolicyRuntimeMBeanImpl.getData());
    }

    protected void setOwsmSecPolicy(OwsmSecurityPolicyRuntimeMBeanImpl owsmSecurityPolicyRuntimeMBeanImpl) {
        this.owsmSecPolicy = owsmSecurityPolicyRuntimeMBeanImpl;
        ((WseeRuntimeData)this.getData()).setOwsmSecurityPolicyRuntime((OwsmSecurityPolicyRuntimeData)owsmSecurityPolicyRuntimeMBeanImpl.getData());
    }

    @Override
    public String getURI() {
        return ((WseeRuntimeData)this.getData()).getURI();
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public WseePortRuntimeMBean[] getPorts() {
        return this.ports.toArray(new WseePortRuntimeMBean[this.ports.size()]);
    }

    @Override
    public WseePolicyRuntimeMBean getPolicyRuntime() {
        return this.wprm;
    }

    @Override
    public long getConversationInstanceCount() {
        return ((WseeRuntimeData)this.getData()).getConversationInstanceCount();
    }

    @Override
    public String getImplementationType() {
        return ((WseeRuntimeData)this.getData()).getImplementationType();
    }

    public void setWebserviceDescriptrionName(String string) {
        ((WseeRuntimeData)this.getData()).setWebserviceDescriptrionName(string);
    }

    @Override
    public String getWebserviceDescriptionName() {
        return ((WseeRuntimeData)this.getData()).getWebserviceDescriptionName();
    }

    @Override
    public void addPort(WseePortRuntimeMBean wseePortRuntimeMBean) {
        for (WseePortRuntimeMBeanImpl wseePortRuntimeMBeanImpl : this.ports) {
            if (!wseePortRuntimeMBeanImpl.getName().equals(wseePortRuntimeMBean.getName())) continue;
            return;
        }
        ((WseeRuntimeData)this.getData()).addPort((WseePortRuntimeData)((WseePortRuntimeMBeanImpl)wseePortRuntimeMBean).getData());
        this.ports.add((WseePortRuntimeMBeanImpl)wseePortRuntimeMBean);
        try {
            wseePortRuntimeMBean.setParent((WebLogicMBean)this);
            if (this.isRegistered()) {
                ((WseePortRuntimeMBeanImpl)wseePortRuntimeMBean).register();
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString(), exception);
        }
    }

    @Override
    public OwsmSecurityPolicyRuntimeMBean getOwsmSecurityPolicyRuntime() {
        return this.owsmSecPolicy;
    }

    @Override
    public int getPolicyFaults() {
        return ((WseeRuntimeData)this.getData()).getPolicyFaults();
    }

    @Override
    public long getStartTime() {
        return ((WseeRuntimeData)this.getData()).getStartTime();
    }

    @Override
    @Deprecated
    public int getTotalFaults() {
        return ((WseeRuntimeData)this.getData()).getTotalFaults();
    }

    @Override
    public int getTotalSecurityFaults() {
        return ((WseeRuntimeData)this.getData()).getTotalSecurityFaults();
    }

    @Override
    public void register() throws ManagementException {
        if (this.isRegistered()) {
            return;
        }
        super.register();
        this.wprm.register();
        this.owsmSecPolicy.register();
        if (!this.isProxy()) {
            ((WseeRuntimeData)this.getData()).setStartTime(System.currentTimeMillis());
        }
        for (WseePortRuntimeMBeanImpl wseePortRuntimeMBeanImpl : this.ports) {
            wseePortRuntimeMBeanImpl.setParent((WebLogicMBean)this);
            wseePortRuntimeMBeanImpl.register();
        }
    }

    @Override
    public void unregister() throws ManagementException {
        super.unregister();
        WseeRuntimeMBeanManager.remove(this.getServiceName());
        this.unregisterPorts();
        this.unregisterWprm();
        this.unregisterOwsmSecPolicy();
        if (!this.isProxy()) {
            ((WseeRuntimeData)this.getData()).setStartTime(0L);
            if (((WseeRuntimeData)this.getData()).getVersion() != null) {
                VersioningHelper.removeRecord(((WseeRuntimeData)this.getData()).getAppName(), ((WseeRuntimeData)this.getData()).getVersion());
            }
        }
        ServerRuntime.theOne().removeChild(this);
    }

    private void unregisterPorts() {
        for (WseePortRuntimeMBeanImpl wseePortRuntimeMBeanImpl : this.ports) {
            try {
                wseePortRuntimeMBeanImpl.unregister();
                ServerRuntime.theOne().removeChild(wseePortRuntimeMBeanImpl);
            }
            catch (ManagementException managementException) {
                managementException.printStackTrace();
            }
        }
        this.ports.clear();
        ((WseeRuntimeData)this.getData()).clearPorts();
    }

    private void unregisterWprm() {
        if (this.wprm != null) {
            try {
                this.wprm.unregister();
                ServerRuntime.theOne().removeChild(this.wprm);
            }
            catch (ManagementException managementException) {
                managementException.printStackTrace();
                this.wprm = null;
                ((WseeRuntimeData)this.getData()).clearPolicyRuntime();
            }
        }
        this.wprm = null;
        ((WseeRuntimeData)this.getData()).clearPolicyRuntime();
    }

    private void unregisterOwsmSecPolicy() {
        if (this.owsmSecPolicy != null) {
            try {
                this.owsmSecPolicy.unregister();
                ServerRuntime.theOne().removeChild(this.owsmSecPolicy);
            }
            catch (ManagementException managementException) {
                managementException.printStackTrace();
                this.owsmSecPolicy = null;
                ((WseeRuntimeData)this.getData()).clearOwsmSecurityPolicyRuntime();
            }
        }
        this.owsmSecPolicy = null;
        ((WseeRuntimeData)this.getData()).clearOwsmSecurityPolicyRuntime();
    }

    @Override
    public WseeBaseRuntimeMBean.Type getWsType() {
        if (((WseeRuntimeData)this.getData()).getImplementationType().startsWith(WseeBaseRuntimeMBean.Type.JAXRPC.toString())) {
            return WseeBaseRuntimeMBean.Type.JAXRPC;
        }
        return WseeBaseRuntimeMBean.Type.JAXWS;
    }
}

