/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.monitoring;

import java.util.HashSet;
import java.util.Set;
import weblogic.ejb.container.internal.EJBComponentRuntimeMBeanImpl;
import weblogic.management.ManagementException;
import weblogic.management.WebLogicMBean;
import weblogic.management.runtime.EJBComponentRuntimeMBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.WebAppComponentRuntimeMBean;
import weblogic.management.runtime.WseeClientConfigurationRuntimeMBean;
import weblogic.management.runtime.WseePortConfigurationRuntimeMBean;
import weblogic.servlet.internal.WebAppRuntimeMBeanImpl;
import weblogic.t3.srvr.ServerRuntime;
import weblogic.wsee.monitoring.WseeClientConfigurationRuntimeData;
import weblogic.wsee.monitoring.WseePortConfigurationRuntimeMBeanImpl;
import weblogic.wsee.monitoring.WseeRuntimeMBeanDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WseeClientConfigurationRuntimeMBeanImpl
extends WseeRuntimeMBeanDelegate<WseeClientConfigurationRuntimeMBean, WseeClientConfigurationRuntimeData>
implements WseeClientConfigurationRuntimeMBean {
    private Set<WseePortConfigurationRuntimeMBeanImpl> ports = new HashSet<WseePortConfigurationRuntimeMBeanImpl>();

    public WseeClientConfigurationRuntimeMBeanImpl(String string, RuntimeMBean runtimeMBean) throws ManagementException {
        super(string, runtimeMBean, null, false);
        this.setData(new WseeClientConfigurationRuntimeData(string));
        if (runtimeMBean instanceof WebAppComponentRuntimeMBean) {
            ((WebAppRuntimeMBeanImpl)runtimeMBean).addWseeClientConfigurationRuntime(this);
        } else if (runtimeMBean instanceof EJBComponentRuntimeMBean) {
            ((EJBComponentRuntimeMBeanImpl)runtimeMBean).addWseeClientConfigurationRuntime(this);
        }
    }

    private WseeClientConfigurationRuntimeMBeanImpl(String string, RuntimeMBean runtimeMBean, WseeRuntimeMBeanDelegate<WseeClientConfigurationRuntimeMBean, WseeClientConfigurationRuntimeData> wseeRuntimeMBeanDelegate) throws ManagementException {
        super(string, runtimeMBean, wseeRuntimeMBeanDelegate, false);
    }

    void addPort(WseePortConfigurationRuntimeMBeanImpl wseePortConfigurationRuntimeMBeanImpl) {
        wseePortConfigurationRuntimeMBeanImpl.setParent((WebLogicMBean)this);
        this.ports.add(wseePortConfigurationRuntimeMBeanImpl);
        if (this.isRegistered()) {
            try {
                wseePortConfigurationRuntimeMBeanImpl.register();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.toString(), exception);
            }
        }
    }

    @Override
    public void register() throws ManagementException {
        if (this.isRegistered()) {
            return;
        }
        super.register();
        for (WseePortConfigurationRuntimeMBeanImpl wseePortConfigurationRuntimeMBeanImpl : this.ports) {
            wseePortConfigurationRuntimeMBeanImpl.register();
        }
    }

    @Override
    public void unregister() throws ManagementException {
        super.unregister();
        for (WseePortConfigurationRuntimeMBeanImpl wseePortConfigurationRuntimeMBeanImpl : this.ports) {
            wseePortConfigurationRuntimeMBeanImpl.unregister();
            ServerRuntime.theOne().removeChild(wseePortConfigurationRuntimeMBeanImpl);
        }
        if (this.parent instanceof WebAppComponentRuntimeMBean) {
            ((WebAppRuntimeMBeanImpl)this.parent).removeWseeClientConfigurationRuntime(this);
        } else if (this.parent instanceof EJBComponentRuntimeMBean) {
            ((EJBComponentRuntimeMBeanImpl)this.parent).removeWseeClientConfigurationRuntime(this);
        }
        ServerRuntime.theOne().removeChild(this);
    }

    @Override
    protected WseeRuntimeMBeanDelegate<WseeClientConfigurationRuntimeMBean, WseeClientConfigurationRuntimeData> internalCreateProxy(String string, RuntimeMBean runtimeMBean) throws ManagementException {
        WseeClientConfigurationRuntimeMBeanImpl wseeClientConfigurationRuntimeMBeanImpl = new WseeClientConfigurationRuntimeMBeanImpl(string, runtimeMBean, this);
        wseeClientConfigurationRuntimeMBeanImpl.setData(this.getData());
        for (WseePortConfigurationRuntimeMBeanImpl wseePortConfigurationRuntimeMBeanImpl : this.ports) {
            WseePortConfigurationRuntimeMBeanImpl wseePortConfigurationRuntimeMBeanImpl2 = (WseePortConfigurationRuntimeMBeanImpl)wseePortConfigurationRuntimeMBeanImpl.createProxy(string, wseeClientConfigurationRuntimeMBeanImpl);
            wseeClientConfigurationRuntimeMBeanImpl.addPort(wseePortConfigurationRuntimeMBeanImpl2);
        }
        return wseeClientConfigurationRuntimeMBeanImpl;
    }

    @Override
    public WseePortConfigurationRuntimeMBean[] getPorts() {
        return this.ports.toArray(new WseePortConfigurationRuntimeMBeanImpl[this.ports.size()]);
    }

    @Override
    public String getServiceReferenceName() {
        return ((WseeClientConfigurationRuntimeData)this.getData()).getServiceRefName();
    }
}

