/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.monitoring;

import weblogic.management.ManagementException;
import weblogic.wsee.jaxws.spi.ClientIdentityRegistry;
import weblogic.wsee.jaxws.spi.ClientInstancePool;
import weblogic.wsee.monitoring.WseeBasePortRuntimeData;
import weblogic.wsee.monitoring.WseeClientRuntimeData;
import weblogic.wsee.util.Verbose;

public final class WseeClientPortRuntimeData
extends WseeBasePortRuntimeData {
    private static final boolean verbose = Verbose.isVerbose(WseeClientPortRuntimeData.class);
    String _clientId;

    WseeClientPortRuntimeData(String string, String string2) throws ManagementException {
        super(string, string2);
        if (verbose) {
            Verbose.log("WseeClientPortRuntimeData[" + string + "]");
        }
    }

    public void setParentData(WseeClientRuntimeData wseeClientRuntimeData) {
        super.setParentData(wseeClientRuntimeData);
        this._clientId = wseeClientRuntimeData.getClientId();
    }

    private ClientInstancePool.PoolStats getPoolStats() {
        ClientIdentityRegistry.ClientInfo clientInfo = ClientIdentityRegistry.getRequiredClientInfo(this._clientId);
        ClientInstancePool<?> clientInstancePool = clientInfo.getFirstClientInstancePool();
        return clientInstancePool != null ? clientInstancePool.getStats() : new ClientInstancePool.PoolStats();
    }

    public int getPoolCapacity() {
        return this.getPoolStats().getCapacity();
    }

    public int getPoolFreeCount() {
        return this.getPoolStats().getFreeCount();
    }

    public int getPoolTakenCount() {
        return this.getPoolStats().getTakenCount();
    }

    public int getPoolTotalPooledClientTakeCount() {
        return this.getPoolStats().getPooledClientTakeCount();
    }

    public int getPoolTotalConversationalClientTakeCount() {
        return this.getPoolStats().getConversationalClientTakeCount();
    }

    public int getPoolTotalSimpleClientCreateCount() {
        return this.getPoolStats().getSimpleClientCreateCount();
    }
}

