/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.monitoring;

import java.util.logging.Logger;
import weblogic.ejb.container.internal.EJBComponentRuntimeMBeanImpl;
import weblogic.management.ManagementException;
import weblogic.management.WebLogicMBean;
import weblogic.management.runtime.EJBComponentRuntimeMBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.WebAppComponentRuntimeMBean;
import weblogic.management.runtime.WseeClientPortRuntimeMBean;
import weblogic.management.runtime.WseeClientRuntimeMBean;
import weblogic.servlet.internal.WebAppRuntimeMBeanImpl;
import weblogic.wsee.jaxws.MonitoringStatMap;
import weblogic.wsee.jaxws.spi.ClientIdentityRegistry;
import weblogic.wsee.monitoring.WseeClientPortRuntimeData;
import weblogic.wsee.monitoring.WseeClientPortRuntimeMBeanImpl;
import weblogic.wsee.monitoring.WseeClientRuntimeData;
import weblogic.wsee.monitoring.WseeRuntimeMBeanDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WseeClientRuntimeMBeanImpl
extends WseeRuntimeMBeanDelegate<WseeClientRuntimeMBean, WseeClientRuntimeData>
implements WseeClientRuntimeMBean {
    private static Logger LOGGER = Logger.getLogger(WseeClientRuntimeMBeanImpl.class.getName());
    private WseeClientPortRuntimeMBeanImpl _port;
    private MonitoringStatMap _statMap;

    public WseeClientRuntimeMBeanImpl(String string, RuntimeMBean runtimeMBean, WseeRuntimeMBeanDelegate wseeRuntimeMBeanDelegate) throws ManagementException {
        super(string, runtimeMBean, wseeRuntimeMBeanDelegate, false);
    }

    public WseeClientRuntimeMBeanImpl(String string, String string2, RuntimeMBean runtimeMBean) throws ManagementException {
        super(string, runtimeMBean, null, false);
        if (runtimeMBean instanceof WebAppComponentRuntimeMBean) {
            ((WebAppRuntimeMBeanImpl)runtimeMBean).addWseeClientRuntime(this);
        } else if (runtimeMBean instanceof EJBComponentRuntimeMBean) {
            ((EJBComponentRuntimeMBeanImpl)runtimeMBean).addWseeClientRuntime(this);
        }
        WseeClientRuntimeData wseeClientRuntimeData = new WseeClientRuntimeData(string, string2);
        this.setData(wseeClientRuntimeData);
    }

    @Override
    public void register() throws ManagementException {
        if (this.isRegistered()) {
            return;
        }
        super.register();
        if (this._port != null) {
            this._port.register();
        }
    }

    @Override
    protected WseeRuntimeMBeanDelegate<WseeClientRuntimeMBean, WseeClientRuntimeData> internalCreateProxy(String string, RuntimeMBean runtimeMBean) throws ManagementException {
        WseeClientRuntimeMBeanImpl wseeClientRuntimeMBeanImpl = new WseeClientRuntimeMBeanImpl(string, runtimeMBean, this);
        WseeClientPortRuntimeMBeanImpl wseeClientPortRuntimeMBeanImpl = (WseeClientPortRuntimeMBeanImpl)this._port.createProxy(string, runtimeMBean);
        wseeClientRuntimeMBeanImpl.setPort(wseeClientPortRuntimeMBeanImpl);
        wseeClientRuntimeMBeanImpl.setStatMap(this._statMap);
        return wseeClientRuntimeMBeanImpl;
    }

    @Override
    public void unregister() throws ManagementException {
        super.unregister();
        ClientIdentityRegistry.removeClientRuntimeMBean(this.getClientID());
        if (this._port != null) {
            this._port.unregister();
            this._port = null;
        }
        if (this.parent instanceof WebAppComponentRuntimeMBean) {
            ((WebAppRuntimeMBeanImpl)this.parent).removeWseeClientRuntime(this);
        } else if (this.parent instanceof EJBComponentRuntimeMBean) {
            ((EJBComponentRuntimeMBeanImpl)this.parent).removeWseeClientRuntime(this);
        }
    }

    @Override
    public WseeClientPortRuntimeMBean getPort() {
        return this._port;
    }

    public void setPort(WseeClientPortRuntimeMBeanImpl wseeClientPortRuntimeMBeanImpl) {
        this._port = wseeClientPortRuntimeMBeanImpl;
        this._port.setParent((WebLogicMBean)this);
        ((WseeClientRuntimeData)this.getData()).setPort((WseeClientPortRuntimeData)wseeClientPortRuntimeMBeanImpl.getData());
        if (this.isRegistered()) {
            try {
                wseeClientPortRuntimeMBeanImpl.register();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.toString(), exception);
            }
        }
        this.setStatMap(new MonitoringStatMap(this));
    }

    @Override
    public String getClientID() {
        return ((WseeClientRuntimeData)this.getData()).getClientId();
    }

    private void setStatMap(MonitoringStatMap monitoringStatMap) {
        this._statMap = monitoringStatMap;
    }

    public MonitoringStatMap getStatMap() {
        return this._statMap;
    }
}

