/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.monitoring;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.TreeMap;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import weblogic.wsee.WseeCoreLogger;

public final class WseeCompositeDataFactory {
    private WseeCompositeType _type;
    private CompositeType _compositeType;

    public WseeCompositeDataFactory(Class clazz) throws IntrospectionException, OpenDataException {
        this._type = new WseeCompositeType(clazz);
        this._compositeType = this._type.generateCompositeType();
    }

    public CompositeType getCompositeType() {
        return this._compositeType;
    }

    public CompositeData createCompositeData(Object object) throws OpenDataException {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        for (String string : this._type._propMap.keySet()) {
            PropertyDescriptor propertyDescriptor = this._type._propMap.get(string);
            Method method = propertyDescriptor.getReadMethod();
            try {
                Object object2 = method.invoke(object, new Object[0]);
                OpenType<?> openType = this._compositeType.getType(string);
                if (openType instanceof SimpleType) {
                    treeMap.put(string, object2);
                    continue;
                }
                if (openType.isArray()) {
                    Object[] objectArray = (Object[])object2;
                    CompositeData[] compositeDataArray = new CompositeData[objectArray.length];
                    int n = 0;
                    for (Object object3 : objectArray) {
                        compositeDataArray[n++] = object3 instanceof WseeCompositable ? ((WseeCompositable)object3).createCompositeData() : null;
                    }
                    treeMap.put(string, compositeDataArray);
                    continue;
                }
                if (!(object2 instanceof WseeCompositable)) continue;
                treeMap.put(string, ((WseeCompositable)object2).createCompositeData());
            }
            catch (Exception exception) {
                WseeCoreLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
                throw new OpenDataException(exception.toString());
            }
        }
        CompositeDataSupport compositeDataSupport = new CompositeDataSupport(this._compositeType, treeMap);
        return compositeDataSupport;
    }

    public static interface WseeCompositable {
        public CompositeData createCompositeData() throws OpenDataException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WseeCompositeType {
        private Class _class;
        public Map<String, PropertyDescriptor> _propMap;

        public WseeCompositeType(Class clazz) throws IntrospectionException {
            this(clazz, null);
        }

        public WseeCompositeType(Class clazz, Class clazz2) throws IntrospectionException {
            PropertyDescriptor[] propertyDescriptorArray;
            this._class = clazz;
            this._propMap = new TreeMap<String, PropertyDescriptor>();
            BeanInfo beanInfo = clazz2 == null ? Introspector.getBeanInfo(this._class) : Introspector.getBeanInfo(this._class, clazz2);
            for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray = beanInfo.getPropertyDescriptors()) {
                this._propMap.put(propertyDescriptor.getName(), propertyDescriptor);
            }
        }

        public CompositeType generateCompositeType() throws IntrospectionException, OpenDataException {
            String string = this._class.getName();
            String string2 = this._class.getName();
            String[] stringArray = new String[this._propMap.size()];
            String[] stringArray2 = new String[this._propMap.size()];
            OpenType[] openTypeArray = new OpenType[this._propMap.size()];
            int n = 0;
            for (String string3 : this._propMap.keySet()) {
                PropertyDescriptor propertyDescriptor = this._propMap.get(string3);
                stringArray[n] = string3;
                stringArray2[n] = string3;
                OpenType openType = this.getSimpleType(propertyDescriptor.getPropertyType());
                if (openType == null) {
                    Class<?> clazz;
                    if (propertyDescriptor.getPropertyType().isArray()) {
                        clazz = propertyDescriptor.getPropertyType().getComponentType();
                        OpenType openType2 = this.getSimpleType(clazz);
                        if (openType2 == null) {
                            if (CompositeData.class.isAssignableFrom(clazz)) {
                                throw new IllegalArgumentException("CompositeData not supported as a field type in another CompositeType");
                            }
                            WseeCompositeType wseeCompositeType = new WseeCompositeType(clazz);
                            openType2 = wseeCompositeType.generateCompositeType();
                        }
                        openType = new ArrayType(1, openType2);
                    } else {
                        if (CompositeData.class.isAssignableFrom(propertyDescriptor.getPropertyType())) {
                            throw new IllegalArgumentException("CompositeData not supported as a field type in another CompositeType");
                        }
                        clazz = new WseeCompositeType(propertyDescriptor.getPropertyType());
                        openType = ((WseeCompositeType)((Object)clazz)).generateCompositeType();
                    }
                }
                openTypeArray[n] = openType;
                ++n;
            }
            return new CompositeType(string, string2, stringArray, stringArray2, openTypeArray);
        }

        private SimpleType<?> getSimpleType(Class clazz) {
            if (clazz == Byte.TYPE || clazz == Byte.TYPE) {
                return SimpleType.BYTE;
            }
            if (clazz == Short.TYPE || clazz == Short.class) {
                return SimpleType.SHORT;
            }
            if (clazz == Integer.TYPE || clazz == Integer.class) {
                return SimpleType.INTEGER;
            }
            if (clazz == Long.TYPE || clazz == Long.class) {
                return SimpleType.LONG;
            }
            if (clazz == Float.TYPE || clazz == Float.class) {
                return SimpleType.FLOAT;
            }
            if (clazz == Character.TYPE || clazz == Character.class) {
                return SimpleType.CHARACTER;
            }
            if (clazz == String.class) {
                return SimpleType.STRING;
            }
            if (clazz == Boolean.TYPE || clazz == Boolean.class) {
                return SimpleType.BOOLEAN;
            }
            return null;
        }
    }
}

