/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.monitoring;

import java.util.Date;
import javax.xml.namespace.QName;
import javax.xml.rpc.soap.SOAPFaultException;
import weblogic.management.ManagementException;
import weblogic.wsee.monitoring.WseeBaseRuntimeData;
import weblogic.wsee.util.Verbose;

public final class WseeHandlerRuntimeData
extends WseeBaseRuntimeData {
    private static final boolean verbose = Verbose.isVerbose(WseeHandlerRuntimeData.class);
    private QName[] headers;
    private Class handlerClass = null;
    private boolean isInternal;
    private Throwable initError = null;
    private Throwable lastRequestError = null;
    private Throwable lastResponseError = null;
    private SOAPFaultException lastRequestSoapFault = null;
    private SOAPFaultException lastResponseSoapFault = null;
    private int requestSoapFaultsCount = 0;
    private int requestTerminationsCount = 0;
    private int requestErrorsCount = 0;
    private int responseSoapFaultsCount = 0;
    private int responseTerminationsCount = 0;
    private int responseErrorsCount = 0;
    private Date lastResetTime = null;

    WseeHandlerRuntimeData(String string, Class clazz, QName[] qNameArray) throws ManagementException {
        super(string, null);
        this.handlerClass = clazz;
        this.headers = qNameArray;
        this.isInternal = clazz.getName().startsWith("weblogic.wsee");
        if (verbose) {
            Verbose.log("WseeHandlerRuntimeData[" + string + "]");
        }
    }

    public Class getHandlerClass() {
        return this.handlerClass;
    }

    public QName[] getHeaders() {
        return this.headers;
    }

    public int getRequestSOAPFaultsCount() {
        return this.requestSoapFaultsCount;
    }

    public int getRequestTerminationsCount() {
        return this.requestTerminationsCount;
    }

    public int getRequestErrorsCount() {
        return this.requestErrorsCount;
    }

    public int getResponseSOAPFaultsCount() {
        return this.responseSoapFaultsCount;
    }

    public int getResponseTerminationsCount() {
        return this.responseTerminationsCount;
    }

    public int getResponseErrorsCount() {
        return this.responseErrorsCount;
    }

    public boolean isInternal() {
        return this.isInternal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportRequestSOAPFault(SOAPFaultException sOAPFaultException) {
        WseeHandlerRuntimeData wseeHandlerRuntimeData = this;
        synchronized (wseeHandlerRuntimeData) {
            ++this.requestSoapFaultsCount;
            this.lastRequestSoapFault = sOAPFaultException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportRequestTermination() {
        WseeHandlerRuntimeData wseeHandlerRuntimeData = this;
        synchronized (wseeHandlerRuntimeData) {
            ++this.requestTerminationsCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportRequestError(Throwable throwable) {
        WseeHandlerRuntimeData wseeHandlerRuntimeData = this;
        synchronized (wseeHandlerRuntimeData) {
            ++this.requestErrorsCount;
            this.lastRequestError = throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportResponseSOAPFault(SOAPFaultException sOAPFaultException) {
        WseeHandlerRuntimeData wseeHandlerRuntimeData = this;
        synchronized (wseeHandlerRuntimeData) {
            ++this.responseSoapFaultsCount;
            this.lastResponseSoapFault = sOAPFaultException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportResponseTermination() {
        WseeHandlerRuntimeData wseeHandlerRuntimeData = this;
        synchronized (wseeHandlerRuntimeData) {
            ++this.responseTerminationsCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportResponseError(Throwable throwable) {
        WseeHandlerRuntimeData wseeHandlerRuntimeData = this;
        synchronized (wseeHandlerRuntimeData) {
            ++this.responseErrorsCount;
            this.lastResponseError = throwable;
        }
    }

    public void reportInitError(Throwable throwable) {
        this.initError = throwable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        WseeHandlerRuntimeData wseeHandlerRuntimeData = this;
        synchronized (wseeHandlerRuntimeData) {
            this.lastResetTime = new Date();
            this.requestSoapFaultsCount = 0;
            this.requestTerminationsCount = 0;
            this.requestErrorsCount = 0;
            this.responseTerminationsCount = 0;
            this.responseErrorsCount = 0;
            this.lastRequestSoapFault = null;
            this.lastResponseSoapFault = null;
            this.lastRequestError = null;
            this.lastResponseError = null;
        }
    }

    public Date getLastResetTime() {
        return this.lastResetTime;
    }
}

