/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.monitoring;

import java.util.HashSet;
import java.util.Set;
import weblogic.wsee.deploy.VersioningHelper;
import weblogic.wsee.monitoring.OwsmSecurityPolicyRuntimeData;
import weblogic.wsee.monitoring.WseeBaseRuntimeData;
import weblogic.wsee.monitoring.WseePolicyRuntimeData;
import weblogic.wsee.monitoring.WseePortRuntimeData;

public final class WseeRuntimeData
extends WseeBaseRuntimeData {
    private String contextPath = null;
    private String URI = null;
    private String appName = null;
    private String version = null;
    private String implementationType = null;
    private String webserviceDescriptionName = null;
    private Set<WseePortRuntimeData> ports = new HashSet<WseePortRuntimeData>();
    private WseePolicyRuntimeData wprd = null;
    private OwsmSecurityPolicyRuntimeData owsmSecPolicy = null;
    private long startTime = 0L;

    WseeRuntimeData(String string, String string2, String string3, String string4, String string5, String string6) {
        super(string, null);
        this.contextPath = string2;
        this.URI = string2 != null ? string2 + string3 : string3;
        this.version = string5;
        this.appName = string4;
        this.implementationType = string6;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getURI() {
        return this.URI;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getVersion() {
        return this.version;
    }

    public WseePortRuntimeData[] getPorts() {
        return this.ports.toArray(new WseePortRuntimeData[this.ports.size()]);
    }

    public void clearPorts() {
        this.ports = null;
    }

    void setPolicyRuntime(WseePolicyRuntimeData wseePolicyRuntimeData) {
        this.wprd = wseePolicyRuntimeData;
    }

    public WseePolicyRuntimeData getPolicyRuntime() {
        return this.wprd;
    }

    public void clearPolicyRuntime() {
        this.wprd = null;
    }

    public long getConversationInstanceCount() {
        return VersioningHelper.getCount(this.appName, this.version);
    }

    public String getImplementationType() {
        return this.implementationType;
    }

    public void setWebserviceDescriptrionName(String string) {
        this.webserviceDescriptionName = string;
    }

    public String getWebserviceDescriptionName() {
        return this.webserviceDescriptionName;
    }

    public boolean addPort(WseePortRuntimeData wseePortRuntimeData) {
        assert (wseePortRuntimeData != null);
        for (WseePortRuntimeData wseePortRuntimeData2 : this.ports) {
            if (!wseePortRuntimeData2.getName().equals(wseePortRuntimeData.getName())) continue;
            return false;
        }
        wseePortRuntimeData.setParentData(this);
        this.ports.add(wseePortRuntimeData);
        return true;
    }

    void setOwsmSecurityPolicyRuntime(OwsmSecurityPolicyRuntimeData owsmSecurityPolicyRuntimeData) {
        this.owsmSecPolicy = owsmSecurityPolicyRuntimeData;
    }

    public OwsmSecurityPolicyRuntimeData getOwsmSecurityPolicyRuntime() {
        return this.owsmSecPolicy;
    }

    public void clearOwsmSecurityPolicyRuntime() {
        this.owsmSecPolicy = null;
    }

    public int getPolicyFaults() {
        int n = 0;
        for (WseePortRuntimeData wseePortRuntimeData : this.getPorts()) {
            n += wseePortRuntimeData.getPolicyFaults();
        }
        return n;
    }

    public long getStartTime() {
        return this.startTime;
    }

    @Deprecated
    public int getTotalFaults() {
        int n = 0;
        for (WseePortRuntimeData wseePortRuntimeData : this.getPorts()) {
            n += wseePortRuntimeData.getTotalFaults();
        }
        return n;
    }

    public int getTotalSecurityFaults() {
        int n = 0;
        for (WseePortRuntimeData wseePortRuntimeData : this.getPorts()) {
            n += wseePortRuntimeData.getTotalSecurityFaults();
        }
        return n;
    }

    public void setURI(String string) {
        this.URI = string;
    }

    public void setAppName(String string) {
        this.appName = string;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public void setImplementationType(String string) {
        this.implementationType = string;
    }

    public void setWebserviceDescriptionName(String string) {
        this.webserviceDescriptionName = string;
    }

    public void setStartTime(long l) {
        this.startTime = l;
    }
}

