/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.monitoring;

import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.management.ManagementException;
import weblogic.management.WebLogicMBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.t3.srvr.ServerRuntime;
import weblogic.wsee.monitoring.WseeBaseRuntimeData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WseeRuntimeMBeanDelegate<M extends RuntimeMBean, D extends WseeBaseRuntimeData>
extends RuntimeMBeanDelegate {
    private static final Logger LOGGER = Logger.getLogger(WseeRuntimeMBeanDelegate.class.getName());
    public static final String RELIABLE_SECURE_PROFILE_ENABLED_PROPERTY = "weblogic.wsee.ReliableSecureProfileEnabled";
    private static boolean isReliableSecureProfileEnabled;
    private boolean _isProxy;
    private WseeRuntimeMBeanDelegate<M, D> _proxy;
    private WseeRuntimeMBeanDelegate<M, D> _master;
    private D _data;
    private String _registeredName;

    public static final boolean isReliableSecureProfileEnabled() {
        return isReliableSecureProfileEnabled;
    }

    protected abstract WseeRuntimeMBeanDelegate<M, D> internalCreateProxy(String var1, RuntimeMBean var2) throws ManagementException;

    public WseeRuntimeMBeanDelegate<M, D> createProxy(String string, RuntimeMBean runtimeMBean) throws ManagementException {
        if (this.isProxy()) {
            throw new ManagementException("Cannot create a proxy for MBean " + this.getName() + " because it already is a proxy");
        }
        this._proxy = this.internalCreateProxy(string, runtimeMBean);
        this._proxy._isProxy = true;
        this._proxy.setData(this._data);
        return this._proxy;
    }

    protected WseeRuntimeMBeanDelegate(String string, RuntimeMBean runtimeMBean, WseeRuntimeMBeanDelegate<M, D> wseeRuntimeMBeanDelegate, boolean bl) throws ManagementException {
        super(string, runtimeMBean, bl);
        boolean bl2 = this._isProxy = wseeRuntimeMBeanDelegate != null;
        if (runtimeMBean instanceof WseeRuntimeMBeanDelegate && this._isProxy != ((WseeRuntimeMBeanDelegate)runtimeMBean).isProxy()) {
            throw new ManagementException("Attempt to create a WSEE MBean where part of the hierarchy isn't doesn't match proxy/non-proxy " + ((Object)((Object)this)).getClass().getSimpleName() + " name=" + string + " isProxy=" + this._isProxy + " parent isProxy=" + ((WseeRuntimeMBeanDelegate)runtimeMBean).isProxy());
        }
        this._master = wseeRuntimeMBeanDelegate;
    }

    public boolean isProxy() {
        return this._isProxy;
    }

    public WseeRuntimeMBeanDelegate getProxy() {
        return this.isProxy() ? null : this._proxy;
    }

    public WseeRuntimeMBeanDelegate getMaster() {
        return this.isProxy() ? this._master : null;
    }

    public D getData() {
        return this._data;
    }

    public void setData(D d) {
        this._data = d;
    }

    public void register() throws ManagementException {
        if (this.isRegistered()) {
            return;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Registering: " + this.toString());
        }
        this._registeredName = this.getQualifiedName();
        super.register();
        if (this._proxy != null) {
            this._proxy.register();
        }
    }

    public void unregister() throws ManagementException {
        if (!this.isRegistered()) {
            return;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Un-Registering: " + this.toString());
        }
        if (this._proxy != null) {
            this._proxy.unregister();
            this._proxy = null;
        }
        super.unregister();
    }

    public String getQualifiedName() {
        if (this._registeredName != null) {
            return this._registeredName;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (WseeRuntimeMBeanDelegate wseeRuntimeMBeanDelegate = this; wseeRuntimeMBeanDelegate != null; wseeRuntimeMBeanDelegate = wseeRuntimeMBeanDelegate.getParent()) {
            stringBuffer.insert(0, "]");
            stringBuffer.insert(0, ((Object)((Object)wseeRuntimeMBeanDelegate)).getClass().getSimpleName());
            stringBuffer.insert(0, "[");
            stringBuffer.insert(0, wseeRuntimeMBeanDelegate.getName());
            if (wseeRuntimeMBeanDelegate instanceof WseeRuntimeMBeanDelegate && wseeRuntimeMBeanDelegate.isProxy()) {
                stringBuffer.insert(0, "Proxy:");
            }
            stringBuffer.insert(0, "/");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append(" - ");
        stringBuffer.append(this.getQualifiedName());
        return stringBuffer.toString();
    }

    public int hashCode() {
        return this.getQualifiedName().hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof WseeRuntimeMBeanDelegate)) {
            return false;
        }
        WseeRuntimeMBeanDelegate wseeRuntimeMBeanDelegate = (WseeRuntimeMBeanDelegate)((Object)object);
        return wseeRuntimeMBeanDelegate.getQualifiedName().equals(this.getQualifiedName());
    }

    public void setParent(WebLogicMBean webLogicMBean) {
        ServerRuntime.theOne().removeChild(this);
        this.parent = (RuntimeMBeanDelegate)webLogicMBean;
    }

    static {
        try {
            String string = System.getProperty(RELIABLE_SECURE_PROFILE_ENABLED_PROPERTY);
            isReliableSecureProfileEnabled = string == null ? true : string.equalsIgnoreCase("true");
        }
        catch (Exception exception) {
            isReliableSecureProfileEnabled = false;
            exception.printStackTrace();
        }
    }
}

