/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.monitoring;

import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.server.ContainerResolver;
import com.sun.xml.ws.api.server.WSEndpoint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.soap.SOAPHandler;
import weblogic.j2ee.ComponentRuntimeMBeanImpl;
import weblogic.management.ManagementException;
import weblogic.management.runtime.ApplicationRuntimeMBean;
import weblogic.management.runtime.ComponentRuntimeMBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.WseeBaseRuntimeMBean;
import weblogic.management.runtime.WseePortConfigurationRuntimeMBean;
import weblogic.wsee.deploy.DeployInfo;
import weblogic.wsee.handler.HandlerListImpl;
import weblogic.wsee.jaxws.tubeline.standard.ClientContainerUtil;
import weblogic.wsee.monitoring.WseeBaseRuntimeMBeanImpl;
import weblogic.wsee.monitoring.WseeClientConfigurationRuntimeMBeanImpl;
import weblogic.wsee.monitoring.WseeClientOperationRuntimeMBeanImpl;
import weblogic.wsee.monitoring.WseeClientPortRuntimeMBeanImpl;
import weblogic.wsee.monitoring.WseeHandlerRuntimeMBeanImpl;
import weblogic.wsee.monitoring.WseeOperationConfigurationRuntimeMBeanImpl;
import weblogic.wsee.monitoring.WseeOperationRuntimeData;
import weblogic.wsee.monitoring.WseeOperationRuntimeMBeanImpl;
import weblogic.wsee.monitoring.WseePortConfigurationRuntimeMBeanImpl;
import weblogic.wsee.monitoring.WseePortRuntimeData;
import weblogic.wsee.monitoring.WseePortRuntimeMBeanImpl;
import weblogic.wsee.monitoring.WseeRuntimeMBeanImpl;
import weblogic.wsee.monitoring.WseeV2RuntimeMBeanImpl;
import weblogic.wsee.monitoring.WsspStats;
import weblogic.wsee.runtime.owsm.PolicySubjectUtil;
import weblogic.wsee.security.policy.WssPolicyContext;
import weblogic.wsee.util.UniqueNameSet;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsEndpoint;
import weblogic.wsee.ws.WsMethod;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.WsPortImpl;
import weblogic.wsee.ws.WsService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WseeRuntimeMBeanManager {
    private static final boolean verbose = Verbose.isVerbose(WseeRuntimeMBeanManager.class);
    private static final Map<String, WseeBaseRuntimeMBean> wseeRuntimeMBeanNames = new HashMap<String, WseeBaseRuntimeMBean>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void remove(String string) {
        Map<String, WseeBaseRuntimeMBean> map = wseeRuntimeMBeanNames;
        synchronized (map) {
            wseeRuntimeMBeanNames.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WseeBaseRuntimeMBean createJaxWsMBean(WSEndpoint<?> wSEndpoint, RuntimeMBean runtimeMBean, RuntimeMBean runtimeMBean2, String string, String string2, String string3, String string4, WssPolicyContext wssPolicyContext) throws ManagementException {
        if (runtimeMBean == null) {
            throw new IllegalArgumentException("Null app runtime in runtime mbean");
        }
        String string5 = wSEndpoint.getServiceName().getLocalPart();
        String string6 = "1";
        int n = string.indexOf(35);
        if (n >= 0) {
            string6 = string.substring(n + 1);
            string = string.substring(0, n);
        }
        String string7 = WseeRuntimeMBeanManager.getOldStyleName(string, string6, string5);
        DeployInfo deployInfo = (DeployInfo)wSEndpoint.getContainer().getSPI(DeployInfo.class);
        String string8 = deployInfo == null ? (runtimeMBean2 != null ? runtimeMBean2.getName() : null) : deployInfo.getModuleName();
        String string9 = WseeRuntimeMBeanManager.getNewStyleName(string, string6, string8, string5);
        Map<String, WseeBaseRuntimeMBean> map = wseeRuntimeMBeanNames;
        synchronized (map) {
            if (!wseeRuntimeMBeanNames.containsKey(string9)) {
                WseePortRuntimeMBeanImpl wseePortRuntimeMBeanImpl = WseeRuntimeMBeanManager.createJaxWsPort(wSEndpoint.getPortName(), wSEndpoint.getBinding(), wSEndpoint.getPort(), string8);
                if (string2 == null) {
                    // empty if block
                }
                WseeV2RuntimeMBeanImpl wseeV2RuntimeMBeanImpl = new WseeV2RuntimeMBeanImpl(string2, runtimeMBean2 != null ? runtimeMBean2 : runtimeMBean, string3, string4, string, string6, (Object)((Object)Type.JAXWS) + " " + (Object)((Object)JaxWsVersion.latest()), string9);
                wseeV2RuntimeMBeanImpl.addPort(wseePortRuntimeMBeanImpl);
                wseeV2RuntimeMBeanImpl.setWebserviceDescriptrionName(string2);
                if (wssPolicyContext != null) {
                    wseeV2RuntimeMBeanImpl.getPolicyRuntime().addPolicies(wssPolicyContext.getPolicyServer().getCachedPolicies());
                }
                if (verbose) {
                    Verbose.log("WseeRuntimeMbeanImpl[" + string5 + "] with full name " + string9 + " created");
                }
                wseeRuntimeMBeanNames.put(string9, wseeV2RuntimeMBeanImpl);
                wseeV2RuntimeMBeanImpl.register();
                if (!string7.equals(string9)) {
                    if (!wseeRuntimeMBeanNames.containsKey(string7)) {
                        if (verbose) {
                            Verbose.log("WseeRuntimeMbeanImpl[" + string5 + "] with full name " + string9 + " and old name " + string7 + " created AS PROXY");
                        }
                        WseeRuntimeMBeanImpl wseeRuntimeMBeanImpl = (WseeRuntimeMBeanImpl)wseeV2RuntimeMBeanImpl.createProxy(string7, runtimeMBean);
                        wseeRuntimeMBeanImpl.setServiceName(string7);
                        wseeRuntimeMBeanNames.put(string7, wseeRuntimeMBeanImpl);
                        wseeRuntimeMBeanImpl.register();
                    } else {
                        WseeBaseRuntimeMBean wseeBaseRuntimeMBean;
                        if (verbose) {
                            Verbose.log("WseeV2RuntimeMBeanImpl[" + string5 + "] with old name " + string7 + " already registered");
                        }
                        if (((WseeBaseRuntimeMBeanImpl)(wseeBaseRuntimeMBean = wseeRuntimeMBeanNames.get(string7))).isProxy()) {
                            wseePortRuntimeMBeanImpl = (WseePortRuntimeMBeanImpl)wseePortRuntimeMBeanImpl.createProxy(wseePortRuntimeMBeanImpl.getName(), wseeBaseRuntimeMBean);
                        }
                        wseeBaseRuntimeMBean.addPort(wseePortRuntimeMBeanImpl);
                    }
                }
                if (verbose) {
                    Verbose.log("WseeV2RuntimeMbeanImpl[" + string5 + "] with full name " + string9 + " created");
                }
                return wseeV2RuntimeMBeanImpl;
            }
            if (verbose) {
                Verbose.log("WseeV2RuntimeMBeanImpl[" + string5 + "] with full name " + string9 + " already registered");
            }
            WseePortRuntimeMBeanImpl wseePortRuntimeMBeanImpl = WseeRuntimeMBeanManager.createJaxWsPort(wSEndpoint.getPortName(), wSEndpoint.getBinding(), wSEndpoint.getPort(), string8);
            WseeBaseRuntimeMBean wseeBaseRuntimeMBean = wseeRuntimeMBeanNames.get(string9);
            if (((WseeBaseRuntimeMBeanImpl)wseeBaseRuntimeMBean).isProxy()) {
                wseePortRuntimeMBeanImpl = (WseePortRuntimeMBeanImpl)wseePortRuntimeMBeanImpl.createProxy(wseePortRuntimeMBeanImpl.getName(), wseeBaseRuntimeMBean);
            }
            wseeBaseRuntimeMBean.addPort(wseePortRuntimeMBeanImpl);
            return wseeBaseRuntimeMBean;
        }
    }

    private static WseePortRuntimeMBeanImpl createJaxWsPort(QName qName, WSBinding wSBinding, WSDLPort wSDLPort, String string) throws ManagementException {
        if (qName == null && wSDLPort != null) {
            qName = wSDLPort.getName();
        }
        String string2 = qName != null ? qName.getLocalPart() : "???";
        String string3 = wSDLPort != null ? wSDLPort.getOwner().getName().getLocalPart() : null;
        WseePortRuntimeMBeanImpl wseePortRuntimeMBeanImpl = new WseePortRuntimeMBeanImpl(string2, "http");
        ((WseePortRuntimeData)wseePortRuntimeMBeanImpl.getData()).setPolicySubjectName(string2);
        ((WseePortRuntimeData)wseePortRuntimeMBeanImpl.getData()).setPolicySubjectType("WLSWSENDPOINT");
        ((WseePortRuntimeData)wseePortRuntimeMBeanImpl.getData()).setPolicyAttachmentSupport("binding.server.soap.http");
        String string4 = PolicySubjectUtil.formatEndpointPortResourcePattern(string2, string3, string);
        ((WseePortRuntimeData)wseePortRuntimeMBeanImpl.getData()).setPolicySubjectResourcePattern(string4);
        List<WseeOperationRuntimeMBeanImpl> list = WseeRuntimeMBeanManager.createJaxWsOperations(wSDLPort);
        for (WseeOperationRuntimeMBeanImpl object2 : list) {
            wseePortRuntimeMBeanImpl.addOperation(object2);
            ((WseeOperationRuntimeData)object2.getData()).setPolicySubjectName(object2.getName());
            ((WseeOperationRuntimeData)object2.getData()).setPolicySubjectResourcePattern(string4 + "/OPERATIONs/" + object2.getName());
            ((WseeOperationRuntimeData)object2.getData()).setPolicySubjectType("WLSWSENDPOINT");
            ((WseeOperationRuntimeData)object2.getData()).setPolicyAttachmentSupport("binding.server.soap.http");
        }
        List<WseeHandlerRuntimeMBeanImpl> list2 = WseeRuntimeMBeanManager.createJaxWsHandlers(wSBinding);
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            WseeHandlerRuntimeMBeanImpl wseeHandlerRuntimeMBeanImpl = (WseeHandlerRuntimeMBeanImpl)iterator.next();
            wseePortRuntimeMBeanImpl.addHandler(wseeHandlerRuntimeMBeanImpl);
        }
        return wseePortRuntimeMBeanImpl;
    }

    public static WseeClientPortRuntimeMBeanImpl createJaxWsClientPort(QName qName, WSBinding wSBinding, WSDLPort wSDLPort, String string, WseePortConfigurationRuntimeMBean wseePortConfigurationRuntimeMBean) throws ManagementException {
        if (qName == null && wSDLPort != null) {
            qName = wSDLPort.getName();
        }
        String string2 = qName != null ? qName.getLocalPart() : "???";
        WseeClientPortRuntimeMBeanImpl wseeClientPortRuntimeMBeanImpl = new WseeClientPortRuntimeMBeanImpl(string2, "http");
        for (WseeClientOperationRuntimeMBeanImpl wseeRuntimeMBeanDelegate : WseeRuntimeMBeanManager.createJaxWsClientOperations(wSDLPort)) {
            wseeClientPortRuntimeMBeanImpl.addOperation(wseeRuntimeMBeanDelegate);
        }
        for (WseeHandlerRuntimeMBeanImpl wseeHandlerRuntimeMBeanImpl : WseeRuntimeMBeanManager.createJaxWsHandlers(wSBinding)) {
            wseeClientPortRuntimeMBeanImpl.addHandler(wseeHandlerRuntimeMBeanImpl);
        }
        wseeClientPortRuntimeMBeanImpl.setWseePortConfigurationRuntimeMBean(wseePortConfigurationRuntimeMBean);
        return wseeClientPortRuntimeMBeanImpl;
    }

    private static List<WseeOperationRuntimeMBeanImpl> createJaxWsOperations(WSDLPort wSDLPort) throws ManagementException {
        ArrayList<WseeOperationRuntimeMBeanImpl> arrayList = new ArrayList<WseeOperationRuntimeMBeanImpl>();
        if (wSDLPort != null) {
            Iterable iterable = wSDLPort.getBinding().getPortType().getOperations();
            for (WSDLOperation wSDLOperation : iterable) {
                arrayList.add(new WseeOperationRuntimeMBeanImpl(wSDLOperation.getName().getLocalPart()));
            }
        }
        arrayList.add(WseeOperationRuntimeMBeanImpl.createWsProtocolOp());
        return arrayList;
    }

    private static List<WseeClientOperationRuntimeMBeanImpl> createJaxWsClientOperations(WSDLPort wSDLPort) throws ManagementException {
        ArrayList<WseeClientOperationRuntimeMBeanImpl> arrayList = new ArrayList<WseeClientOperationRuntimeMBeanImpl>();
        if (wSDLPort != null) {
            Iterable iterable = wSDLPort.getBinding().getPortType().getOperations();
            for (WSDLOperation wSDLOperation : iterable) {
                arrayList.add(new WseeClientOperationRuntimeMBeanImpl(wSDLOperation.getName().getLocalPart()));
            }
        }
        arrayList.add(WseeClientOperationRuntimeMBeanImpl.createWsProtocolOp());
        return arrayList;
    }

    private static List<WseeHandlerRuntimeMBeanImpl> createJaxWsHandlers(WSBinding wSBinding) throws ManagementException {
        UniqueNameSet uniqueNameSet = new UniqueNameSet();
        ArrayList<WseeHandlerRuntimeMBeanImpl> arrayList = new ArrayList<WseeHandlerRuntimeMBeanImpl>();
        List list = wSBinding.getHandlerChain();
        for (Handler handler : list) {
            Object object;
            QName[] qNameArray = new QName[]{};
            if (handler instanceof SOAPHandler && (object = ((SOAPHandler)handler).getHeaders()) != null) {
                qNameArray = object.toArray(new QName[object.size()]);
            }
            object = new WseeHandlerRuntimeMBeanImpl(uniqueNameSet.add(handler.getClass().getName()), handler.getClass(), qNameArray);
            arrayList.add((WseeHandlerRuntimeMBeanImpl)object);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WseeBaseRuntimeMBean createJaxRpcMBean(ApplicationRuntimeMBean applicationRuntimeMBean, ComponentRuntimeMBean componentRuntimeMBean, WsService wsService, DeployInfo deployInfo, String string, String string2, String string3, String string4) throws ManagementException {
        if (applicationRuntimeMBean == null) {
            throw new IllegalArgumentException("Null app runtime in runtime mbean");
        }
        int n = string3.indexOf(35);
        if (n >= 0) {
            string4 = string3.substring(n + 1);
            string3 = string3.substring(0, n);
        }
        String string5 = wsService.getWsdlService().getName().getLocalPart();
        String string6 = WseeRuntimeMBeanManager.getOldStyleName(string3, string4, string5);
        String string7 = deployInfo == null ? componentRuntimeMBean.getName() : deployInfo.getModuleName();
        String string8 = WseeRuntimeMBeanManager.getNewStyleName(string3, string4, string7, string5);
        Map<String, WseeBaseRuntimeMBean> map = wseeRuntimeMBeanNames;
        synchronized (map) {
            if (!wseeRuntimeMBeanNames.containsKey(string8)) {
                int n2;
                WseePortRuntimeMBeanImpl[] wseePortRuntimeMBeanImplArray = WseeRuntimeMBeanManager.createJaxRpcPorts(wsService);
                WseeV2RuntimeMBeanImpl wseeV2RuntimeMBeanImpl = new WseeV2RuntimeMBeanImpl(string, componentRuntimeMBean, null, string2, string3, string4, (Object)((Object)Type.JAXRPC) + " " + (Object)((Object)JaxRpcVersion.latest()), string8);
                Object object = wseePortRuntimeMBeanImplArray;
                int n3 = ((WseePortRuntimeMBeanImpl[])object).length;
                for (n2 = 0; n2 < n3; ++n2) {
                    WseePortRuntimeMBeanImpl wseePortRuntimeMBeanImpl = object[n2];
                    wseeV2RuntimeMBeanImpl.addPort(wseePortRuntimeMBeanImpl);
                }
                wseeV2RuntimeMBeanImpl.setWebserviceDescriptrionName(string);
                wseeV2RuntimeMBeanImpl.getPolicyRuntime().addPolicies(deployInfo.getWssPolicyContext().getPolicyServer().getCachedPolicies());
                if (verbose) {
                    Verbose.log("WseeRuntimeMbeanImpl[" + string5 + "] with full name " + string8 + " created");
                }
                wseeRuntimeMBeanNames.put(string8, wseeV2RuntimeMBeanImpl);
                wseeV2RuntimeMBeanImpl.register();
                if (!string6.equals(string8)) {
                    if (!wseeRuntimeMBeanNames.containsKey(string6)) {
                        if (verbose) {
                            Verbose.log("WseeRuntimeMbeanImpl[" + string5 + "] with full name " + string8 + " and old name " + string6 + " created AS PROXY");
                        }
                        object = (WseeRuntimeMBeanImpl)wseeV2RuntimeMBeanImpl.createProxy(string6, applicationRuntimeMBean);
                        ((WseeRuntimeMBeanImpl)object).setServiceName(string6);
                        wseeRuntimeMBeanNames.put(string6, (WseeBaseRuntimeMBean)object);
                        ((WseeRuntimeMBeanImpl)object).register();
                    } else {
                        if (verbose) {
                            Verbose.log("WseeV2RuntimeMBeanImpl[" + string5 + "] with old name " + string6 + " already registered");
                        }
                        if (((WseeBaseRuntimeMBeanImpl)(object = wseeRuntimeMBeanNames.get(string6))).isProxy()) {
                            WseePortRuntimeMBeanImpl[] wseePortRuntimeMBeanImplArray2 = new WseePortRuntimeMBeanImpl[wseePortRuntimeMBeanImplArray.length];
                            for (n2 = 0; n2 < wseePortRuntimeMBeanImplArray.length; ++n2) {
                                wseePortRuntimeMBeanImplArray2[n2] = (WseePortRuntimeMBeanImpl)wseePortRuntimeMBeanImplArray[n2].createProxy(wseePortRuntimeMBeanImplArray[n2].getName(), (RuntimeMBean)object);
                            }
                            wseePortRuntimeMBeanImplArray = wseePortRuntimeMBeanImplArray2;
                        }
                        for (WseePortRuntimeMBeanImpl wseePortRuntimeMBeanImpl : wseePortRuntimeMBeanImplArray) {
                            object.addPort(wseePortRuntimeMBeanImpl);
                        }
                    }
                }
                if (verbose) {
                    Verbose.log("WseeV2RuntimeMbeanImpl[" + string5 + "] with full name " + string8 + " created");
                }
                return wseeV2RuntimeMBeanImpl;
            }
            if (verbose) {
                Verbose.log("WseeV2RuntimeMBeanImpl[" + string5 + "] with full name " + string8 + " already registered");
            }
            WseePortRuntimeMBeanImpl[] wseePortRuntimeMBeanImplArray = WseeRuntimeMBeanManager.createJaxRpcPorts(wsService);
            WseeBaseRuntimeMBean wseeBaseRuntimeMBean = wseeRuntimeMBeanNames.get(string8);
            if (((WseeBaseRuntimeMBeanImpl)wseeBaseRuntimeMBean).isProxy()) {
                WseePortRuntimeMBeanImpl[] wseePortRuntimeMBeanImplArray3 = new WseePortRuntimeMBeanImpl[wseePortRuntimeMBeanImplArray.length];
                for (int i = 0; i < wseePortRuntimeMBeanImplArray.length; ++i) {
                    wseePortRuntimeMBeanImplArray3[i] = (WseePortRuntimeMBeanImpl)wseePortRuntimeMBeanImplArray[i].createProxy(wseePortRuntimeMBeanImplArray[i].getName(), wseeBaseRuntimeMBean);
                }
                wseePortRuntimeMBeanImplArray = wseePortRuntimeMBeanImplArray3;
            }
            for (WseePortRuntimeMBeanImpl wseePortRuntimeMBeanImpl : wseePortRuntimeMBeanImplArray) {
                wseeBaseRuntimeMBean.addPort(wseePortRuntimeMBeanImpl);
            }
            return wseeBaseRuntimeMBean;
        }
    }

    private static String getOldStyleName(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder(string);
        if (string2 != null) {
            stringBuilder.append('#').append(string2);
        }
        stringBuilder.append('!').append(string3);
        return stringBuilder.toString();
    }

    private static String getNewStyleName(String string, String string2, String string3, String string4) {
        StringBuilder stringBuilder = new StringBuilder(string);
        if (string2 != null) {
            stringBuilder.append('#').append(string2);
        }
        if (string3 != null) {
            stringBuilder.append('!').append(string3);
        }
        stringBuilder.append('!').append(string4);
        return stringBuilder.toString();
    }

    private static WseePortRuntimeMBeanImpl[] createJaxRpcPorts(WsService wsService) throws ManagementException {
        ArrayList<WseePortRuntimeMBeanImpl> arrayList = new ArrayList<WseePortRuntimeMBeanImpl>();
        Iterator<WsPort> iterator = wsService.getPorts();
        while (iterator.hasNext()) {
            WsPortImpl wsPortImpl = (WsPortImpl)iterator.next();
            WseePortRuntimeMBeanImpl wseePortRuntimeMBeanImpl = new WseePortRuntimeMBeanImpl(wsPortImpl.getWsdlPort().getName().getLocalPart(), wsPortImpl.getWsdlPort().getTransport());
            List<WseeOperationRuntimeMBeanImpl> list = WseeRuntimeMBeanManager.createJaxRpcOperations(wsPortImpl.getEndpoint());
            for (WseeOperationRuntimeMBeanImpl wseeOperationRuntimeMBeanImpl : list) {
                wseePortRuntimeMBeanImpl.addOperation(wseeOperationRuntimeMBeanImpl);
            }
            List<WseeHandlerRuntimeMBeanImpl> list2 = WseeRuntimeMBeanManager.createJaxRpcHandlers(wsPortImpl);
            Iterator object2 = list2.iterator();
            while (object2.hasNext()) {
                WseeHandlerRuntimeMBeanImpl wseeHandlerRuntimeMBeanImpl = (WseeHandlerRuntimeMBeanImpl)object2.next();
                wseePortRuntimeMBeanImpl.addHandler(wseeHandlerRuntimeMBeanImpl);
            }
            arrayList.add(wseePortRuntimeMBeanImpl);
            wsPortImpl.setRuntimeMBean(wseePortRuntimeMBeanImpl);
            wsPortImpl.setWsspStats((WsspStats)WsspStats.class.cast(wseePortRuntimeMBeanImpl.getPortPolicy()));
        }
        return arrayList.toArray(new WseePortRuntimeMBeanImpl[arrayList.size()]);
    }

    private static List<WseeOperationRuntimeMBeanImpl> createJaxRpcOperations(WsEndpoint wsEndpoint) throws ManagementException {
        ArrayList<WseeOperationRuntimeMBeanImpl> arrayList = new ArrayList<WseeOperationRuntimeMBeanImpl>();
        Iterator iterator = wsEndpoint.getMethods();
        while (iterator.hasNext()) {
            WsMethod wsMethod = (WsMethod)iterator.next();
            WseeOperationRuntimeMBeanImpl wseeOperationRuntimeMBeanImpl = new WseeOperationRuntimeMBeanImpl(wsMethod.getOperationName().getLocalPart());
            arrayList.add(wseeOperationRuntimeMBeanImpl);
            wsMethod.setStats(wseeOperationRuntimeMBeanImpl);
        }
        return arrayList;
    }

    private static List<WseeHandlerRuntimeMBeanImpl> createJaxRpcHandlers(WsPort wsPort) throws ManagementException {
        UniqueNameSet uniqueNameSet = new UniqueNameSet();
        ArrayList<WseeHandlerRuntimeMBeanImpl> arrayList = new ArrayList<WseeHandlerRuntimeMBeanImpl>();
        HandlerListImpl handlerListImpl = (HandlerListImpl)wsPort.getInternalHandlerList();
        for (int i = 0; i < handlerListImpl.size(); ++i) {
            HandlerInfo handlerInfo = handlerListImpl.getInfo(i);
            WseeHandlerRuntimeMBeanImpl wseeHandlerRuntimeMBeanImpl = new WseeHandlerRuntimeMBeanImpl(uniqueNameSet.add(handlerListImpl.getName(i)), handlerInfo.getHandlerClass(), handlerInfo.getHeaders());
            arrayList.add(wseeHandlerRuntimeMBeanImpl);
            handlerListImpl.insert(i, wseeHandlerRuntimeMBeanImpl);
        }
        return arrayList;
    }

    public static WseeClientConfigurationRuntimeMBeanImpl createClientConfigurationMBean(String string) throws ManagementException {
        ComponentRuntimeMBeanImpl componentRuntimeMBeanImpl = ClientContainerUtil.getContainingComponentRuntimeByModuleName(ContainerResolver.getInstance().getContainer().getSPI(DeployInfo.class) == null ? null : ((DeployInfo)ContainerResolver.getInstance().getContainer().getSPI(DeployInfo.class)).getModuleName());
        WseeClientConfigurationRuntimeMBeanImpl wseeClientConfigurationRuntimeMBeanImpl = new WseeClientConfigurationRuntimeMBeanImpl(string, componentRuntimeMBeanImpl);
        return wseeClientConfigurationRuntimeMBeanImpl;
    }

    public static WseePortConfigurationRuntimeMBeanImpl createPortConfigurationMBean(WSDLPort wSDLPort, String string, WseeClientConfigurationRuntimeMBeanImpl wseeClientConfigurationRuntimeMBeanImpl) throws ManagementException {
        WseePortConfigurationRuntimeMBeanImpl wseePortConfigurationRuntimeMBeanImpl = new WseePortConfigurationRuntimeMBeanImpl(wSDLPort.getName().getLocalPart(), string);
        for (WSDLBoundOperation wSDLBoundOperation : wSDLPort.getBinding().getBindingOperations()) {
            WseeOperationConfigurationRuntimeMBeanImpl wseeOperationConfigurationRuntimeMBeanImpl = new WseeOperationConfigurationRuntimeMBeanImpl(wSDLBoundOperation.getName().getLocalPart(), wseePortConfigurationRuntimeMBeanImpl);
            wseePortConfigurationRuntimeMBeanImpl.addOperation(wseeOperationConfigurationRuntimeMBeanImpl);
        }
        wseeClientConfigurationRuntimeMBeanImpl.addPort(wseePortConfigurationRuntimeMBeanImpl);
        return wseePortConfigurationRuntimeMBeanImpl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JaxWsVersion {
        VERSION_20("2.0"),
        VERSION_21("2.1");

        private String _name;

        private JaxWsVersion(String string2) {
            this._name = string2;
        }

        public String toString() {
            return this._name;
        }

        public static JaxWsVersion latest() {
            return JaxWsVersion.values()[JaxWsVersion.values().length - 1];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JaxRpcVersion {
        VERSION_11("1.1");

        private String _name;

        private JaxRpcVersion(String string2) {
            this._name = string2;
        }

        public String toString() {
            return this._name;
        }

        public static JaxRpcVersion latest() {
            return JaxRpcVersion.values()[JaxRpcVersion.values().length - 1];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        JAXRPC("JAX-RPC"),
        JAXWS("JAX-WS");

        private String _name;

        private Type(String string2) {
            this._name = string2;
        }

        public String toString() {
            return this._name;
        }
    }
}

