/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.monitoring;

import com.sun.istack.Nullable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import weblogic.management.ManagementException;
import weblogic.management.runtime.WsrmRequestInfo;
import weblogic.management.runtime.WsrmSequenceInfo;
import weblogic.wsee.monitoring.WseeBaseRuntimeData;
import weblogic.wsee.monitoring.WseeCompositeDataFactory;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability2.sequence.DestinationMessageInfo;
import weblogic.wsee.reliability2.sequence.DestinationOfferSequence;
import weblogic.wsee.reliability2.sequence.DestinationSequence;
import weblogic.wsee.reliability2.sequence.DestinationSequenceManager;
import weblogic.wsee.reliability2.sequence.MessageInfo;
import weblogic.wsee.reliability2.sequence.OfferSequence;
import weblogic.wsee.reliability2.sequence.Sequence;
import weblogic.wsee.reliability2.sequence.SourceMessageInfo;
import weblogic.wsee.reliability2.sequence.SourceOfferSequence;
import weblogic.wsee.reliability2.sequence.SourceSequence;
import weblogic.wsee.reliability2.sequence.SourceSequenceManager;
import weblogic.wsee.reliability2.sequence.UnknownDestinationSequenceException;
import weblogic.wsee.reliability2.sequence.UnknownSourceSequenceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WseeWsrmRuntimeData
extends WseeBaseRuntimeData {
    private boolean _global;
    private List<String> _seqIds;

    public WseeWsrmRuntimeData(String string, boolean bl, @Nullable WseeBaseRuntimeData wseeBaseRuntimeData) throws ManagementException {
        super(string, wseeBaseRuntimeData);
        this._global = bl;
        this._seqIds = new ArrayList<String>();
    }

    public boolean isGlobal() {
        return this._global;
    }

    public void addSequenceId(String string) {
        if (!this._global) {
            this._seqIds.add(string);
        }
    }

    public void removeSequenceId(String string) {
        if (!this._global) {
            this._seqIds.remove(string);
        }
    }

    public List<String> getSequenceIDList() {
        if (this._global) {
            return this.getGlobalSequenceIDList();
        }
        return this.getLocalSequenceIDList();
    }

    private List<String> getGlobalSequenceIDList() {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = SourceSequenceManager.getInstance().listSequences();
        while (iterator.hasNext()) {
            object = (SourceSequence)iterator.next();
            arrayList.add(((Sequence)object).getId());
        }
        object = DestinationSequenceManager.getInstance().listSequences();
        while (object.hasNext()) {
            DestinationSequence destinationSequence = (DestinationSequence)object.next();
            arrayList.add(destinationSequence.getId());
        }
        return arrayList;
    }

    private List<String> getLocalSequenceIDList() {
        ArrayList<String> arrayList = new ArrayList<String>(this._seqIds);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            boolean bl = false;
            try {
                bl = this.getSequence(string) != null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bl) continue;
            iterator.remove();
        }
        this._seqIds = new ArrayList<String>(arrayList);
        return arrayList;
    }

    public String[] getSequenceIds() {
        List<String> list = this.getSequenceIDList();
        return list.toArray(new String[list.size()]);
    }

    public CompositeData getSequenceInfo(String string) throws ManagementException {
        try {
            Sequence sequence = this.getSequence(string);
            if (sequence == null) {
                return null;
            }
            WsrmSequenceInfoImpl wsrmSequenceInfoImpl = new WsrmSequenceInfoImpl(sequence);
            return wsrmSequenceInfoImpl.createCompositeData();
        }
        catch (Exception exception) {
            throw new ManagementException(exception.toString(), (Throwable)exception);
        }
    }

    private Sequence getSequence(String string) throws UnknownSourceSequenceException, UnknownDestinationSequenceException {
        DestinationSequence destinationSequence;
        Sequence sequence = null;
        SourceSequence sourceSequence = SourceSequenceManager.getInstance().getSequence(WsrmConstants.RMVersion.RM_11, string, true);
        if (!(sourceSequence != null && sourceSequence.getId().equals(string) || (destinationSequence = DestinationSequenceManager.getInstance().getSequence(WsrmConstants.RMVersion.RM_11, string, true)) == null)) {
            sequence = destinationSequence;
        }
        if (sequence == null) {
            sequence = sourceSequence;
        }
        return sequence;
    }

    public static class WsrmRequestInfoImpl
    implements WsrmRequestInfo,
    WseeCompositeDataFactory.WseeCompositable {
        private static final long serialVersionUID = 1L;
        private static WseeCompositeDataFactory _factory;
        private String _messageId;
        private long _seqNum;
        private String _soapAction;
        private long _timestamp;
        private boolean _ackFlag;
        private String _responseMessageId;
        private long _responseTimestamp;

        public WsrmRequestInfoImpl() {
        }

        public WsrmRequestInfoImpl(Sequence sequence, MessageInfo messageInfo) {
            this.initTransients();
            this._messageId = messageInfo.getMessageId();
            this._seqNum = messageInfo.getMessageNum();
            this._soapAction = messageInfo.getSOAPAction();
            this._timestamp = messageInfo.getTimestamp();
            this._ackFlag = messageInfo.isAck();
            if (sequence instanceof SourceOfferSequence) {
                this._responseMessageId = null;
                this._responseTimestamp = 0L;
            } else if (sequence instanceof SourceSequence) {
                DestinationOfferSequence destinationOfferSequence = ((SourceSequence)sequence).getOffer();
                long l = ((SourceMessageInfo)messageInfo).getResponseMessageNum();
                if (l > 0L && destinationOfferSequence != null) {
                    this._responseMessageId = ((DestinationMessageInfo)destinationOfferSequence.getRequest(l)).getMessageId();
                    this._responseTimestamp = ((DestinationMessageInfo)destinationOfferSequence.getRequest(l)).getTimestamp();
                } else {
                    this._responseMessageId = null;
                    this._responseTimestamp = 0L;
                }
            } else if (sequence instanceof DestinationOfferSequence) {
                this._responseMessageId = null;
            } else if (sequence instanceof DestinationSequence) {
                SourceOfferSequence sourceOfferSequence = ((DestinationSequence)sequence).getOffer();
                long l = ((DestinationMessageInfo)messageInfo).getResponseMsgNum();
                if (l > 0L && sourceOfferSequence != null) {
                    this._responseMessageId = ((SourceMessageInfo)sourceOfferSequence.getRequest(l)).getMessageId();
                    this._responseTimestamp = ((SourceMessageInfo)sourceOfferSequence.getRequest(l)).getTimestamp();
                } else {
                    this._responseMessageId = null;
                    this._responseTimestamp = 0L;
                }
            }
        }

        public WsrmRequestInfoImpl(WsrmRequestInfoImpl wsrmRequestInfoImpl) {
            this.initTransients();
            this._messageId = wsrmRequestInfoImpl._messageId;
            this._seqNum = wsrmRequestInfoImpl._seqNum;
            this._soapAction = wsrmRequestInfoImpl._soapAction;
            this._timestamp = wsrmRequestInfoImpl._timestamp;
            this._ackFlag = wsrmRequestInfoImpl._ackFlag;
            this._responseMessageId = wsrmRequestInfoImpl._responseMessageId;
            this._responseTimestamp = wsrmRequestInfoImpl._responseTimestamp;
        }

        private void initTransients() {
        }

        public CompositeData createCompositeData() throws OpenDataException {
            return _factory.createCompositeData(this);
        }

        public String getMessageId() {
            return this._messageId;
        }

        public long getSeqNum() {
            return this._seqNum;
        }

        public void setSeqNum(int n) {
            this._seqNum = n;
        }

        public String getSoapAction() {
            return this._soapAction;
        }

        public void setSoapAction(String string) {
            this._soapAction = string;
        }

        public long getTimestamp() {
            return this._timestamp;
        }

        public void setTimestamp(long l) {
            this._timestamp = l;
        }

        public boolean isAckFlag() {
            return this._ackFlag;
        }

        public void setAckFlag(boolean bl) {
            this._ackFlag = bl;
        }

        public String getResponseMessageId() {
            return this._responseMessageId;
        }

        public void setResponseMessageId(String string) {
            this._responseMessageId = string;
        }

        public long getResponseTimestamp() {
            return this._responseTimestamp;
        }

        public void setResponseTimestamp(long l) {
            this._responseTimestamp = l;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            this.initTransients();
            objectInputStream.defaultReadObject();
        }

        static {
            try {
                _factory = new WseeCompositeDataFactory(WsrmRequestInfo.class);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.toString(), exception);
            }
        }
    }

    public static class WsrmSequenceInfoImpl
    implements WsrmSequenceInfo,
    WseeCompositeDataFactory.WseeCompositable {
        private static final long serialVersionUID = 1L;
        private static WseeCompositeDataFactory _factory;
        private String _id;
        private String _logicalStoreName;
        private String _physicalStoreName;
        private boolean _isSource;
        private String _destinationId;
        private boolean _isOffer;
        private String _mainSequenceId;
        private String _state;
        private long _creationTime;
        private long _lastActivityTime;
        private long _maxAge;
        private long _lastAckdMsgNum;
        private long _unackdCount;
        private Map<String, WsrmRequestInfoImpl> _requestInfoList;

        public WsrmSequenceInfoImpl() {
        }

        public WsrmSequenceInfoImpl(Sequence sequence) {
            Object object;
            this.initTransients();
            this._id = sequence.getId();
            this._logicalStoreName = sequence.getLogicalStoreName();
            this._physicalStoreName = sequence.getPhysicalStoreName();
            this._isSource = sequence instanceof SourceSequence;
            if (sequence instanceof OfferSequence) {
                this._isOffer = true;
                object = ((OfferSequence)((Object)sequence)).getMainSequence();
                String string = this._mainSequenceId = object != null ? ((Sequence)object).getId() : null;
            }
            if (this._isSource && !this._isOffer && sequence instanceof SourceSequence) {
                this._destinationId = ((SourceSequence)sequence).getDestinationId();
            }
            this._state = sequence.getState().name();
            this._creationTime = sequence.getTimestamp();
            this._lastActivityTime = sequence.getLastActivityTime();
            this._maxAge = sequence.getExpires() != null ? sequence.getTimestamp() + sequence.getExpires().getTimeInMillis(new Date()) : 0L;
            object = sequence.getRequests();
            this._lastAckdMsgNum = 0L;
            for (Object object2 : object.keySet()) {
                MessageInfo messageInfo = (MessageInfo)object.get(object2);
                if (!messageInfo.isAck() || messageInfo.getMessageNum() <= this._lastAckdMsgNum) continue;
                this._lastAckdMsgNum = messageInfo.getMessageNum();
            }
            this._unackdCount = sequence.getUnackdCount();
            this._requestInfoList = new HashMap<String, WsrmRequestInfoImpl>();
            Map map = sequence.getRequests();
            for (MessageInfo messageInfo : map.values()) {
                this._requestInfoList.put(messageInfo.getMessageId(), new WsrmRequestInfoImpl(sequence, messageInfo));
            }
        }

        public WsrmSequenceInfoImpl(WsrmSequenceInfoImpl wsrmSequenceInfoImpl) {
            this.initTransients();
            this._id = wsrmSequenceInfoImpl._id;
            this._logicalStoreName = wsrmSequenceInfoImpl._logicalStoreName;
            this._physicalStoreName = wsrmSequenceInfoImpl._physicalStoreName;
            this._isSource = wsrmSequenceInfoImpl._isSource;
            this._destinationId = wsrmSequenceInfoImpl._destinationId;
            this._isOffer = wsrmSequenceInfoImpl._isOffer;
            this._mainSequenceId = wsrmSequenceInfoImpl._mainSequenceId;
            this._state = wsrmSequenceInfoImpl._state;
            this._creationTime = wsrmSequenceInfoImpl._creationTime;
            this._lastActivityTime = wsrmSequenceInfoImpl._lastActivityTime;
            this._maxAge = wsrmSequenceInfoImpl._maxAge;
            this._lastAckdMsgNum = wsrmSequenceInfoImpl._lastAckdMsgNum;
            this._unackdCount = wsrmSequenceInfoImpl._unackdCount;
            this._requestInfoList = new HashMap<String, WsrmRequestInfoImpl>(wsrmSequenceInfoImpl._requestInfoList.size());
            for (String string : wsrmSequenceInfoImpl._requestInfoList.keySet()) {
                WsrmRequestInfoImpl wsrmRequestInfoImpl = wsrmSequenceInfoImpl._requestInfoList.get(string);
                WsrmRequestInfoImpl wsrmRequestInfoImpl2 = new WsrmRequestInfoImpl(wsrmRequestInfoImpl);
                this._requestInfoList.put(string, wsrmRequestInfoImpl2);
            }
        }

        private void initTransients() {
        }

        public CompositeData createCompositeData() throws OpenDataException {
            return _factory.createCompositeData(this);
        }

        public String getId() {
            return this._id;
        }

        public String getLogicalStoreName() {
            return this._logicalStoreName;
        }

        public String getPhysicalStoreName() {
            return this._physicalStoreName;
        }

        public boolean isSource() {
            return this._isSource;
        }

        public String getDestinationId() {
            return this._destinationId;
        }

        public boolean isOffer() {
            return this._isOffer;
        }

        public String getMainSequenceId() {
            return this._mainSequenceId;
        }

        public String getState() {
            return this._state;
        }

        public long getCreationTime() {
            return this._creationTime;
        }

        public long getLastActivityTime() {
            return this._lastActivityTime;
        }

        public long getMaxAge() {
            return this._maxAge;
        }

        public long getLastAckdMessageNum() {
            return this._lastAckdMsgNum;
        }

        public long getUnackdCount() {
            return this._unackdCount;
        }

        public WsrmRequestInfo[] getRequests() throws ManagementException {
            return this._requestInfoList.values().toArray(new WsrmRequestInfo[this._requestInfoList.size()]);
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            this.initTransients();
            objectInputStream.defaultReadObject();
        }

        static {
            try {
                _factory = new WseeCompositeDataFactory(WsrmSequenceInfo.class);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.toString(), exception);
            }
        }
    }
}

