/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.mtom.internal;

import com.bea.xml.XmlException;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Node;
import weblogic.wsee.util.MtomUtil;
import weblogic.xml.dom.DOMUtils;
import weblogic.xml.saaj.SOAPMessageImpl;

public abstract class MtomXopHandler
extends GenericHandler {
    public static final String VERBOSE_PROPERTY = "weblogic.wsee.mtom.internal.MtomXopHandler";
    public static final boolean VERBOSE = Boolean.getBoolean("weblogic.wsee.mtom.internal.MtomXopHandler");
    private static final QName ENCRYPTED_DATA_QNAME = new QName("http://www.w3.org/2001/04/xmlenc#", "EncryptedData");

    public QName[] getHeaders() {
        return null;
    }

    protected void processXOP(SOAPMessageContext sOAPMessageContext) throws Exception {
        Node node;
        SOAPEnvelope sOAPEnvelope;
        int n;
        SOAPMessage sOAPMessage = sOAPMessageContext.getMessage();
        Set set = (Set)sOAPMessageContext.getProperty("weblogic.wsee.xop.normal.set");
        Object object = sOAPMessageContext.getProperty("weblogic.wsee.mtom.threshold");
        int n2 = n = object == null ? 0 : (Integer)object;
        if (set != null) {
            sOAPEnvelope = set.iterator();
            while (sOAPEnvelope.hasNext()) {
                node = (Node)sOAPEnvelope.next();
                if (node.getTextContent() == null || MtomUtil.calculateRawBytesLength(node.getTextContent().length()) <= n || !MtomUtil.isValidNode((Node)sOAPMessage.getSOAPPart().getEnvelope(), node)) continue;
                MtomUtil.replaceContentWithIncludeElement(sOAPMessage, (SOAPElement)node);
            }
            set.clear();
            sOAPMessageContext.setProperty("weblogic.wsee.xop.normal.set", null);
        }
        if ("encrypt".equals(sOAPMessageContext.getProperty("weblogic.wsee.xop.normal")) && sOAPMessage.getSOAPPart() != null && (sOAPEnvelope = sOAPMessage.getSOAPPart().getEnvelope()) != null) {
            Object object2;
            Iterator iterator;
            node = sOAPEnvelope.getBody();
            if (node != null) {
                iterator = node.getChildElements();
                while (iterator.hasNext() && (object2 = (Node)iterator.next()).getNodeType() != 3) {
                    this.process(sOAPMessage, (SOAPElement)object2, n);
                }
            }
            if ((iterator = sOAPEnvelope.getHeader()) != null) {
                Node node2;
                object2 = iterator.getChildElements();
                while (object2.hasNext() && (node2 = (Node)object2.next()).getNodeType() != 3) {
                    this.process(sOAPMessage, (SOAPElement)node2, n);
                }
            }
        }
    }

    private void process(SOAPMessage sOAPMessage, SOAPElement sOAPElement, int n) throws XmlException {
        if (DOMUtils.equalsQName((Node)sOAPElement, ENCRYPTED_DATA_QNAME)) {
            SOAPElement sOAPElement2 = MtomUtil.getCipherValueFromEncryptedData(sOAPElement);
            if (sOAPElement2 == null || sOAPElement2.getTextContent() == null || MtomUtil.calculateRawBytesLength(sOAPElement2.getTextContent().length()) < n) {
                return;
            }
            MtomUtil.replaceContentWithIncludeElement(sOAPMessage, sOAPElement2);
        } else {
            Node node;
            Iterator iterator = sOAPElement.getChildElements();
            while (iterator.hasNext() && (node = (Node)iterator.next()).getNodeType() != 3) {
                this.process(sOAPMessage, (SOAPElement)node, n);
            }
        }
    }

    protected boolean isMtomEnable(SOAPMessageContext sOAPMessageContext) {
        boolean bl = false;
        SOAPMessage sOAPMessage = sOAPMessageContext.getMessage();
        if (sOAPMessageContext.getProperty("weblogic.wsee.mtom.enable") != null) {
            bl = true;
        } else if (sOAPMessage instanceof SOAPMessageImpl) {
            bl = ((SOAPMessageImpl)sOAPMessage).getIsMTOMmessage();
        }
        return bl;
    }
}

