/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.persistence;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import weblogic.wsee.persistence.AbstractStorable;

public abstract class AbstractExpirable
extends AbstractStorable {
    private static final long serialVersionUID = 1L;
    protected transient String _serialFormVersion = "10.3.6";
    private String _maxLifetime;
    private String _idleTimeout;
    private transient Duration _maxLifetimeDuration;
    private transient Duration _idleTimeoutDuration;

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this._serialFormVersion);
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this._serialFormVersion = (String)objectInputStream.readObject();
        objectInputStream.defaultReadObject();
        this.initTransients();
    }

    public AbstractExpirable(Serializable serializable, long l, long l2) {
        this(serializable, AbstractExpirable.parseDuration(l).toString(), AbstractExpirable.parseDuration(l2).toString());
    }

    public AbstractExpirable(Serializable serializable, String string, String string2) {
        super(serializable);
        this._maxLifetime = string;
        this._idleTimeout = string2;
        this.initTransients();
    }

    protected void initTransients() {
        if (this._maxLifetime != null) {
            this._maxLifetimeDuration = AbstractExpirable.parseDuration(this._maxLifetime);
        }
        if (this._idleTimeout != null) {
            this._idleTimeoutDuration = AbstractExpirable.parseDuration(this._idleTimeout);
        }
    }

    public Duration getMaxLifetimeDuration() {
        return this._maxLifetimeDuration;
    }

    public Duration getIdleTimeoutDuration() {
        return this._idleTimeoutDuration;
    }

    protected void setMaxLifetime(String string) {
        this._maxLifetimeDuration = AbstractExpirable.parseDuration(string);
        this._maxLifetime = string;
    }

    protected void setIdleTimeout(String string) {
        this._idleTimeoutDuration = AbstractExpirable.parseDuration(string);
        this._idleTimeout = string;
    }

    public boolean hasExplicitExpiration() {
        return this._maxLifetime != null || this._idleTimeout != null;
    }

    public boolean isExpired() {
        return this._maxLifetime != null && this._maxLifetimeDuration.getTimeInMillis(new Date(this.getCreationTime())) + this.getCreationTime() < System.currentTimeMillis() || this._idleTimeout != null && this._idleTimeoutDuration.getTimeInMillis(new Date(this.getLastUpdatedTime())) + this.getLastUpdatedTime() < System.currentTimeMillis();
    }

    private static Duration parseDuration(String string) {
        try {
            return DatatypeFactory.newInstance().newDuration(string);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString(), exception);
        }
    }

    private static Duration parseDuration(long l) {
        try {
            return DatatypeFactory.newInstance().newDuration(l);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString(), exception);
        }
    }
}

