/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.persistence;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import weblogic.wsee.Version;
import weblogic.wsee.persistence.Storable;

public abstract class AbstractStorable
implements Storable {
    private static final long serialVersionUID = 1L;
    private Serializable _id;
    private long _creationTimestamp;
    private long _lastUpdateTimestamp;
    protected transient String _serialFormVersion = "10.3.6";
    private transient String _physicalStoreName;

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this._serialFormVersion);
        objectOutputStream.writeObject(this._id);
        objectOutputStream.writeLong(this._creationTimestamp);
        objectOutputStream.writeLong(this._lastUpdateTimestamp);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this._serialFormVersion = (String)objectInputStream.readObject();
        this._id = (Serializable)objectInputStream.readObject();
        if (Version.isLaterThanOrEqualTo(this._serialFormVersion, "10.3.6")) {
            this._creationTimestamp = objectInputStream.readLong();
            this._lastUpdateTimestamp = objectInputStream.readLong();
        }
    }

    public AbstractStorable(Serializable serializable) {
        this._id = serializable;
        this._creationTimestamp = System.currentTimeMillis();
    }

    public Serializable getObjectId() {
        return this._id;
    }

    public boolean hasExplicitExpiration() {
        return false;
    }

    public boolean isExpired() {
        return false;
    }

    public String getPhysicalStoreName() {
        return this._physicalStoreName;
    }

    public void setPhysicalStoreName(String string) {
        this._physicalStoreName = string;
    }

    public Long getCreationTime() {
        return this._creationTimestamp;
    }

    public Long getLastUpdatedTime() {
        return this._lastUpdateTimestamp;
    }

    protected void setCreationTime(long l) {
        this._creationTimestamp = l;
    }

    public void touch() {
        this._lastUpdateTimestamp = System.currentTimeMillis();
    }

    protected void setLastUpdatedTime(long l) {
        this._lastUpdateTimestamp = l;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this._id);
        return stringBuffer.toString();
    }
}

