/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.persistence;

import java.io.Serializable;
import java.security.AccessController;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.wsee.persistence.Storable;
import weblogic.wsee.persistence.ValuesMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryValuesMap<K extends Serializable, V extends Storable>
extends ValuesMap<K, V> {
    private static final Logger LOGGER = Logger.getLogger(InMemoryValuesMap.class.getName());
    public static final String PHYSICAL_STORE_PREFIX = "WseeInMemoryPhysicalStore-";
    public static final String PHYSICAL_STORE_NAME;
    private Map<K, V> _valuesMap;
    private final ReentrantReadWriteLock _valueLock = new ReentrantReadWriteLock(false);

    public InMemoryValuesMap(String string) {
        super(string);
        this._valuesMap = new HashMap();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(" == Store Created for " + this);
        }
    }

    public String toString() {
        return "storeName = " + this.getStoreName() + " connectionName = " + this._connectionName;
    }

    @Override
    public String getStoreName() {
        return PHYSICAL_STORE_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        try {
            this._valueLock.readLock().lock();
            int n = this._valuesMap.size();
            Object var3_2 = null;
            this._valueLock.readLock().unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._valueLock.readLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        try {
            this._valueLock.readLock().lock();
            boolean bl = this._valuesMap.isEmpty();
            Object var3_2 = null;
            this._valueLock.readLock().unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._valueLock.readLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object object) {
        try {
            this._valueLock.readLock().lock();
            boolean bl = this._valuesMap.containsKey(object);
            Object var4_3 = null;
            this._valueLock.readLock().unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this._valueLock.readLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object object) {
        try {
            this._valueLock.readLock().lock();
            boolean bl = this._valuesMap.containsValue(object);
            Object var4_3 = null;
            this._valueLock.readLock().unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this._valueLock.readLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object object) {
        Storable storable;
        try {
            this._valueLock.readLock().lock();
            storable = (Storable)this._valuesMap.get(object);
            Object var4_3 = null;
            this._valueLock.readLock().unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this._valueLock.readLock().unlock();
            throw throwable;
        }
        return (V)storable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K k, V v) {
        Storable storable;
        try {
            this._valueLock.writeLock().lock();
            storable = (Storable)this._valuesMap.put(k, v);
            Object var5_4 = null;
            this._valueLock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this._valueLock.writeLock().unlock();
            throw throwable;
        }
        return (V)storable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object object) {
        Storable storable;
        try {
            this._valueLock.writeLock().lock();
            storable = (Storable)this._valuesMap.remove(object);
            Object var4_3 = null;
            this._valueLock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this._valueLock.writeLock().unlock();
            throw throwable;
        }
        return (V)storable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        try {
            this._valueLock.writeLock().lock();
            this._valuesMap.putAll(map);
            Object var3_2 = null;
            this._valueLock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._valueLock.writeLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        try {
            this._valueLock.writeLock().lock();
            this._valuesMap.clear();
            Object var2_1 = null;
            this._valueLock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this._valueLock.writeLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<K> keySet() {
        try {
            this._valueLock.readLock().lock();
            Set<K> set = this._valuesMap.keySet();
            Object var3_2 = null;
            this._valueLock.readLock().unlock();
            return set;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._valueLock.readLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<V> values() {
        try {
            this._valueLock.readLock().lock();
            Collection<V> collection = this._valuesMap.values();
            Object var3_2 = null;
            this._valueLock.readLock().unlock();
            return collection;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._valueLock.readLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        try {
            this._valueLock.readLock().lock();
            Set<Map.Entry<K, V>> set = this._valuesMap.entrySet();
            Object var3_2 = null;
            this._valueLock.readLock().unlock();
            return set;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._valueLock.readLock().unlock();
            throw throwable;
        }
    }

    static {
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(authenticatedSubject);
        PHYSICAL_STORE_NAME = runtimeAccess != null ? PHYSICAL_STORE_PREFIX + runtimeAccess.getServerName() : PHYSICAL_STORE_PREFIX;
    }
}

