/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.persistence;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.common.CompletionRequest;
import weblogic.store.PersistentHandle;
import weblogic.store.PersistentStore;
import weblogic.store.PersistentStoreConnection;
import weblogic.store.PersistentStoreException;
import weblogic.store.PersistentStoreRecord;
import weblogic.store.PersistentStoreTransaction;
import weblogic.wsee.WseePersistLogger;
import weblogic.wsee.persistence.Storable;
import weblogic.wsee.persistence.StoreException;
import weblogic.wsee.persistence.StoreRecord;
import weblogic.wsee.persistence.StoreRuntimeException;
import weblogic.wsee.persistence.WLSStoreValuesMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalWLSStoreValuesMap<K extends Serializable, V extends Storable>
extends WLSStoreValuesMap<K, V> {
    private static final Logger LOGGER = Logger.getLogger(LocalWLSStoreValuesMap.class.getName());
    private Map<K, PersistentHandle> _storeHandles;
    private Map<K, V> _valuesMap;
    private final ReentrantReadWriteLock _valueLock = new ReentrantReadWriteLock(false);
    private PersistentStoreConnection _storeConnection;
    private boolean _recovered;
    private static final int NO_FLAGS = 0;

    public LocalWLSStoreValuesMap(PersistentStore persistentStore, String string) throws StoreException {
        super(persistentStore, string);
        this.open();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(" == Store Created for " + this);
        }
    }

    public String toString() {
        return "storeName = " + this.getStoreName() + " connectionName = " + this._connectionName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void open() throws StoreException {
        this._storeHandles = null;
        this._valuesMap = null;
        try {
            this._storeHandles = new HashMap<K, PersistentHandle>();
            this._valuesMap = new HashMap();
            this._storeConnection = this._store.createConnection(this._connectionName);
        }
        catch (PersistentStoreException persistentStoreException) {
            throw new StoreException(persistentStoreException.toString(), persistentStoreException);
        }
        StoreRecord storeRecord = this.recover();
        try {
            this._valueLock.writeLock().lock();
            while (storeRecord != null) {
                StoreRecord storeRecord2;
                block8: {
                    Storable storable;
                    storeRecord2 = storeRecord.getNext();
                    storeRecord.setNext(null);
                    try {
                        storable = (Storable)storeRecord.getStoreObject();
                    }
                    catch (PersistentStoreException persistentStoreException) {
                        WseePersistLogger.logUnexpectedException((String)persistentStoreException.toString(), (Throwable)persistentStoreException);
                        break block8;
                    }
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("*********** ***** <StoreRecord> state= class=" + storable.getClass().getName() + " obj=" + storable);
                    }
                    this.recoverValue(storable);
                    this._storeHandles.put(storable.getObjectId(), storeRecord.getHandle());
                }
                storeRecord = storeRecord2;
            }
            Object var6_6 = null;
            this._valueLock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this._valueLock.writeLock().unlock();
            throw throwable;
        }
    }

    protected void recoverValue(V v) {
        this._valuesMap.put(v.getObjectId(), v);
    }

    private StoreRecord recover() throws StoreException {
        if (this._recovered) {
            return null;
        }
        this._recovered = true;
        StoreRecord storeRecord = null;
        StoreRecord storeRecord2 = null;
        try {
            PersistentStoreRecord persistentStoreRecord;
            PersistentStoreConnection.Cursor cursor = this._storeConnection.createCursor(0);
            while ((persistentStoreRecord = cursor.next()) != null) {
                StoreRecord storeRecord3 = new StoreRecord(persistentStoreRecord);
                if (storeRecord2 == null) {
                    storeRecord = storeRecord2 = storeRecord3;
                    continue;
                }
                storeRecord2.setNext(storeRecord3);
                storeRecord2 = storeRecord3;
            }
        }
        catch (PersistentStoreException persistentStoreException) {
            StoreException storeException = new StoreException(persistentStoreException.toString(), persistentStoreException);
            throw storeException;
        }
        return storeRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws StoreException {
        try {
            this._valueLock.writeLock().lock();
            this._valuesMap.clear();
            this._storeHandles.clear();
            Object var2_1 = null;
            this._valueLock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this._valueLock.writeLock().unlock();
            throw throwable;
        }
        if (this._storeConnection != null) {
            this._storeConnection.close();
        }
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clean() throws StoreException {
        try {
            this._valueLock.writeLock().lock();
            for (PersistentHandle persistentHandle : this._storeHandles.values()) {
                this.delete(persistentHandle);
            }
            Object var4_3 = null;
            this._valueLock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this._valueLock.writeLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWhileLocked(Runnable runnable, boolean bl) {
        try {
            if (bl) {
                this._valueLock.readLock().lock();
            } else {
                this._valueLock.writeLock().lock();
            }
            runnable.run();
            Object var4_3 = null;
            if (bl) {
                this._valueLock.readLock().unlock();
            } else {
                this._valueLock.writeLock().unlock();
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (bl) {
                this._valueLock.readLock().unlock();
            } else {
                this._valueLock.writeLock().unlock();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<K> keySet() {
        try {
            this._valueLock.readLock().lock();
            TreeSet<K> treeSet = new TreeSet<K>(this._valuesMap.keySet());
            Object var3_2 = null;
            this._valueLock.readLock().unlock();
            return treeSet;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._valueLock.readLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<V> values() {
        try {
            this._valueLock.readLock().lock();
            LinkedList<V> linkedList = new LinkedList<V>();
            for (Serializable serializable : this._valuesMap.keySet()) {
                linkedList.add(this._valuesMap.get(serializable));
            }
            LinkedList<V> linkedList2 = linkedList;
            Object var5_4 = null;
            this._valueLock.readLock().unlock();
            return linkedList2;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this._valueLock.readLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        try {
            this._valueLock.readLock().lock();
            HashSet<Map.Entry<K, V>> hashSet = new HashSet<Map.Entry<K, V>>(this._valuesMap.entrySet());
            Object var3_2 = null;
            this._valueLock.readLock().unlock();
            return hashSet;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._valueLock.readLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object object) {
        try {
            this._valueLock.readLock().lock();
            boolean bl = this._valuesMap.containsKey(object);
            Object var4_3 = null;
            this._valueLock.readLock().unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this._valueLock.readLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object object) {
        try {
            this._valueLock.readLock().lock();
            boolean bl = this._valuesMap.containsValue(object);
            Object var4_3 = null;
            this._valueLock.readLock().unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this._valueLock.readLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        try {
            this._valueLock.readLock().lock();
            boolean bl = this._valuesMap.isEmpty();
            Object var3_2 = null;
            this._valueLock.readLock().unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._valueLock.readLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        try {
            this._valueLock.readLock().lock();
            int n = this._valuesMap.size();
            Object var3_2 = null;
            this._valueLock.readLock().unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._valueLock.readLock().unlock();
            throw throwable;
        }
    }

    @Override
    public V put(K k, V v) throws StoreRuntimeException {
        Object object;
        try {
            this._valueLock.writeLock().lock();
            Object object2 = null;
            if (!this._valuesMap.containsKey(k)) {
                PersistentHandle persistentHandle = this.storeSync(v);
                this._valuesMap.put(k, v);
                this._storeHandles.put(k, persistentHandle);
            } else {
                object2 = this.get(k);
                PersistentHandle persistentHandle = this._storeHandles.get(k);
                this.updateSync(persistentHandle, v);
            }
            object = object2;
            Object var7_8 = null;
        }
        catch (StoreRuntimeException storeRuntimeException) {
            try {
                WseePersistLogger.logUnexpectedException((String)storeRuntimeException.toString(), (Throwable)storeRuntimeException);
                throw storeRuntimeException;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                this._valueLock.writeLock().unlock();
                throw throwable;
            }
        }
        this._valueLock.writeLock().unlock();
        return (V)object;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) throws StoreRuntimeException {
        try {
            for (Serializable serializable : map.keySet()) {
                Storable storable = (Storable)map.get(serializable);
                this.put((K)serializable, (V)storable);
            }
        }
        catch (StoreRuntimeException storeRuntimeException) {
            WseePersistLogger.logUnexpectedException((String)storeRuntimeException.toString(), (Throwable)storeRuntimeException);
            throw storeRuntimeException;
        }
    }

    @Override
    public void clear() throws StoreRuntimeException {
        try {
            HashSet<K> hashSet = new HashSet<K>(this.keySet());
            for (Serializable serializable : hashSet) {
                this.remove(serializable);
            }
        }
        catch (StoreRuntimeException storeRuntimeException) {
            WseePersistLogger.logUnexpectedException((String)storeRuntimeException.toString(), (Throwable)storeRuntimeException);
            throw storeRuntimeException;
        }
    }

    @Override
    public V get(Object object) throws StoreRuntimeException {
        Storable storable;
        try {
            this._valueLock.readLock().lock();
            storable = (Storable)this._valuesMap.get(object);
            Object var4_4 = null;
        }
        catch (StoreRuntimeException storeRuntimeException) {
            try {
                WseePersistLogger.logUnexpectedException((String)storeRuntimeException.toString(), (Throwable)storeRuntimeException);
                throw storeRuntimeException;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this._valueLock.readLock().unlock();
                throw throwable;
            }
        }
        this._valueLock.readLock().unlock();
        return (V)storable;
    }

    @Override
    public V remove(Object object) throws StoreRuntimeException {
        V v;
        block5: {
            this._valueLock.writeLock().lock();
            if (!this._valuesMap.containsKey(object)) break block5;
            Storable storable = (Storable)this._valuesMap.remove(object);
            this.delete(this._storeHandles.remove(object));
            Storable storable2 = storable;
            Object var5_6 = null;
            this._valueLock.writeLock().unlock();
            return (V)storable2;
        }
        try {
            v = null;
            Object var5_7 = null;
        }
        catch (StoreRuntimeException storeRuntimeException) {
            try {
                WseePersistLogger.logUnexpectedException((String)storeRuntimeException.toString(), (Throwable)storeRuntimeException);
                throw storeRuntimeException;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                this._valueLock.writeLock().unlock();
                throw throwable;
            }
        }
        this._valueLock.writeLock().unlock();
        return v;
    }

    private PersistentHandle storeInternal(Object object, CompletionRequest completionRequest) {
        PersistentStoreTransaction persistentStoreTransaction = this._store.begin();
        PersistentHandle persistentHandle = this._storeConnection.create(persistentStoreTransaction, object, 0);
        persistentStoreTransaction.commit(completionRequest);
        return persistentHandle;
    }

    private void updateInternal(PersistentHandle persistentHandle, Object object, CompletionRequest completionRequest) {
        PersistentStoreTransaction persistentStoreTransaction = this._store.begin();
        this._storeConnection.update(persistentStoreTransaction, persistentHandle, object, 0);
        persistentStoreTransaction.commit(completionRequest);
    }

    private PersistentHandle storeSync(Object object) throws StoreRuntimeException {
        CompletionRequest completionRequest = new CompletionRequest();
        PersistentHandle persistentHandle = this.storeInternal(object, completionRequest);
        try {
            completionRequest.getResult();
        }
        catch (Throwable throwable) {
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new StoreRuntimeException(throwable.toString(), throwable);
        }
        return persistentHandle;
    }

    private void updateSync(PersistentHandle persistentHandle, Object object) throws StoreRuntimeException {
        CompletionRequest completionRequest = new CompletionRequest();
        this.updateInternal(persistentHandle, object, completionRequest);
        try {
            completionRequest.getResult();
        }
        catch (Throwable throwable) {
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new StoreRuntimeException(throwable.toString(), throwable);
        }
    }

    private void delete(PersistentHandle persistentHandle) throws StoreRuntimeException {
        PersistentStoreTransaction persistentStoreTransaction = this._store.begin();
        this._storeConnection.delete(persistentStoreTransaction, persistentHandle, 0);
        try {
            persistentStoreTransaction.commit();
        }
        catch (PersistentStoreException persistentStoreException) {
            throw new StoreRuntimeException(persistentStoreException.toString(), persistentStoreException);
        }
    }
}

