/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.persistence;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import weblogic.kernel.KernelStatus;
import weblogic.management.configuration.WebServiceLogicalStoreMBean;
import weblogic.store.PersistentStore;
import weblogic.store.PersistentStoreManager;
import weblogic.store.xa.PersistentStoreXA;
import weblogic.wsee.WseePersistLogger;
import weblogic.wsee.jaxws.framework.ConfigUtil;
import weblogic.wsee.persistence.InMemoryValuesMap;
import weblogic.wsee.persistence.LogicalStoreListChangeListener;
import weblogic.wsee.persistence.Storable;
import weblogic.wsee.persistence.StoreConnection;
import weblogic.wsee.persistence.StoreException;
import weblogic.wsee.runtime.WebServicesRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogicalStore<K extends Serializable, V extends Storable>
implements Map<K, V> {
    private static boolean _closeAllCalledExplicitly = false;
    private static final Logger LOGGER;
    private static final Map<String, LogicalStore> _storeMap;
    private static final Map<String, List<LogicalStore>> _storeNameToStoreMap;
    private static final ReentrantReadWriteLock _storeMapLock;
    private static final List<LogicalStoreListChangeListener> _listeners;
    public static final String LOGICAL_STORE_LIST = "LogicalStoreList";
    private String _name;
    private String _connectionName;
    private PersistenceStrategy _persistStrategy;
    private long _maxObjectLifetimeMillis;
    private long _cleanerIntervalMillis;
    private ReentrantReadWriteLock _storeConnListLock = new ReentrantReadWriteLock(false);
    private List<StoreConnection<K, V>> _storeConnList;
    private int _lastUsedStoreConnIndex;
    private final String _lastUsedStoreConnIndexMonitor = "_lastUsedStoreConnIndexMonitor";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean storeExists(String string, String string2) {
        try {
            _storeMapLock.readLock().lock();
            boolean bl = _storeMap.containsKey(string + string2);
            return bl;
        }
        finally {
            _storeMapLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addStore(String string) {
        LogicalStoreListChangeListener[] logicalStoreListChangeListenerArray;
        try {
            _storeMapLock.writeLock().lock();
            logicalStoreListChangeListenerArray = _storeNameToStoreMap.get(string);
            if (logicalStoreListChangeListenerArray != null) {
                boolean bl = false;
                return bl;
            }
            logicalStoreListChangeListenerArray = new ArrayList<LogicalStore>();
            _storeNameToStoreMap.put(string, (List<LogicalStore>)logicalStoreListChangeListenerArray);
        }
        finally {
            _storeMapLock.writeLock().unlock();
        }
        for (LogicalStoreListChangeListener logicalStoreListChangeListener : logicalStoreListChangeListenerArray = _listeners.toArray(new LogicalStoreListChangeListener[_listeners.size()])) {
            try {
                logicalStoreListChangeListener.logicalStoreAdded(string);
            }
            catch (Exception exception) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, exception.toString(), exception);
                }
                WseePersistLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean addStore(String string, String string2, LogicalStore logicalStore) {
        try {
            _storeMapLock.writeLock().lock();
            String string3 = string + string2;
            if (_storeMap.containsKey(string3)) {
                boolean bl = false;
                return bl;
            }
            _storeMap.put(string3, logicalStore);
            List<LogicalStore> list = _storeNameToStoreMap.get(string);
            if (list == null) {
                list = new ArrayList<LogicalStore>();
                _storeNameToStoreMap.put(string, list);
            }
            list.add(logicalStore);
        }
        finally {
            _storeMapLock.writeLock().unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogicalStore<? extends Serializable, ? extends Storable> getStore(String string, String string2) throws StoreException {
        try {
            _storeMapLock.readLock().lock();
            String string3 = string + string2;
            LogicalStore logicalStore = _storeMap.get(string3);
            return logicalStore;
        }
        finally {
            _storeMapLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeStore(String string) {
        boolean bl;
        LogicalStoreListChangeListener[] logicalStoreListChangeListenerArray;
        for (LogicalStoreListChangeListener logicalStoreListChangeListener : logicalStoreListChangeListenerArray = _listeners.toArray(new LogicalStoreListChangeListener[_listeners.size()])) {
            try {
                logicalStoreListChangeListener.logicalStorePreRemoval(string);
            }
            catch (Exception exception) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, exception.toString(), exception);
                }
                WseePersistLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
            }
        }
        try {
            _storeMapLock.writeLock().lock();
            LogicalStoreListChangeListener[] logicalStoreListChangeListenerArray2 = _storeNameToStoreMap.remove(string);
            boolean bl2 = bl = logicalStoreListChangeListenerArray2 != null;
            if (logicalStoreListChangeListenerArray2 != null) {
                LogicalStore.closeLogicalStores(logicalStoreListChangeListenerArray2, string);
            }
        }
        finally {
            _storeMapLock.writeLock().unlock();
        }
        for (LogicalStoreListChangeListener logicalStoreListChangeListener : logicalStoreListChangeListenerArray = _listeners.toArray(new LogicalStoreListChangeListener[_listeners.size()])) {
            try {
                logicalStoreListChangeListener.logicalStoreRemoved(string);
            }
            catch (Exception exception) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, exception.toString(), exception);
                }
                WseePersistLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAllStores() {
        try {
            _closeAllCalledExplicitly = true;
            _storeMapLock.writeLock().lock();
            Set<String> set = _storeNameToStoreMap.keySet();
            for (String string : set) {
                LogicalStore.closeStore(string);
            }
        }
        finally {
            _storeMapLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean closeStore(String string) {
        try {
            _storeMapLock.writeLock().lock();
            List<LogicalStore> list = _storeNameToStoreMap.get(string);
            if (list == null) {
                boolean bl = false;
                return bl;
            }
            LogicalStore.closeLogicalStores(list, string);
        }
        finally {
            _storeMapLock.writeLock().unlock();
        }
        return true;
    }

    private static void closeLogicalStores(List<LogicalStore> list, String string) {
        Iterator<LogicalStore> iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                LogicalStore logicalStore = iterator.next();
                _storeMap.remove(string + logicalStore.getConnectionName());
                logicalStore.close();
                iterator.remove();
            }
            catch (Exception exception) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, exception.toString(), exception);
                }
                WseePersistLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean closeStore(String string, String string2) throws StoreException {
        try {
            _storeMapLock.writeLock().lock();
            LogicalStore logicalStore = _storeMap.remove(string + string2);
            List<LogicalStore> list = _storeNameToStoreMap.get(string);
            if (list != null) {
                list.remove(logicalStore);
            }
            if (logicalStore != null) {
                logicalStore.close();
            }
            boolean bl = logicalStore != null;
            return bl;
        }
        finally {
            _storeMapLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<LogicalStore> getLogicalStores(String string) {
        try {
            _storeMapLock.readLock().lock();
            List<LogicalStore> list = _storeNameToStoreMap.get(string);
            list = list == null ? new ArrayList<LogicalStore>() : new ArrayList<LogicalStore>(list);
            List<LogicalStore> list2 = list;
            return list2;
        }
        finally {
            _storeMapLock.readLock().unlock();
        }
    }

    public static void addLogicalStoreListChangeListener(LogicalStoreListChangeListener logicalStoreListChangeListener) {
        if (!_listeners.contains(logicalStoreListChangeListener)) {
            _listeners.add(logicalStoreListChangeListener);
        }
    }

    public static void removeLogicalStoreListChangeListener(LogicalStoreListChangeListener logicalStoreListChangeListener) {
        if (_listeners.contains(logicalStoreListChangeListener)) {
            _listeners.remove(logicalStoreListChangeListener);
        }
    }

    protected LogicalStore() {
        this._storeConnList = new ArrayList<StoreConnection<K, V>>();
    }

    public LogicalStore(String string, String string2) throws StoreException {
        this(string, string2, true);
    }

    public LogicalStore(String string, String string2, boolean bl) throws StoreException {
        this._name = string;
        this._connectionName = string2;
        if (bl) {
            this.addAvailablePhysicalStores();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addAvailablePhysicalStores() throws StoreException {
        StoreInfo storeInfo = LogicalStore.getStoreInfo(this._name);
        this._persistStrategy = storeInfo.persistStrategy;
        this._maxObjectLifetimeMillis = storeInfo.maxObjectLifetimeMillis;
        this._cleanerIntervalMillis = storeInfo.cleanerIntervalMillis;
        try {
            this._storeConnListLock.writeLock().lock();
            this._storeConnList = new ArrayList<StoreConnection<K, V>>();
            this._lastUsedStoreConnIndex = -1;
            for (String string : storeInfo.physicalStoreNames) {
                String string2;
                if (PersistenceStrategy.IN_MEMORY != storeInfo.persistStrategy && !(string2 = this.preConnectStoreCheck(string)).equals(string)) {
                    string = string2;
                }
                this.addPhysicalStore(string);
                this.postConnectStoreCheck();
            }
        }
        finally {
            this._storeConnListLock.writeLock().unlock();
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(" == LogicalStore Created for " + this._name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LogicalStore<K, V> getOrCreateLogicalStore(String string, String string2) throws StoreException {
        try {
            _storeMapLock.writeLock().lock();
            if (LogicalStore.storeExists(string, string2)) {
                LogicalStore<Serializable, Storable> logicalStore = LogicalStore.getStore(string, string2);
                return logicalStore;
            }
            LogicalStore<K, V> logicalStore = this.createLogicalStore(string, string2);
            LogicalStore.addStore(string, string2, logicalStore);
            LogicalStore<K, V> logicalStore2 = logicalStore;
            return logicalStore2;
        }
        finally {
            _storeMapLock.writeLock().unlock();
        }
    }

    private static StoreInfo getStoreInfo(String string) {
        Duration duration;
        Duration duration2;
        String string2;
        StoreInfo storeInfo = new StoreInfo();
        WebServiceLogicalStoreMBean webServiceLogicalStoreMBean = ConfigUtil.getLogicalStoreMBean(string);
        String string3 = webServiceLogicalStoreMBean.getPersistenceStrategy();
        if (string3 == null) {
            string3 = "LOCAL_ACCESS_ONLY";
        }
        if ((string2 = webServiceLogicalStoreMBean.getDefaultMaximumObjectLifetime()) == null) {
            string2 = "P1D";
        }
        try {
            duration2 = DatatypeFactory.newInstance().newDuration(string2);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString(), exception);
        }
        storeInfo.maxObjectLifetimeMillis = duration2.getTimeInMillis(new Date());
        String string4 = webServiceLogicalStoreMBean.getCleanerInterval();
        if (string4 == null) {
            string4 = "PT10M";
        }
        try {
            duration = DatatypeFactory.newInstance().newDuration(string4);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString(), exception);
        }
        storeInfo.cleanerIntervalMillis = duration.getTimeInMillis(new Date());
        if (storeInfo.cleanerIntervalMillis > storeInfo.maxObjectLifetimeMillis / 2L) {
            storeInfo.cleanerIntervalMillis = storeInfo.maxObjectLifetimeMillis / 2L;
        }
        storeInfo.physicalStoreNames = new ArrayList<String>();
        if (string3.equals("IN_MEMORY")) {
            storeInfo.physicalStoreNames.add(InMemoryValuesMap.PHYSICAL_STORE_NAME);
        } else if (webServiceLogicalStoreMBean.getRequestBufferingQueueJndiName() != null) {
            storeInfo.physicalStoreNames = WebServicesRuntime.getInstance().getLocalPhysicalStoresForLogicalStore(string);
        } else {
            String string5 = webServiceLogicalStoreMBean.getPhysicalStoreName();
            if (string5 == null) {
                string5 = "";
            }
            storeInfo.physicalStoreNames.add(string5);
        }
        storeInfo.persistStrategy = PersistenceStrategy.valueOf(string3);
        return storeInfo;
    }

    protected LogicalStore<K, V> createLogicalStore(String string, String string2) throws StoreException {
        return new LogicalStore<K, V>(string, string2);
    }

    protected StoreConnection<K, V> createStoreConnection(String string, String string2) throws StoreException {
        return new StoreConnection(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addPhysicalStore(String string) throws StoreException {
        StoreConnection<K, V> storeConnection;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        boolean bl = false;
        try {
            ClassLoader classLoader2 = this.getClass().getClassLoader();
            if (classLoader2 != classLoader) {
                Thread.currentThread().setContextClassLoader(classLoader2);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("LogicalStore " + this + " is being asked to add a new member physical store: " + string);
            }
            try {
                StoreConnection.connectionMapWriteLock();
                if (StoreConnection.storeConnectionExists(string, this._connectionName)) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("LogicalStore " + this + " is reusing an existing StoreConnection to physical store: " + string);
                    }
                    storeConnection = StoreConnection.getStoreConnection(string, this._connectionName);
                } else {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("LogicalStore " + this + " is adding a new StoreConnection to physical store: " + string);
                    }
                    storeConnection = this.createStoreConnection(string, this._connectionName);
                    storeConnection.setPhysicalStoreMustExist(KernelStatus.isServer() || this._persistStrategy != PersistenceStrategy.LOCAL_ACCESS_ONLY);
                    storeConnection.setCleanerIntervalMillis(this._cleanerIntervalMillis);
                    storeConnection.setMaxObjectLifetimeMillis(this._maxObjectLifetimeMillis);
                    storeConnection.open();
                    StoreConnection.addStoreConnection(string, this._connectionName, storeConnection);
                }
            }
            finally {
                StoreConnection.connectionMapWriteUnlock();
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        try {
            this._storeConnListLock.writeLock().lock();
            if (!this._storeConnList.contains(storeConnection)) {
                this._storeConnList.add(storeConnection);
                bl = true;
            }
            this.dumpStoreConnections();
        }
        finally {
            this._storeConnListLock.writeLock().unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public StoreConnection<K, V> removePhysicalStore(String string) throws StoreException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("LogicalStore " + this + " is removing the StoreConnection for physical store: " + string);
        }
        try {
            StoreConnection.connectionMapWriteLock();
            if (StoreConnection.storeConnectionExists(string, this._connectionName)) {
                StoreConnection.closeStoreConnection(string, this._connectionName);
            }
        }
        finally {
            StoreConnection.connectionMapWriteUnlock();
        }
        try {
            this._storeConnListLock.writeLock().lock();
            if (this._storeConnList.isEmpty()) {
                StoreConnection<K, V> storeConnection = null;
                return storeConnection;
            }
            StoreConnection<K, V> storeConnection = null;
            for (int i = 0; i < this._storeConnList.size(); ++i) {
                StoreConnection<K, V> storeConnection2 = this._storeConnList.get(i);
                if (!storeConnection2.getPhysicalStoreName().equals(string)) continue;
                this._storeConnList.remove(storeConnection2);
                storeConnection = storeConnection2;
                String string2 = "_lastUsedStoreConnIndexMonitor";
                // MONITORENTER : "_lastUsedStoreConnIndexMonitor"
                if (this._lastUsedStoreConnIndex >= i) {
                    --this._lastUsedStoreConnIndex;
                }
                // MONITOREXIT : string2
                break;
            }
            this.dumpStoreConnections();
            StoreConnection<K, V> storeConnection3 = storeConnection;
            return storeConnection3;
        }
        finally {
            this._storeConnListLock.writeLock().unlock();
        }
    }

    private void dumpStoreConnections() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Store connections for logical store: ").append(this).append("\n");
        for (StoreConnection<K, V> storeConnection : this._storeConnList) {
            stringBuffer.append("   ");
            stringBuffer.append(storeConnection.getPhysicalStoreName());
            stringBuffer.append("/");
            stringBuffer.append(storeConnection.getConnectionName());
            stringBuffer.append("\n");
        }
        LOGGER.fine(stringBuffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<StoreConnection<K, V>> getStoreConnections() {
        try {
            WebServicesRuntime.getInstance().ensureReady();
            this._storeConnListLock.readLock().lock();
            ArrayList<StoreConnection<K, V>> arrayList = new ArrayList<StoreConnection<K, V>>(this._storeConnList);
            return arrayList;
        }
        finally {
            this._storeConnListLock.readLock().unlock();
        }
    }

    private String preConnectStoreCheck(String string) throws StoreException {
        PersistentStore persistentStore;
        if (string == null || string.isEmpty()) {
            persistentStore = PersistentStoreManager.getManager().getDefaultStore();
        } else {
            PersistentStore persistentStore2;
            persistentStore = PersistentStoreManager.getManager().getStore(string);
            if (persistentStore == null && (persistentStore2 = PersistentStoreManager.getManager().getDefaultStore()) != null && persistentStore2.getName().equals(string)) {
                persistentStore = persistentStore2;
            }
        }
        if (persistentStore == null && (KernelStatus.isServer() || this._persistStrategy != PersistenceStrategy.LOCAL_ACCESS_ONLY)) {
            throw new StoreException(WseePersistLogger.logStoreNameNotSetLoggable().getMessage());
        }
        return string;
    }

    private void postConnectStoreCheck() throws StoreException {
        if (this._persistStrategy == PersistenceStrategy.NETWORK_ACCESSIBLE && !(this._storeConnList instanceof PersistentStoreXA)) {
            throw new StoreException(WseePersistLogger.logNetworkStoreNotXALoggable((String)this._name).getMessage());
        }
    }

    public String getName() {
        return this._name;
    }

    public String getConnectionName() {
        return this._connectionName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws StoreException {
        ArrayList<String> arrayList;
        try {
            this._storeConnListLock.readLock().lock();
            arrayList = new ArrayList<String>();
            for (StoreConnection<K, V> object : this._storeConnList) {
                arrayList.add(object.getPhysicalStoreName());
            }
        }
        finally {
            this._storeConnListLock.readLock().unlock();
        }
        Object object = null;
        for (String string : arrayList) {
            try {
                StoreConnection<K, V> storeException = this.removePhysicalStore(string);
                if (storeException == null) continue;
                try {
                    storeException.close();
                }
                catch (StoreException storeException2) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, "Error closing physical store '" + string + "': " + storeException2.toString(), storeException2);
                    }
                    throw storeException2;
                }
            }
            catch (StoreException storeException) {
                object = storeException;
                WseePersistLogger.logUnexpectedException((String)storeException.toString(), (Throwable)storeException);
            }
        }
        if (object != null) {
            throw object;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append(" (").append(this.getName()).append(")");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        this.ensureLogicalStoreReady();
        try {
            this._storeConnListLock.readLock().lock();
            int n = 0;
            for (StoreConnection<K, V> storeConnection : this._storeConnList) {
                n += storeConnection.size();
            }
            int n2 = n;
            return n2;
        }
        finally {
            this._storeConnListLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        this.ensureLogicalStoreReady();
        try {
            this._storeConnListLock.readLock().lock();
            for (StoreConnection<K, V> storeConnection : this._storeConnList) {
                if (!storeConnection.isEmpty()) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this._storeConnListLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object object) {
        this.ensureLogicalStoreReady();
        try {
            this._storeConnListLock.readLock().lock();
            for (StoreConnection<K, V> storeConnection : this._storeConnList) {
                if (!storeConnection.containsKey(object)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this._storeConnListLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object object) {
        this.ensureLogicalStoreReady();
        try {
            this._storeConnListLock.readLock().lock();
            for (StoreConnection<K, V> storeConnection : this._storeConnList) {
                if (!storeConnection.containsValue(object)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this._storeConnListLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object object) {
        this.ensureLogicalStoreReady();
        try {
            this._storeConnListLock.readLock().lock();
            for (StoreConnection<K, V> storeConnection : this._storeConnList) {
                Serializable serializable;
                if (!storeConnection.containsKey(serializable = (Serializable)object)) continue;
                Object object2 = storeConnection.get(object);
                return (V)object2;
            }
            Iterator<StoreConnection<K, V>> iterator = null;
            return (V)iterator;
        }
        finally {
            this._storeConnListLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K k, V v) {
        this.ensureLogicalStoreReady();
        try {
            StoreConnection<K, V> storeConnection;
            this._storeConnListLock.readLock().lock();
            Object object = this.get(k);
            String string = object != null ? object.getPhysicalStoreName() : v.getPhysicalStoreName();
            if (string == null) {
                storeConnection = this.getNextPhysicalStore();
                v.setPhysicalStoreName(storeConnection.getPhysicalStoreName());
            } else {
                storeConnection = this.getStoreConnection(string);
            }
            V v2 = storeConnection.put(k, v);
            return v2;
        }
        finally {
            this._storeConnListLock.readLock().unlock();
        }
    }

    public String getNextPhysicalStoreName() {
        return this.getNextPhysicalStore().getPhysicalStoreName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StoreConnection<K, V> getNextPhysicalStore() {
        String string = "_lastUsedStoreConnIndexMonitor";
        synchronized ("_lastUsedStoreConnIndexMonitor") {
            StoreConnection<K, V> storeConnection;
            this.ensureLogicalStoreReady();
            try {
                this._storeConnListLock.readLock().lock();
                this._lastUsedStoreConnIndex = 0;
                storeConnection = this._storeConnList.get(this._lastUsedStoreConnIndex);
                this._storeConnListLock.readLock().unlock();
            }
            catch (Throwable throwable) {
                this._storeConnListLock.readLock().unlock();
                throw throwable;
            }
            return storeConnection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureLogicalStoreReady() {
        block9: {
            if (!WebServicesRuntime.getInstance().ensureReady()) {
                return;
            }
            boolean bl = false;
            try {
                this._storeConnListLock.readLock().lock();
                bl = true;
                if (this._storeConnList.size() >= 1) break block9;
                this._storeConnListLock.readLock().unlock();
                bl = false;
                Exception exception = null;
                try {
                    this.addAvailablePhysicalStores();
                }
                catch (Exception exception2) {
                    exception = exception2;
                }
                this._storeConnListLock.readLock().lock();
                bl = true;
                if (this._storeConnList.size() < 1 || exception != null) {
                    String string = "No store connections in LogicalStore " + this + ", cannot put to this logical store.";
                    if (exception != null) {
                        string = string + " Tried to add available physical stores to correct this, but this failed with: " + exception;
                    }
                    throw new RuntimeException(string);
                }
            }
            finally {
                if (bl) {
                    this._storeConnListLock.readLock().unlock();
                }
            }
        }
    }

    protected StoreConnection<K, V> getStoreConnection(String string) {
        return this.doGetStoreConnection(string, true);
    }

    protected StoreConnection<K, V> getStoreConnectionInternal(String string) {
        return this.doGetStoreConnection(string, false);
    }

    private StoreConnection<K, V> doGetStoreConnection(String string, boolean bl) {
        try {
            if (bl) {
                this.ensureLogicalStoreReady();
            }
            this._storeConnListLock.readLock().lock();
            for (StoreConnection<K, V> storeConnection : this._storeConnList) {
                if (!storeConnection.getPhysicalStoreName().equals(string)) continue;
                StoreConnection<K, V> storeConnection2 = storeConnection;
                return storeConnection2;
            }
            throw new RuntimeException("No physical store with name " + string + " is associated with logical store " + this._name);
        }
        finally {
            this._storeConnListLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object object) {
        this.ensureLogicalStoreReady();
        try {
            this._storeConnListLock.readLock().lock();
            Serializable serializable = (Serializable)object;
            for (StoreConnection<K, V> storeConnection : this._storeConnList) {
                if (!storeConnection.containsKey(serializable)) continue;
                Object object2 = storeConnection.remove(serializable);
                return (V)object2;
            }
            Iterator<StoreConnection<K, V>> iterator = null;
            return (V)iterator;
        }
        finally {
            this._storeConnListLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        try {
            this._storeConnListLock.readLock().lock();
            for (Serializable serializable : map.keySet()) {
                Storable storable = (Storable)map.get(serializable);
                this.put((K)serializable, (V)storable);
            }
        }
        finally {
            this._storeConnListLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.ensureLogicalStoreReady();
        try {
            this._storeConnListLock.readLock().lock();
            for (StoreConnection<K, V> storeConnection : this._storeConnList) {
                storeConnection.clear();
            }
        }
        finally {
            this._storeConnListLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<K> keySet() {
        this.ensureLogicalStoreReady();
        try {
            this._storeConnListLock.readLock().lock();
            HashSet<K> hashSet = new HashSet<K>();
            for (StoreConnection<K, V> storeConnection : this._storeConnList) {
                hashSet.addAll(storeConnection.keySet());
            }
            HashSet<K> hashSet2 = hashSet;
            return hashSet2;
        }
        finally {
            this._storeConnListLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<V> values() {
        this.ensureLogicalStoreReady();
        try {
            this._storeConnListLock.readLock().lock();
            LinkedList<V> linkedList = new LinkedList<V>();
            for (StoreConnection<K, V> storeConnection : this._storeConnList) {
                linkedList.addAll(storeConnection.values());
            }
            LinkedList<V> linkedList2 = linkedList;
            return linkedList2;
        }
        finally {
            this._storeConnListLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.ensureLogicalStoreReady();
        try {
            this._storeConnListLock.readLock().lock();
            HashSet<Map.Entry<K, V>> hashSet = new HashSet<Map.Entry<K, V>>();
            for (StoreConnection<K, V> storeConnection : this._storeConnList) {
                hashSet.addAll(storeConnection.entrySet());
            }
            HashSet<Map.Entry<K, V>> hashSet2 = hashSet;
            return hashSet2;
        }
        finally {
            this._storeConnListLock.readLock().unlock();
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                String string;
                String string2 = string = _closeAllCalledExplicitly ? "All LogicalStores already closed. Quitting" : "Closing all logical stores";
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("SHUTDOWN HOOK FIRED: " + string);
                }
                LogicalStore.closeAllStores();
            }
        });
        LOGGER = Logger.getLogger(LogicalStore.class.getName());
        _storeMap = new HashMap<String, LogicalStore>();
        _storeNameToStoreMap = new HashMap<String, List<LogicalStore>>();
        _storeMapLock = new ReentrantReadWriteLock(false);
        _listeners = new ArrayList<LogicalStoreListChangeListener>();
    }

    private static class StoreInfo {
        public List<String> physicalStoreNames;
        public PersistenceStrategy persistStrategy;
        public long cleanerIntervalMillis;
        public long maxObjectLifetimeMillis;

        private StoreInfo() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PersistenceStrategy {
        LOCAL_ACCESS_ONLY,
        NETWORK_ACCESSIBLE,
        IN_MEMORY;

    }
}

