/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.persistence;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import weblogic.store.PersistentMap;
import weblogic.store.PersistentStore;
import weblogic.store.PersistentStoreException;
import weblogic.store.xa.PersistentStoreXA;
import weblogic.wsee.WseePersistLogger;
import weblogic.wsee.persistence.Storable;
import weblogic.wsee.persistence.StoreRuntimeException;
import weblogic.wsee.persistence.WLSStoreValuesMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkWLSStoreValuesMap<K extends Serializable, V extends Storable>
extends WLSStoreValuesMap<K, V> {
    private ReentrantReadWriteLock _valuesLock = new ReentrantReadWriteLock(false);
    private PersistentMap _valuesMap;

    public NetworkWLSStoreValuesMap(PersistentStore persistentStore, String string) throws PersistentStoreException {
        super(persistentStore, string);
        this._valuesMap = ((PersistentStoreXA)persistentStore).createPersistentMapXA(string);
    }

    @Override
    public int size() {
        try {
            this._valuesLock.readLock().lock();
            int n = this._valuesMap.size();
            Object var3_3 = null;
            this._valuesLock.readLock().unlock();
            return n;
        }
        catch (Exception exception) {
            try {
                WseePersistLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
                throw new StoreRuntimeException(exception.toString(), exception);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this._valuesLock.readLock().unlock();
                throw throwable;
            }
        }
    }

    @Override
    public boolean isEmpty() {
        try {
            this._valuesLock.readLock().lock();
            boolean bl = this._valuesMap.isEmpty();
            Object var3_3 = null;
            this._valuesLock.readLock().unlock();
            return bl;
        }
        catch (Exception exception) {
            try {
                WseePersistLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
                throw new StoreRuntimeException(exception.toString(), exception);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this._valuesLock.readLock().unlock();
                throw throwable;
            }
        }
    }

    @Override
    public boolean containsKey(Object object) {
        try {
            this._valuesLock.readLock().lock();
            boolean bl = this._valuesMap.containsKey(object);
            Object var4_4 = null;
            this._valuesLock.readLock().unlock();
            return bl;
        }
        catch (Exception exception) {
            try {
                WseePersistLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
                throw new StoreRuntimeException(exception.toString(), exception);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this._valuesLock.readLock().unlock();
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean containsValue(Object object) {
        boolean bl;
        try {
            try {
                this._valuesLock.readLock().lock();
                Set set = this._valuesMap.keySet();
                for (Serializable serializable : set) {
                    Storable storable = (Storable)this._valuesMap.get((Object)serializable);
                    if (storable == null || !storable.equals(object)) continue;
                    boolean bl2 = true;
                    Object var8_9 = null;
                    this._valuesLock.readLock().unlock();
                    return bl2;
                }
                bl = false;
            }
            catch (Exception exception) {
                WseePersistLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
                throw new StoreRuntimeException(exception.toString(), exception);
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            this._valuesLock.readLock().unlock();
            throw throwable;
        }
        Object var8_10 = null;
        this._valuesLock.readLock().unlock();
        return bl;
    }

    @Override
    public V get(Object object) {
        Storable storable;
        try {
            this._valuesLock.readLock().lock();
            storable = (Storable)this._valuesMap.get(object);
            Object var4_4 = null;
            this._valuesLock.readLock().unlock();
        }
        catch (Exception exception) {
            try {
                WseePersistLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
                throw new StoreRuntimeException(exception.toString(), exception);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this._valuesLock.readLock().unlock();
                throw throwable;
            }
        }
        return (V)storable;
    }

    @Override
    public V put(K k, V v) {
        return null;
    }

    @Override
    public V remove(Object object) {
        Storable storable;
        try {
            this._valuesLock.writeLock().lock();
            Storable storable2 = null;
            if (this._valuesMap.containsKey(object)) {
                storable2 = (Storable)this._valuesMap.get(object);
            }
            this._valuesMap.remove(object);
            storable = storable2;
            Object var5_5 = null;
            this._valuesLock.writeLock().unlock();
        }
        catch (Exception exception) {
            try {
                WseePersistLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
                throw new StoreRuntimeException(exception.toString(), exception);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this._valuesLock.writeLock().unlock();
                throw throwable;
            }
        }
        return (V)storable;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Serializable serializable : map.keySet()) {
            Storable storable = (Storable)map.get(serializable);
            this.put((K)serializable, (V)storable);
        }
    }

    @Override
    public void clear() {
        try {
            try {
                this._valuesLock.writeLock().lock();
                HashSet<K> hashSet = new HashSet<K>(this.keySet());
                for (Serializable serializable : hashSet) {
                    this.remove(serializable);
                }
                Object var5_5 = null;
                this._valuesLock.writeLock().unlock();
            }
            catch (Exception exception) {
                WseePersistLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
                throw new StoreRuntimeException(exception.toString(), exception);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this._valuesLock.writeLock().unlock();
            throw throwable;
        }
    }

    @Override
    public Set<K> keySet() {
        try {
            this._valuesLock.readLock().lock();
            HashSet hashSet = new HashSet(this._valuesMap.keySet());
            Object var3_3 = null;
            this._valuesLock.readLock().unlock();
            return hashSet;
        }
        catch (Exception exception) {
            try {
                WseePersistLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
                throw new StoreRuntimeException(exception.toString(), exception);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this._valuesLock.readLock().unlock();
                throw throwable;
            }
        }
    }

    @Override
    public Collection<V> values() {
        try {
            this._valuesLock.readLock().lock();
            Set set = this._valuesMap.keySet();
            LinkedList<Storable> linkedList = new LinkedList<Storable>();
            for (Serializable serializable : set) {
                Storable storable = (Storable)this._valuesMap.get((Object)serializable);
                linkedList.add(storable);
            }
            LinkedList<Storable> linkedList2 = linkedList;
            Object var7_7 = null;
            this._valuesLock.readLock().unlock();
            return linkedList2;
        }
        catch (Exception exception) {
            try {
                WseePersistLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
                throw new StoreRuntimeException(exception.toString(), exception);
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this._valuesLock.readLock().unlock();
                throw throwable;
            }
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException("entrySet()");
    }
}

