/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.persistence;

import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;
import weblogic.work.WorkManagerFactory;
import weblogic.wsee.WseePersistLogger;
import weblogic.wsee.persistence.Storable;
import weblogic.wsee.persistence.StoreConnection;
import weblogic.wsee.persistence.StoreException;

public class StoreCleaner {
    public static final Logger LOGGER = Logger.getLogger(StoreCleaner.class.getName());
    private static final String STATE_CLEAN_INTERVAL_PROP = "weblogic.wsee.StateCleanInterval";
    private static final String STATE_CLEAN_DISABLE_PROP = "weblogic.wsee.DisableStateCleaner";
    private static final String STATE_TIMER_MANAGER_NAME = "WseeStoreCleanerTimerManager";
    private long cleanerIntervalMillis;
    private long maxObjectLifetimeMillis;
    private long maxIdleTimeMillis;
    private boolean suspended = false;
    private boolean started = false;
    private boolean disabled = false;
    private TimerManager tm;
    private Timer timer;
    private final StoreConnection stg;
    private boolean cleaning = false;

    StoreCleaner(StoreConnection storeConnection, long l, long l2, long l3) {
        this.stg = storeConnection;
        if (l <= 0L) {
            l = StoreCleaner.getDefaultCleanerIntervalMillis();
        }
        this.cleanerIntervalMillis = l;
        this.maxObjectLifetimeMillis = l2;
        this.maxIdleTimeMillis = l3;
        this.disabled = Boolean.getBoolean(STATE_CLEAN_DISABLE_PROP);
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("StoreCLeaner created for " + storeConnection + " with interval=" + l + " msecs, maxObjectLifetime=" + l2 + " msecs maxIdleTimeMillis=" + l3 + " msecs with disabled = " + this.disabled);
        }
        this.tm = TimerManagerFactory.getTimerManagerFactory().getTimerManager(STATE_TIMER_MANAGER_NAME, WorkManagerFactory.getInstance().getSystem());
    }

    public static long getDefaultCleanerIntervalMillis() {
        long l = 60000L;
        String string = System.getProperty(STATE_CLEAN_INTERVAL_PROP, "60000");
        if (string != null && (string = string.trim()).length() != 0) {
            try {
                int n = Integer.parseInt(string);
                if (n < 30000) {
                    n = 30000;
                }
                l = n;
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        return l;
    }

    public long getCleanerIntervalMillis() {
        return this.cleanerIntervalMillis;
    }

    public long getMaxObjectLifetimeMillis() {
        return this.maxObjectLifetimeMillis;
    }

    public void setMaxObjectLifetimeMillis(long l) {
        this.maxObjectLifetimeMillis = l;
    }

    public long getMaxIdleTimeMillis() {
        return this.maxIdleTimeMillis;
    }

    public void setMaxIdleTimeMillis(long l) {
        this.maxIdleTimeMillis = l;
    }

    void startCleanup() {
        if (this.disabled) {
            return;
        }
        if (!this.started) {
            this.timer = this.tm.schedule((TimerListener)new TimerListenerImpl(), 0L, this.cleanerIntervalMillis);
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("StoreCLeaner starting for " + this.stg + " with interval=" + this.cleanerIntervalMillis + " msecs, maxObjectLifetime=" + this.maxObjectLifetimeMillis + " msecs maxIdleTimeMillis=" + this.maxIdleTimeMillis + " msecs with disabled = " + this.disabled);
            }
            this.started = true;
        }
    }

    public void setCleanerIntervalMillis(long l) {
        if (l > 0L && l != this.cleanerIntervalMillis) {
            this.cleanerIntervalMillis = l;
            if (this.timer != null) {
                this.timer.cancel();
            }
            this.timer = this.tm.schedule((TimerListener)new TimerListenerImpl(), 0L, this.cleanerIntervalMillis);
        }
    }

    void stopCleanup() {
        if (this.disabled) {
            return;
        }
        if (this.started) {
            this.tm.stop();
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("StoreCLeaner stopping for " + this.stg);
            }
            this.started = false;
        }
    }

    void suspendCleanup() {
        if (this.disabled) {
            return;
        }
        if (this.started && !this.suspended) {
            this.tm.suspend();
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("StoreCLeaner for " + this.stg + " suspended");
            }
            this.suspended = true;
        }
    }

    void resumeCleanup() {
        if (this.disabled) {
            return;
        }
        if (this.started && this.suspended) {
            this.tm.resume();
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("StoreCLeaner for " + this.stg + " resumed");
            }
            this.suspended = false;
        }
    }

    boolean isDisabled() {
        return this.disabled;
    }

    void setDisabled(boolean bl) {
        if (!this.disabled && bl) {
            this.stopCleanup();
        }
        this.disabled = bl;
    }

    private class TimerListenerImpl
    implements TimerListener {
        private TimerListenerImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void timerExpired(Timer timer) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("StoreCleaner for " + StoreCleaner.this.stg + " timer popped");
            }
            TimerListenerImpl timerListenerImpl = this;
            synchronized (timerListenerImpl) {
                if (StoreCleaner.this.cleaning) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("StoreCleaner for " + StoreCleaner.this.stg + " is already cleaning, bypassing this round of cleaning");
                    }
                    return;
                }
                StoreCleaner.this.cleaning = true;
            }
            try {
                this.doClean();
            }
            catch (Throwable throwable) {
                WseePersistLogger.logUnexpectedException((String)throwable.toString(), (Throwable)throwable);
            }
            finally {
                timerListenerImpl = this;
                synchronized (timerListenerImpl) {
                    StoreCleaner.this.cleaning = false;
                }
            }
        }

        private void doClean() throws StoreException {
            Set set;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Now checking persistent state objects");
            }
            if ((set = StoreCleaner.this.stg.keySet()) != null && !set.isEmpty()) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("StoreCleaner(" + StoreCleaner.this.stg + ") - persistent store has " + set.size() + " invocation objects to check..");
                }
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Object k = iterator.next();
                    Object object = StoreCleaner.this.stg.get(k);
                    if (!Storable.class.isInstance(object)) {
                        if (!LOGGER.isLoggable(Level.FINE)) continue;
                        LOGGER.fine("Value " + object + "stored in persistent store is not a Storable instance, but instead is a " + (object == null ? "null" : object.getClass().toString()));
                        continue;
                    }
                    Storable storable = (Storable)Storable.class.cast(object);
                    boolean bl = false;
                    boolean bl2 = false;
                    if (storable != null) {
                        if (storable.hasExplicitExpiration() && storable.isExpired()) {
                            LOGGER.fine("Storable explicitly indicated it is expired: " + object);
                            bl = true;
                        } else if (!storable.hasExplicitExpiration()) {
                            if (storable.getCreationTime() > 0L && StoreCleaner.this.maxObjectLifetimeMillis > 0L && System.currentTimeMillis() - storable.getCreationTime() > StoreCleaner.this.maxObjectLifetimeMillis) {
                                LOGGER.fine("Storable max lifetime exceeded: " + object);
                                bl = true;
                            }
                            if (storable.getLastUpdatedTime() > 0L && StoreCleaner.this.maxIdleTimeMillis > 0L && System.currentTimeMillis() - storable.getLastUpdatedTime() > StoreCleaner.this.maxIdleTimeMillis) {
                                LOGGER.fine("Storable max idle time exceeded: " + object);
                                bl2 = true;
                            }
                        }
                    }
                    if (!bl && !bl2) continue;
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Removing expired " + (bl2 ? " (idle timeout)" : "") + " Storable " + storable);
                    }
                    try {
                        iterator.remove();
                        StoreCleaner.this.stg.remove(k);
                    }
                    catch (Exception exception) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, exception.toString(), exception);
                        }
                        exception.printStackTrace();
                    }
                    if (!LOGGER.isLoggable(Level.FINE)) continue;
                    LOGGER.fine("After StoreCleaner removal, current state object count: " + set.size());
                }
            } else if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("StoreCleaner(" + StoreCleaner.this.stg + ") - persistent store empty.");
            }
        }
    }
}

