/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.persistence;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.kernel.KernelStatus;
import weblogic.management.configuration.WebServiceLogicalStoreMBean;
import weblogic.management.configuration.WebServiceMBean;
import weblogic.management.configuration.WebServicePhysicalStoreMBean;
import weblogic.store.PersistentStore;
import weblogic.store.PersistentStoreManager;
import weblogic.store.StoreWritePolicy;
import weblogic.store.internal.PersistentStoreImpl;
import weblogic.store.io.PersistentStoreIO;
import weblogic.store.io.file.FileStoreIO;
import weblogic.wsee.WseePersistLogger;
import weblogic.wsee.config.WebServiceMBeanFactory;
import weblogic.wsee.jaxws.framework.ConfigUtil;
import weblogic.wsee.persistence.InMemoryValuesMap;
import weblogic.wsee.persistence.LocalWLSStoreValuesMap;
import weblogic.wsee.persistence.NetworkWLSStoreValuesMap;
import weblogic.wsee.persistence.Storable;
import weblogic.wsee.persistence.StoreCleaner;
import weblogic.wsee.persistence.StoreException;
import weblogic.wsee.persistence.ValuesMap;
import weblogic.wsee.persistence.WLSStoreValuesMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreConnection<K extends Serializable, V extends Storable>
implements Map<K, V> {
    private static final Logger LOGGER = Logger.getLogger(StoreConnection.class.getName());
    private static final Map<String, StoreConnection> _nameConnToStoreMap = new HashMap<String, StoreConnection>();
    private static final ReentrantReadWriteLock _nameConnToStoreMapLock = new ReentrantReadWriteLock(false);
    private ValuesMap<K, V> _valuesMap;
    private String _physicalStoreName;
    private boolean _physicalStoreMustExist = KernelStatus.isServer();
    private String _connectionName;
    private long _cleanerIntervalMillis;
    private long _maxObjectLifetimeMillis;
    private long _maxIdleTimeMillis;
    private StoreCleaner _cleaner;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean storeConnectionExists(String string, String string2) {
        try {
            _nameConnToStoreMapLock.readLock().lock();
            boolean bl = _nameConnToStoreMap.containsKey(string + string2);
            return bl;
        }
        finally {
            _nameConnToStoreMapLock.readLock().unlock();
        }
    }

    protected static void connectionMapWriteLock() {
        _nameConnToStoreMapLock.writeLock().lock();
    }

    protected static void connectionMapWriteUnlock() {
        _nameConnToStoreMapLock.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean addStoreConnection(String string, String string2, StoreConnection storeConnection) {
        try {
            _nameConnToStoreMapLock.writeLock().lock();
            String string3 = string + string2;
            if (_nameConnToStoreMap.containsKey(string3)) {
                boolean bl = false;
                return bl;
            }
            _nameConnToStoreMap.put(string3, storeConnection);
            boolean bl = true;
            return bl;
        }
        finally {
            _nameConnToStoreMapLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StoreConnection getStoreConnection(String string, String string2) throws StoreException {
        try {
            _nameConnToStoreMapLock.readLock().lock();
            String string3 = string + string2;
            StoreConnection storeConnection = _nameConnToStoreMap.get(string3);
            return storeConnection;
        }
        finally {
            _nameConnToStoreMapLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean closeStoreConnection(String string, String string2) throws StoreException {
        try {
            _nameConnToStoreMapLock.writeLock().lock();
            StoreConnection storeConnection = _nameConnToStoreMap.remove(string + string2);
            if (storeConnection != null) {
                storeConnection.close();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            _nameConnToStoreMapLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAllStoreConnections() {
        try {
            _nameConnToStoreMapLock.writeLock().lock();
            for (StoreConnection storeConnection : _nameConnToStoreMap.values()) {
                try {
                    storeConnection.close();
                }
                catch (Exception exception) {
                    WseePersistLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
                }
            }
        }
        finally {
            _nameConnToStoreMapLock.writeLock().unlock();
        }
    }

    public StoreConnection(String string, String string2) throws StoreException {
        if (StoreConnection.storeConnectionExists(string, string2)) {
            throw new StoreException(WseePersistLogger.logStoreExistsLoggable((String)string, (String)string2).getMessage());
        }
        this._physicalStoreName = string;
        this._connectionName = string2;
        this._cleanerIntervalMillis = -1L;
        this._maxObjectLifetimeMillis = -1L;
        this._maxIdleTimeMillis = -1L;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(" == StoreConnection Created for physical store '" + string + "' and connection name '" + string2 + "'");
        }
    }

    public String getPhysicalStoreName() {
        return this._physicalStoreName;
    }

    public String getEffectiveStoreName() {
        String string = this.getPhysicalStoreName();
        if (string == null) {
            string = this._valuesMap.getStoreName();
        }
        return string;
    }

    public long getCleanerIntervalMillis() {
        return this._cleanerIntervalMillis;
    }

    public void setCleanerIntervalMillis(long l) {
        this._cleanerIntervalMillis = l;
    }

    public long getMaxObjectLifetimeMillis() {
        return this._maxObjectLifetimeMillis;
    }

    public void setMaxObjectLifetimeMillis(long l) {
        this._maxObjectLifetimeMillis = l;
    }

    public long getMaxIdleTimeMillis() {
        return this._maxIdleTimeMillis;
    }

    public void setMaxIdleTimeMillis(long l) {
        this._maxIdleTimeMillis = l;
    }

    public boolean isPhysicalStoreMustExist() {
        return this._physicalStoreMustExist;
    }

    public void setPhysicalStoreMustExist(boolean bl) {
        this._physicalStoreMustExist = bl;
    }

    public String getConnectionName() {
        return this._connectionName;
    }

    public String toString() {
        return "<StoreConnection> : storeName = " + this._physicalStoreName + " connectionName = " + this._connectionName;
    }

    ValuesMap createValuesMap() throws StoreException {
        if (InMemoryValuesMap.PHYSICAL_STORE_NAME.equals(this._physicalStoreName)) {
            return new InMemoryValuesMap(this._connectionName);
        }
        return this.createWLSStoreValuesMap();
    }

    private WLSStoreValuesMap createWLSStoreValuesMap() throws StoreException {
        InitInfo initInfo = this.initPersistentStore();
        boolean bl = initInfo.store instanceof PersistentStoreImpl;
        if (bl) {
            return this.createLocalMap(initInfo);
        }
        return this.createNetworkMap(initInfo);
    }

    private InitInfo initPersistentStore() throws StoreException {
        InitInfo initInfo = new InitInfo();
        if (this.getPhysicalStoreName() == null || this.getPhysicalStoreName().isEmpty()) {
            initInfo.store = PersistentStoreManager.getManager().getDefaultStore();
        } else {
            PersistentStore persistentStore;
            initInfo.store = PersistentStoreManager.getManager().getStore(this.getPhysicalStoreName());
            if (initInfo.store == null && (persistentStore = PersistentStoreManager.getManager().getDefaultStore()) != null && persistentStore.getName().equals(this.getPhysicalStoreName())) {
                initInfo.store = persistentStore;
            }
        }
        if (initInfo.store == null) {
            if (this._physicalStoreMustExist) {
                throw new StoreException(WseePersistLogger.logStoreNameNotSetLoggable().getMessage());
            }
            initInfo.store = this.createLocalFileStore();
        }
        return initInfo;
    }

    private PersistentStore createLocalFileStore() throws StoreException {
        WebServicePhysicalStoreMBean[] webServicePhysicalStoreMBeanArray;
        WebServiceMBean webServiceMBean = WebServiceMBeanFactory.getInstance();
        WebServiceLogicalStoreMBean webServiceLogicalStoreMBean = ConfigUtil.getLogicalStoreMBean(webServiceMBean.getWebServicePersistence().getDefaultLogicalStoreName());
        String string = webServiceLogicalStoreMBean.getPhysicalStoreName();
        WebServicePhysicalStoreMBean webServicePhysicalStoreMBean = null;
        for (WebServicePhysicalStoreMBean webServicePhysicalStoreMBean2 : webServicePhysicalStoreMBeanArray = webServiceMBean.getWebServicePersistence().getWebServicePhysicalStores()) {
            if (!webServicePhysicalStoreMBean2.getName().equals(string)) continue;
            webServicePhysicalStoreMBean = webServicePhysicalStoreMBean2;
            break;
        }
        if (webServicePhysicalStoreMBean == null) {
            throw new RuntimeException("Couldn't find physical store named: " + webServiceLogicalStoreMBean.getPhysicalStoreName());
        }
        String string2 = webServicePhysicalStoreMBean.getLocation();
        try {
            FileStoreIO exception = new FileStoreIO("weblogic.wsee.persistence." + string, string2);
            PersistentStoreImpl persistentStoreImpl = new PersistentStoreImpl(string, (PersistentStoreIO)exception);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("SynchronousWritePolicy", StoreWritePolicy.CACHE_FLUSH);
            hashMap.put("DaemonThreadInClientJVM", true);
            persistentStoreImpl.open(hashMap);
            PersistentStoreManager.getManager().addStore(string, (PersistentStore)persistentStoreImpl);
            return persistentStoreImpl;
        }
        catch (Exception exception) {
            throw new StoreException(exception.toString(), exception);
        }
    }

    private WLSStoreValuesMap createNetworkMap(InitInfo initInfo) throws StoreException {
        try {
            return new NetworkWLSStoreValuesMap(initInfo.store, this.getConnectionName());
        }
        catch (Exception exception) {
            throw new StoreException(exception.toString(), exception);
        }
    }

    private WLSStoreValuesMap createLocalMap(InitInfo initInfo) throws StoreException {
        return new LocalWLSStoreValuesMap(initInfo.store, this.getConnectionName());
    }

    protected void open() throws StoreException {
        if (this._valuesMap != null) {
            throw new StoreException("Already opened this StoreConnection: " + this._physicalStoreName + "/" + this._connectionName);
        }
        try {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(" == StoreConnection being Opened for physical store '" + this._physicalStoreName + "' and connection name '" + this._connectionName + "'");
            }
            this._valuesMap = this.createValuesMap();
            this.recoveryStarting();
            Set set = this._valuesMap.keySet();
            for (Object k : set) {
                Serializable serializable = (Serializable)k;
                Storable storable = (Storable)this._valuesMap.get(serializable);
                storable.setPhysicalStoreName(this.getPhysicalStoreName());
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(this + " recovering: " + storable);
                }
                this.recoverValue(storable);
            }
            this.recoveryComplete();
            long l = Long.MAX_VALUE;
            if (this._maxObjectLifetimeMillis > 0L && this._maxObjectLifetimeMillis < l) {
                l = this._maxObjectLifetimeMillis;
            }
            if (this._maxIdleTimeMillis > 0L && this._maxIdleTimeMillis < l) {
                l = this._maxIdleTimeMillis;
            }
            if (this._cleanerIntervalMillis > l / 2L) {
                this._cleanerIntervalMillis = l / 2L;
            }
            this._cleaner = new StoreCleaner(this, this._cleanerIntervalMillis, this._maxObjectLifetimeMillis, this._maxIdleTimeMillis);
            this._cleaner.startCleanup();
        }
        catch (StoreException storeException) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, storeException.toString(), storeException);
            }
            throw storeException;
        }
        catch (Throwable throwable) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, throwable.toString(), throwable);
            }
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }

    protected void recoveryStarting() {
    }

    protected void recoverValue(V v) {
    }

    protected void recoveryComplete() {
    }

    public void close() throws StoreException {
        this._cleaner.stopCleanup();
        this._valuesMap.close();
    }

    @Override
    public Set<K> keySet() {
        return this._valuesMap.keySet();
    }

    @Override
    public Collection<V> values() {
        return this._valuesMap.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this._valuesMap.entrySet();
    }

    @Override
    public boolean containsKey(Object object) {
        return this._valuesMap.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this._valuesMap.containsValue(object);
    }

    @Override
    public boolean isEmpty() {
        return this._valuesMap.isEmpty();
    }

    @Override
    public int size() {
        return this._valuesMap.size();
    }

    @Override
    public V put(K k, V v) {
        if (k == null) {
            throw new IllegalArgumentException("Attempt to store null key with value: " + v);
        }
        if (v == null) {
            throw new IllegalArgumentException("Attempt to store null value with key: " + k);
        }
        if (v.getPhysicalStoreName() == null) {
            v.setPhysicalStoreName(this.getPhysicalStoreName());
        }
        return (V)((Storable)this._valuesMap.put(k, v));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this._valuesMap.putAll(map);
    }

    @Override
    public void clear() {
        this._valuesMap.clear();
    }

    @Override
    public V get(Object object) {
        return (V)((Storable)this._valuesMap.get(object));
    }

    @Override
    public V remove(Object object) {
        return (V)((Storable)this._valuesMap.remove(object));
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                StoreConnection.closeAllStoreConnections();
            }
        });
    }

    private class InitInfo {
        public PersistentStore store;

        private InitInfo() {
        }
    }
}

