/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.policy.checker;

import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import weblogic.wsee.mc.internal.MCSupported;
import weblogic.wsee.policy.deployment.WsdlPolicySubject;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyAssertion;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.framework.PolicyMath;
import weblogic.wsee.policy.runtime.PolicyServer;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.WsService;
import weblogic.wsee.wsdl.WsdlBindingOperation;
import weblogic.wsee.wsdl.WsdlPort;

public class PolicyLevelChecker {
    private WsService wsService;
    private QName portName;
    private NormalizedExpression methodsPolicies;
    private NormalizedExpression classPolicies;
    private static final Class[] JAXWS_ASSERTIONS = new Class[]{MCSupported.class};
    private static final Logger LOGGER = Logger.getLogger(PolicyLevelChecker.class.getName());

    public PolicyLevelChecker(WsService wsService, QName qName) {
        this.wsService = wsService;
        this.portName = qName;
        this.methodsPolicies = this.getMethodsLevelPolicies();
        this.classPolicies = this.getClassLevelPolicies();
    }

    public void doJAXWSDefaultCheck() throws WebServiceException {
        for (Class clazz : JAXWS_ASSERTIONS) {
            if (this.isValidate(clazz)) continue;
            throw new WebServiceException(this.errorMsg(clazz.getSimpleName()));
        }
    }

    public boolean isValidate(PolicyAssertion policyAssertion) {
        Set set;
        Set set2 = this.methodsPolicies.getPolicyAlternatives(policyAssertion);
        return set2 == null || set2.size() <= 0 || (set = this.classPolicies.getPolicyAlternatives(policyAssertion)) == null || set.size() <= 0;
    }

    public boolean isValidate(Class clazz) {
        return !this.methodsPolicies.containsPolicyAssertion(clazz) || this.classPolicies.containsPolicyAssertion(clazz);
    }

    private String errorMsg(String string) {
        return "Policy contained assertion [" + string + "] is deployed at method level, it can only deployed at class level!";
    }

    private NormalizedExpression getMethodsLevelPolicies() {
        NormalizedExpression normalizedExpression = new NormalizedExpression();
        WsdlPort wsdlPort = this.wsService.getPort(this.portName.getLocalPart()).getWsdlPort();
        for (WsdlBindingOperation wsdlBindingOperation : wsdlPort.getBinding().getOperations().values()) {
            try {
                NormalizedExpression normalizedExpression2 = WsdlPolicySubject.getOperationPolicySubject(this.wsService.getPolicyServer(), wsdlBindingOperation, Collections.EMPTY_MAP);
                if (normalizedExpression2 == null) continue;
                normalizedExpression = PolicyMath.merge(normalizedExpression, normalizedExpression2);
            }
            catch (PolicyException policyException) {
                if (LOGGER.getLevel() != Level.WARNING) continue;
                LOGGER.warning(policyException.getMessage());
            }
        }
        return normalizedExpression;
    }

    private NormalizedExpression getClassLevelPolicies() {
        NormalizedExpression normalizedExpression;
        block3: {
            normalizedExpression = new NormalizedExpression();
            WsPort wsPort = this.wsService.getPort(this.portName.getLocalPart());
            PolicyServer policyServer = this.wsService.getPolicyServer();
            if (policyServer == null) {
                return normalizedExpression;
            }
            try {
                normalizedExpression = policyServer.getEndpointPolicy(wsPort.getWsdlPort());
            }
            catch (PolicyException policyException) {
                if (!LOGGER.isLoggable(Level.FINE)) break block3;
                LOGGER.fine("Exception getting policy for " + wsPort.getEndpoint());
            }
        }
        return normalizedExpression;
    }
}

