/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.policy.deployment;

import java.lang.reflect.Method;
import weblogic.descriptor.EditableDescriptorManager;
import weblogic.j2ee.descriptor.wl.OperationPolicyBean;
import weblogic.j2ee.descriptor.wl.PortPolicyBean;
import weblogic.j2ee.descriptor.wl.WebservicePolicyRefBean;
import weblogic.j2ee.descriptor.wl.WsPolicyBean;
import weblogic.jws.Policies;
import weblogic.jws.Policy;
import weblogic.wsee.jws.JWSVisitor;

public class PolicyBeanVisitor
implements JWSVisitor {
    WebservicePolicyRefBean bean;

    public PolicyBeanVisitor() {
        EditableDescriptorManager editableDescriptorManager = new EditableDescriptorManager();
        this.bean = (WebservicePolicyRefBean)editableDescriptorManager.createDescriptorRoot(WebservicePolicyRefBean.class).getRootBean();
    }

    public WebservicePolicyRefBean getPolicyRefBean() {
        return this.bean;
    }

    public void visitClass(JWSVisitor.JWSClass jWSClass) {
        Class clazz = jWSClass.getServiceImpl();
        Policy policy = clazz.getAnnotation(Policy.class);
        Policies policies = clazz.getAnnotation(Policies.class);
        if (policy == null && policies == null) {
            return;
        }
        PortPolicyBean portPolicyBean = this.bean.createPortPolicy();
        portPolicyBean.setPortName(jWSClass.getPortName().getLocalPart());
        if (policies != null) {
            PolicyBeanVisitor.createWspolicyBean(portPolicyBean, policies.value());
        } else if (policy != null) {
            PolicyBeanVisitor.createWspolicyBean(portPolicyBean, policy);
        }
    }

    public void visitMethod(JWSVisitor.WsMethod wsMethod) {
        Method method = wsMethod.getImplMethod();
        Policy policy = method.getAnnotation(Policy.class);
        Policies policies = method.getAnnotation(Policies.class);
        if (policy == null && policies == null) {
            return;
        }
        OperationPolicyBean operationPolicyBean = this.bean.createOperationPolicy();
        operationPolicyBean.setOperationName(wsMethod.getOperationName());
        if (policies != null) {
            PolicyBeanVisitor.createWspolicyBean(operationPolicyBean, policies.value());
        } else if (policy != null) {
            PolicyBeanVisitor.createWspolicyBean(operationPolicyBean, policy);
        }
    }

    private static void createWspolicyBean(PortPolicyBean portPolicyBean, Policy ... policyArray) {
        for (int i = 0; i < policyArray.length; ++i) {
            Policy policy = policyArray[i];
            if (policy == null) continue;
            WsPolicyBean wsPolicyBean = portPolicyBean.createWsPolicy();
            wsPolicyBean.setUri(policy.uri());
            wsPolicyBean.setDirection(policy.direction().toString());
        }
    }

    private static void createWspolicyBean(OperationPolicyBean operationPolicyBean, Policy ... policyArray) {
        for (int i = 0; i < policyArray.length; ++i) {
            Policy policy = policyArray[i];
            if (policy == null) continue;
            WsPolicyBean wsPolicyBean = operationPolicyBean.createWsPolicy();
            wsPolicyBean.setUri(policy.uri());
            wsPolicyBean.setDirection(policy.direction().toString());
        }
    }
}

