/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.policy.deployment;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.xml.ws.WebServiceProvider;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.EditableDescriptorManager;
import weblogic.j2ee.descriptor.wl.OperationPolicyBean;
import weblogic.j2ee.descriptor.wl.OwsmSecurityPolicyBean;
import weblogic.j2ee.descriptor.wl.PortPolicyBean;
import weblogic.j2ee.descriptor.wl.WebservicePolicyRefBean;
import weblogic.j2ee.descriptor.wl.WsPolicyBean;
import weblogic.j2ee.descriptor.wl.validators.WseePolicyBeanValidator;
import weblogic.jws.Policies;
import weblogic.jws.Policy;
import weblogic.utils.jars.RandomAccessJarFile;
import weblogic.wsee.jws.jaxws.owsm.SecurityPolicies;
import weblogic.wsee.jws.jaxws.owsm.SecurityPolicy;
import weblogic.wsee.policy.deployment.PolicyReferenceWsdlExtension;
import weblogic.wsee.policy.deployment.PolicyURIs;
import weblogic.wsee.policy.deployment.PolicyWsdlExtension;
import weblogic.wsee.policy.deployment.UsingPolicy;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.framework.PolicyStatement;
import weblogic.wsee.policy.runtime.PolicyServer;
import weblogic.wsee.tools.jws.decl.PolicyDecl;
import weblogic.wsee.util.ClassUtil;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.wsdl.WsdlBinding;
import weblogic.wsee.wsdl.WsdlBindingMessage;
import weblogic.wsee.wsdl.WsdlBindingOperation;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlExtensible;
import weblogic.wsee.wsdl.WsdlMessage;
import weblogic.wsee.wsdl.WsdlOperation;
import weblogic.wsee.wsdl.WsdlPort;
import weblogic.wsee.wsdl.WsdlPortType;
import weblogic.wsee.wsdl.WsdlService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PolicyDeployUtils {
    private static boolean verbose = Verbose.isVerbose(PolicyDeployUtils.class);
    public static final String BOTH = "both";
    public static final String INBOUND = "inbound";
    public static final String OUTBOUND = "outbound";
    public static final String ENABLED = "enabled";
    public static final String DISABLED = "disabled";
    public static final String DELETED = "deleted";

    public static String getXPointerId(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '=' || c == '+' || c == '/') {
                c = '_';
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static PolicyReferenceWsdlExtension addPolicyReferenceToWsdlExtensible(WsdlExtensible wsdlExtensible, URI uRI) {
        if (wsdlExtensible == null) {
            return new PolicyReferenceWsdlExtension();
        }
        PolicyReferenceWsdlExtension policyReferenceWsdlExtension = (PolicyReferenceWsdlExtension)wsdlExtensible.getExtension("PolicyReference");
        if (policyReferenceWsdlExtension == null) {
            policyReferenceWsdlExtension = new PolicyReferenceWsdlExtension();
            wsdlExtensible.putExtension(policyReferenceWsdlExtension);
        }
        if (!policyReferenceWsdlExtension.getURIs().contains(uRI)) {
            policyReferenceWsdlExtension.addURI(uRI);
        }
        return policyReferenceWsdlExtension;
    }

    private static PolicyReferenceWsdlExtension removePolicyFromWsdlExtensible(WsdlExtensible wsdlExtensible, URI uRI) {
        PolicyReferenceWsdlExtension policyReferenceWsdlExtension = PolicyDeployUtils.getPolicyExtension(wsdlExtensible);
        if (policyReferenceWsdlExtension != null && policyReferenceWsdlExtension.getURIs() != null && policyReferenceWsdlExtension.getURIs().contains(uRI)) {
            policyReferenceWsdlExtension.removeURI(uRI);
        }
        return policyReferenceWsdlExtension;
    }

    private static PolicyReferenceWsdlExtension removePolicy(WsdlPort wsdlPort, URI uRI) {
        PolicyReferenceWsdlExtension policyReferenceWsdlExtension = PolicyDeployUtils.removePolicyFromWsdlExtensible(wsdlPort, uRI);
        PolicyURIs policyURIs = wsdlPort.getPortType().getPolicyUris();
        policyURIs.removeURI(uRI);
        return policyReferenceWsdlExtension;
    }

    private static void removePolicy(WsdlPort wsdlPort, URI uRI, String string) {
        for (WsdlBindingOperation wsdlBindingOperation : wsdlPort.getBinding().getOperations().values()) {
            if (string.equals(INBOUND)) {
                PolicyDeployUtils.removePolicyFromWsdlExtensible(wsdlBindingOperation.getInput(), uRI);
                continue;
            }
            PolicyDeployUtils.removePolicyFromWsdlExtensible(wsdlBindingOperation.getOutput(), uRI);
        }
    }

    private static void removePolicy(WsdlBindingOperation wsdlBindingOperation, URI uRI, String string) {
        if (string.equals(INBOUND)) {
            PolicyDeployUtils.removePolicyFromWsdlExtensible(wsdlBindingOperation.getInput(), uRI);
        } else {
            PolicyDeployUtils.removePolicyFromWsdlExtensible(wsdlBindingOperation.getOutput(), uRI);
        }
    }

    private static List<URI> getPolicies(WsdlPort wsdlPort, String string) {
        if (BOTH.equals(string)) {
            return PolicyDeployUtils.getPolicies(wsdlPort);
        }
        List<URI> list = null;
        Iterator<? extends WsdlBindingOperation> iterator = wsdlPort.getBinding().getOperations().values().iterator();
        if (iterator.hasNext()) {
            list = PolicyDeployUtils.getPolicies(iterator.next(), string);
        }
        if (list != null) {
            while (iterator.hasNext()) {
                List<URI> list2 = PolicyDeployUtils.getPolicies(iterator.next(), string);
                if (list2 == null) continue;
                for (URI uRI : list) {
                    if (list2.contains(uRI)) continue;
                    list.remove(uRI);
                }
            }
        }
        return list;
    }

    private static List<URI> getPolicies(WsdlBindingOperation wsdlBindingOperation, String string) {
        if (INBOUND.equals(string)) {
            return PolicyDeployUtils.getPoliciesFromWsdlExtensible(wsdlBindingOperation.getInput());
        }
        if (OUTBOUND.equals(string)) {
            return PolicyDeployUtils.getPoliciesFromWsdlExtensible(wsdlBindingOperation.getOutput());
        }
        return null;
    }

    private static List<URI> getPoliciesFromWsdlExtensible(WsdlExtensible wsdlExtensible) {
        PolicyReferenceWsdlExtension policyReferenceWsdlExtension = wsdlExtensible == null ? null : PolicyDeployUtils.getPolicyExtension(wsdlExtensible);
        return policyReferenceWsdlExtension != null ? policyReferenceWsdlExtension.getURIs() : null;
    }

    private static List<URI> getPolicies(WsdlPort wsdlPort) {
        PolicyURIs policyURIs;
        ArrayList<URI> arrayList = new ArrayList<URI>();
        List<URI> list = PolicyDeployUtils.getPoliciesFromWsdlExtensible(wsdlPort);
        if (list != null) {
            arrayList.addAll(list);
        }
        if ((policyURIs = wsdlPort.getPortType().getPolicyUris()) != null && policyURIs.getURIs() != null) {
            for (URI uRI : policyURIs.getURIs()) {
                arrayList.add(uRI);
            }
        }
        return arrayList;
    }

    private static PolicyReferenceWsdlExtension getPolicyExtension(WsdlExtensible wsdlExtensible) {
        return (PolicyReferenceWsdlExtension)wsdlExtensible.getExtension("PolicyReference");
    }

    public static PolicyURIs addPolicyURIToPortType(WsdlPortType wsdlPortType, URI uRI) {
        PolicyURIs policyURIs = wsdlPortType.getPolicyUris();
        if (policyURIs == null) {
            if (verbose) {
                Verbose.log("Add PolicyURIs on port: " + wsdlPortType.getName());
            }
            policyURIs = new PolicyURIs(uRI);
        } else {
            policyURIs.addURI(uRI);
        }
        wsdlPortType.setPolicyUris(policyURIs);
        return policyURIs;
    }

    public static PolicyURIs addPoliyURIToPort(WsdlPort wsdlPort, URI uRI, String string) {
        PolicyURIs policyURIs = null;
        if (uRI == null) {
            try {
                uRI = new URI("policy:" + string);
            }
            catch (URISyntaxException uRISyntaxException) {
                uRISyntaxException.printStackTrace();
            }
        }
        if ((policyURIs = wsdlPort.getPolicyUris()) == null) {
            if (verbose) {
                Verbose.log("Add PolicyURIs on port: " + wsdlPort.getName());
            }
            policyURIs = new PolicyURIs(uRI);
        } else {
            policyURIs.addURI(uRI);
        }
        wsdlPort.setPolicyUris(policyURIs);
        return policyURIs;
    }

    public static PolicyURIs addPoliyURIToOperation(WsdlBindingOperation wsdlBindingOperation, URI uRI, String string) {
        PolicyURIs policyURIs = null;
        if (uRI == null) {
            try {
                uRI = new URI("policy:" + string);
            }
            catch (URISyntaxException uRISyntaxException) {
                uRISyntaxException.printStackTrace();
            }
        }
        if ((policyURIs = wsdlBindingOperation.getPolicyUris()) == null) {
            if (verbose) {
                Verbose.log("Add PolicyURIs on operation: " + wsdlBindingOperation.getName());
            }
            policyURIs = new PolicyURIs(uRI);
        } else {
            policyURIs.addURI(uRI);
        }
        wsdlBindingOperation.setPolicyUris(policyURIs);
        return policyURIs;
    }

    public static PolicyURIs addPoliyURIToMessage(WsdlBindingMessage wsdlBindingMessage, URI uRI, String string) {
        PolicyURIs policyURIs = null;
        if (uRI == null) {
            try {
                uRI = new URI("policy:" + string);
            }
            catch (URISyntaxException uRISyntaxException) {
                uRISyntaxException.printStackTrace();
            }
        }
        if ((policyURIs = wsdlBindingMessage.getPolicyUris()) == null) {
            if (verbose) {
                Verbose.log("Add PolicyURIs on message: " + wsdlBindingMessage.getName());
            }
            policyURIs = new PolicyURIs(uRI);
        } else {
            policyURIs.addURI(uRI);
        }
        wsdlBindingMessage.setPolicyUris(policyURIs);
        return policyURIs;
    }

    public static ArrayList<String> getPoliciesFromAnnotatedElement(AnnotatedElement annotatedElement) {
        return PolicyDeployUtils.getPoliciesFromAnnotatedElement(annotatedElement, null);
    }

    public static ArrayList<String> getPoliciesFromAnnotatedElement(AnnotatedElement annotatedElement, Policy.Direction direction) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Policies policies = annotatedElement.getAnnotation(Policies.class);
        if (policies != null) {
            for (Policy policy : policies.value()) {
                if (direction != null && !direction.equals((Object)policy.direction())) continue;
                arrayList.add(policy.uri());
            }
        } else {
            Policy policy = annotatedElement.getAnnotation(Policy.class);
            if (policy != null && (direction == null || direction.equals((Object)policy.direction()))) {
                arrayList.add(policy.uri());
            }
        }
        return arrayList;
    }

    public static ArrayList<String> getOwsmSecurityPoliciesFromAnnotatedElement(AnnotatedElement annotatedElement) {
        ArrayList<String> arrayList = new ArrayList<String>();
        SecurityPolicies securityPolicies = annotatedElement.getAnnotation(SecurityPolicies.class);
        if (securityPolicies != null) {
            for (SecurityPolicy securityPolicy : securityPolicies.value()) {
                arrayList.add(securityPolicy.uri());
            }
        } else {
            SecurityPolicy securityPolicy = annotatedElement.getAnnotation(SecurityPolicy.class);
            if (securityPolicy != null) {
                arrayList.add(securityPolicy.uri());
            }
        }
        return arrayList;
    }

    public static String[] getPoliciesFromPort(WebservicePolicyRefBean webservicePolicyRefBean, String string, Class clazz) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (clazz != null) {
            arrayList.addAll(PolicyDeployUtils.getPoliciesFromAnnotatedElement(clazz));
        }
        PortPolicyBean[] portPolicyBeanArray = webservicePolicyRefBean.getPortPolicy();
        for (int i = 0; portPolicyBeanArray != null && i < portPolicyBeanArray.length; ++i) {
            if (!portPolicyBeanArray[i].getPortName().equals(string)) continue;
            WsPolicyBean[] wsPolicyBeanArray = portPolicyBeanArray[i].getWsPolicy();
            PolicyDeployUtils.updatePolicies(arrayList, wsPolicyBeanArray);
        }
        return arrayList.toArray(new String[0]);
    }

    private static void updatePolicies(List<String> list, WsPolicyBean[] wsPolicyBeanArray) {
        for (int i = 0; i < wsPolicyBeanArray.length; ++i) {
            WsPolicyBean wsPolicyBean = wsPolicyBeanArray[i];
            if (wsPolicyBean.getStatus().equals(ENABLED) && !list.contains(wsPolicyBean.getUri())) {
                list.add(wsPolicyBean.getUri());
            }
            if (!wsPolicyBean.getStatus().equals(DISABLED) && !wsPolicyBean.getStatus().equals(DELETED)) continue;
            list.remove(wsPolicyBean.getUri());
        }
    }

    private static void updatePolicies(List<String> list, OwsmSecurityPolicyBean[] owsmSecurityPolicyBeanArray) {
        for (int i = 0; i < owsmSecurityPolicyBeanArray.length; ++i) {
            OwsmSecurityPolicyBean owsmSecurityPolicyBean = owsmSecurityPolicyBeanArray[i];
            if (owsmSecurityPolicyBean.getStatus().equals(ENABLED) && !list.contains(owsmSecurityPolicyBean.getUri())) {
                list.add(owsmSecurityPolicyBean.getUri());
            }
            if (!owsmSecurityPolicyBean.getStatus().equals(DISABLED) && !owsmSecurityPolicyBean.getStatus().equals(DELETED)) continue;
            list.remove(owsmSecurityPolicyBean.getUri());
        }
    }

    private static void updatePolicies(String string, List<String> list, WsPolicyBean[] wsPolicyBeanArray) {
        for (int i = 0; i < wsPolicyBeanArray.length; ++i) {
            if (!(string == null ? wsPolicyBeanArray[i].getDirection() == null : string.equals(wsPolicyBeanArray[i].getDirection())) || !wsPolicyBeanArray[i].getStatus().equals(ENABLED) || list.contains(wsPolicyBeanArray[i].getUri())) continue;
            list.add(wsPolicyBeanArray[i].getUri());
        }
        if (string == null) {
            string = BOTH;
        }
        PolicyDeployUtils.removePolicies(list, wsPolicyBeanArray, string);
    }

    private static void removePolicies(List<String> list, WsPolicyBean[] wsPolicyBeanArray, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(list);
        for (String string2 : arrayList) {
            for (int i = 0; i < wsPolicyBeanArray.length; ++i) {
                WsPolicyBean wsPolicyBean = wsPolicyBeanArray[i];
                if (!PolicyDeployUtils.urisEquivalent(wsPolicyBean.getUri(), string2)) continue;
                if (string.equals(BOTH)) {
                    if (wsPolicyBean.getStatus().equals(ENABLED)) continue;
                    list.remove(string2);
                    continue;
                }
                if (!wsPolicyBean.getStatus().equals(ENABLED)) {
                    if (!string.equals(wsPolicyBean.getDirection())) continue;
                    list.remove(string2);
                    continue;
                }
                if (string.equals(wsPolicyBean.getDirection())) continue;
                list.remove(string2);
            }
        }
    }

    private static boolean urisEquivalent(String string, String string2) {
        String string3;
        if (string.equals(string2)) {
            return true;
        }
        return string.endsWith(".xml") && (string3 = string.substring(0, string.length() - 4)).equals(string2);
    }

    public static String[] getPoliciesFromPort(WebservicePolicyRefBean webservicePolicyRefBean, String string) {
        return PolicyDeployUtils.getPoliciesFromPort(webservicePolicyRefBean, string, null);
    }

    public static String[] getOwsmSecurityPoliciesFromPort(WebservicePolicyRefBean webservicePolicyRefBean, String string, Class clazz) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (clazz != null) {
            arrayList.addAll(PolicyDeployUtils.getOwsmSecurityPoliciesFromAnnotatedElement(clazz));
        }
        PortPolicyBean[] portPolicyBeanArray = webservicePolicyRefBean.getPortPolicy();
        for (int i = 0; portPolicyBeanArray != null && i < portPolicyBeanArray.length; ++i) {
            if (!portPolicyBeanArray[i].getPortName().equals(string)) continue;
            OwsmSecurityPolicyBean[] owsmSecurityPolicyBeanArray = portPolicyBeanArray[i].getOwsmSecurityPolicy();
            PolicyDeployUtils.updatePolicies(arrayList, owsmSecurityPolicyBeanArray);
        }
        return arrayList.toArray(new String[0]);
    }

    public static String[] getPoliciesFromOperation(WebservicePolicyRefBean webservicePolicyRefBean, String string, String string2, Class clazz, String string3) {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (clazz != null && clazz.getAnnotation(WebServiceProvider.class) == null) {
            object = PolicyDeployUtils.findWebMethodFromService(clazz, string);
            arrayList.addAll(PolicyDeployUtils.getPoliciesFromAnnotatedElement((AnnotatedElement)object, Policy.Direction.valueOf((String)string2)));
        }
        if ((object = webservicePolicyRefBean.getOperationPolicy()) != null && ((OperationPolicyBean[])object).length > 0) {
            for (int i = 0; i < ((OperationPolicyBean[])object).length; ++i) {
                String string4 = object[i].getServiceLink();
                String string5 = object[i].getOperationName();
                if (!StringUtil.isEmpty(string4) && (StringUtil.isEmpty(string4) || !string4.equals(string3)) || !string5.equals(string)) continue;
                WsPolicyBean[] wsPolicyBeanArray = object[i].getWsPolicy();
                PolicyDeployUtils.updatePolicies(string2, arrayList, wsPolicyBeanArray);
            }
        }
        return arrayList.toArray(new String[0]);
    }

    public static String[] getPoliciesFromOperation(WebservicePolicyRefBean webservicePolicyRefBean, String string, String string2) {
        return PolicyDeployUtils.getPoliciesFromOperation(webservicePolicyRefBean, string, string2, null, null);
    }

    public static void attachPolicy(WebservicePolicyRefBean webservicePolicyRefBean, WsdlDefinitions wsdlDefinitions, WsdlPort wsdlPort, String string) {
        boolean bl = false;
        String string2 = wsdlPort.getName().getLocalPart();
        PortPolicyBean[] portPolicyBeanArray = webservicePolicyRefBean.getPortPolicy();
        for (int i = 0; portPolicyBeanArray != null && i < portPolicyBeanArray.length; ++i) {
            if (!portPolicyBeanArray[i].getPortName().equals(string2)) continue;
            WsPolicyBean[] wsPolicyBeanArray = portPolicyBeanArray[i].getWsPolicy();
            bl = PolicyDeployUtils.updatePolicies(wsdlPort, wsPolicyBeanArray);
        }
        OperationPolicyBean[] operationPolicyBeanArray = webservicePolicyRefBean.getOperationPolicy();
        for (int i = 0; operationPolicyBeanArray != null && i < operationPolicyBeanArray.length; ++i) {
            String string3 = operationPolicyBeanArray[i].getOperationName();
            String string4 = operationPolicyBeanArray[i].getServiceLink();
            for (WsdlBindingOperation wsdlBindingOperation : wsdlPort.getBinding().getOperations().values()) {
                if (!string3.equals(wsdlBindingOperation.getName().getLocalPart()) || !StringUtil.isEmpty(string4) && !string4.equals(string)) continue;
                WsPolicyBean[] wsPolicyBeanArray = operationPolicyBeanArray[i].getWsPolicy();
                bl = PolicyDeployUtils.updatePolicies(wsdlBindingOperation, wsPolicyBeanArray) || bl;
            }
        }
        if (bl) {
            UsingPolicy usingPolicy = UsingPolicy.narrow(wsdlDefinitions);
            if (usingPolicy == null) {
                wsdlDefinitions.putExtension(new UsingPolicy(true));
            } else if (!usingPolicy.isSet()) {
                usingPolicy.enableUsingPolicy();
            }
        }
    }

    private static boolean updatePolicies(WsdlBindingOperation wsdlBindingOperation, WsPolicyBean[] wsPolicyBeanArray) {
        boolean bl = false;
        for (int i = 0; i < wsPolicyBeanArray.length; ++i) {
            WsPolicyBean wsPolicyBean = wsPolicyBeanArray[i];
            if (!wsPolicyBeanArray[i].getStatus().equals(ENABLED)) continue;
            PolicyDeployUtils.addPolicies(wsPolicyBeanArray[i].getDirection(), wsdlBindingOperation, wsPolicyBeanArray[i].getUri());
            bl = true;
        }
        PolicyDeployUtils.removePolicies(wsdlBindingOperation, wsPolicyBeanArray, BOTH);
        PolicyDeployUtils.removePolicies(wsdlBindingOperation, wsPolicyBeanArray, INBOUND);
        PolicyDeployUtils.removePolicies(wsdlBindingOperation, wsPolicyBeanArray, OUTBOUND);
        return bl;
    }

    private static boolean updatePolicies(WsdlPort wsdlPort, WsPolicyBean[] wsPolicyBeanArray) {
        boolean bl = false;
        for (int i = 0; i < wsPolicyBeanArray.length; ++i) {
            if (!wsPolicyBeanArray[i].getStatus().equals(ENABLED)) continue;
            PolicyDeployUtils.addPolicies(wsPolicyBeanArray[i].getDirection(), wsdlPort, wsPolicyBeanArray[i].getUri());
            bl = true;
        }
        PolicyDeployUtils.removePolicies(wsdlPort, wsPolicyBeanArray, BOTH);
        PolicyDeployUtils.removePolicies(wsdlPort, wsPolicyBeanArray, INBOUND);
        PolicyDeployUtils.removePolicies(wsdlPort, wsPolicyBeanArray, OUTBOUND);
        return bl;
    }

    private static void removePolicies(WsdlPort wsdlPort, WsPolicyBean[] wsPolicyBeanArray, String string) {
        List<URI> list = PolicyDeployUtils.getPolicies(wsdlPort, string);
        if (list != null) {
            ArrayList<URI> arrayList = new ArrayList<URI>(list);
            for (URI uRI : arrayList) {
                for (int i = 0; i < wsPolicyBeanArray.length; ++i) {
                    WsPolicyBean wsPolicyBean = wsPolicyBeanArray[i];
                    if (!PolicyDeployUtils.urisEquivalent(wsPolicyBean.getUri(), uRI.toString())) continue;
                    if (string.equals(BOTH)) {
                        if (wsPolicyBean.getStatus().equals(ENABLED)) continue;
                        PolicyDeployUtils.removePolicy(wsdlPort, uRI);
                        continue;
                    }
                    if (!wsPolicyBean.getStatus().equals(ENABLED)) {
                        if (!string.equals(wsPolicyBean.getDirection())) continue;
                        PolicyDeployUtils.removePolicy(wsdlPort, uRI, string);
                        continue;
                    }
                    if (string.equals(wsPolicyBean.getDirection())) continue;
                    PolicyDeployUtils.removePolicy(wsdlPort, uRI, string);
                }
            }
        }
    }

    private static void removePolicies(WsdlBindingOperation wsdlBindingOperation, WsPolicyBean[] wsPolicyBeanArray, String string) {
        List<URI> list = null;
        list = string == null || string.equals(BOTH) ? PolicyDeployUtils.getPoliciesFromWsdlExtensible(wsdlBindingOperation) : PolicyDeployUtils.getPolicies(wsdlBindingOperation, string);
        if (list != null) {
            ArrayList<URI> arrayList = new ArrayList<URI>(list);
            for (URI uRI : arrayList) {
                for (int i = 0; i < wsPolicyBeanArray.length; ++i) {
                    WsPolicyBean wsPolicyBean = wsPolicyBeanArray[i];
                    if (!PolicyDeployUtils.urisEquivalent(wsPolicyBean.getUri(), uRI.toString())) continue;
                    if (string.equals(BOTH)) {
                        if (wsPolicyBean.getStatus().equals(ENABLED)) continue;
                        PolicyDeployUtils.removePolicyFromWsdlExtensible(wsdlBindingOperation, uRI);
                        continue;
                    }
                    if (!wsPolicyBean.getStatus().equals(ENABLED)) {
                        if (!string.equals(wsPolicyBean.getDirection())) continue;
                        PolicyDeployUtils.removePolicy(wsdlBindingOperation, uRI, string);
                        continue;
                    }
                    if (string.equals(wsPolicyBean.getDirection())) continue;
                    PolicyDeployUtils.removePolicy(wsdlBindingOperation, uRI, string);
                }
            }
        }
    }

    private static void addPolicies(String string, WsdlPort wsdlPort, String string2) {
        if (string == null || string.equals(BOTH)) {
            PolicyDeployUtils.addPolicyReferenceToWsdlExtensible(wsdlPort, PolicyDeployUtils.getURI(string2));
        } else {
            for (WsdlBindingOperation wsdlBindingOperation : wsdlPort.getBinding().getOperations().values()) {
                if (string.equals(INBOUND)) {
                    PolicyDeployUtils.addPolicyReferenceToWsdlExtensible(wsdlBindingOperation.getInput(), PolicyDeployUtils.getURI(string2));
                    continue;
                }
                if (string.equals(OUTBOUND)) {
                    PolicyDeployUtils.addPolicyReferenceToWsdlExtensible(wsdlBindingOperation.getOutput(), PolicyDeployUtils.getURI(string2));
                    continue;
                }
                throw new AssertionError((Object)("unrecognized value of direction: " + string));
            }
        }
    }

    private static void addPolicies(String string, WsdlBindingOperation wsdlBindingOperation, String string2) {
        if (string == null || string.equals(BOTH)) {
            PolicyDeployUtils.addPolicyReferenceToWsdlExtensible(wsdlBindingOperation, PolicyDeployUtils.getURI(string2));
        } else if (string.equals(INBOUND)) {
            PolicyDeployUtils.addPolicyReferenceToWsdlExtensible(wsdlBindingOperation.getInput(), PolicyDeployUtils.getURI(string2));
        } else if (string.equals(OUTBOUND)) {
            PolicyDeployUtils.addPolicyReferenceToWsdlExtensible(wsdlBindingOperation.getOutput(), PolicyDeployUtils.getURI(string2));
        } else {
            throw new AssertionError((Object)("unrecognized value of direction: " + string));
        }
    }

    public static void writePolicyBeanToStream(EditableDescriptorManager editableDescriptorManager, WebservicePolicyRefBean webservicePolicyRefBean, OutputStream outputStream) throws IOException {
        editableDescriptorManager.writeDescriptorAsXML(((DescriptorBean)webservicePolicyRefBean).getDescriptor(), outputStream);
        outputStream.flush();
        outputStream.close();
    }

    public static void writePolicyBeanToPath(EditableDescriptorManager editableDescriptorManager, WebservicePolicyRefBean webservicePolicyRefBean, String string) throws IOException {
        if (string.endsWith(".war")) {
            PolicyDeployUtils.writePolicyBeanToWar(editableDescriptorManager, webservicePolicyRefBean, string);
        } else if (string.endsWith("jar")) {
            PolicyDeployUtils.writePolicyBeanToEjb(editableDescriptorManager, webservicePolicyRefBean, string);
        } else {
            File file = new File(string);
            PolicyDeployUtils.writePolicyBeanToFile(editableDescriptorManager, webservicePolicyRefBean, file);
        }
    }

    public static void writePolicyBeanToFile(EditableDescriptorManager editableDescriptorManager, WebservicePolicyRefBean webservicePolicyRefBean, File file) throws IOException {
        Object object;
        if (!file.exists() && (object = file.getParentFile()) != null && !((File)object).exists()) {
            ((File)object).mkdirs();
        }
        object = new BufferedOutputStream(new FileOutputStream(file));
        PolicyDeployUtils.writePolicyBeanToStream(editableDescriptorManager, webservicePolicyRefBean, (OutputStream)object);
    }

    public static void writePolicyBeanToWar(EditableDescriptorManager editableDescriptorManager, WebservicePolicyRefBean webservicePolicyRefBean, String string) throws IOException {
        String string2 = ".";
        RandomAccessJarFile randomAccessJarFile = new RandomAccessJarFile(new File(string2), new File(string));
        OutputStream outputStream = randomAccessJarFile.writeEntry("WEB-INF/weblogic-webservices-policy.xml", true);
        PolicyDeployUtils.writePolicyBeanToStream(editableDescriptorManager, webservicePolicyRefBean, outputStream);
        randomAccessJarFile.close();
    }

    public static void writePolicyBeanToEjb(EditableDescriptorManager editableDescriptorManager, WebservicePolicyRefBean webservicePolicyRefBean, String string) throws IOException {
        String string2 = ".";
        RandomAccessJarFile randomAccessJarFile = new RandomAccessJarFile(new File(string2), new File(string));
        OutputStream outputStream = randomAccessJarFile.writeEntry("META-INF/weblogic-webservices-policy.xml", true);
        PolicyDeployUtils.writePolicyBeanToStream(editableDescriptorManager, webservicePolicyRefBean, outputStream);
        randomAccessJarFile.close();
    }

    public static boolean addPolicyToPort(WebservicePolicyRefBean webservicePolicyRefBean, String string, String string2, String string3) {
        return PolicyDeployUtils.addPolicyToPort(webservicePolicyRefBean, string, string2, string3, ENABLED);
    }

    public static boolean addPolicyToPort(WebservicePolicyRefBean webservicePolicyRefBean, Class clazz, String string, String string2, String string3) {
        if (PolicyDeployUtils.destroyOrUpdate(webservicePolicyRefBean, clazz, string, string2, string3)) {
            return true;
        }
        return PolicyDeployUtils.addPolicyToPort(webservicePolicyRefBean, string, string2, string3, ENABLED);
    }

    private static boolean destroyOrUpdate(WebservicePolicyRefBean webservicePolicyRefBean, Class clazz, String string, String string2, String string3) {
        PortPolicyBean[] portPolicyBeanArray = webservicePolicyRefBean.getPortPolicy();
        if (portPolicyBeanArray == null || portPolicyBeanArray.length == 0) {
            return false;
        }
        for (int i = 0; i < portPolicyBeanArray.length; ++i) {
            if (!portPolicyBeanArray[i].getPortName().equals(string) || !PolicyDeployUtils.destroyOrUpdate(portPolicyBeanArray[i], clazz, string2, string3)) continue;
            return true;
        }
        return false;
    }

    private static boolean destroyOrUpdate(PortPolicyBean portPolicyBean, Class clazz, String string, String string2) {
        WsPolicyBean[] wsPolicyBeanArray = portPolicyBean.getWsPolicy();
        if (wsPolicyBeanArray == null || wsPolicyBeanArray.length == 0) {
            return false;
        }
        for (WsPolicyBean wsPolicyBean : wsPolicyBeanArray) {
            if (!wsPolicyBean.getUri().equals(string) || !wsPolicyBean.getStatus().equals(DELETED)) continue;
            ArrayList<String> arrayList = PolicyDeployUtils.getPoliciesFromAnnotatedElement(clazz, Policy.Direction.valueOf((String)string2));
            if (arrayList.contains(string)) {
                portPolicyBean.destroyWsPolicy(wsPolicyBean);
            } else {
                wsPolicyBean.setDirection(string2);
                wsPolicyBean.setStatus(ENABLED);
            }
            return true;
        }
        return false;
    }

    public static boolean addPolicyToPort(WebservicePolicyRefBean webservicePolicyRefBean, String string, String string2, String string3, String string4) {
        WseePolicyBeanValidator.checkDuplicatedPolicyForPort((WebservicePolicyRefBean)webservicePolicyRefBean, (String)string, (String)string2);
        PortPolicyBean[] portPolicyBeanArray = webservicePolicyRefBean.getPortPolicy();
        if (portPolicyBeanArray == null || portPolicyBeanArray.length == 0) {
            PolicyDeployUtils.createPortPolicyBean(webservicePolicyRefBean, string, string2, string3, string4);
        } else {
            for (int i = 0; i < portPolicyBeanArray.length; ++i) {
                if (!portPolicyBeanArray[i].getPortName().equals(string)) continue;
                PolicyDeployUtils.createWsPolicyBean(portPolicyBeanArray[i], string2, string3, string4);
                return true;
            }
            PolicyDeployUtils.createPortPolicyBean(webservicePolicyRefBean, string, string2, string3, string4);
        }
        return true;
    }

    public static boolean addPolicyToPort(WebservicePolicyRefBean webservicePolicyRefBean, String string, String string2) {
        return PolicyDeployUtils.addPolicyToPort(webservicePolicyRefBean, string, string2, BOTH, ENABLED);
    }

    public static boolean addOwsmSecurityPolicyToPort(WebservicePolicyRefBean webservicePolicyRefBean, String string, String string2) {
        if (PolicyDeployUtils.destroyOrUpdate(webservicePolicyRefBean, string, string2)) {
            return true;
        }
        return PolicyDeployUtils.addOwsmSecurityPolicyToPort(webservicePolicyRefBean, string, string2, ENABLED);
    }

    private static boolean destroyOrUpdate(WebservicePolicyRefBean webservicePolicyRefBean, String string, String string2) {
        PortPolicyBean[] portPolicyBeanArray = webservicePolicyRefBean.getPortPolicy();
        if (portPolicyBeanArray == null || portPolicyBeanArray.length == 0) {
            return false;
        }
        for (int i = 0; i < portPolicyBeanArray.length; ++i) {
            if (!portPolicyBeanArray[i].getPortName().equals(string)) continue;
            OwsmSecurityPolicyBean[] owsmSecurityPolicyBeanArray = portPolicyBeanArray[i].getOwsmSecurityPolicy();
            if (owsmSecurityPolicyBeanArray == null || owsmSecurityPolicyBeanArray.length == 0) {
                return false;
            }
            for (OwsmSecurityPolicyBean owsmSecurityPolicyBean : owsmSecurityPolicyBeanArray) {
                if (!owsmSecurityPolicyBean.getUri().equals(string2) || !owsmSecurityPolicyBean.getStatus().equals(DELETED)) continue;
                portPolicyBeanArray[i].destroyOwsmSecurityPolicy(owsmSecurityPolicyBean);
                return true;
            }
        }
        return false;
    }

    public static boolean addOwsmSecurityPolicyToPort(WebservicePolicyRefBean webservicePolicyRefBean, String string, String string2, String string3) {
        WseePolicyBeanValidator.checkDuplicatedOwsmSecurityPolicyForPort((WebservicePolicyRefBean)webservicePolicyRefBean, (String)string, (String)string2);
        PortPolicyBean[] portPolicyBeanArray = webservicePolicyRefBean.getPortPolicy();
        if (portPolicyBeanArray == null || portPolicyBeanArray.length == 0) {
            PolicyDeployUtils.createOwsmPortPolicyBean(webservicePolicyRefBean, string, string2, string3);
        } else {
            for (int i = 0; i < portPolicyBeanArray.length; ++i) {
                if (!portPolicyBeanArray[i].getPortName().equals(string)) continue;
                WsPolicyBean[] wsPolicyBeanArray = portPolicyBeanArray[i].getWsPolicy();
                if (wsPolicyBeanArray != null && wsPolicyBeanArray.length != 0) {
                    for (WsPolicyBean wsPolicyBean : wsPolicyBeanArray) {
                        if (!wsPolicyBean.getStatus().equals(ENABLED)) continue;
                        throw new IllegalArgumentException("OWSM Policy " + string2 + " cannot be attached to port " + string + " due to Ws Policy alreay exist!");
                    }
                }
                PolicyDeployUtils.createOwsmSecurityPolicyBean(portPolicyBeanArray[i], string2, string3);
                return true;
            }
            PolicyDeployUtils.createOwsmPortPolicyBean(webservicePolicyRefBean, string, string2, string3);
        }
        return true;
    }

    public static boolean addPolicyToOperation(WebservicePolicyRefBean webservicePolicyRefBean, Class clazz, String string, String string2, String string3, String string4) {
        if (PolicyDeployUtils.destroyOrUpdate(webservicePolicyRefBean, clazz, string, string2, string3, string4)) {
            return true;
        }
        return PolicyDeployUtils.addPolicyToOperation(webservicePolicyRefBean, string, string2, string3, string4);
    }

    private static boolean destroyOrUpdate(WebservicePolicyRefBean webservicePolicyRefBean, Class clazz, String string, String string2, String string3, String string4) {
        OperationPolicyBean[] operationPolicyBeanArray = webservicePolicyRefBean.getOperationPolicy();
        if (operationPolicyBeanArray == null || operationPolicyBeanArray.length == 0) {
            return false;
        }
        for (int i = 0; i < operationPolicyBeanArray.length; ++i) {
            if (!operationPolicyBeanArray[i].getOperationName().equals(string) || (operationPolicyBeanArray[i].getServiceLink() != null || string4 != null) && !operationPolicyBeanArray[i].getServiceLink().equals(string4) || !PolicyDeployUtils.destroyOrUpdate(operationPolicyBeanArray[i], clazz, string2, string3)) continue;
            return true;
        }
        return false;
    }

    private static boolean destroyOrUpdate(OperationPolicyBean operationPolicyBean, Class clazz, String string, String string2) {
        WsPolicyBean[] wsPolicyBeanArray = operationPolicyBean.getWsPolicy();
        if (wsPolicyBeanArray == null || wsPolicyBeanArray.length == 0) {
            return false;
        }
        for (WsPolicyBean wsPolicyBean : wsPolicyBeanArray) {
            if (!wsPolicyBean.getUri().equals(string) || !wsPolicyBean.getStatus().equals(DELETED)) continue;
            Method method = PolicyDeployUtils.findWebMethodFromService(clazz, operationPolicyBean.getOperationName());
            ArrayList<String> arrayList = PolicyDeployUtils.getPoliciesFromAnnotatedElement(method, Policy.Direction.valueOf((String)string2));
            if (arrayList.contains(string)) {
                operationPolicyBean.destroyWsPolicy(wsPolicyBean);
            } else {
                wsPolicyBean.setDirection(string2);
                wsPolicyBean.setStatus(ENABLED);
            }
            return true;
        }
        return false;
    }

    public static boolean addPolicyToOperation(WebservicePolicyRefBean webservicePolicyRefBean, String string, String string2, String string3, String string4) {
        WseePolicyBeanValidator.checkDuplidatePolicyFroOperation((WebservicePolicyRefBean)webservicePolicyRefBean, (String)string, (String)string2, (String)string3, (String)string4);
        OperationPolicyBean[] operationPolicyBeanArray = webservicePolicyRefBean.getOperationPolicy();
        if (operationPolicyBeanArray == null || operationPolicyBeanArray.length == 0) {
            PolicyDeployUtils.createOperationPolicyBean(webservicePolicyRefBean, string, string2, string3, string4);
        } else {
            for (int i = 0; i < operationPolicyBeanArray.length; ++i) {
                String string5 = operationPolicyBeanArray[i].getOperationName();
                String string6 = operationPolicyBeanArray[i].getServiceLink();
                if ((StringUtil.isEmpty(string6) || !string6.equals(string4)) && !StringUtil.isEmpty(string6) || !string5.equals(string)) continue;
                if (StringUtil.isEmpty(string6)) {
                    operationPolicyBeanArray[i].setServiceLink(string4);
                }
                PolicyDeployUtils.createWsPolicyBean(operationPolicyBeanArray[i], string2, string3);
                return true;
            }
            PolicyDeployUtils.createOperationPolicyBean(webservicePolicyRefBean, string, string2, string3, string4);
        }
        return true;
    }

    public static void removePolicyFromPort(WebservicePolicyRefBean webservicePolicyRefBean, String string, String string2) {
        int n;
        boolean bl = false;
        PortPolicyBean[] portPolicyBeanArray = webservicePolicyRefBean.getPortPolicy();
        for (n = 0; portPolicyBeanArray != null && n < portPolicyBeanArray.length; ++n) {
            if (!portPolicyBeanArray[n].getPortName().equals(string)) continue;
            WsPolicyBean[] wsPolicyBeanArray = portPolicyBeanArray[n].getWsPolicy();
            for (int i = 0; wsPolicyBeanArray != null && i < wsPolicyBeanArray.length; ++i) {
                if (!wsPolicyBeanArray[i].getUri().equals(string2)) continue;
                portPolicyBeanArray[n].destroyWsPolicy(wsPolicyBeanArray[i]);
                bl = true;
            }
        }
        if (!bl) {
            n = 1;
            if (portPolicyBeanArray == null) {
                PolicyDeployUtils.createPortPolicyBean(webservicePolicyRefBean, string, string2, BOTH, DELETED);
            } else {
                for (int i = 0; i < portPolicyBeanArray.length; ++i) {
                    if (!portPolicyBeanArray[i].getPortName().equals(string)) continue;
                    PolicyDeployUtils.createWsPolicyBean(portPolicyBeanArray[i], string2, BOTH, DELETED);
                    return;
                }
                PolicyDeployUtils.createPortPolicyBean(webservicePolicyRefBean, string, string2, BOTH, DELETED);
            }
        }
    }

    public static void removeOwsmSecurityPolicyFromPort(WebservicePolicyRefBean webservicePolicyRefBean, String string, String string2) {
        int n;
        boolean bl = false;
        PortPolicyBean[] portPolicyBeanArray = webservicePolicyRefBean.getPortPolicy();
        for (n = 0; portPolicyBeanArray != null && n < portPolicyBeanArray.length; ++n) {
            if (!portPolicyBeanArray[n].getPortName().equals(string)) continue;
            OwsmSecurityPolicyBean[] owsmSecurityPolicyBeanArray = portPolicyBeanArray[n].getOwsmSecurityPolicy();
            for (int i = 0; owsmSecurityPolicyBeanArray != null && i < owsmSecurityPolicyBeanArray.length; ++i) {
                if (!owsmSecurityPolicyBeanArray[i].getUri().equals(string2)) continue;
                portPolicyBeanArray[n].destroyOwsmSecurityPolicy(owsmSecurityPolicyBeanArray[i]);
                bl = true;
            }
        }
        if (!bl) {
            if (portPolicyBeanArray == null) {
                PolicyDeployUtils.createOwsmPortPolicyBean(webservicePolicyRefBean, string, string2, DELETED);
            } else {
                for (n = 0; n < portPolicyBeanArray.length; ++n) {
                    if (!portPolicyBeanArray[n].getPortName().equals(string)) continue;
                    PolicyDeployUtils.createOwsmSecurityPolicyBean(portPolicyBeanArray[n], string2, DELETED);
                    return;
                }
                PolicyDeployUtils.createOwsmPortPolicyBean(webservicePolicyRefBean, string, string2, DELETED);
            }
        }
    }

    public static void removePolicyFromOperation(WebservicePolicyRefBean webservicePolicyRefBean, String string, String string2) {
        PolicyDeployUtils.removePolicyFromOperation(webservicePolicyRefBean, string, string2, BOTH, null);
    }

    public static void removePolicyFromOperation(WebservicePolicyRefBean webservicePolicyRefBean, String string, String string2, String string3, String string4) {
        Object object;
        String string5;
        int n;
        boolean bl = false;
        OperationPolicyBean[] operationPolicyBeanArray = webservicePolicyRefBean.getOperationPolicy();
        for (n = 0; operationPolicyBeanArray != null && n < operationPolicyBeanArray.length; ++n) {
            String string6 = operationPolicyBeanArray[n].getOperationName();
            string5 = operationPolicyBeanArray[n].getServiceLink();
            if (!StringUtil.isEmpty(string5) && (StringUtil.isEmpty(string5) || !string5.equals(string4) || !string6.equals(string))) continue;
            object = operationPolicyBeanArray[n].getWsPolicy();
            for (int i = 0; object != null && i < ((WsPolicyBean[])object).length; ++i) {
                if (!object[i].getUri().equals(string2) || !string3.equals(BOTH) && !string3.equals(object[i].getDirection())) continue;
                operationPolicyBeanArray[n].destroyWsPolicy((WsPolicyBean)object[i]);
                object = operationPolicyBeanArray[n].getWsPolicy();
                bl = true;
            }
        }
        if (!bl) {
            n = 1;
            if (operationPolicyBeanArray == null || operationPolicyBeanArray.length == 0) {
                PolicyDeployUtils.createOperationPolicyBean(webservicePolicyRefBean, string, string2, string3, string4, n != 0);
            } else {
                for (int i = 0; i < operationPolicyBeanArray.length; ++i) {
                    string5 = operationPolicyBeanArray[i].getOperationName();
                    object = operationPolicyBeanArray[i].getServiceLink();
                    if ((StringUtil.isEmpty((String)object) || !((String)object).equals(string4)) && !StringUtil.isEmpty((String)object) || !string5.equals(string)) continue;
                    if (StringUtil.isEmpty((String)object)) {
                        operationPolicyBeanArray[i].setServiceLink(string4);
                    }
                    PolicyDeployUtils.createWsPolicyBean(operationPolicyBeanArray[i], string2, string3, n != 0);
                    return;
                }
                PolicyDeployUtils.createOperationPolicyBean(webservicePolicyRefBean, string, string2, string3, string4, n != 0);
            }
        }
    }

    public static void embedPoliciesInWsdl(WsdlDefinitions wsdlDefinitions, PolicyServer policyServer) throws PolicyException {
        UsingPolicy usingPolicy = UsingPolicy.narrow(wsdlDefinitions);
        if (usingPolicy == null || !usingPolicy.isSet()) {
            return;
        }
        PolicyWsdlExtension policyWsdlExtension = PolicyDeployUtils.getPolicyWsdlExtension(wsdlDefinitions);
        for (WsdlPortType wsdlElement : wsdlDefinitions.getPortTypes().values()) {
            wsdlElement.setPolicyUris(PolicyDeployUtils.replacePolicyURIs(wsdlElement.getPolicyUris(), policyServer, policyWsdlExtension));
            for (WsdlOperation wsdlOperation : wsdlElement.getOperations().values()) {
                WsdlMessage wsdlMessage;
                wsdlOperation.setPolicyUris(PolicyDeployUtils.replacePolicyURIs(wsdlOperation.getPolicyUris(), policyServer, policyWsdlExtension));
                PolicyDeployUtils.replacePolicyReference(wsdlOperation, policyServer, policyWsdlExtension);
                WsdlMessage wsdlMessage2 = wsdlOperation.getInput();
                if (wsdlMessage2 != null) {
                    wsdlOperation.setInputPolicyUris(PolicyDeployUtils.replacePolicyURIs(wsdlOperation.getInputPolicyUris(), policyServer, policyWsdlExtension));
                }
                if ((wsdlMessage = wsdlOperation.getOutput()) == null) continue;
                wsdlOperation.setOutputPolicyUris(PolicyDeployUtils.replacePolicyURIs(wsdlOperation.getOutputPolicyUris(), policyServer, policyWsdlExtension));
            }
        }
        for (WsdlBinding wsdlBinding : wsdlDefinitions.getBindings().values()) {
            wsdlBinding.setPolicyUris(PolicyDeployUtils.replacePolicyURIs(wsdlBinding.getPolicyUris(), policyServer, policyWsdlExtension));
            PolicyDeployUtils.replacePolicyReference(wsdlBinding, policyServer, policyWsdlExtension);
        }
        for (WsdlMessage wsdlMessage : wsdlDefinitions.getMessages().values()) {
            wsdlMessage.setPolicyUris(PolicyDeployUtils.replacePolicyURIs(wsdlMessage.getPolicyUris(), policyServer, policyWsdlExtension));
            PolicyDeployUtils.replacePolicyReference(wsdlMessage, policyServer, policyWsdlExtension);
        }
        for (WsdlService wsdlService : wsdlDefinitions.getServices().values()) {
            for (WsdlPort wsdlPort : wsdlService.getPorts().values()) {
                wsdlPort.setPolicyUris(PolicyDeployUtils.replacePolicyURIs(wsdlPort.getPolicyUris(), policyServer, policyWsdlExtension));
                PolicyDeployUtils.replacePolicyReference(wsdlPort, policyServer, policyWsdlExtension);
                for (WsdlBindingOperation wsdlBindingOperation : wsdlPort.getBinding().getOperations().values()) {
                    WsdlBindingMessage wsdlBindingMessage;
                    wsdlBindingOperation.setPolicyUris(PolicyDeployUtils.replacePolicyURIs(wsdlBindingOperation.getPolicyUris(), policyServer, policyWsdlExtension));
                    PolicyDeployUtils.replacePolicyReference(wsdlBindingOperation, policyServer, policyWsdlExtension);
                    WsdlBindingMessage wsdlBindingMessage2 = wsdlBindingOperation.getInput();
                    if (wsdlBindingMessage2 != null) {
                        wsdlBindingMessage2.setPolicyUris(PolicyDeployUtils.replacePolicyURIs(wsdlBindingMessage2.getPolicyUris(), policyServer, policyWsdlExtension));
                        PolicyDeployUtils.replacePolicyReference(wsdlBindingMessage2, policyServer, policyWsdlExtension);
                    }
                    if ((wsdlBindingMessage = wsdlBindingOperation.getOutput()) == null) continue;
                    wsdlBindingMessage.setPolicyUris(PolicyDeployUtils.replacePolicyURIs(wsdlBindingMessage.getPolicyUris(), policyServer, policyWsdlExtension));
                    PolicyDeployUtils.replacePolicyReference(wsdlBindingOperation.getOutput(), policyServer, policyWsdlExtension);
                }
            }
        }
    }

    public static boolean isCannedMtomPolicy(PolicyDecl policyDecl) {
        String string;
        if (policyDecl == null) {
            return false;
        }
        if (policyDecl.isBuiltInPolicy() && (string = policyDecl.getPolicyURI().toString()) != null) {
            return string.indexOf("policy:Mtom") >= 0;
        }
        return false;
    }

    private static PolicyWsdlExtension getPolicyWsdlExtension(WsdlDefinitions wsdlDefinitions) {
        PolicyWsdlExtension policyWsdlExtension = (PolicyWsdlExtension)wsdlDefinitions.getExtension("Policy");
        if (policyWsdlExtension == null) {
            policyWsdlExtension = new PolicyWsdlExtension();
            wsdlDefinitions.putExtension(policyWsdlExtension);
        }
        return policyWsdlExtension;
    }

    private static void replacePolicyReference(WsdlExtensible wsdlExtensible, PolicyServer policyServer, PolicyWsdlExtension policyWsdlExtension) throws PolicyException {
        if (wsdlExtensible == null) {
            return;
        }
        PolicyReferenceWsdlExtension policyReferenceWsdlExtension = (PolicyReferenceWsdlExtension)wsdlExtensible.getExtension("PolicyReference");
        if (policyReferenceWsdlExtension == null) {
            return;
        }
        ArrayList arrayList = policyReferenceWsdlExtension.getURIs();
        ArrayList arrayList2 = new ArrayList();
        for (int i = 0; i < arrayList.size(); ++i) {
            URI uRI = (URI)arrayList.get(i);
            PolicyDeployUtils.replaceURI(uRI, policyServer, arrayList2, policyWsdlExtension);
        }
        policyReferenceWsdlExtension.setURIs(arrayList2);
    }

    private static PolicyURIs replacePolicyURIs(PolicyURIs policyURIs, PolicyServer policyServer, PolicyWsdlExtension policyWsdlExtension) throws PolicyException {
        if (policyURIs != null) {
            URI[] uRIArray;
            ArrayList arrayList = new ArrayList();
            for (URI uRI : uRIArray = policyURIs.getURIs()) {
                PolicyDeployUtils.replaceURI(uRI, policyServer, arrayList, policyWsdlExtension);
            }
            return new PolicyURIs(arrayList.toArray(new URI[arrayList.size()]));
        }
        return policyURIs;
    }

    private static void replaceURI(URI uRI, PolicyServer policyServer, ArrayList arrayList, PolicyWsdlExtension policyWsdlExtension) throws PolicyException {
        if ("policy".equals(uRI.getScheme())) {
            PolicyStatement policyStatement = policyServer.getPolicy(uRI.getRawSchemeSpecificPart());
            try {
                URI uRI2 = new URI("#" + policyStatement.getId());
                policyWsdlExtension.addPolicy(policyStatement);
                arrayList.add(uRI2);
            }
            catch (URISyntaxException uRISyntaxException) {
                uRISyntaxException.printStackTrace();
            }
        } else {
            arrayList.add(uRI);
        }
    }

    private static WsPolicyBean createWsPolicyBean(PortPolicyBean portPolicyBean, String string, String string2) {
        return PolicyDeployUtils.createWsPolicyBean(portPolicyBean, string, string2, ENABLED);
    }

    private static WsPolicyBean createWsPolicyBean(PortPolicyBean portPolicyBean, String string, String string2, String string3) {
        WsPolicyBean wsPolicyBean = portPolicyBean.getWsPolicy();
        if (wsPolicyBean != null) {
            for (WsPolicyBean wsPolicyBean2 : wsPolicyBean) {
                if (!wsPolicyBean2.getUri().equals(string)) continue;
                wsPolicyBean2.setStatus(string3);
                if (string3.equals(ENABLED)) {
                    if (string2 != null) {
                        wsPolicyBean2.setDirection(string2);
                    } else {
                        wsPolicyBean2.setDirection(BOTH);
                    }
                }
                return wsPolicyBean2;
            }
        }
        WsPolicyBean wsPolicyBean3 = null;
        try {
            wsPolicyBean3 = portPolicyBean.createWsPolicy();
            wsPolicyBean3.setUri(string);
            if (string2 != null) {
                wsPolicyBean3.setDirection(string2);
            }
            wsPolicyBean3.setStatus(string3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (wsPolicyBean3 != null) {
                portPolicyBean.destroyWsPolicy(wsPolicyBean3);
            }
            throw illegalArgumentException;
        }
        return wsPolicyBean3;
    }

    private static OwsmSecurityPolicyBean createOwsmSecurityPolicyBean(PortPolicyBean portPolicyBean, String string) {
        return PolicyDeployUtils.createOwsmSecurityPolicyBean(portPolicyBean, string, ENABLED);
    }

    private static OwsmSecurityPolicyBean createOwsmSecurityPolicyBean(PortPolicyBean portPolicyBean, String string, String string2) {
        OwsmSecurityPolicyBean owsmSecurityPolicyBean = portPolicyBean.getOwsmSecurityPolicy();
        if (owsmSecurityPolicyBean != null) {
            for (OwsmSecurityPolicyBean owsmSecurityPolicyBean2 : owsmSecurityPolicyBean) {
                if (!owsmSecurityPolicyBean2.getUri().equals(string)) continue;
                owsmSecurityPolicyBean2.setStatus(string2);
                return owsmSecurityPolicyBean2;
            }
        }
        OwsmSecurityPolicyBean owsmSecurityPolicyBean3 = null;
        try {
            owsmSecurityPolicyBean3 = portPolicyBean.createOwsmSecurityPolicy();
            owsmSecurityPolicyBean3.setUri(string);
            owsmSecurityPolicyBean3.setStatus(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (owsmSecurityPolicyBean3 != null) {
                portPolicyBean.destroyOwsmSecurityPolicy(owsmSecurityPolicyBean3);
            }
            throw illegalArgumentException;
        }
        return owsmSecurityPolicyBean3;
    }

    private static WsPolicyBean createWsPolicyBean(OperationPolicyBean operationPolicyBean, String string, String string2) {
        return PolicyDeployUtils.createWsPolicyBean(operationPolicyBean, string, string2, false);
    }

    private static WsPolicyBean createWsPolicyBean(OperationPolicyBean operationPolicyBean, String string, String string2, boolean bl) {
        WsPolicyBean wsPolicyBean = operationPolicyBean.getWsPolicy();
        if (wsPolicyBean != null) {
            for (WsPolicyBean wsPolicyBean2 : wsPolicyBean) {
                if (!wsPolicyBean2.getUri().equals(string)) continue;
                if (!bl) {
                    wsPolicyBean2.setStatus(ENABLED);
                    wsPolicyBean2.setDirection(string2);
                } else if (string2.equals(wsPolicyBean2.getDirection())) {
                    wsPolicyBean2.setStatus(DELETED);
                }
                return wsPolicyBean2;
            }
        }
        WsPolicyBean wsPolicyBean3 = null;
        try {
            wsPolicyBean3 = operationPolicyBean.createWsPolicy();
            wsPolicyBean3.setUri(string);
            if (string2 != null) {
                wsPolicyBean3.setDirection(string2);
            }
            if (bl) {
                wsPolicyBean3.setStatus(DELETED);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (wsPolicyBean3 != null) {
                operationPolicyBean.destroyWsPolicy(wsPolicyBean3);
            }
            throw illegalArgumentException;
        }
        return wsPolicyBean3;
    }

    private static PortPolicyBean createPortPolicyBean(WebservicePolicyRefBean webservicePolicyRefBean, String string, String string2, String string3, String string4) {
        PortPolicyBean portPolicyBean = webservicePolicyRefBean.createPortPolicy();
        portPolicyBean.setPortName(string);
        PolicyDeployUtils.createWsPolicyBean(portPolicyBean, string2, string3, string4);
        return portPolicyBean;
    }

    private static PortPolicyBean createOwsmPortPolicyBean(WebservicePolicyRefBean webservicePolicyRefBean, String string, String string2, String string3) {
        PortPolicyBean portPolicyBean = webservicePolicyRefBean.createPortPolicy();
        portPolicyBean.setPortName(string);
        PolicyDeployUtils.createOwsmSecurityPolicyBean(portPolicyBean, string2, string3);
        return portPolicyBean;
    }

    private static OperationPolicyBean createOperationPolicyBean(WebservicePolicyRefBean webservicePolicyRefBean, String string, String string2, String string3, String string4) {
        return PolicyDeployUtils.createOperationPolicyBean(webservicePolicyRefBean, string, string2, string3, string4, false);
    }

    private static OperationPolicyBean createOperationPolicyBean(WebservicePolicyRefBean webservicePolicyRefBean, String string, String string2, String string3, String string4, boolean bl) {
        OperationPolicyBean operationPolicyBean = webservicePolicyRefBean.createOperationPolicy();
        operationPolicyBean.setOperationName(string);
        operationPolicyBean.setServiceLink(string4);
        PolicyDeployUtils.createWsPolicyBean(operationPolicyBean, string2, string3, bl);
        return operationPolicyBean;
    }

    private static final URI getURI(String string) {
        if (string == null) {
            return null;
        }
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
            return null;
        }
    }

    public static final Method findWebMethodFromService(Class clazz, String string) {
        Method[] methodArray = clazz.getMethods();
        Method[] methodArray2 = PolicyDeployUtils.getSEIMethods(clazz);
        for (Method method : methodArray) {
            if (method.getName().equals(string)) {
                return method;
            }
            WebMethod webMethod = method.getAnnotation(WebMethod.class);
            if (webMethod != null && webMethod.operationName().equals(string)) {
                return method;
            }
            if (!PolicyDeployUtils.matchSEIMethod(method, string, methodArray2)) continue;
            return method;
        }
        throw new IllegalArgumentException("Can't find method " + string + " for service " + clazz.getName());
    }

    static final Method[] getSEIMethods(Class clazz) {
        Method[] methodArray;
        block5: {
            methodArray = null;
            try {
                WebService webService = clazz.getAnnotation(WebService.class);
                if (webService != null && webService.endpointInterface() != null && webService.endpointInterface().length() > 0) {
                    Class clazz2 = clazz.getClassLoader().loadClass(webService.endpointInterface());
                    if (clazz2 == null) {
                        clazz2 = ClassUtil.loadClass(webService.endpointInterface());
                    }
                    if (clazz2 != null) {
                        methodArray = clazz2.getMethods();
                    }
                }
            }
            catch (Exception exception) {
                if (!verbose) break block5;
                Verbose.log("Info: Get Methods failed from SEI: " + exception.toString());
                exception.printStackTrace();
            }
        }
        return methodArray;
    }

    private static final boolean matchSEIMethod(Method method, String string, Method[] methodArray) {
        if (methodArray == null) {
            return false;
        }
        for (Method method2 : methodArray) {
            WebMethod webMethod;
            if (!ClassUtil.equalMethods(method2, method) || (webMethod = method2.getAnnotation(WebMethod.class)) == null || !webMethod.operationName().equals(string)) continue;
            return true;
        }
        return false;
    }
}

