/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.policy.deployment;

import java.util.Iterator;
import weblogic.wsee.policy.deployment.ProviderRegistry;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.provider.PolicyProvider;
import weblogic.wsee.policy.provider.ServiceConfigurationHandler;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.init.WsDeploymentContext;
import weblogic.wsee.ws.init.WsDeploymentException;
import weblogic.wsee.ws.init.WsDeploymentListener;

public class PolicyDeploymentListener
implements WsDeploymentListener {
    private static final boolean verbose = Verbose.isVerbose(PolicyDeploymentListener.class);

    public void process(WsDeploymentContext wsDeploymentContext) throws WsDeploymentException {
        if (verbose) {
            Verbose.log("PolicyDeploymentListener.process()");
        }
        PolicyDeploymentListener.invokeProviderConfig(wsDeploymentContext);
    }

    private static void invokeProviderConfig(WsDeploymentContext wsDeploymentContext) throws WsDeploymentException {
        ProviderRegistry providerRegistry = null;
        try {
            providerRegistry = ProviderRegistry.getTheRegistry();
        }
        catch (PolicyException policyException) {
            throw new WsDeploymentException("Could not obtain the policy provider registry", policyException);
        }
        if (providerRegistry == null || providerRegistry.isEmpty()) {
            return;
        }
        Iterator iterator = providerRegistry.iterateProviders();
        while (iterator.hasNext()) {
            ServiceConfigurationHandler serviceConfigurationHandler = ((PolicyProvider)iterator.next()).getServiceConfigHandler();
            if (serviceConfigurationHandler == null) continue;
            try {
                serviceConfigurationHandler.process(wsDeploymentContext);
            }
            catch (PolicyException policyException) {
                throw new WsDeploymentException("Could not process Policy", policyException);
            }
        }
    }
}

