/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.policy.deployment;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weblogic.wsee.policy.deployment.PolicyRef;
import weblogic.wsee.policy.deployment.ProviderRegistry;
import weblogic.wsee.policy.framework.DOMUtils;
import weblogic.wsee.policy.framework.OperatorType;
import weblogic.wsee.policy.framework.PolicyAssertion;
import weblogic.wsee.policy.framework.PolicyAssertionFactory;
import weblogic.wsee.policy.framework.PolicyConstants;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.framework.PolicyExpression;
import weblogic.wsee.policy.framework.PolicyStatement;
import weblogic.wsee.policy.provider.PolicyProvider;
import weblogic.wsee.policy.provider.PolicyValidationHandler;
import weblogic.wsee.policy.runtime.PolicyServer;
import weblogic.wsee.policy.util.PolicyHelper;

public class PolicyLoader {
    private static final boolean debug = false;
    private ProviderRegistry providerRegistry;
    private Map embeddedStatements = new HashMap();
    private boolean haveForwardReferences = false;
    private PolicyServer ps;

    public PolicyLoader(ProviderRegistry providerRegistry) {
        this(providerRegistry, null);
    }

    public PolicyLoader(ProviderRegistry providerRegistry, PolicyServer policyServer) {
        assert (providerRegistry != null);
        this.providerRegistry = providerRegistry;
        this.ps = policyServer;
    }

    public PolicyStatement load(Document document) throws PolicyException {
        Element element = document.getDocumentElement();
        return this.load(element);
    }

    public PolicyStatement load(Node node) throws PolicyException {
        PolicyStatement policyStatement = this.readPolicyStatement(node);
        if (this.haveForwardReferences) {
            this.resolveForwardRefs(policyStatement);
        }
        return policyStatement;
    }

    public boolean validate(String string, PolicyStatement policyStatement) throws PolicyException {
        Iterator iterator = this.providerRegistry.iterateProviders();
        while (iterator.hasNext()) {
            PolicyProvider policyProvider = (PolicyProvider)iterator.next();
            PolicyValidationHandler policyValidationHandler = policyProvider.getValidationHandler();
            if (policyValidationHandler == null) continue;
            policyValidationHandler.validate(string, policyStatement);
        }
        return true;
    }

    private PolicyStatement readPolicyStatement(Node node) throws PolicyException {
        boolean bl;
        assert (node.getNodeType() == 1);
        Element element = (Element)node;
        String string = element.getNamespaceURI();
        boolean bl2 = bl = DOMUtils.equalsQName(element, PolicyConstants.POLICY_INCLUDE) || DOMUtils.equalsQName(element, PolicyConstants.POLICY_INCLUDE_15);
        if (bl) {
            PolicyStatement policyStatement = PolicyStatement.createPolicyStatement(null);
            policyStatement.setPolicyNamespaceUri(string);
            PolicyExpression policyExpression = this.readExpression(element);
            policyStatement.addExpression(policyExpression);
            return policyStatement;
        }
        String string2 = DOMUtils.getAttributeValueAsString(element, PolicyConstants.POLICY_STATEMENT_ID_ATTRIBUTE);
        PolicyStatement policyStatement = PolicyStatement.createPolicyStatement(string2);
        policyStatement.setPolicyNamespaceUri(string);
        if (string2 != null && string2.length() > 0 && this.embeddedStatements.get(string2) == null) {
            this.embeddedStatements.put(string2, policyStatement);
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            PolicyExpression policyExpression = this.readExpression((Element)node2);
            policyStatement.addExpression(policyExpression);
        }
        return policyStatement;
    }

    private PolicyExpression readExpression(Element element) throws PolicyException {
        if (element == null) {
            return null;
        }
        PolicyExpression policyExpression = null;
        boolean bl = PolicyHelper.hasWsp15NamespaceUri(element);
        policyExpression = PolicyConstants.ALL.getLocalPart().equals(element.getLocalName()) ? this.readAllExpression(element) : (PolicyConstants.ONE_OR_MORE.getLocalPart().equals(element.getLocalName()) ? this.readOneOrMoreExpression(element) : (PolicyConstants.EXACTLY_ONE.getLocalPart().equals(element.getLocalName()) ? this.readExactlyOneExpression(element) : (PolicyConstants.POLICY_INCLUDE.getLocalPart().equals(element.getLocalName()) ? this.readPolicyIncludeExpression(element) : (PolicyConstants.POLICY_STATEMENT_ELEMENT.getLocalPart().equals(element.getLocalName()) ? this.readPolicyStatement(element) : this.readAssertionExpression(element)))));
        if (policyExpression == null) {
            throw new PolicyException("Unrecognized element in policy expression: " + element);
        }
        if (bl) {
            policyExpression.setPolicyNamespaceUri("http://www.w3.org/ns/ws-policy");
        } else {
            policyExpression.setPolicyNamespaceUri("http://schemas.xmlsoap.org/ws/2004/09/policy");
        }
        return policyExpression;
    }

    private PolicyExpression readAllExpression(Element element) throws PolicyException {
        PolicyExpression policyExpression = PolicyExpression.createExpression(OperatorType.ALL);
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            policyExpression.addExpression(this.readExpression((Element)node));
        }
        return policyExpression;
    }

    private PolicyExpression readOneOrMoreExpression(Element element) throws PolicyException {
        PolicyExpression policyExpression = PolicyExpression.createExpression(OperatorType.ONE_OR_MORE);
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            policyExpression.addExpression(this.readExpression((Element)node));
        }
        return policyExpression;
    }

    private PolicyExpression readExactlyOneExpression(Element element) throws PolicyException {
        PolicyExpression policyExpression = PolicyExpression.createExpression(OperatorType.EXACTLY_ONE);
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            policyExpression.addExpression(this.readExpression((Element)node));
        }
        return policyExpression;
    }

    private PolicyExpression readPolicyIncludeExpression(Element element) throws PolicyException {
        QName qName = DOMUtils.getAttributeValueAsQName(element, PolicyConstants.POLICY_INCLUDE_QNAME_REF_ATTRIBUTE);
        if (qName != null) {
            // empty if block
        }
        URI uRI = null;
        try {
            uRI = DOMUtils.getAttributeValueAsURI(element, PolicyConstants.POLICY_INCLUDE_URI_REF_ATTRIBUTE);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new PolicyException(uRISyntaxException);
        }
        if (uRI == null) {
            throw new PolicyException("PolicyReference element must contain a URI attribute");
        }
        byte[] byArray = DOMUtils.getAttributeValueAsByteArray(element, PolicyConstants.POLICY_INCLUDE_DIGEST_ATTRIBUTE);
        QName qName2 = DOMUtils.getAttributeValueAsQName(element, PolicyConstants.POLICY_INCLUDE_DIGEST_ALGORITHM_ATTRIBUTE);
        if (PolicyLoader.isInternalRef(uRI)) {
            String string = uRI.getRawFragment();
            assert (string != null);
            PolicyStatement policyStatement = (PolicyStatement)this.embeddedStatements.get(string);
            if (policyStatement == null) {
                policyStatement = new ForwardRef(string);
                this.haveForwardReferences = true;
            }
            return policyStatement;
        }
        PolicyRef policyRef = new PolicyRef(null, uRI, byArray, qName2);
        return policyRef.getPolicy(this.ps, false);
    }

    private static boolean isInternalRef(URI uRI) {
        return uRI.toString().trim().startsWith("#");
    }

    private PolicyExpression readAssertionExpression(Node node) throws PolicyException {
        PolicyExpression policyExpression = null;
        PolicyAssertion policyAssertion = this.readAssertionElement(node);
        policyExpression = PolicyExpression.createTerminal(policyAssertion);
        PolicyHelper.setPolicyExpressionNs(policyExpression, node);
        return policyExpression;
    }

    private PolicyAssertion readAssertionElement(Node node) throws PolicyException {
        Iterator iterator = this.providerRegistry.iterateProviders();
        PolicyAssertion policyAssertion = null;
        while (iterator.hasNext()) {
            PolicyProvider policyProvider = (PolicyProvider)iterator.next();
            PolicyAssertionFactory policyAssertionFactory = policyProvider.getAssertionFactory();
            policyAssertion = policyAssertionFactory.createAssertion(node);
            if (policyAssertion == null) continue;
            Boolean bl = PolicyHelper.getOptionalBoolean((Element)node);
            if (null == bl) break;
            policyAssertion.setOptional(bl);
            String string = PolicyHelper.getOptionalPolicyNamespaceUri((Element)node);
            if (null == string) break;
            policyAssertion.setPolicyNamespaceUri(string);
            break;
        }
        return policyAssertion;
    }

    private void resolveForwardRefs(PolicyExpression policyExpression) throws PolicyException {
        List list = policyExpression.getExpressions();
        if (list == null) {
            return;
        }
        ListIterator<PolicyStatement> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            PolicyExpression policyExpression2 = (PolicyExpression)listIterator.next();
            if (policyExpression2 instanceof ForwardRef) {
                ForwardRef forwardRef = (ForwardRef)policyExpression2;
                PolicyStatement policyStatement = (PolicyStatement)this.embeddedStatements.get(forwardRef.getId());
                if (policyStatement == null) {
                    throw new PolicyException("Could not resolve reference to policy statement '" + forwardRef.getId() + "'");
                }
                listIterator.set(policyStatement);
                continue;
            }
            this.resolveForwardRefs(policyExpression2);
        }
    }

    public static DocumentBuilder getParser() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            return documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new AssertionError((Object)parserConfigurationException);
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new AssertionError((Object)factoryConfigurationError);
        }
    }

    private static class ForwardRef
    extends PolicyStatement {
        public ForwardRef(String string) {
            super(string);
        }
    }
}

