/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.policy.deployment;

import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import weblogic.wsee.policy.deployment.PolicyLoader;
import weblogic.wsee.policy.deployment.ProviderRegistry;
import weblogic.wsee.policy.framework.ExternalizationUtils;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyConstants;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.framework.PolicyStatement;
import weblogic.wsee.policy.runtime.PolicyServer;
import weblogic.wsee.util.Verbose;
import weblogic.xml.babel.stream.ExclusiveCanonicalWriter;
import weblogic.xml.babel.stream.XMLOutputStreamBase;
import weblogic.xml.babel.stream.XMLWriter;
import weblogic.xml.crypto.wss.Base64Encoding;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLInputStreamFactory;
import weblogic.xml.stream.XMLStreamException;

public class PolicyRef
implements Externalizable {
    protected String refName;
    protected PolicyStatement reffedPolicy;
    protected NormalizedExpression normalizedPolicy;
    private static final boolean verbose = Verbose.isVerbose(PolicyRef.class);
    private static final boolean loadPolicyFromClassPath = Boolean.getBoolean("weblogic.wsee.policy.LoadFromClassPathEnabled");
    public static final boolean debug = false;
    protected URI uri;
    byte[] digest;
    QName digestAlg;

    PolicyRef(String string, URI uRI, byte[] byArray, QName qName) {
        assert (uRI != null);
        if (string == null || string.length() == 0) {
            string = uRI.getFragment();
        }
        this.refName = string;
        this.uri = uRI;
        if (byArray == null ? !$assertionsDisabled && qName != null : !$assertionsDisabled && !PolicyConstants.SHA1.equals(qName)) {
            throw new AssertionError();
        }
        this.digestAlg = qName;
        this.digest = byArray;
    }

    PolicyRef(String string, URI uRI) {
        this(string, uRI, null, null);
    }

    PolicyRef(String string, URI uRI, PolicyStatement policyStatement) {
        this.refName = string;
        this.uri = uRI;
        this.reffedPolicy = policyStatement;
    }

    public PolicyRef() {
    }

    public String getRefName() {
        return this.refName;
    }

    public NormalizedExpression getNormalizedPolicy(PolicyServer policyServer, boolean bl) throws PolicyException {
        if (this.normalizedPolicy == null) {
            this.normalizedPolicy = this.getPolicy(policyServer, bl).normalize();
        }
        return this.normalizedPolicy;
    }

    public NormalizedExpression getNormalizedPolicy() throws PolicyException {
        return this.getNormalizedPolicy(null, false);
    }

    protected static boolean nullableEqual(Object object, Object object2) {
        return object == null && object2 == null || object != null && object2 != null && object.equals(object2);
    }

    public PolicyStatement getPolicy(PolicyServer policyServer, boolean bl) throws PolicyException {
        if (this.reffedPolicy == null) {
            assert (this.uri != null);
            String string = this.uri.getScheme();
            if (string != null && string.equals("policy")) {
                if (policyServer == null) {
                    throw new PolicyException("Can not retrieve policy from the static wsdl, you must initialize the service from a dynamic wsdl");
                }
                this.reffedPolicy = policyServer.getPolicy(this.uri.getSchemeSpecificPart(), bl);
            } else {
                if (this.reffedPolicy == null && policyServer != null) {
                    try {
                        this.reffedPolicy = policyServer.getPolicy(this.uri.toString(), bl);
                    }
                    catch (PolicyException policyException) {
                        // empty catch block
                    }
                }
                if (this.reffedPolicy == null && policyServer != null) {
                    this.reffedPolicy = policyServer.getPolicyFromCache(this.uri.getFragment());
                    if (this.reffedPolicy == null) {
                        this.reffedPolicy = policyServer.getPolicyFromCache(this.uri.toString());
                    }
                }
                if (this.reffedPolicy == null) {
                    InputStream inputStream = null;
                    try {
                        inputStream = PolicyRef.getInputStreamFromURI(this.uri);
                    }
                    catch (IOException iOException) {
                        throw new PolicyException("Problem reading policy from URI " + this.uri, iOException);
                    }
                    if (inputStream == null) {
                        throw new PolicyException("Unable to to retrieve policy from URI '" + this.uri + "'");
                    }
                    this.reffedPolicy = PolicyRef.parsePolicy(inputStream, this.digest);
                }
            }
            if (this.reffedPolicy == null) {
                throw new PolicyException("Can not find policy: " + this.uri);
            }
        }
        return this.reffedPolicy;
    }

    public PolicyStatement getPolicy() throws PolicyException {
        return this.getPolicy(null, false);
    }

    public URI getURI() {
        return this.uri;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        PolicyRef policyRef = null;
        try {
            policyRef = (PolicyRef)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return PolicyRef.nullableEqual(this.refName, policyRef.refName) && PolicyRef.nullableEqual(this.uri, policyRef.uri);
    }

    public int hashCode() {
        if (this.refName != null) {
            int n = this.refName.hashCode();
            if (this.uri != null) {
                n ^= this.uri.hashCode();
            }
            return n;
        }
        return this.uri.hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[Policy Ref name = " + this.refName + ", uri = " + this.uri + "]");
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }

    private static PolicyStatement parsePolicy(InputStream inputStream, byte[] byArray) throws PolicyException {
        PolicyLoader policyLoader = new PolicyLoader(ProviderRegistry.getTheRegistry());
        DocumentBuilder documentBuilder = PolicyLoader.getParser();
        Document document = null;
        try {
            document = documentBuilder.parse(inputStream);
        }
        catch (Exception exception) {
            throw new PolicyException("Problem parsing policy XML", exception);
        }
        if (byArray != null) {
            PolicyRef.verifyDigest(document, byArray);
        }
        return policyLoader.load(document.getDocumentElement());
    }

    private static void verifyDigest(Document document, byte[] byArray) throws PolicyException {
        Object object;
        DigestOutputStream digestOutputStream = null;
        try {
            digestOutputStream = new DigestOutputStream(null, MessageDigest.getInstance("SHA-1"));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError((Object)noSuchAlgorithmException);
        }
        ExclusiveCanonicalWriter exclusiveCanonicalWriter = new ExclusiveCanonicalWriter((Writer)new OutputStreamWriter(digestOutputStream));
        try {
            object = XMLInputStreamFactory.newInstance();
            XMLInputStream xMLInputStream = object.newInputStream(document);
            xMLInputStream.skip(2);
            xMLInputStream.next();
            XMLOutputStreamBase xMLOutputStreamBase = new XMLOutputStreamBase((XMLWriter)exclusiveCanonicalWriter);
            xMLOutputStreamBase.add(xMLInputStream.getSubStream());
        }
        catch (XMLStreamException xMLStreamException) {
            throw new PolicyException("Problem verifying document", xMLStreamException);
        }
        object = digestOutputStream.getMessageDigest().digest();
        if (!MessageDigest.isEqual(byArray, (byte[])object)) {
            if (verbose) {
                Verbose.log("declared digest =" + new Base64Encoding().encode(byArray));
                Verbose.log("Computed digest = " + new Base64Encoding().encode((byte[])object));
            }
            throw new PolicyException("Message digest not verified");
        }
    }

    private static InputStream getInputStreamFromURI(URI uRI) throws IOException {
        InputStream inputStream = null;
        String string = uRI.getScheme();
        if (string == null) {
            File file = new File(uRI.toString());
            if (file.exists()) {
                inputStream = new FileInputStream(file);
            } else if (loadPolicyFromClassPath) {
                if (verbose) {
                    Verbose.log("Looking up resource '" + uRI.toString() + "' via ClassLoader " + PolicyRef.getClassLoader().getClass());
                }
                inputStream = PolicyRef.getClassLoader().getResourceAsStream(uRI.toString());
            }
        } else {
            inputStream = uRI.toURL().openConnection().getInputStream();
        }
        return inputStream;
    }

    private static ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = PolicyRef.class.getClassLoader();
        }
        return classLoader;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.refName = objectInput.readUTF();
        this.reffedPolicy = ExternalizationUtils.readPolicyStatement(objectInput);
        this.normalizedPolicy = ExternalizationUtils.readNormalizedExpression(objectInput);
        this.uri = (URI)objectInput.readObject();
        this.digestAlg = ExternalizationUtils.readQName(objectInput);
        this.digest = ExternalizationUtils.readByteArray(objectInput);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeUTF(this.refName);
        ExternalizationUtils.writePolicyStatement(this.reffedPolicy, objectOutput);
        ExternalizationUtils.writeNormalizedExpression(this.normalizedPolicy, objectOutput);
        objectOutput.writeObject(this.uri);
        ExternalizationUtils.writeQName(this.digestAlg, objectOutput);
        if (this.digest == null) {
            objectOutput.writeInt(0);
        } else {
            objectOutput.writeInt(this.digest.length);
            objectOutput.write(this.digest);
        }
    }
}

