/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.policy.deployment;

import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.w3c.dom.Element;
import weblogic.wsee.policy.deployment.PolicyRefFactory;
import weblogic.wsee.policy.deployment.PolicyURIs;
import weblogic.wsee.policy.deployment.PolicyWsdlExtension;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.framework.PolicyStatement;
import weblogic.wsee.policy.runtime.PolicyServer;
import weblogic.wsee.policy.util.PolicyHelper;
import weblogic.wsee.wsdl.WsdlExtension;
import weblogic.wsee.wsdl.WsdlUtils;
import weblogic.wsee.wsdl.WsdlWriter;

public class PolicyReferenceWsdlExtension
implements WsdlExtension {
    private ArrayList URIs = new ArrayList();

    public void addURI(URI uRI) {
        this.URIs.add(uRI);
    }

    public void removeURI(URI uRI) {
        this.URIs.remove(uRI);
    }

    public ArrayList getURIs() {
        return this.URIs;
    }

    public void setURIs(ArrayList arrayList) {
        this.URIs = arrayList;
    }

    public String getKey() {
        return "PolicyReference";
    }

    public void write(Element element, WsdlWriter wsdlWriter) {
        String string = PolicyHelper.hasWsp15NamespaceUri(element) ? "http://www.w3.org/ns/ws-policy" : "http://schemas.xmlsoap.org/ws/2004/09/policy";
        Element element2 = wsdlWriter.addChild(element, "Policy", string);
        for (URI uRI : this.URIs) {
            if (null == uRI || uRI.toString() == null || uRI.toString().trim().length() == 0) continue;
            Element element3 = wsdlWriter.addChild(element2, "PolicyReference", string);
            wsdlWriter.setAttribute(element3, "URI", null, PolicyURIs.replaceURIWithId(uRI, wsdlWriter));
        }
    }

    public NormalizedExpression getEffectivePolicy(Map map) throws PolicyException {
        return this.getEffectivePolicy(null, map);
    }

    public NormalizedExpression getEffectivePolicy(PolicyServer policyServer, Map map) throws PolicyException {
        PolicyRefFactory policyRefFactory = new PolicyRefFactory(map);
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (URI uRI : this.URIs) {
            if (null == uRI || uRI.toString() == null || uRI.toString().trim().length() == 0) continue;
            PolicyStatement policyStatement = policyRefFactory.createPolicyRef(null, uRI).getPolicy(policyServer, false);
            WsdlUtils.addPolicyToMap(linkedHashMap, policyStatement);
        }
        return PolicyWsdlExtension.getEffectivePolicy(linkedHashMap);
    }
}

