/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.policy.deployment;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;
import weblogic.utils.StringUtils;
import weblogic.wsee.deploy.WsdlAddressInfo;
import weblogic.wsee.policy.framework.PolicyStatement;
import weblogic.wsee.policy.util.PolicyHelper;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.wsdl.WsdlWriter;

public class PolicyURIs {
    private static final boolean verbose = Verbose.isVerbose(PolicyURIs.class);
    private static final boolean debug = false;
    private static boolean attachPolicyToWsdl = true;
    private Map knownURIs = new HashMap();

    public PolicyURIs(URI uRI) {
        this.addURI(uRI);
    }

    public PolicyURIs(URI[] uRIArray) {
        for (URI uRI : uRIArray) {
            this.addURI(uRI);
        }
    }

    public PolicyURIs(String string) throws URISyntaxException {
        assert (string != null && string.length() > 0);
        String[] stringArray = StringUtils.splitCompletely((String)string, (String)", \t\n");
        assert (stringArray.length > 0);
        for (int i = 0; i < stringArray.length; ++i) {
            URI uRI = new URI(stringArray[i]);
            this.addURI(uRI);
        }
    }

    public PolicyURIs(String[] stringArray) throws URISyntaxException {
        assert (stringArray != null && stringArray.length > 0);
        for (int i = 0; i < stringArray.length; ++i) {
            URI uRI = new URI(stringArray[i]);
            this.addURI(uRI);
        }
    }

    public URI[] getURIs() {
        return this.knownURIs.values().toArray(new URI[0]);
    }

    public void addURI(URI uRI) {
        this.knownURIs.put(uRI, uRI);
    }

    public void removeURI(URI uRI) {
        this.knownURIs.remove(uRI);
    }

    public String getKey() {
        return "PolicyURIs";
    }

    public void write(Element element, WsdlWriter wsdlWriter) {
        if (this.knownURIs == null || this.knownURIs.size() == 0) {
            return;
        }
        WsdlAddressInfo wsdlAddressInfo = wsdlWriter.getWsdlAddressInfo();
        String string = PolicyHelper.hasWsp15NamespaceUri(element) ? "http://www.w3.org/ns/ws-policy" : "http://schemas.xmlsoap.org/ws/2004/09/policy";
        wsdlWriter.createPrefix(string);
        wsdlWriter.setAttribute(element, "PolicyURIs", string, attachPolicyToWsdl ? this.replaceURIsWithId(wsdlWriter) : this.replaceURIsWithHostAndPort(wsdlAddressInfo));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        URI[] uRIArray = this.getURIs();
        stringBuffer.append(uRIArray[0]);
        for (int i = 1; i < uRIArray.length; ++i) {
            stringBuffer.append(" ");
            stringBuffer.append(uRIArray[i].toString());
        }
        return stringBuffer.toString();
    }

    private String replaceURIsWithHostAndPort(WsdlAddressInfo wsdlAddressInfo) {
        URI[] uRIArray = this.getURIs();
        if (wsdlAddressInfo == null) {
            return this.toString();
        }
        String string = wsdlAddressInfo.getPolicyURL();
        String string2 = PolicyURIs.replaceURIHostAndPort(uRIArray[0], string);
        if (verbose) {
            Verbose.log("replace policy uri:  " + uRIArray[0].toString() + " by  " + string2);
        }
        for (int i = 1; i < uRIArray.length; ++i) {
            string2 = string2 + " ";
            string2 = string2 + PolicyURIs.replaceURIHostAndPort(uRIArray[i], string);
        }
        return string2;
    }

    private static String replaceURIHostAndPort(URI uRI, String string) {
        if (uRI.getScheme() == null || !uRI.getScheme().equals("policy")) {
            return uRI.toString();
        }
        return string + uRI.getSchemeSpecificPart();
    }

    private String replaceURIsWithId(WsdlWriter wsdlWriter) {
        URI[] uRIArray = this.getURIs();
        if (uRIArray == null) {
            return null;
        }
        String string = PolicyURIs.replaceURIWithId(uRIArray[0], wsdlWriter);
        if (verbose) {
            Verbose.log("replace policy uri:  " + uRIArray[0].toString() + " by  " + string);
        }
        for (int i = 1; i < uRIArray.length; ++i) {
            string = string + " ";
            string = string + PolicyURIs.replaceURIWithId(uRIArray[i], wsdlWriter);
        }
        return string;
    }

    protected static String replaceURIWithId(URI uRI, WsdlWriter wsdlWriter) {
        Map map = wsdlWriter.getAttachedPolices();
        String string = uRI.getScheme();
        String string2 = uRI.getSchemeSpecificPart();
        if (string != null && string.equals("policy")) {
            PolicyStatement policyStatement = (PolicyStatement)map.get(string2);
            if (policyStatement != null) {
                return "#" + policyStatement.getId();
            }
            WsdlAddressInfo wsdlAddressInfo = wsdlWriter.getWsdlAddressInfo();
            if (wsdlAddressInfo != null) {
                String string3 = wsdlAddressInfo.getPolicyURL();
                return PolicyURIs.replaceURIHostAndPort(uRI, string3);
            }
        }
        return uRI.toString();
    }
}

