/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.policy.deployment;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;
import weblogic.wsee.policy.deployment.PolicyRef;
import weblogic.wsee.policy.deployment.PolicyRefFactory;
import weblogic.wsee.policy.deployment.PolicyURIs;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.framework.PolicyMath;
import weblogic.wsee.policy.framework.PolicyStatement;
import weblogic.wsee.policy.runtime.PolicyServer;
import weblogic.wsee.wsdl.WsdlExtension;
import weblogic.wsee.wsdl.WsdlUtils;
import weblogic.wsee.wsdl.WsdlWriter;

public class PolicyWsdlExtension
implements WsdlExtension {
    private Map policies = new HashMap();

    public void addPolicy(PolicyStatement policyStatement) {
        WsdlUtils.addPolicyToMap(this.policies, policyStatement);
    }

    public void addAllPolicies(Map map) {
        this.policies.putAll(map);
    }

    public boolean policyExists(PolicyStatement policyStatement) {
        return WsdlUtils.policyExists(this.policies, policyStatement);
    }

    public boolean hasPolicies() {
        return this.policies.size() > 0;
    }

    public Map getPolicies() {
        return this.policies;
    }

    public String getKey() {
        return "Policy";
    }

    public void write(Element element, WsdlWriter wsdlWriter) {
        wsdlWriter.setAttachedPolices(this.getPolicies());
        for (PolicyStatement policyStatement : this.getPolicies().values()) {
            policyStatement.write(element, wsdlWriter);
        }
    }

    public static NormalizedExpression getEffectivePolicy(Map map) throws PolicyException {
        NormalizedExpression normalizedExpression = NormalizedExpression.createUnitializedExpression();
        if (map != null) {
            for (PolicyStatement policyStatement : map.values()) {
                normalizedExpression = PolicyMath.merge(normalizedExpression, policyStatement.normalize());
            }
        }
        return normalizedExpression;
    }

    public static NormalizedExpression getEffectivePolicy(PolicyServer policyServer, Map map, PolicyURIs policyURIs) throws PolicyException {
        NormalizedExpression normalizedExpression = NormalizedExpression.createUnitializedExpression();
        if (policyURIs != null) {
            PolicyRefFactory policyRefFactory = new PolicyRefFactory(map);
            URI[] uRIArray = policyURIs.getURIs();
            for (int i = 0; i < uRIArray.length; ++i) {
                PolicyRef policyRef = policyRefFactory.createPolicyRef(null, uRIArray[i]);
                normalizedExpression = PolicyMath.merge(normalizedExpression, policyRef.getNormalizedPolicy(policyServer, false));
            }
        }
        return normalizedExpression;
    }
}

