/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.policy.deployment;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weblogic.wsee.policy.deployment.PolicyLoader;
import weblogic.wsee.policy.deployment.PolicyReferenceWsdlExtension;
import weblogic.wsee.policy.deployment.PolicyWsdlExtension;
import weblogic.wsee.policy.deployment.ProviderRegistry;
import weblogic.wsee.policy.deployment.UsingPolicy;
import weblogic.wsee.policy.framework.DOMUtils;
import weblogic.wsee.policy.framework.PolicyConstants;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.framework.PolicyStatement;
import weblogic.wsee.wsdl.WsdlBinding;
import weblogic.wsee.wsdl.WsdlBindingMessage;
import weblogic.wsee.wsdl.WsdlBindingOperation;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlExtensible;
import weblogic.wsee.wsdl.WsdlExtension;
import weblogic.wsee.wsdl.WsdlExtensionParser;
import weblogic.wsee.wsdl.WsdlMessage;
import weblogic.wsee.wsdl.WsdlOperation;
import weblogic.wsee.wsdl.WsdlPort;
import weblogic.wsee.wsdl.WsdlReader;
import weblogic.wsee.wsdl.WsdlService;

public class PolicyWsdlExtensionParser
implements WsdlExtensionParser {
    private PolicyLoader policyLoader = this.createPolicyLoader();

    public WsdlExtension parseMessage(WsdlMessage wsdlMessage, Element element) throws WsdlException {
        Element[] elementArray = null;
        elementArray = PolicyWsdlExtensionParser.getPolicyReferenceExtensionElement(element);
        if (elementArray != null) {
            return this.addPolicyReferenceWsdlExtension(wsdlMessage, elementArray);
        }
        if (PolicyWsdlExtensionParser.isPolicyExtensionElement(element)) {
            return this.addPolicyWsdlExtension(wsdlMessage, element);
        }
        return null;
    }

    public WsdlExtension parseOperation(WsdlOperation wsdlOperation, Element element) throws WsdlException {
        Element[] elementArray = null;
        elementArray = PolicyWsdlExtensionParser.getPolicyReferenceExtensionElement(element);
        if (elementArray != null) {
            return this.addPolicyReferenceWsdlExtension(wsdlOperation, elementArray);
        }
        if (PolicyWsdlExtensionParser.isPolicyExtensionElement(element)) {
            return this.addPolicyWsdlExtension(wsdlOperation, element);
        }
        return null;
    }

    public WsdlExtension parseBinding(WsdlBinding wsdlBinding, Element element) throws WsdlException {
        Element[] elementArray = null;
        elementArray = PolicyWsdlExtensionParser.getPolicyReferenceExtensionElement(element);
        if (elementArray != null) {
            return this.addPolicyReferenceWsdlExtension(wsdlBinding, elementArray);
        }
        if (PolicyWsdlExtensionParser.isPolicyExtensionElement(element)) {
            return this.addPolicyWsdlExtension(wsdlBinding, element);
        }
        return null;
    }

    public WsdlExtension parseBindingOperation(WsdlBindingOperation wsdlBindingOperation, Element element) throws WsdlException {
        Element[] elementArray = null;
        elementArray = PolicyWsdlExtensionParser.getPolicyReferenceExtensionElement(element);
        if (elementArray != null) {
            return this.addPolicyReferenceWsdlExtension(wsdlBindingOperation, elementArray);
        }
        if (PolicyWsdlExtensionParser.isPolicyExtensionElement(element)) {
            return this.addPolicyWsdlExtension(wsdlBindingOperation, element);
        }
        return null;
    }

    public WsdlExtension parseBindingMessage(WsdlBindingMessage wsdlBindingMessage, Element element) throws WsdlException {
        Element[] elementArray = null;
        elementArray = PolicyWsdlExtensionParser.getPolicyReferenceExtensionElement(element);
        if (elementArray != null) {
            return this.addPolicyReferenceWsdlExtension(wsdlBindingMessage, elementArray);
        }
        if (PolicyWsdlExtensionParser.isPolicyExtensionElement(element)) {
            return this.addPolicyWsdlExtension(wsdlBindingMessage, element);
        }
        return null;
    }

    public WsdlExtension parseService(WsdlService wsdlService, Element element) throws WsdlException {
        Element[] elementArray = null;
        elementArray = PolicyWsdlExtensionParser.getPolicyReferenceExtensionElement(element);
        if (elementArray != null) {
            return this.addPolicyReferenceWsdlExtension(wsdlService, elementArray);
        }
        if (PolicyWsdlExtensionParser.isPolicyExtensionElement(element)) {
            return this.addPolicyWsdlExtension(wsdlService, element);
        }
        return null;
    }

    public WsdlExtension parsePort(WsdlPort wsdlPort, Element element) throws WsdlException {
        Element[] elementArray = null;
        elementArray = PolicyWsdlExtensionParser.getPolicyReferenceExtensionElement(element);
        if (elementArray != null) {
            return this.addPolicyReferenceWsdlExtension(wsdlPort, elementArray);
        }
        if (PolicyWsdlExtensionParser.isPolicyExtensionElement(element)) {
            return this.addPolicyWsdlExtension(wsdlPort, element);
        }
        return null;
    }

    public WsdlExtension parseDefinitions(WsdlDefinitions wsdlDefinitions, Element element) throws WsdlException {
        if (WsdlReader.tagEquals(element, "UsingPolicy", "http://schemas.xmlsoap.org/ws/2004/09/policy") || WsdlReader.tagEquals(element, "UsingPolicy", "http://www.w3.org/ns/ws-policy")) {
            String string = WsdlReader.getAttribute(element, PolicyConstants.WSDL_NAMESPACE_URI, "Required");
            if (string == null) {
                string = "true";
            }
            boolean bl = "true".equalsIgnoreCase(string);
            return new UsingPolicy(bl);
        }
        if (PolicyWsdlExtensionParser.isPolicyExtensionElement(element)) {
            return this.addPolicyWsdlExtension(wsdlDefinitions, element);
        }
        return null;
    }

    public void cleanUp() {
        this.policyLoader = this.createPolicyLoader();
    }

    private PolicyLoader createPolicyLoader() {
        try {
            return new PolicyLoader(ProviderRegistry.getTheRegistry());
        }
        catch (PolicyException policyException) {
            throw new AssertionError((Object)policyException.getMessage());
        }
    }

    private PolicyStatement parsePolicyStatement(Element element) throws WsdlException {
        try {
            PolicyStatement policyStatement = this.policyLoader.load(element);
            return policyStatement;
        }
        catch (PolicyException policyException) {
            policyException.printStackTrace();
            throw new WsdlException("Fail to handle " + element.getLocalName());
        }
    }

    private PolicyWsdlExtension addPolicyWsdlExtension(WsdlExtensible wsdlExtensible, Element element) throws WsdlException {
        PolicyWsdlExtension policyWsdlExtension = (PolicyWsdlExtension)wsdlExtensible.getExtension("Policy");
        if (policyWsdlExtension == null) {
            policyWsdlExtension = new PolicyWsdlExtension();
            wsdlExtensible.putExtension(policyWsdlExtension);
        }
        policyWsdlExtension.addPolicy(this.parsePolicyStatement(element));
        return policyWsdlExtension;
    }

    private PolicyReferenceWsdlExtension addPolicyReferenceWsdlExtension(WsdlExtensible wsdlExtensible, Element[] elementArray) throws WsdlException {
        PolicyReferenceWsdlExtension policyReferenceWsdlExtension = (PolicyReferenceWsdlExtension)wsdlExtensible.getExtension("PolicyReference");
        if (policyReferenceWsdlExtension == null) {
            policyReferenceWsdlExtension = new PolicyReferenceWsdlExtension();
        }
        try {
            for (int i = 0; i < elementArray.length; ++i) {
                URI uRI = DOMUtils.getAttributeValueAsURI(elementArray[i], PolicyConstants.POLICY_INCLUDE_URI_REF_ATTRIBUTE);
                policyReferenceWsdlExtension.addURI(uRI);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new WsdlException(uRISyntaxException.getMessage());
        }
        return policyReferenceWsdlExtension;
    }

    private static boolean isPolicyExtensionElement(Element element) {
        return WsdlReader.tagEquals(element, "Policy", "http://schemas.xmlsoap.org/ws/2004/09/policy") || WsdlReader.tagEquals(element, "Policy", "http://www.w3.org/ns/ws-policy");
    }

    private static Element[] getPolicyReferenceExtensionElement(Element element) {
        if (WsdlReader.tagEquals(element, "PolicyReference", "http://schemas.xmlsoap.org/ws/2004/09/policy") || WsdlReader.tagEquals(element, "PolicyReference", "http://www.w3.org/ns/ws-policy")) {
            Element[] elementArray = new Element[]{element};
            return elementArray;
        }
        if (WsdlReader.tagEquals(element, "Policy", "http://schemas.xmlsoap.org/ws/2004/09/policy") || WsdlReader.tagEquals(element, "Policy", "http://www.w3.org/ns/ws-policy")) {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                if (DOMUtils.equalsQName((Element)node, PolicyConstants.POLICY_INCLUDE) || DOMUtils.equalsQName((Element)node, PolicyConstants.POLICY_INCLUDE_15)) {
                    arrayList.add(node);
                    continue;
                }
                return null;
            }
            if (arrayList.size() > 0) {
                return arrayList.toArray(new Element[0]);
            }
        }
        return null;
    }
}

