/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.policy.deployment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import weblogic.wsee.addressing.policy.internal.UsingAddressingPolicyAssertionFactory;
import weblogic.wsee.mc.internal.McPolicyAssertionFactory;
import weblogic.wsee.mtom.internal.MtomPolicyAssertionFactory;
import weblogic.wsee.policy.factory.DefaultPolicyAssertionFactory;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.provider.PolicyProvider;
import weblogic.wsee.reliability.policy.ReliabilityPolicyAssertionsFactory;
import weblogic.wsee.reliability.policy.WsrmClientConfigHandler;
import weblogic.wsee.reliability.policy.WsrmServiceConfigHandler;
import weblogic.wsee.security.policy.assertions.SecurityPolicyAssertionFactory;
import weblogic.wsee.security.policy.assertions.SecurityPolicyDeploymentValidationHandler;
import weblogic.wsee.security.policy.assertions.WssServiceConfigHandler;
import weblogic.wsee.security.policy11.assertions.SecurityPolicy11AssertionFactory;
import weblogic.wsee.security.policy12.assertions.SecurityPolicy122007AssertionFactory;
import weblogic.wsee.security.policy12.assertions.SecurityPolicy12AssertionFactory;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.wstx.wsat.policy.ATPolicyAssertionFactory;

public class ProviderRegistry {
    private static final boolean verbose = Verbose.isVerbose(ProviderRegistry.class);
    private static ProviderRegistry theRegistry = new ProviderRegistry();
    private Set providers = new LinkedHashSet();
    private PolicyProvider defaultProvider;

    private ProviderRegistry() {
        PolicyProvider policyProvider = new PolicyProvider(new ReliabilityPolicyAssertionsFactory(), new WsrmClientConfigHandler(), new WsrmServiceConfigHandler(), null);
        this.deployProvider(policyProvider);
        PolicyProvider policyProvider2 = new PolicyProvider(SecurityPolicy12AssertionFactory.getInstance(), null, null, null);
        this.deployProvider(policyProvider2);
        PolicyProvider policyProvider3 = new PolicyProvider(new SecurityPolicyAssertionFactory(), null, new WssServiceConfigHandler(), new SecurityPolicyDeploymentValidationHandler());
        this.deployProvider(policyProvider3);
        PolicyProvider policyProvider4 = new PolicyProvider(new SecurityPolicy11AssertionFactory(), null, null, null);
        this.deployProvider(policyProvider4);
        PolicyProvider policyProvider5 = new PolicyProvider(new SecurityPolicy122007AssertionFactory(), null, null, null);
        this.deployProvider(policyProvider5);
        PolicyProvider policyProvider6 = new PolicyProvider(new MtomPolicyAssertionFactory(), null, null, null);
        this.deployProvider(policyProvider6);
        PolicyProvider policyProvider7 = new PolicyProvider(new McPolicyAssertionFactory(), null, null, null);
        this.deployProvider(policyProvider7);
        PolicyProvider policyProvider8 = new PolicyProvider(new UsingAddressingPolicyAssertionFactory(), null, null, null);
        this.deployProvider(policyProvider8);
        PolicyProvider policyProvider9 = new PolicyProvider(new ATPolicyAssertionFactory(), null, null, null);
        this.deployProvider(policyProvider9);
        this.defaultProvider = new PolicyProvider(new DefaultPolicyAssertionFactory(), null, null, null);
    }

    public void deployProviders(PolicyProvider[] policyProviderArray) {
        assert (this.providers != null);
        this.providers.addAll(Arrays.asList((Object[])policyProviderArray));
    }

    public void undeployProviders(PolicyProvider[] policyProviderArray) {
        assert (this.providers != null);
        this.providers.removeAll(Arrays.asList((Object[])policyProviderArray));
    }

    public void deployProvider(PolicyProvider policyProvider) {
        if (verbose) {
            Verbose.logArgs("provider", policyProvider);
        }
        assert (policyProvider != null);
        this.providers.add(policyProvider);
    }

    public void undeployProvider(PolicyProvider policyProvider) {
        assert (policyProvider != null);
        this.providers.remove(policyProvider);
    }

    public boolean isEmpty() {
        return this.providers.size() == 0;
    }

    public Iterator iterateProviders() {
        Iterator iterator = this.providers.iterator();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        arrayList.add(this.defaultProvider);
        return arrayList.iterator();
    }

    public static ProviderRegistry getTheRegistry() throws PolicyException {
        return theRegistry;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Policy Registry:\n");
        for (PolicyProvider policyProvider : this.providers) {
            stringBuffer.append(policyProvider.toString());
        }
        return stringBuffer.toString();
    }
}

