/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.policy.deployment;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.jar.JarFile;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import weblogic.application.descriptor.AbstractDescriptorLoader2;
import weblogic.application.descriptor.VersionMunger;
import weblogic.deploy.internal.DeploymentPlanDescriptorLoader;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorManager;
import weblogic.descriptor.EditableDescriptorManager;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.j2ee.descriptor.wl.WebservicePolicyRefBean;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;

public class WsPolicyDescriptor {
    public static final String WLS_WS_POLICY_WEB_URI = "WEB-INF/weblogic-webservices-policy.xml";
    public static final String WLS_WS_POLICY_EJB_URI = "META-INF/weblogic-webservices-policy.xml";
    private MyWsPolicyDescriptor wsPolicyDescriptor;

    public WsPolicyDescriptor(VirtualJarFile virtualJarFile, File file, DeploymentPlanBean deploymentPlanBean, String string) {
        this.wsPolicyDescriptor = new MyWsPolicyDescriptor(virtualJarFile, file, deploymentPlanBean, string);
    }

    public WsPolicyDescriptor(VirtualJarFile virtualJarFile, File file, DeploymentPlanBean deploymentPlanBean, String string, boolean bl) {
        this.wsPolicyDescriptor = new MyWsPolicyDescriptor(virtualJarFile, file, deploymentPlanBean, string, bl);
    }

    public WsPolicyDescriptor(WebAppServletContext webAppServletContext, File file, DeploymentPlanBean deploymentPlanBean, String string) throws IOException, XMLStreamException {
        this.wsPolicyDescriptor = new MyWsPolicyDescriptor(webAppServletContext, file, deploymentPlanBean, string);
        this.mergePolicyDescriptors(webAppServletContext);
    }

    public WsPolicyDescriptor(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader, File file, DeploymentPlanBean deploymentPlanBean, String string, boolean bl) {
        this.wsPolicyDescriptor = new MyWsPolicyDescriptor(descriptorManager, genericClassLoader, file, deploymentPlanBean, string, bl);
    }

    private void mergePolicyDescriptors(WebAppServletContext webAppServletContext) throws IOException, XMLStreamException {
        String string = "/WEB-INF/weblogic-webservices-policy.xml";
        Enumeration enumeration = webAppServletContext.getResourceFinder("/").getSources(string);
        Object[] objectArray = Collections.list(enumeration).toArray();
        if (objectArray.length > 1) {
            this.wsPolicyDescriptor.mergeDescriptors(objectArray);
        }
    }

    public DeploymentPlanBean getDeploymentPlan() {
        return this.wsPolicyDescriptor.getDeploymentPlan();
    }

    public WebservicePolicyRefBean getWebservicesPolicyBean() throws IOException, XMLStreamException {
        WebservicePolicyRefBean webservicePolicyRefBean = (WebservicePolicyRefBean)this.wsPolicyDescriptor.loadDescriptorBean();
        if (webservicePolicyRefBean == null) {
            EditableDescriptorManager editableDescriptorManager = new EditableDescriptorManager();
            webservicePolicyRefBean = (WebservicePolicyRefBean)editableDescriptorManager.createDescriptorRoot(WebservicePolicyRefBean.class).getRootBean();
        }
        return webservicePolicyRefBean;
    }

    public static void main(String[] stringArray) throws Exception {
        String string = stringArray[0];
        File file = new File(string);
        if (file.getName().endsWith(".war") || file.getName().endsWith(".jar")) {
            Object object;
            JarFile jarFile = new JarFile(string);
            VirtualJarFile virtualJarFile = VirtualJarFactory.createVirtualJar((JarFile)jarFile);
            WsPolicyDescriptor wsPolicyDescriptor = new WsPolicyDescriptor(virtualJarFile, null, null, null);
            WebservicePolicyRefBean webservicePolicyRefBean = wsPolicyDescriptor.getWebservicesPolicyBean();
            if (webservicePolicyRefBean != null && (object = ((DescriptorBean)webservicePolicyRefBean).getDescriptor()) != null) {
                object.toXML((OutputStream)System.out);
            }
            System.out.println("\n\n... getting WebservicePolicyBean:");
            if (stringArray.length > 1 && ((File)(object = new File(stringArray[1]))).getPath().endsWith("plan.xml")) {
                System.out.println("\n\n... plan:");
                DeploymentPlanDescriptorLoader deploymentPlanDescriptorLoader = new DeploymentPlanDescriptorLoader((File)object);
                DeploymentPlanBean deploymentPlanBean = deploymentPlanDescriptorLoader.getDeploymentPlanBean();
                ((DescriptorBean)deploymentPlanBean).getDescriptor().toXML((OutputStream)System.out);
                System.out.println("\n\nConfig root = " + deploymentPlanBean.getConfigRoot());
                System.out.println("\nApplication name = " + deploymentPlanBean.getApplicationName());
                WsPolicyDescriptor wsPolicyDescriptor2 = new WsPolicyDescriptor(virtualJarFile, new File(deploymentPlanBean.getConfigRoot()), deploymentPlanBean, string);
                System.out.println("\n\n... plan merged WeblogicWebservicesBean with :");
                ((DescriptorBean)wsPolicyDescriptor2.getWebservicesPolicyBean()).getDescriptor().toXML((OutputStream)System.out);
            }
        }
    }

    public static class MyWsPolicyDescriptor
    extends MyAbstractDescriptorLoader {
        public MyWsPolicyDescriptor(VirtualJarFile virtualJarFile, File file, DeploymentPlanBean deploymentPlanBean, String string) {
            super(virtualJarFile, file, deploymentPlanBean, string);
        }

        public MyWsPolicyDescriptor(VirtualJarFile virtualJarFile, File file, DeploymentPlanBean deploymentPlanBean, String string, boolean bl) {
            super(virtualJarFile, file, deploymentPlanBean, string);
            this.useWarPath = bl;
        }

        public MyWsPolicyDescriptor(VirtualJarFile virtualJarFile, File file, DeploymentPlanBean deploymentPlanBean, String string, String string2) {
            super(virtualJarFile, file, deploymentPlanBean, string, string2);
        }

        public MyWsPolicyDescriptor(WebAppServletContext webAppServletContext, File file, DeploymentPlanBean deploymentPlanBean, String string) {
            super(webAppServletContext, file, deploymentPlanBean, string);
        }

        public MyWsPolicyDescriptor(File file, File file2, DeploymentPlanBean deploymentPlanBean, String string) {
            super(file, file2, deploymentPlanBean, string);
        }

        public MyWsPolicyDescriptor(File file, File file2, DeploymentPlanBean deploymentPlanBean, String string, String string2) {
            super(file, file2, deploymentPlanBean, string, string2);
        }

        public MyWsPolicyDescriptor(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader, File file, DeploymentPlanBean deploymentPlanBean, String string, boolean bl) {
            super(descriptorManager, genericClassLoader, file, deploymentPlanBean, string);
            this.useWarPath = bl;
        }

        public String getDocumentURI() {
            if (this.useWarPath) {
                return WsPolicyDescriptor.WLS_WS_POLICY_WEB_URI;
            }
            return WsPolicyDescriptor.WLS_WS_POLICY_EJB_URI;
        }

        protected XMLStreamReader createXMLStreamReader(InputStream inputStream) throws XMLStreamException {
            String string = "weblogic.j2ee.descriptor.wl.WebservicePolicyRefBeanImpl$SchemaHelper2";
            return new VersionMunger(inputStream, (AbstractDescriptorLoader2)this, string, "http://xmlns.oracle.com/weblogic/webservice-policy-ref");
        }
    }

    public static abstract class MyAbstractDescriptorLoader
    extends AbstractDescriptorLoader2 {
        protected boolean useWarPath = false;
        protected WebAppServletContext svltCtx;

        public MyAbstractDescriptorLoader(VirtualJarFile virtualJarFile, File file, DeploymentPlanBean deploymentPlanBean, String string) {
            super(virtualJarFile, file, deploymentPlanBean, string, null);
            if (virtualJarFile.getName().endsWith(".war")) {
                this.useWarPath = true;
            }
        }

        public MyAbstractDescriptorLoader(VirtualJarFile virtualJarFile, File file, DeploymentPlanBean deploymentPlanBean, String string, String string2) {
            super(virtualJarFile, file, deploymentPlanBean, string, string2);
            if (virtualJarFile.getName().endsWith(".war")) {
                this.useWarPath = true;
            }
        }

        public MyAbstractDescriptorLoader(WebAppServletContext webAppServletContext, File file, DeploymentPlanBean deploymentPlanBean, String string) {
            super((VirtualJarFile)null, file, deploymentPlanBean, string, null);
            this.useWarPath = true;
            this.svltCtx = webAppServletContext;
        }

        public MyAbstractDescriptorLoader(File file, File file2, DeploymentPlanBean deploymentPlanBean, String string) {
            super(file, file2, deploymentPlanBean, string, null);
        }

        public MyAbstractDescriptorLoader(File file, File file2, DeploymentPlanBean deploymentPlanBean, String string, String string2) {
            super(file, file2, deploymentPlanBean, string, string2);
        }

        MyAbstractDescriptorLoader(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader) {
            super(descriptorManager, genericClassLoader, null);
        }

        MyAbstractDescriptorLoader(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader, File file, DeploymentPlanBean deploymentPlanBean, String string) {
            super(descriptorManager, genericClassLoader, file, deploymentPlanBean, string, null);
        }

        public InputStream getInputStream() throws IOException {
            if (this.svltCtx != null) {
                return this.svltCtx.getResourceAsStream(this.getDocumentURI());
            }
            return super.getInputStream();
        }
    }
}

