/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.policy.deployment;

import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import weblogic.wsee.policy.deployment.PolicyReferenceWsdlExtension;
import weblogic.wsee.policy.deployment.PolicyURIs;
import weblogic.wsee.policy.deployment.PolicyWsdlExtension;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.framework.PolicyMath;
import weblogic.wsee.policy.framework.PolicyStatement;
import weblogic.wsee.policy.runtime.PolicyServer;
import weblogic.wsee.wsdl.WsdlBinding;
import weblogic.wsee.wsdl.WsdlBindingMessage;
import weblogic.wsee.wsdl.WsdlBindingOperation;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlExtensible;
import weblogic.wsee.wsdl.WsdlMessage;
import weblogic.wsee.wsdl.WsdlOperation;
import weblogic.wsee.wsdl.WsdlPort;
import weblogic.wsee.wsdl.WsdlPortType;
import weblogic.wsee.wsdl.WsdlService;

public class WsdlPolicySubject {
    private WsdlDefinitions definitions;
    PolicyWsdlExtension definitionsExt;
    private Map cachedEffectivePolicies = new HashMap();
    private boolean effectivePolicyMapBuilt = false;
    private PolicyServer ps;

    public WsdlPolicySubject(WsdlDefinitions wsdlDefinitions) {
        this(wsdlDefinitions, null);
    }

    public WsdlPolicySubject(WsdlDefinitions wsdlDefinitions, PolicyServer policyServer) {
        this.definitions = wsdlDefinitions;
        this.definitionsExt = (PolicyWsdlExtension)wsdlDefinitions.getExtension("Policy");
        if (this.definitionsExt == null) {
            this.definitionsExt = new PolicyWsdlExtension();
            this.definitions.putExtension(this.definitionsExt);
        }
        WsdlPolicySubject.findPolicyWsdlExtension(wsdlDefinitions, this.definitionsExt);
        this.ps = policyServer;
    }

    public Map getAllEffectivePolicies() throws PolicyException {
        if (!this.effectivePolicyMapBuilt) {
            this.calculateAllEffectivePolicies();
            this.effectivePolicyMapBuilt = true;
        }
        return this.cachedEffectivePolicies;
    }

    public void addPolicy(PolicyStatement policyStatement) {
        this.definitionsExt.addPolicy(policyStatement);
    }

    public Map getPolicies() {
        return this.definitionsExt.getPolicies();
    }

    public boolean policyExists(PolicyStatement policyStatement) {
        String string = policyStatement.getId();
        if (string != null) {
            return this.getPolicies().get(string) != null;
        }
        return false;
    }

    public boolean policyExists(URI uRI) {
        if (!uRI.isAbsolute() && uRI.getFragment() != null) {
            return this.getPolicies().get(uRI.getFragment()) != null;
        }
        return true;
    }

    public NormalizedExpression getServicePolicySubject(QName qName) throws PolicyException {
        String string;
        NormalizedExpression normalizedExpression = null;
        WsdlService wsdlService = this.definitions.getServices().get(qName);
        if (wsdlService != null && (normalizedExpression = (NormalizedExpression)this.cachedEffectivePolicies.get(string = qName.getLocalPart())) == null) {
            normalizedExpression = WsdlPolicySubject.getEffectivePolicyFromWsdlExtensible(this.ps, wsdlService, null, this.getPolicies());
            this.cachedEffectivePolicies.put(string, normalizedExpression);
        }
        return normalizedExpression;
    }

    public NormalizedExpression getEndpointPolicySubject(QName qName, QName qName2) throws PolicyException {
        String string;
        WsdlPort wsdlPort;
        NormalizedExpression normalizedExpression = null;
        WsdlService wsdlService = this.definitions.getServices().get(qName);
        if (wsdlService != null && (wsdlPort = wsdlService.getPorts().get(qName2)) != null && (normalizedExpression = (NormalizedExpression)this.cachedEffectivePolicies.get(string = qName.getLocalPart() + qName2.getLocalPart())) == null) {
            normalizedExpression = WsdlPolicySubject.getEndpointPolicySubject(this.ps, wsdlPort, this.getPolicies());
            this.cachedEffectivePolicies.put(string, normalizedExpression);
        }
        return normalizedExpression;
    }

    public NormalizedExpression getOperationPolicySubject(QName qName, QName qName2, QName qName3) throws PolicyException {
        WsdlPort wsdlPort;
        NormalizedExpression normalizedExpression = null;
        WsdlService wsdlService = this.definitions.getServices().get(qName);
        if (wsdlService != null && (wsdlPort = wsdlService.getPorts().get(qName2)) != null) {
            String string;
            WsdlOperation wsdlOperation = wsdlPort.getPortType().getOperations().get(qName3);
            WsdlBindingOperation wsdlBindingOperation = wsdlPort.getBinding().getOperations().get(qName3);
            if (wsdlOperation != null && wsdlBindingOperation != null && (normalizedExpression = (NormalizedExpression)this.cachedEffectivePolicies.get(string = qName.getLocalPart() + qName2.getLocalPart() + qName3.getLocalPart())) == null) {
                normalizedExpression = WsdlPolicySubject.getOperationPolicySubject(this.ps, wsdlOperation, wsdlBindingOperation, this.getPolicies());
                this.cachedEffectivePolicies.put(string, normalizedExpression);
            }
        }
        return normalizedExpression;
    }

    public NormalizedExpression getInputMessagePolicySubject(QName qName, QName qName2, QName qName3) throws PolicyException {
        WsdlPort wsdlPort;
        NormalizedExpression normalizedExpression = null;
        WsdlService wsdlService = this.definitions.getServices().get(qName);
        if (wsdlService != null && (wsdlPort = wsdlService.getPorts().get(qName2)) != null) {
            String string;
            WsdlMessage wsdlMessage;
            WsdlOperation wsdlOperation = wsdlPort.getPortType().getOperations().get(qName3);
            WsdlBindingOperation wsdlBindingOperation = wsdlPort.getBinding().getOperations().get(qName3);
            if (wsdlOperation != null && wsdlBindingOperation != null && (wsdlMessage = wsdlOperation.getInput()) != null && (normalizedExpression = (NormalizedExpression)this.cachedEffectivePolicies.get(string = qName.getLocalPart() + qName2.getLocalPart() + qName3.getLocalPart() + "Input")) == null) {
                normalizedExpression = WsdlPolicySubject.getMessagePolicySubject(this.ps, wsdlMessage, wsdlBindingOperation.getInput(), wsdlOperation.getInputPolicyUris(), this.getPolicies());
                this.cachedEffectivePolicies.put(string, normalizedExpression);
            }
        }
        return normalizedExpression;
    }

    public NormalizedExpression getOutputMessagePolicySubject(QName qName, QName qName2, QName qName3) throws PolicyException {
        WsdlPort wsdlPort;
        NormalizedExpression normalizedExpression = null;
        WsdlService wsdlService = this.definitions.getServices().get(qName);
        if (wsdlService != null && (wsdlPort = wsdlService.getPorts().get(qName2)) != null) {
            String string;
            WsdlMessage wsdlMessage;
            WsdlOperation wsdlOperation = wsdlPort.getPortType().getOperations().get(qName3);
            WsdlBindingOperation wsdlBindingOperation = wsdlPort.getBinding().getOperations().get(qName3);
            if (wsdlOperation != null && wsdlBindingOperation != null && (wsdlMessage = wsdlOperation.getOutput()) != null && (normalizedExpression = (NormalizedExpression)this.cachedEffectivePolicies.get(string = qName.getLocalPart() + qName2.getLocalPart() + qName3.getLocalPart() + "Output")) == null) {
                normalizedExpression = WsdlPolicySubject.getMessagePolicySubject(this.ps, wsdlMessage, wsdlBindingOperation.getOutput(), wsdlOperation.getOutputPolicyUris(), this.getPolicies());
                this.cachedEffectivePolicies.put(string, normalizedExpression);
            }
        }
        return normalizedExpression;
    }

    public NormalizedExpression getFaultMessagePolicySubject(QName qName, QName qName2, QName qName3, String string) throws PolicyException {
        WsdlPort wsdlPort;
        NormalizedExpression normalizedExpression = null;
        WsdlService wsdlService = this.definitions.getServices().get(qName);
        if (wsdlService != null && (wsdlPort = wsdlService.getPorts().get(qName2)) != null) {
            String string2;
            WsdlMessage wsdlMessage;
            WsdlOperation wsdlOperation = wsdlPort.getPortType().getOperations().get(qName3);
            WsdlBindingOperation wsdlBindingOperation = wsdlPort.getBinding().getOperations().get(qName3);
            if (wsdlOperation != null && wsdlBindingOperation != null && (wsdlMessage = wsdlOperation.getFaults().get(string)) != null && (normalizedExpression = (NormalizedExpression)this.cachedEffectivePolicies.get(string2 = qName.getLocalPart() + qName2.getLocalPart() + qName3.getLocalPart() + string)) == null) {
                normalizedExpression = WsdlPolicySubject.getMessagePolicySubject(this.ps, wsdlMessage, wsdlBindingOperation.getFaults().get(string), wsdlOperation.getFaultPolicyUris(string), this.getPolicies());
                this.cachedEffectivePolicies.put(string2, normalizedExpression);
            }
        }
        return normalizedExpression;
    }

    public static NormalizedExpression getEndpointPolicySubject(WsdlPort wsdlPort, Map map) throws PolicyException {
        return WsdlPolicySubject.getEndpointPolicySubject(null, wsdlPort, map);
    }

    public static NormalizedExpression getEndpointPolicySubject(PolicyServer policyServer, WsdlPort wsdlPort, Map map) throws PolicyException {
        NormalizedExpression normalizedExpression = WsdlPolicySubject.getEffectivePolicyFromWsdlExtensible(policyServer, wsdlPort, wsdlPort.getPolicyUris(), map);
        WsdlBinding wsdlBinding = wsdlPort.getBinding();
        NormalizedExpression normalizedExpression2 = WsdlPolicySubject.getEffectivePolicyFromWsdlExtensible(policyServer, wsdlBinding, wsdlBinding.getPolicyUris(), map);
        WsdlPortType wsdlPortType = wsdlPort.getPortType();
        NormalizedExpression normalizedExpression3 = PolicyWsdlExtension.getEffectivePolicy(policyServer, map, wsdlPortType.getPolicyUris());
        NormalizedExpression normalizedExpression4 = PolicyMath.merge(normalizedExpression, normalizedExpression2);
        normalizedExpression4 = PolicyMath.merge(normalizedExpression4, normalizedExpression3);
        return normalizedExpression4;
    }

    public static NormalizedExpression getEndpointPolicySubject(PolicyServer policyServer, WsdlBinding wsdlBinding, Map map) throws PolicyException {
        NormalizedExpression normalizedExpression = WsdlPolicySubject.getEffectivePolicyFromWsdlExtensible(policyServer, wsdlBinding, wsdlBinding.getPolicyUris(), map);
        WsdlPortType wsdlPortType = wsdlBinding.getPortType();
        NormalizedExpression normalizedExpression2 = PolicyWsdlExtension.getEffectivePolicy(policyServer, map, wsdlPortType.getPolicyUris());
        NormalizedExpression normalizedExpression3 = PolicyMath.merge(normalizedExpression, normalizedExpression2);
        return normalizedExpression3;
    }

    public static NormalizedExpression getOperationPolicySubject(WsdlOperation wsdlOperation, WsdlBindingOperation wsdlBindingOperation, Map map) throws PolicyException {
        return WsdlPolicySubject.getOperationPolicySubject(null, wsdlOperation, wsdlBindingOperation, map);
    }

    public static NormalizedExpression getOperationPolicySubject(PolicyServer policyServer, WsdlOperation wsdlOperation, WsdlBindingOperation wsdlBindingOperation, Map map) throws PolicyException {
        NormalizedExpression normalizedExpression = WsdlPolicySubject.getEffectivePolicyFromWsdlExtensible(policyServer, wsdlBindingOperation, wsdlBindingOperation.getPolicyUris(), map);
        NormalizedExpression normalizedExpression2 = WsdlPolicySubject.getEffectivePolicyFromWsdlExtensible(policyServer, wsdlOperation, wsdlOperation.getPolicyUris(), map);
        return PolicyMath.merge(normalizedExpression, normalizedExpression2);
    }

    public static NormalizedExpression getOperationPolicySubject(PolicyServer policyServer, WsdlBindingOperation wsdlBindingOperation, Map map) throws PolicyException {
        NormalizedExpression normalizedExpression = WsdlPolicySubject.getEffectivePolicyFromWsdlExtensible(policyServer, wsdlBindingOperation, wsdlBindingOperation.getPolicyUris(), map);
        return normalizedExpression;
    }

    public static NormalizedExpression getMessagePolicySubject(WsdlMessage wsdlMessage, WsdlBindingMessage wsdlBindingMessage, PolicyURIs policyURIs, Map map) throws PolicyException {
        return WsdlPolicySubject.getMessagePolicySubject(null, wsdlMessage, wsdlBindingMessage, policyURIs, map);
    }

    public static NormalizedExpression getMessagePolicySubject(PolicyServer policyServer, WsdlMessage wsdlMessage, WsdlBindingMessage wsdlBindingMessage, PolicyURIs policyURIs, Map map) throws PolicyException {
        NormalizedExpression normalizedExpression = NormalizedExpression.createUnitializedExpression();
        if (wsdlBindingMessage != null) {
            normalizedExpression = PolicyMath.merge(normalizedExpression, WsdlPolicySubject.getEffectivePolicyFromWsdlExtensible(policyServer, wsdlBindingMessage, wsdlBindingMessage.getPolicyUris(), map));
        }
        if (wsdlMessage != null) {
            normalizedExpression = PolicyMath.merge(normalizedExpression, WsdlPolicySubject.getEffectivePolicyFromWsdlExtensible(policyServer, wsdlMessage, wsdlMessage.getPolicyUris(), map));
        }
        if (policyURIs != null) {
            normalizedExpression = PolicyMath.merge(normalizedExpression, PolicyWsdlExtension.getEffectivePolicy(policyServer, map, policyURIs));
        }
        return normalizedExpression;
    }

    private static NormalizedExpression getEffectivePolicyFromWsdlExtensible(PolicyServer policyServer, WsdlExtensible wsdlExtensible, PolicyURIs policyURIs, Map map) throws PolicyException {
        PolicyWsdlExtension policyWsdlExtension = (PolicyWsdlExtension)wsdlExtensible.getExtension("Policy");
        NormalizedExpression normalizedExpression = PolicyWsdlExtension.getEffectivePolicy(policyWsdlExtension == null ? null : policyWsdlExtension.getPolicies());
        PolicyReferenceWsdlExtension policyReferenceWsdlExtension = (PolicyReferenceWsdlExtension)wsdlExtensible.getExtension("PolicyReference");
        if (policyReferenceWsdlExtension != null) {
            normalizedExpression = PolicyMath.merge(normalizedExpression, policyReferenceWsdlExtension.getEffectivePolicy(policyServer, map));
        }
        if (policyURIs != null) {
            normalizedExpression = PolicyMath.merge(normalizedExpression, PolicyWsdlExtension.getEffectivePolicy(policyServer, map, policyURIs));
        }
        return normalizedExpression;
    }

    private void calculateAllEffectivePolicies() throws PolicyException {
        for (WsdlService wsdlService : this.definitions.getServices().values()) {
            QName qName = wsdlService.getName();
            this.getServicePolicySubject(qName);
            for (WsdlPort wsdlPort : wsdlService.getPorts().values()) {
                QName qName2 = wsdlPort.getName();
                this.getEndpointPolicySubject(qName, qName2);
                for (WsdlOperation wsdlOperation : wsdlPort.getPortType().getOperations().values()) {
                    QName qName3 = wsdlOperation.getName();
                    this.getOperationPolicySubject(qName, qName2, qName3);
                    this.getInputMessagePolicySubject(qName, qName2, qName3);
                    this.getOutputMessagePolicySubject(qName, qName2, qName3);
                    Iterator<? extends WsdlMessage> iterator = wsdlOperation.getFaults().values().iterator();
                    while (iterator.hasNext()) {
                        String string = iterator.next().getName().getLocalPart();
                        this.getFaultMessagePolicySubject(qName, qName2, qName3, string);
                    }
                }
            }
        }
    }

    private static void findPolicyWsdlExtension(WsdlDefinitions wsdlDefinitions, PolicyWsdlExtension policyWsdlExtension) {
        List<? extends WsdlDefinitions> list = wsdlDefinitions.getImportedWsdlDefinitions();
        for (WsdlDefinitions wsdlDefinitions2 : list) {
            PolicyWsdlExtension policyWsdlExtension2 = (PolicyWsdlExtension)wsdlDefinitions2.getExtension("Policy");
            if (policyWsdlExtension2 != null) {
                Map map = policyWsdlExtension2.getPolicies();
                if (policyWsdlExtension.hasPolicies()) {
                    for (PolicyStatement policyStatement : map.values()) {
                        if (policyWsdlExtension.policyExists(policyStatement)) continue;
                        policyWsdlExtension.addPolicy(policyStatement);
                    }
                } else {
                    policyWsdlExtension.addAllPolicies(map);
                }
            }
            WsdlPolicySubject.findPolicyWsdlExtension(wsdlDefinitions2, policyWsdlExtension);
        }
    }
}

