/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.policy.deployment;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WseePolicyReferenceInfo {
    private static final String[] ITEM_NAMES = new String[]{"category", "policyReferenceURI", "enabled", "configOverrides", "direction"};
    private static CompositeType COMPOSITE_TYPE = null;
    private static TabularType TABULAR_TYPE = null;
    private static final String[] MAP_ITEM_NAMES = new String[]{"key", "value"};
    private static final TabularType STRING_MAP_TYPE;
    private static final CompositeType STRING_MAP_ENTRY_TYPE;
    public static final String CATEGORY_OWSM_SECURITY = "owsm-security";
    public static final String CATEGORY_WS_POLICY = "ws-policy";
    public static final String STATUS_ENABLED = "enabled";
    public static final String STATUS_DISABLED = "disabled";
    public static final String STATUS_DELETED = "deleted";
    public static final String DIRECTION_BOTH = "both";
    public static final String DIRECTION_INBOUND = "inbound";
    public static final String DIRECTION_OUTBOUND = "outbound";
    private static HashSet<String> CATEGORIES;
    private static HashSet<String> STATUSES;
    private static HashSet<String> DIRECTIONS;
    private String category = null;
    private String uri = null;
    private String status = "enabled";
    private String direction = "both";
    private Map<String, String> overrides = null;

    public WseePolicyReferenceInfo() {
    }

    public WseePolicyReferenceInfo(String string, String string2) {
        this.setCategory(string);
        this.setUri(string2);
    }

    public WseePolicyReferenceInfo(String string, String string2, String string3) {
        this(string, string2);
        this.setStatus(string3);
    }

    public WseePolicyReferenceInfo(String string, String string2, String string3, String string4) {
        this(string, string2, string3);
        this.setDirection(string4);
    }

    public WseePolicyReferenceInfo(String string, String string2, String string3, Map<String, String> map) {
        this(string, string2, string3);
        this.setOverrides(map);
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String string) {
        this.validateCategory(string);
        this.category = string;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String string) {
        this.uri = string;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String string) {
        this.validateStatus(string);
        this.status = string;
    }

    public String getDirection() {
        return this.direction;
    }

    public void setDirection(String string) {
        this.validateDirection(string);
        this.direction = string;
    }

    public Map<String, String> getOverrides() {
        return this.overrides;
    }

    public void setOverrides(Map<String, String> map) {
        if (CATEGORY_WS_POLICY.equals(this.category) && map != null) {
            throw new IllegalArgumentException("Overrides invalid for category " + this.category);
        }
        this.overrides = map;
    }

    private void validateCategory(String string) {
        if (!CATEGORIES.contains(string)) {
            throw new IllegalArgumentException("Invalid policy category: " + string);
        }
        if (CATEGORY_OWSM_SECURITY.equals(string) && !DIRECTION_BOTH.equals(this.direction)) {
            throw new IllegalArgumentException("Invalid policy direction " + this.direction + " for category " + string);
        }
        if (CATEGORY_WS_POLICY.equals(string) && this.overrides != null) {
            throw new IllegalArgumentException("Invalid policy category " + string + " for existing overrides.");
        }
    }

    private void validateStatus(String string) {
        if (!STATUSES.contains(string)) {
            throw new IllegalArgumentException("Invalid policy status: " + string);
        }
        if (STATUS_DISABLED.equals(string) && !DIRECTION_BOTH.equals(this.direction)) {
            throw new IllegalArgumentException("Invalid policy status " + string + " for direction " + this.direction);
        }
    }

    private void validateDirection(String string) {
        if (!DIRECTIONS.contains(string)) {
            throw new IllegalArgumentException("Invalid policy direction: " + string);
        }
        if (CATEGORY_OWSM_SECURITY.equals(this.category) && !DIRECTION_BOTH.equals(string)) {
            throw new IllegalArgumentException("Invalid policy direction " + string + " for category " + this.category);
        }
        if (STATUS_DISABLED.equals(this.status) && !DIRECTION_BOTH.equals(string)) {
            throw new IllegalArgumentException("Invalid policy direction " + string + " for status " + this.status);
        }
    }

    public boolean equals(Object object) {
        if (object == null && object.getClass() != this.getClass()) {
            return false;
        }
        WseePolicyReferenceInfo wseePolicyReferenceInfo = (WseePolicyReferenceInfo)object;
        if (!this.getUri().equals(wseePolicyReferenceInfo.getUri())) {
            return false;
        }
        if (!this.getDirection().equals(wseePolicyReferenceInfo.getDirection())) {
            return false;
        }
        if (!this.getStatus().equals(wseePolicyReferenceInfo.getStatus())) {
            return false;
        }
        return this.getCategory().equals(wseePolicyReferenceInfo.getCategory());
    }

    public int hashCode() {
        return this.getUri().hashCode();
    }

    public static WseePolicyReferenceInfo from(CompositeData compositeData) {
        if (compositeData == null) {
            return null;
        }
        TabularData tabularData = (TabularData)compositeData.get(ITEM_NAMES[3]);
        HashMap<String, String> hashMap = null;
        if (tabularData != null && !tabularData.isEmpty()) {
            hashMap = new HashMap<String, String>();
            for (CompositeData compositeData2 : tabularData.values()) {
                hashMap.put((String)compositeData2.get(MAP_ITEM_NAMES[0]), (String)compositeData2.get(MAP_ITEM_NAMES[1]));
            }
        }
        WseePolicyReferenceInfo wseePolicyReferenceInfo = new WseePolicyReferenceInfo((String)compositeData.get(ITEM_NAMES[0]), (String)compositeData.get(ITEM_NAMES[1]), (String)compositeData.get(ITEM_NAMES[2]), hashMap);
        wseePolicyReferenceInfo.setDirection((String)compositeData.get(ITEM_NAMES[4]));
        return wseePolicyReferenceInfo;
    }

    public static CompositeData from(WseePolicyReferenceInfo wseePolicyReferenceInfo) {
        if (wseePolicyReferenceInfo == null) {
            return null;
        }
        Map<String, String> map = wseePolicyReferenceInfo.getOverrides();
        if (map != null && map.isEmpty()) {
            wseePolicyReferenceInfo.setOverrides(null);
        }
        TabularDataSupport tabularDataSupport = new TabularDataSupport(STRING_MAP_TYPE);
        map = wseePolicyReferenceInfo.getOverrides();
        try {
            if (map != null) {
                for (String string : wseePolicyReferenceInfo.getOverrides().keySet()) {
                    tabularDataSupport.put(new CompositeDataSupport(STRING_MAP_ENTRY_TYPE, MAP_ITEM_NAMES, new Object[]{string, wseePolicyReferenceInfo.getOverrides().get(string)}));
                }
            }
            Object[] objectArray = new Object[]{wseePolicyReferenceInfo.getCategory(), wseePolicyReferenceInfo.getUri(), wseePolicyReferenceInfo.getStatus(), tabularDataSupport, wseePolicyReferenceInfo.getDirection()};
            return new CompositeDataSupport(COMPOSITE_TYPE, ITEM_NAMES, objectArray);
        }
        catch (OpenDataException openDataException) {
            throw new RuntimeException(openDataException);
        }
    }

    public static TabularData from(WseePolicyReferenceInfo[] wseePolicyReferenceInfoArray) {
        if (wseePolicyReferenceInfoArray == null) {
            return null;
        }
        TabularDataSupport tabularDataSupport = new TabularDataSupport(TABULAR_TYPE);
        for (WseePolicyReferenceInfo wseePolicyReferenceInfo : wseePolicyReferenceInfoArray) {
            tabularDataSupport.put(WseePolicyReferenceInfo.from(wseePolicyReferenceInfo));
        }
        return tabularDataSupport;
    }

    public static WseePolicyReferenceInfo[] from(TabularData tabularData) {
        if (tabularData == null) {
            return null;
        }
        WseePolicyReferenceInfo[] wseePolicyReferenceInfoArray = new WseePolicyReferenceInfo[tabularData.size()];
        int n = 0;
        for (CompositeData compositeData : tabularData.values()) {
            wseePolicyReferenceInfoArray[n] = WseePolicyReferenceInfo.from(compositeData);
            ++n;
        }
        return wseePolicyReferenceInfoArray;
    }

    static {
        try {
            STRING_MAP_ENTRY_TYPE = new CompositeType("StringMapEntry", "A Map entry whose value type is String", MAP_ITEM_NAMES, MAP_ITEM_NAMES, new OpenType[]{SimpleType.STRING, SimpleType.STRING});
            STRING_MAP_TYPE = new TabularType("Map", "A Map of String keys to String values", STRING_MAP_ENTRY_TYPE, new String[]{MAP_ITEM_NAMES[0]});
            OpenType[] openTypeArray = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, STRING_MAP_TYPE, SimpleType.STRING};
            COMPOSITE_TYPE = new CompositeType("weblogic.management.runtime.WseePolicyReferenceInfo", "weblogic.management.runtime.WseePolicyReferenceInfo", ITEM_NAMES, ITEM_NAMES, openTypeArray);
            TABULAR_TYPE = new TabularType("weblogic.management.runtime.WseePolicyReferenceInfo[]", "weblogic.management.runtime.WseePolicyReferenceInfo[]", COMPOSITE_TYPE, ITEM_NAMES);
        }
        catch (OpenDataException openDataException) {
            throw new RuntimeException(openDataException);
        }
        CATEGORIES = new HashSet();
        STATUSES = new HashSet();
        DIRECTIONS = new HashSet();
        CATEGORIES.add(CATEGORY_OWSM_SECURITY);
        CATEGORIES.add(CATEGORY_WS_POLICY);
        STATUSES.add(STATUS_ENABLED);
        STATUSES.add(STATUS_DISABLED);
        STATUSES.add(STATUS_DELETED);
        DIRECTIONS.add(DIRECTION_BOTH);
        DIRECTIONS.add(DIRECTION_INBOUND);
        DIRECTIONS.add(DIRECTION_OUTBOUND);
    }
}

