/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.policy.deployment;

import java.io.IOException;
import java.security.AccessController;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import weblogic.management.ManagementException;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.DomainRuntimeMBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.management.runtime.WseePolicySubjectManagerRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.wsee.policy.deployment.WseePolicyReferenceInfo;
import weblogic.wsee.policy.deployment.config.PolicyDescriptorUtils;
import weblogic.wsee.policy.deployment.config.PolicyManagementException;

public class WseePolicySubjectManagerRuntimeMBeanImpl
extends RuntimeMBeanDelegate
implements WseePolicySubjectManagerRuntimeMBean {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    static void initialize() throws ManagementException {
        if (ManagementService.getRuntimeAccess(kernelId).isAdminServer()) {
            new WseePolicySubjectManagerRuntimeMBeanImpl(WseePolicySubjectManagerRuntimeMBeanImpl.getDomainRuntimeMBean());
        }
    }

    private WseePolicySubjectManagerRuntimeMBeanImpl(DomainRuntimeMBean domainRuntimeMBean) throws ManagementException {
        super(domainRuntimeMBean.getName(), (RuntimeMBean)domainRuntimeMBean);
        domainRuntimeMBean.setPolicySubjectManagerRuntime(this);
    }

    public TabularData getPolicyReferenceInfos(String string) throws ManagementException {
        WseePolicyReferenceInfo[] wseePolicyReferenceInfoArray = new WseePolicyReferenceInfo[]{};
        try {
            wseePolicyReferenceInfoArray = PolicyDescriptorUtils.getPolicyReferenceInfos(string);
        }
        catch (PolicyManagementException policyManagementException) {
            throw new ManagementException(WseePolicySubjectManagerRuntimeMBeanImpl.getMessage(policyManagementException));
        }
        catch (ConfigurationException configurationException) {
            throw new ManagementException(WseePolicySubjectManagerRuntimeMBeanImpl.getMessage(configurationException));
        }
        return WseePolicyReferenceInfo.from(wseePolicyReferenceInfoArray);
    }

    public void setPolicyReferenceInfos(String string, TabularData tabularData) throws ManagementException {
        WseePolicyReferenceInfo[] wseePolicyReferenceInfoArray = WseePolicyReferenceInfo.from(tabularData);
        try {
            PolicyDescriptorUtils.setPolicyReferenceInfos(string, wseePolicyReferenceInfoArray);
        }
        catch (PolicyManagementException policyManagementException) {
            throw new ManagementException(WseePolicySubjectManagerRuntimeMBeanImpl.getMessage(policyManagementException));
        }
        catch (ConfigurationException configurationException) {
            throw new ManagementException(WseePolicySubjectManagerRuntimeMBeanImpl.getMessage(configurationException));
        }
        catch (IOException iOException) {
            throw new ManagementException(WseePolicySubjectManagerRuntimeMBeanImpl.getMessage(iOException));
        }
    }

    public void setPolicyReferenceInfos(String string, TabularData tabularData, String string2) throws ManagementException {
    }

    public void setPolicyReferenceInfo(String string, CompositeData compositeData) throws ManagementException {
        try {
            PolicyDescriptorUtils.setPolicyReferenceInfo(string, WseePolicyReferenceInfo.from(compositeData));
        }
        catch (PolicyManagementException policyManagementException) {
            throw new ManagementException(WseePolicySubjectManagerRuntimeMBeanImpl.getMessage(policyManagementException));
        }
        catch (ConfigurationException configurationException) {
            throw new ManagementException(WseePolicySubjectManagerRuntimeMBeanImpl.getMessage(configurationException));
        }
        catch (IOException iOException) {
            throw new ManagementException(WseePolicySubjectManagerRuntimeMBeanImpl.getMessage(iOException));
        }
    }

    public void attachPolicyReference(String string, CompositeData compositeData) throws ManagementException {
        try {
            PolicyDescriptorUtils.attachPolicyReference(string, WseePolicyReferenceInfo.from(compositeData));
        }
        catch (PolicyManagementException policyManagementException) {
            throw new ManagementException(WseePolicySubjectManagerRuntimeMBeanImpl.getMessage(policyManagementException));
        }
        catch (ConfigurationException configurationException) {
            throw new ManagementException(WseePolicySubjectManagerRuntimeMBeanImpl.getMessage(configurationException));
        }
        catch (IOException iOException) {
            throw new ManagementException(WseePolicySubjectManagerRuntimeMBeanImpl.getMessage(iOException));
        }
    }

    public void attachPolicyReference(String string, CompositeData compositeData, String string2) throws ManagementException {
    }

    public void removePolicyReference(String string, String string2) throws ManagementException {
        try {
            PolicyDescriptorUtils.removePolicyReference(string, string2);
        }
        catch (PolicyManagementException policyManagementException) {
            throw new ManagementException(WseePolicySubjectManagerRuntimeMBeanImpl.getMessage(policyManagementException));
        }
        catch (ConfigurationException configurationException) {
            throw new ManagementException(WseePolicySubjectManagerRuntimeMBeanImpl.getMessage(configurationException));
        }
        catch (IOException iOException) {
            throw new ManagementException(WseePolicySubjectManagerRuntimeMBeanImpl.getMessage(iOException));
        }
    }

    public void removePolicyReference(String string, String string2, String string3) throws ManagementException {
    }

    public String getPolicyRefStatus(String string, String string2) throws ManagementException {
        try {
            String string3 = null;
            string3 = PolicyDescriptorUtils.getPolicyRefStatus(string, string2);
            return string3;
        }
        catch (PolicyManagementException policyManagementException) {
            throw new ManagementException(WseePolicySubjectManagerRuntimeMBeanImpl.getMessage(policyManagementException));
        }
        catch (ConfigurationException configurationException) {
            throw new ManagementException(WseePolicySubjectManagerRuntimeMBeanImpl.getMessage(configurationException));
        }
    }

    public void setPolicyRefStatus(String string, String string2, Boolean bl) throws ManagementException {
        try {
            PolicyDescriptorUtils.setPolicyRefStatus(string, string2, bl);
        }
        catch (PolicyManagementException policyManagementException) {
            throw new ManagementException(WseePolicySubjectManagerRuntimeMBeanImpl.getMessage(policyManagementException));
        }
        catch (ConfigurationException configurationException) {
            throw new ManagementException(WseePolicySubjectManagerRuntimeMBeanImpl.getMessage(configurationException));
        }
        catch (IOException iOException) {
            throw new ManagementException(WseePolicySubjectManagerRuntimeMBeanImpl.getMessage(iOException));
        }
    }

    public void setPolicyRefStatus(String string, String string2, boolean bl, String string3) throws ManagementException {
    }

    public boolean isOWSMAttachable(String string) throws ManagementException {
        try {
            return PolicyDescriptorUtils.isOWSMAttachable(string);
        }
        catch (PolicyManagementException policyManagementException) {
            throw new ManagementException(WseePolicySubjectManagerRuntimeMBeanImpl.getMessage(policyManagementException));
        }
        catch (ConfigurationException configurationException) {
            throw new ManagementException(WseePolicySubjectManagerRuntimeMBeanImpl.getMessage(configurationException));
        }
    }

    private static DomainRuntimeMBean getDomainRuntimeMBean() {
        return ManagementService.getDomainAccess(kernelId).getDomainRuntime();
    }

    private static String getMessage(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        return throwable.getMessage();
    }
}

