/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.policy.deployment.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.enterprise.deploy.model.DDBeanRoot;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.model.J2eeApplicationObject;
import javax.enterprise.deploy.model.exceptions.DDBeanCreateException;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DConfigBeanRoot;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import weblogic.deploy.api.model.WebLogicDeployableObject;
import weblogic.deploy.api.model.WebLogicJ2eeApplicationObject;
import weblogic.deploy.api.spi.WebLogicDConfigBean;
import weblogic.deploy.api.spi.WebLogicDeploymentConfiguration;
import weblogic.deploy.api.spi.WebLogicDeploymentManager;
import weblogic.deploy.api.spi.config.DeploymentConfigurationImpl;
import weblogic.deploy.api.tools.SessionHelper;
import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.descriptor.wl.ServiceReferenceDescriptionBean;
import weblogic.j2ee.descriptor.wl.WeblogicEjbJarBean;
import weblogic.j2ee.descriptor.wl.WeblogicEnterpriseBeanBean;
import weblogic.j2ee.descriptor.wl.WeblogicWebAppBean;
import weblogic.j2ee.descriptor.wl.WebservicePolicyRefBean;
import weblogic.j2ee.descriptor.wl.WebservicePolicyRefBeanDConfig;
import weblogic.management.ManagementException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.jmx.MBeanServerInvocationHandler;
import weblogic.utils.classloaders.AugmentableClassLoaderManager;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.wsee.policy.deployment.config.MBeanUtils;
import weblogic.wsee.util.StringUtil;

public class DeploymentConfigurationHelper {
    public static final String TUNABLE = "TUNABLE";
    public static final String BINDABLE = "BINDABLE";
    private static MBeanServerConnection domainEditMBeanServerConnection = null;
    private static String OBJECT_NAME_KEY = "com.bea:Name=";
    private static String OBJECT_TYPE_APP = ",Type=AppDeployment";
    private String _userId;
    private String _password;
    private String _host;
    private int _port;
    private String _modulePath;
    private boolean _newPlan;
    private ModuleType _moduleType;
    private String[] _moduleUris = new String[0];
    private File _planFile;
    private File _configAreaPath;
    private String _appName;
    private SessionHelper _sessionHelper = null;
    private static SessionHelper tmpSessionHelper = null;
    private static WebLogicDeploymentManager tmpDeploymentManager = null;
    private WebLogicDeploymentManager _deploymentManager;
    private DeploymentConfiguration _deploymentConfiguration;
    private Map _annotationDefs = new HashMap();
    private Map _enumDefs = new HashMap();
    private Map _annotationOverridesByUri = new HashMap();
    private Map _annotationDefsByUri = new HashMap();
    private Map _enumDefsByUri = new HashMap();

    public String toString() {
        return super.toString() + "\n   PlanPath=" + this._modulePath;
    }

    public DeploymentConfigurationHelper(String string, boolean bl, String string2, int n, String string3, String string4) throws DeploymentManagerCreationException, ConfigurationException, IOException, InvalidModuleException, ClassNotFoundException, DDBeanCreateException {
        assert (string != null);
        this._userId = string3;
        this._password = string4;
        this._host = string2;
        this._port = n;
        this._modulePath = string;
        this._configAreaPath = DeploymentConfigurationHelper.getDefaultConfigDir(string);
        this._appName = this._configAreaPath.getName();
        this._planFile = DeploymentConfigurationHelper.getDefaultPlanFile(this._configAreaPath);
        this._newPlan = bl;
        long l = System.currentTimeMillis();
        this.initDeploymentConfiguration(bl);
        long l2 = System.currentTimeMillis();
        long l3 = System.currentTimeMillis();
    }

    public DeploymentConfigurationHelper(String string, boolean bl) throws DeploymentManagerCreationException, ConfigurationException, IOException, InvalidModuleException, ClassNotFoundException, DDBeanCreateException {
        this(string, bl, null, 0, null, null);
    }

    public DeploymentConfigurationHelper(String string, String string2, String string3, boolean bl) throws DeploymentManagerCreationException, ConfigurationException, IOException, InvalidModuleException, ClassNotFoundException, DDBeanCreateException {
        assert (string != null);
        assert (string2 != null);
        this._userId = null;
        this._password = null;
        this._host = null;
        this._port = 0;
        this._modulePath = string2;
        this._configAreaPath = new File(string);
        this._appName = this._configAreaPath.getName();
        this._newPlan = bl;
        this._planFile = string3 != null ? new File(string3) : DeploymentConfigurationHelper.getDefaultPlanFile(this._configAreaPath);
        long l = System.currentTimeMillis();
        this.initDeploymentConfiguration(bl);
        long l2 = System.currentTimeMillis();
        long l3 = System.currentTimeMillis();
    }

    public DeploymentConfigurationHelper(String string, String string2, int n) throws DeploymentManagerCreationException, ConfigurationException, IOException, InvalidModuleException, ClassNotFoundException, DDBeanCreateException {
        assert (string != null);
        this._userId = null;
        this._password = null;
        this._host = string2;
        this._port = n;
        this._modulePath = string;
        this._configAreaPath = new File("c:\\temp");
        this._planFile = new File("c:\\temp\\temp.dat");
        long l = System.currentTimeMillis();
        this.initDeploymentConfiguration(true);
        long l2 = System.currentTimeMillis();
    }

    public DeploymentConfigurationHelper(String string, String string2, String string3, boolean bl, String string4, int n) throws DeploymentManagerCreationException, ConfigurationException, IOException, InvalidModuleException, ClassNotFoundException, DDBeanCreateException {
        assert (string != null);
        assert (string2 != null);
        this._userId = null;
        this._password = null;
        this._host = string4;
        this._port = n;
        this._modulePath = string2;
        this._configAreaPath = new File(string);
        this._appName = this._configAreaPath.getName();
        this._planFile = string3 != null ? new File(string3) : DeploymentConfigurationHelper.getDefaultPlanFile(this._configAreaPath);
        this._newPlan = bl;
        long l = System.currentTimeMillis();
        this.initDeploymentConfiguration(bl);
        long l2 = System.currentTimeMillis();
        long l3 = System.currentTimeMillis();
    }

    public String getSourcePath() {
        return this._modulePath;
    }

    public boolean isNewPlan() {
        return this._newPlan;
    }

    public String getPlanPath() {
        return this._planFile.getPath();
    }

    public void setPlanPath(String string) {
        if (string != null) {
            this._planFile = new File(string);
        }
    }

    private static File getDefaultConfigDir(String string) {
        File file = new File(string);
        File file2 = null;
        file2 = file.isDirectory() ? file.getParentFile() : file.getParentFile().getParentFile();
        return file2;
    }

    public WebservicePolicyRefBean getWebservicePolicies(String string) throws FileNotFoundException, DDBeanCreateException, ConfigurationException {
        DDBeanRoot dDBeanRoot;
        WebservicePolicyRefBean webservicePolicyRefBean = null;
        DeployableObject deployableObject = this.getDeployment(string);
        DConfigBeanRoot dConfigBeanRoot = this._deploymentConfiguration.getDConfigBeanRoot(deployableObject.getDDBeanRoot());
        WebservicePolicyRefBeanDConfig webservicePolicyRefBeanDConfig = (WebservicePolicyRefBeanDConfig)dConfigBeanRoot.getDConfigBean(dDBeanRoot = DeploymentConfigurationHelper.getBeanRoot(deployableObject, "WEB-INF/weblogic-webservices-policy.xml", "META-INF/weblogic-webservices-policy.xml"));
        if (webservicePolicyRefBeanDConfig != null) {
            webservicePolicyRefBean = (WebservicePolicyRefBean)webservicePolicyRefBeanDConfig.getDescriptorBean();
        }
        return webservicePolicyRefBean;
    }

    public ServiceReferenceDescriptionBean getServiceRefPolicies(String string, String string2, String string3) throws FileNotFoundException, DDBeanCreateException, ConfigurationException {
        DeployableObject deployableObject = this.getDeployment(string);
        if (deployableObject.getType() == ModuleType.WAR) {
            WeblogicWebAppBean weblogicWebAppBean = (WeblogicWebAppBean)this.getDescriptorBean(string);
            ServiceReferenceDescriptionBean[] serviceReferenceDescriptionBeanArray = weblogicWebAppBean.getServiceReferenceDescriptions();
            if (serviceReferenceDescriptionBeanArray == null) {
                return this.createServiceRefBean(string3, weblogicWebAppBean);
            }
            ServiceReferenceDescriptionBean serviceReferenceDescriptionBean = this.getRefBean(serviceReferenceDescriptionBeanArray, string3);
            if (serviceReferenceDescriptionBean == null) {
                return this.createServiceRefBean(string3, weblogicWebAppBean);
            }
            return serviceReferenceDescriptionBean;
        }
        WeblogicEjbJarBean weblogicEjbJarBean = (WeblogicEjbJarBean)this.getDescriptorBean(string);
        WeblogicEnterpriseBeanBean weblogicEnterpriseBeanBean = weblogicEjbJarBean.getWeblogicEnterpriseBeans();
        if (weblogicEnterpriseBeanBean == null) {
            WeblogicEnterpriseBeanBean weblogicEnterpriseBeanBean2 = this.createEJBBean(string2, weblogicEjbJarBean);
            return this.getServiceRefPolicies(weblogicEnterpriseBeanBean2, string3);
        }
        for (WeblogicEnterpriseBeanBean weblogicEnterpriseBeanBean3 : weblogicEnterpriseBeanBean) {
            if (!weblogicEnterpriseBeanBean3.getEjbName().equals(string2)) continue;
            return this.getServiceRefPolicies(weblogicEnterpriseBeanBean3, string3);
        }
        WeblogicEnterpriseBeanBean weblogicEnterpriseBeanBean4 = this.createEJBBean(string2, weblogicEjbJarBean);
        return this.getServiceRefPolicies(weblogicEnterpriseBeanBean4, string3);
    }

    private WeblogicEnterpriseBeanBean createEJBBean(String string, WeblogicEjbJarBean weblogicEjbJarBean) {
        WeblogicEnterpriseBeanBean weblogicEnterpriseBeanBean = weblogicEjbJarBean.createWeblogicEnterpriseBean();
        weblogicEnterpriseBeanBean.setEjbName(string);
        return weblogicEnterpriseBeanBean;
    }

    private ServiceReferenceDescriptionBean getServiceRefPolicies(WeblogicEnterpriseBeanBean weblogicEnterpriseBeanBean, String string) {
        ServiceReferenceDescriptionBean[] serviceReferenceDescriptionBeanArray = weblogicEnterpriseBeanBean.getServiceReferenceDescriptions();
        if (serviceReferenceDescriptionBeanArray == null) {
            return this.createServiceRefBean(string, weblogicEnterpriseBeanBean);
        }
        for (ServiceReferenceDescriptionBean serviceReferenceDescriptionBean : serviceReferenceDescriptionBeanArray) {
            if (!serviceReferenceDescriptionBean.getServiceRefName().equals(string)) continue;
            return serviceReferenceDescriptionBean;
        }
        return this.createServiceRefBean(string, weblogicEnterpriseBeanBean);
    }

    private ServiceReferenceDescriptionBean createServiceRefBean(String string, WeblogicWebAppBean weblogicWebAppBean) {
        ServiceReferenceDescriptionBean serviceReferenceDescriptionBean = weblogicWebAppBean.createServiceReferenceDescription();
        serviceReferenceDescriptionBean.setServiceRefName(string);
        return serviceReferenceDescriptionBean;
    }

    private ServiceReferenceDescriptionBean createServiceRefBean(String string, WeblogicEnterpriseBeanBean weblogicEnterpriseBeanBean) {
        ServiceReferenceDescriptionBean serviceReferenceDescriptionBean = weblogicEnterpriseBeanBean.createServiceReferenceDescription();
        serviceReferenceDescriptionBean.setServiceRefName(string);
        return serviceReferenceDescriptionBean;
    }

    private ServiceReferenceDescriptionBean getRefBean(ServiceReferenceDescriptionBean[] serviceReferenceDescriptionBeanArray, String string) {
        if (serviceReferenceDescriptionBeanArray != null) {
            for (ServiceReferenceDescriptionBean serviceReferenceDescriptionBean : serviceReferenceDescriptionBeanArray) {
                if (!serviceReferenceDescriptionBean.getServiceRefName().equals(string)) continue;
                return serviceReferenceDescriptionBean;
            }
        }
        return null;
    }

    public DescriptorBean getDescriptorBean(String string) throws ConfigurationException {
        WebLogicDeployableObject webLogicDeployableObject = this.getDeployableObject(string);
        if (webLogicDeployableObject != null) {
            WebLogicDConfigBean webLogicDConfigBean = (WebLogicDConfigBean)this.getDeploymentConfiguration().getDConfigBeanRoot(webLogicDeployableObject.getDDBeanRoot());
            return webLogicDConfigBean.getDescriptorBean();
        }
        return null;
    }

    private DeployableObject getDeployment(String string) {
        WebLogicDeployableObject webLogicDeployableObject = null;
        if (this._moduleType == ModuleType.EAR) {
            J2eeApplicationObject j2eeApplicationObject = (J2eeApplicationObject)this._deploymentConfiguration.getDeployableObject();
            webLogicDeployableObject = j2eeApplicationObject.getDeployableObject(string);
        } else if (this._moduleType == ModuleType.WAR || this._moduleType == ModuleType.EJB) {
            webLogicDeployableObject = this.getDeployableObject(string);
        }
        return webLogicDeployableObject;
    }

    private static DDBeanRoot getBeanRoot(DeployableObject deployableObject, String string, String string2) throws FileNotFoundException, DDBeanCreateException {
        if (deployableObject == null) {
            return null;
        }
        DDBeanRoot dDBeanRoot = null;
        dDBeanRoot = deployableObject.getType() == ModuleType.WAR ? deployableObject.getDDBeanRoot(string) : deployableObject.getDDBeanRoot(string2);
        return dDBeanRoot;
    }

    public WebLogicDeploymentConfiguration getDeploymentConfiguration() {
        if (this._deploymentConfiguration == null) {
            throw new IllegalArgumentException("No deployment configuration available");
        }
        return (WebLogicDeploymentConfiguration)this._deploymentConfiguration;
    }

    private static File getDefaultPlanFile(File file) {
        String string = file.getAbsolutePath() + "/plan/Plan.xml";
        return new File(string);
    }

    private void initDeploymentConfiguration(final boolean bl) throws DeploymentManagerCreationException, ConfigurationException, IOException, InvalidModuleException {
        String string = "N/A";
        try {
            DeploymentConfigurationHelper.runDeploymentAction(new DeploymentAction(){

                public Object execute() throws Exception {
                    DeploymentConfigurationHelper.this._deploymentManager = DeploymentConfigurationHelper.this.getDeploymentManager();
                    DeploymentConfigurationHelper.this._sessionHelper = SessionHelper.getInstance(DeploymentConfigurationHelper.this._deploymentManager);
                    File file = null;
                    if (!bl) {
                        file = DeploymentConfigurationHelper.this._planFile;
                    }
                    DeploymentConfigurationHelper.this._sessionHelper.enableLibraryMerge();
                    DeploymentConfigurationHelper.this._sessionHelper.initializeConfiguration(new File(DeploymentConfigurationHelper.this._modulePath), file, DeploymentConfigurationHelper.this._configAreaPath);
                    return null;
                }
            });
        }
        catch (Exception exception) {
            throw new RuntimeException(string, exception);
        }
        this._deploymentConfiguration = this._sessionHelper.getConfiguration();
        this._moduleType = this._deploymentConfiguration.getDeployableObject().getType();
        if (bl) {
            ((DeploymentConfigurationImpl)this._deploymentConfiguration).getPlan().setApplicationName(this._appName);
        } else {
            this._appName = ((DeploymentConfigurationImpl)this._deploymentConfiguration).getPlan().getApplicationName();
        }
        if (this._moduleType == ModuleType.EAR) {
            this._moduleUris = ((J2eeApplicationObject)this._deploymentConfiguration.getDeployableObject()).getModuleUris();
        }
    }

    public WebLogicDeployableObject getDeployableObject(String string) {
        DeployableObject deployableObject = this.getDeploymentConfiguration().getDeployableObject();
        if (deployableObject != null) {
            if (deployableObject instanceof WebLogicJ2eeApplicationObject && string != null) {
                WebLogicJ2eeApplicationObject webLogicJ2eeApplicationObject = (WebLogicJ2eeApplicationObject)deployableObject;
                return (WebLogicDeployableObject)webLogicJ2eeApplicationObject.getDeployableObject(string);
            }
            return (WebLogicDeployableObject)deployableObject;
        }
        return null;
    }

    public WebLogicDeploymentManager getDeploymentManager() throws DeploymentManagerCreationException {
        if (this._userId != null) {
            return SessionHelper.getDeploymentManager(this._host, Integer.toString(this._port), this._userId, this._password);
        }
        return SessionHelper.getDeploymentManager(this._host, this._port == 0 ? null : Integer.toString(this._port));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object runDeploymentAction(DeploymentAction deploymentAction) throws Exception {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            GenericClassLoader genericClassLoader = AugmentableClassLoaderManager.getAugmentableSystemClassLoader();
            Thread.currentThread().setContextClassLoader((ClassLoader)genericClassLoader);
            Object object = deploymentAction.execute();
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    static DeploymentConfigurationHelper createDeploymentConfigurationHelper(AppDeploymentMBean appDeploymentMBean) throws ManagementException {
        Object object;
        Object object2;
        DeploymentConfigurationHelper deploymentConfigurationHelper = null;
        String string = appDeploymentMBean.getAbsoluteSourcePath();
        String string2 = appDeploymentMBean.getAbsoluteInstallDir();
        String string3 = appDeploymentMBean.getAbsolutePlanPath();
        File file = new File(string);
        if (StringUtil.isEmpty(string2) && (string2 = file.getParent()) == null && (object2 = file.getAbsolutePath()) != null) {
            object = new File((String)object2);
            string2 = ((File)object).getParent();
        }
        try {
            if (StringUtil.isEmpty(string3)) {
                object2 = DeploymentConfigurationHelper.getSessionHelper();
                ((SessionHelper)object2).setApplication(file);
                object = ((SessionHelper)object2).getNewPlanName();
                File[] fileArray = ((SessionHelper)object2).findPlans();
                if (fileArray != null && fileArray.length > 0) {
                    string3 = fileArray[0].getAbsolutePath() + File.pathSeparator + (String)object;
                }
                DeploymentConfigurationHelper.releaseSessionHelper();
                deploymentConfigurationHelper = new DeploymentConfigurationHelper(string2, string, string3, true, null, 0);
            } else {
                deploymentConfigurationHelper = new DeploymentConfigurationHelper(string2, string, string3, false, null, 0);
            }
        }
        catch (DeploymentManagerCreationException deploymentManagerCreationException) {
        }
        catch (ConfigurationException configurationException) {
        }
        catch (IOException iOException) {
        }
        catch (InvalidModuleException invalidModuleException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (DDBeanCreateException dDBeanCreateException) {
            // empty catch block
        }
        return deploymentConfigurationHelper;
    }

    public static SessionHelper getSessionHelper() throws ManagementException {
        DeploymentConfigurationHelper.releaseSessionHelper();
        tmpSessionHelper = SessionHelper.getInstance(DeploymentConfigurationHelper.getTmpDeploymentManager());
        return tmpSessionHelper;
    }

    public static void releaseSessionHelper() {
        if (tmpSessionHelper != null) {
            tmpSessionHelper.close();
            tmpSessionHelper = null;
        }
    }

    public static WebLogicDeploymentManager getTmpDeploymentManager() throws ManagementException {
        if (tmpDeploymentManager == null) {
            try {
                DomainMBean domainMBean = MBeanUtils.getDomainMBean();
                tmpDeploymentManager = SessionHelper.getDeploymentManager(null, null);
            }
            catch (DeploymentManagerCreationException deploymentManagerCreationException) {
                throw new ManagementException((Throwable)deploymentManagerCreationException);
            }
            catch (IOException iOException) {
                throw new ManagementException((Throwable)iOException);
            }
        }
        return tmpDeploymentManager;
    }

    private static MBeanServerConnection lookupMBeanServerConnection(String string) throws IOException {
        int n = 7001;
        String string2 = "localhost";
        String string3 = "wlx";
        JMXServiceURL jMXServiceURL = new JMXServiceURL(string3, string2, n, "/jndi/" + string);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("jmx.remote.protocol.provider.pkgs", "weblogic.management.remote");
        JMXConnector jMXConnector = JMXConnectorFactory.connect(jMXServiceURL, hashtable);
        return jMXConnector.getMBeanServerConnection();
    }

    public static MBeanServerConnection getDomainEditMBeanServerConnection() throws IOException {
        if (domainEditMBeanServerConnection == null) {
            domainEditMBeanServerConnection = DeploymentConfigurationHelper.lookupMBeanServerConnection("weblogic.management.mbeanservers.edit");
        }
        return domainEditMBeanServerConnection;
    }

    private static Object getMBean(ObjectName objectName) throws ManagementException {
        try {
            return MBeanServerInvocationHandler.newProxyInstance((MBeanServerConnection)DeploymentConfigurationHelper.getDomainEditMBeanServerConnection(), (ObjectName)objectName);
        }
        catch (IOException iOException) {
            throw new ManagementException((Throwable)iOException);
        }
        catch (Throwable throwable) {
            throw new ManagementException(throwable);
        }
    }

    public static AppDeploymentMBean getAppDeploymentMBean(String string) throws ManagementException {
        try {
            ObjectName objectName = new ObjectName(OBJECT_NAME_KEY + string + OBJECT_TYPE_APP);
            Object object = DeploymentConfigurationHelper.getMBean(objectName);
            return (AppDeploymentMBean)object;
        }
        catch (Throwable throwable) {
            throw new ManagementException(throwable);
        }
    }

    public void save() throws IOException, ConfigurationException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this._planFile, false);
            this._deploymentConfiguration.save((OutputStream)fileOutputStream);
            this._newPlan = false;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void release() {
        this._modulePath = null;
        this._planFile = null;
        this._moduleUris = null;
        this._deploymentConfiguration = null;
        this._configAreaPath = null;
        if (this._sessionHelper != null) {
            this._sessionHelper.close();
            this._sessionHelper = null;
        }
        if (this._deploymentManager != null) {
            this._deploymentManager.release();
            this._deploymentManager = null;
        }
        if (this._annotationDefs != null) {
            this._annotationDefs.clear();
            this._annotationDefs = null;
        }
        if (this._annotationDefsByUri != null) {
            this._annotationDefsByUri.clear();
            this._annotationDefsByUri = null;
        }
        if (this._annotationOverridesByUri != null) {
            this._annotationOverridesByUri.clear();
            this._annotationOverridesByUri = null;
        }
        if (this._enumDefs != null) {
            this._enumDefs.clear();
            this._enumDefs = null;
        }
        if (this._enumDefsByUri != null) {
            this._enumDefsByUri.clear();
            this._enumDefsByUri = null;
        }
    }

    public static interface DeploymentAction {
        public Object execute() throws Exception;
    }
}

