/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.policy.deployment.config;

import java.io.File;
import java.io.IOException;
import javax.enterprise.deploy.model.exceptions.DDBeanCreateException;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import weblogic.deploy.api.spi.WebLogicDeploymentManager;
import weblogic.deploy.api.tools.SessionHelper;
import weblogic.management.ManagementException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.wsee.policy.deployment.config.DeploymentConfigurationHelper;
import weblogic.wsee.util.StringUtil;

public class DeploymentConfigurationManager {
    private static final DeploymentConfigurationManager INSTANCE = new DeploymentConfigurationManager();
    private static SessionHelper tmpSessionHelper = null;
    private static WebLogicDeploymentManager tmpDeploymentManager = null;

    public static final DeploymentConfigurationManager getInstance() {
        return INSTANCE;
    }

    private DeploymentConfigurationManager() {
    }

    public DeploymentConfigurationHelper getDeploymentConfiguration(AppDeploymentMBean appDeploymentMBean) throws ManagementException {
        return DeploymentConfigurationManager.createDeploymentConfigurationHelper(appDeploymentMBean);
    }

    private static DeploymentConfigurationHelper createDeploymentConfigurationHelper(AppDeploymentMBean appDeploymentMBean) throws ManagementException {
        Object object;
        Object object2;
        DeploymentConfigurationHelper deploymentConfigurationHelper = null;
        String string = appDeploymentMBean.getAbsoluteSourcePath();
        String string2 = appDeploymentMBean.getAbsoluteInstallDir();
        String string3 = appDeploymentMBean.getAbsolutePlanPath();
        File file = new File(string);
        if (StringUtil.isEmpty(string2) && (string2 = file.getParent()) == null && (object2 = file.getAbsolutePath()) != null) {
            object = new File((String)object2);
            string2 = ((File)object).getParent();
        }
        try {
            if (StringUtil.isEmpty(string3)) {
                object2 = DeploymentConfigurationManager.getSessionHelper();
                ((SessionHelper)object2).setApplication(file);
                object = ((SessionHelper)object2).getNewPlanName();
                File[] fileArray = ((SessionHelper)object2).findPlans();
                if (fileArray != null && fileArray.length > 0) {
                    string3 = fileArray[0].getAbsolutePath() + File.pathSeparator + (String)object;
                }
                DeploymentConfigurationManager.releaseSessionHelper();
                deploymentConfigurationHelper = new DeploymentConfigurationHelper(string2, string, string3, true, null, 0);
            } else {
                deploymentConfigurationHelper = new DeploymentConfigurationHelper(string2, string, string3, false, null, 0);
            }
        }
        catch (DeploymentManagerCreationException deploymentManagerCreationException) {
        }
        catch (ConfigurationException configurationException) {
        }
        catch (IOException iOException) {
        }
        catch (InvalidModuleException invalidModuleException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (DDBeanCreateException dDBeanCreateException) {
            // empty catch block
        }
        return deploymentConfigurationHelper;
    }

    public static SessionHelper getSessionHelper() throws ManagementException {
        DeploymentConfigurationManager.releaseSessionHelper();
        tmpSessionHelper = SessionHelper.getInstance(DeploymentConfigurationManager.getTmpDeploymentManager());
        return tmpSessionHelper;
    }

    public static void releaseSessionHelper() {
        if (tmpSessionHelper != null) {
            tmpSessionHelper.close();
            tmpSessionHelper = null;
        }
    }

    public static WebLogicDeploymentManager getTmpDeploymentManager() throws ManagementException {
        if (tmpDeploymentManager == null) {
            try {
                tmpDeploymentManager = SessionHelper.getDeploymentManager(null, null);
            }
            catch (DeploymentManagerCreationException deploymentManagerCreationException) {
                throw new ManagementException((Throwable)deploymentManagerCreationException);
            }
        }
        return tmpDeploymentManager;
    }
}

